/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ProviderKeyBinding;
import java.lang.annotation.Annotation;
import javax.inject.Provider;
import org.eclipse.sisu.inject.Implementations;

enum QualifyingStrategy {
    UNRESTRICTED{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding2) {
            Annotation qualifier = 1.qualify(binding2.getKey());
            return qualifier != null ? qualifier : BLANK_QUALIFIER;
        }
    }
    ,
    NAMED{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding2) {
            Annotation qualifier = 2.qualify(binding2.getKey());
            return qualifier instanceof Named ? qualifier : null;
        }
    }
    ,
    NAMED_WITH_ATTRIBUTES{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding2) {
            Class<?> clazz;
            javax.inject.Named alias2;
            Annotation qualifier = 3.qualify(binding2.getKey());
            if (requirement.getAnnotation().equals(qualifier)) {
                return qualifier;
            }
            if (binding2 instanceof ConstructorBinding && binding2.getKey().getAnnotationType() == null && (alias2 = (clazz = binding2.getKey().getTypeLiteral().getRawType()).getAnnotation(javax.inject.Named.class)) != null && alias2.value().equals(((Named)requirement.getAnnotation()).value()) && clazz.equals(Implementations.find(binding2))) {
                return requirement.getAnnotation();
            }
            return null;
        }
    }
    ,
    MARKED{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding2) {
            Annotation qualifier;
            final Class<Annotation> markerType = requirement.getAnnotationType();
            if (markerType.isInstance(qualifier = 4.qualify(binding2.getKey()))) {
                return qualifier;
            }
            if (markerType.equals(binding2.getKey().getAnnotationType()) && markerType.getDeclaredMethods().length == 0) {
                return new Annotation(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return markerType;
                    }
                };
            }
            if (binding2 instanceof ProviderKeyBinding) {
                Key providerKey = ((ProviderKeyBinding)binding2).getProviderKey();
                return providerKey.getTypeLiteral().getRawType().getAnnotation(markerType);
            }
            Class<?> implementation = Implementations.find(binding2);
            return implementation != null ? implementation.getAnnotation(markerType) : null;
        }
    }
    ,
    MARKED_WITH_ATTRIBUTES{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding2) {
            Annotation qualifier = MARKED.qualifies(requirement, binding2);
            return requirement.getAnnotation().equals(qualifier) ? qualifier : null;
        }
    };

    static final Annotation DEFAULT_QUALIFIER;
    static final Annotation BLANK_QUALIFIER;

    static {
        DEFAULT_QUALIFIER = Names.named("default");
        BLANK_QUALIFIER = Names.named("");
    }

    private QualifyingStrategy() {
    }

    abstract Annotation qualifies(Key<?> var1, Binding<?> var2);

    static final QualifyingStrategy selectFor(Key<?> key2) {
        Class<Annotation> qualifierType = key2.getAnnotationType();
        if (qualifierType == null) {
            return UNRESTRICTED;
        }
        if (Named.class == qualifierType) {
            return key2.hasAttributes() ? NAMED_WITH_ATTRIBUTES : NAMED;
        }
        return key2.hasAttributes() ? MARKED_WITH_ATTRIBUTES : MARKED;
    }

    static final Annotation qualify(Key<?> key2) {
        if (key2.getAnnotationType() == null) {
            return DEFAULT_QUALIFIER;
        }
        Annotation qualifier = key2.getAnnotation();
        if (qualifier instanceof Provider) {
            Object original = ((Provider)((Object)qualifier)).get();
            return original instanceof Annotation ? (Annotation)original : DEFAULT_QUALIFIER;
        }
        return qualifier;
    }

    /* synthetic */ QualifyingStrategy(String string2, int n, QualifyingStrategy qualifyingStrategy) {
        this();
    }
}

