/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.geom.LineSegmentDouble;
import net.sourceforge.plantuml.hector.HectorPath;
import net.sourceforge.plantuml.hector.UnlinearCompression;

class UnlinarCompressedPlan {
    private final UnlinearCompression compX;
    private final UnlinearCompression compY;

    public UnlinarCompressedPlan(double inner, double outer) {
        this(inner, outer, inner, outer);
    }

    public UnlinarCompressedPlan(double innerx, double outerx, double innery, double outery) {
        this.compX = new UnlinearCompression(innerx, outerx);
        this.compY = new UnlinearCompression(innery, outery);
    }

    public double getInnerX() {
        return this.compX.innerSize();
    }

    public double getInnerY() {
        return this.compY.innerSize();
    }

    public HectorPath uncompressSegmentSimple(Point2D pp1, Point2D pp2) {
        HectorPath result = new HectorPath();
        result.add(new LineSegmentDouble(this.uncompress(pp1, UnlinearCompression.Rounding.CENTRAL), this.uncompress(pp2, UnlinearCompression.Rounding.CENTRAL)));
        return result;
    }

    public HectorPath uncompressSegment(Point2D pp1, Point2D pp2) {
        double x1 = pp1.getX();
        double y1 = pp1.getY();
        double x2 = pp2.getX();
        double y2 = pp2.getY();
        HectorPath result = new HectorPath();
        double[] y = this.compY.encounteredSingularities(y1, y2);
        if (y.length == 0 || x1 == x2) {
            result.add(new LineSegmentDouble(this.uncompress(pp1, UnlinearCompression.Rounding.CENTRAL), this.uncompress(pp2, UnlinearCompression.Rounding.CENTRAL)));
            return result;
        }
        System.err.println("len=" + y.length);
        LineSegmentDouble segment = new LineSegmentDouble(pp1, pp2);
        for (int i = 0; i < y.length; ++i) {
            double x = segment.getIntersectionHorizontal(y[i]);
            UnlinearCompression.Rounding r = i == 0 ? UnlinearCompression.Rounding.CENTRAL : UnlinearCompression.Rounding.BORDER_2;
            result.add(this.uncompress(x1, y1, r), this.uncompress(x, y[i], UnlinearCompression.Rounding.BORDER_1));
            x1 = x;
            y1 = y[i];
        }
        result.add(this.uncompress(x1, y1, UnlinearCompression.Rounding.BORDER_2), this.uncompress(x2, y2, UnlinearCompression.Rounding.CENTRAL));
        return result;
    }

    public HectorPath uncompress(LineSegmentDouble segment) {
        double x1 = segment.getX1();
        double y1 = segment.getY1();
        double x2 = segment.getX2();
        double y2 = segment.getY2();
        HectorPath result = new HectorPath();
        double[] x = this.compX.encounteredSingularities(x1, x2);
        if (x.length == 0) {
            result.add(this.getUncompressedSegment(x1, y1, x2, y2, UnlinearCompression.Rounding.BORDER_2));
            return result;
        }
        for (int i = 0; i < x.length; ++i) {
            double y = segment.getIntersectionVertical(x[i]);
            result.add(this.getUncompressedSegment(x1, y1, x[i], y, UnlinearCompression.Rounding.BORDER_2));
            x1 = x[i];
            y1 = y;
        }
        result.add(this.getUncompressedSegment(x1, y1, x2, y2, UnlinearCompression.Rounding.BORDER_2));
        return result;
    }

    public Point2D uncompress(Point2D pt, UnlinearCompression.Rounding rounding) {
        return this.uncompress(pt.getX(), pt.getY(), rounding);
    }

    public Point2D uncompress(double x, double y, UnlinearCompression.Rounding rounding) {
        return new Point2D.Double(this.compX.uncompress(x, rounding), this.compY.uncompress(y, rounding));
    }

    private LineSegmentDouble getUncompressedSegment(double x1, double y1, double x2, double y2, UnlinearCompression.Rounding rounding) {
        LineSegmentDouble un1 = new LineSegmentDouble(this.compX.uncompress(x1, rounding), this.compY.uncompress(y1, rounding), this.compX.uncompress(x2, rounding), this.compY.uncompress(y2, rounding));
        return un1;
    }
}

