/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class MutingLine {
    private final Rose skin;
    private final ISkinParam skinParam;
    private final boolean useContinueLineBecauseOfDelay;
    private final Map<Double, Double> delays = new TreeMap<Double, Double>();
    private final StyleBuilder styleBuilder;

    public MutingLine(Rose skin, ISkinParam skinParam, List<Event> events) {
        this.skin = skin;
        this.skinParam = skinParam;
        this.useContinueLineBecauseOfDelay = this.useContinueLineBecauseOfDelay(events);
        this.styleBuilder = skinParam.getCurrentStyleBuilder();
    }

    private boolean useContinueLineBecauseOfDelay(List<Event> events) {
        String strategy = this.skinParam.getValue("lifelineStrategy");
        if ("nosolid".equalsIgnoreCase(strategy)) {
            return false;
        }
        for (Event ev : events) {
            if (!(ev instanceof Delay)) continue;
            return true;
        }
        return false;
    }

    public void drawLine(UGraphic ug, Context2D context, double createY, double endY) {
        ComponentType defaultLineType;
        ComponentType componentType = defaultLineType = this.useContinueLineBecauseOfDelay ? ComponentType.CONTINUE_LINE : ComponentType.PARTICIPANT_LINE;
        if (this.delays.size() > 0) {
            double y = createY;
            for (Map.Entry<Double, Double> ent : this.delays.entrySet()) {
                if (!(ent.getKey() >= createY)) continue;
                this.drawInternal(ug, context, y, ent.getKey(), defaultLineType);
                this.drawInternal(ug, context, ent.getKey(), ent.getKey() + ent.getValue(), ComponentType.DELAY_LINE);
                y = ent.getKey() + ent.getValue();
            }
            this.drawInternal(ug, context, y, endY, defaultLineType);
        } else {
            this.drawInternal(ug, context, createY, endY, defaultLineType);
        }
    }

    private void drawInternal(UGraphic ug, Context2D context, double y1, double y2, ComponentType defaultLineType) {
        if (y2 == y1) {
            return;
        }
        if (y2 < y1) {
            throw new IllegalArgumentException();
        }
        Style style = defaultLineType.getDefaultStyleDefinition().getMergedStyle(this.styleBuilder);
        Component comp = this.skin.createComponent(new Style[]{style}, defaultLineType, null, this.skinParam, null);
        Dimension2D dim = comp.getPreferredDimension(ug.getStringBounder());
        Area area = new Area(dim.getWidth(), y2 - y1);
        comp.drawU(ug.apply(new UTranslate(0.0, y1)), area, context);
    }

    public void delayOn(double y, double height) {
        this.delays.put(y, height);
    }
}

