/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.ProvidedExtensionsProxy;
import org.netbeans.modules.masterfs.filebasedfs.MasterFileSystemFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RootObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RootObjWindows;
import org.netbeans.modules.masterfs.providers.BaseAnnotationProvider;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.StatusDecorator;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.ProxyLookup;

public class FileBasedFileSystem
extends FileSystem {
    private static final Logger LOG = Logger.getLogger(FileBasedFileSystem.class.getName());
    private static volatile FileBasedFileSystem INSTANCE;
    private transient RootObj<? extends FileObject> root;
    private final transient StatusImpl status = new StatusImpl();
    private static transient int modificationInProgress;

    public FileBasedFileSystem() {
        if (BaseUtilities.isWindows()) {
            RootObjWindows rootObjWindows = new RootObjWindows();
            this.root = new RootObj<RootObjWindows>(rootObjWindows);
        } else {
            FileObjectFactory fileObjectFactory = FileObjectFactory.getInstance(new File("/"));
            this.root = new RootObj<BaseFileObj>(fileObjectFactory.getRoot());
        }
    }

    public static synchronized boolean isModificationInProgress() {
        return modificationInProgress != 0;
    }

    private static synchronized void setModificationInProgress(boolean bl) {
        modificationInProgress = bl ? ++modificationInProgress : --modificationInProgress;
    }

    public static void runAsInconsistent(Runnable runnable) {
        try {
            FileBasedFileSystem.setModificationInProgress(true);
            runnable.run();
        }
        finally {
            FileBasedFileSystem.setModificationInProgress(false);
        }
    }

    public static <Retval> Retval runAsInconsistent(FSCallable<Retval> fSCallable) throws IOException {
        Retval Retval = null;
        try {
            FileBasedFileSystem.setModificationInProgress(true);
            Retval = fSCallable.call();
        }
        finally {
            FileBasedFileSystem.setModificationInProgress(false);
        }
        return Retval;
    }

    public static Map<File, ? extends FileObjectFactory> factories() {
        return FileObjectFactory.factories();
    }

    public static FileObject getFileObject(File file) {
        return FileBasedFileSystem.getFileObject(file, FileObjectFactory.Caller.GetFileObject);
    }

    public static FileObject getFileObject(File file, FileObjectFactory.Caller caller) {
        FileObjectFactory fileObjectFactory = FileObjectFactory.getInstance(file);
        Object object = null;
        if (fileObjectFactory != null) {
            object = file.getParentFile() == null && BaseUtilities.isUnix() ? FileBasedFileSystem.getInstance().getRoot() : fileObjectFactory.getValidFileObject(file, caller);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileBasedFileSystem getInstance() {
        FileBasedFileSystem fileBasedFileSystem = INSTANCE;
        if (fileBasedFileSystem != null) return fileBasedFileSystem;
        MasterFileSystemFactory masterFileSystemFactory = (MasterFileSystemFactory)Lookup.getDefault().lookup(MasterFileSystemFactory.class);
        fileBasedFileSystem = masterFileSystemFactory != null ? masterFileSystemFactory.createFileSystem() : new FileBasedFileSystem();
        Class<FileBasedFileSystem> clazz = FileBasedFileSystem.class;
        synchronized (FileBasedFileSystem.class) {
            FileBasedFileSystem fileBasedFileSystem2 = INSTANCE;
            if (fileBasedFileSystem2 != null) return fileBasedFileSystem2;
            INSTANCE = fileBasedFileSystem;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return fileBasedFileSystem;
        }
    }

    public void refresh(final boolean bl) {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileBasedFileSystem.this.refreshImpl(bl);
            }
        };
        try {
            FileBasedFileSystem.getInstance().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileBasedFileSystem.runAsInconsistent(runnable);
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void refreshImpl(boolean bl) {
        FileObject fileObject = this.root.getRealRoot();
        if (fileObject instanceof BaseFileObj) {
            ((BaseFileObj)fileObject).getFactory().refresh(bl);
        } else if (fileObject instanceof RootObjWindows) {
            Collection<? extends FileObjectFactory> collection = FileBasedFileSystem.factories().values();
            for (FileObjectFactory fileObjectFactory : collection) {
                fileObjectFactory.refresh(bl);
            }
        }
    }

    public String getDisplayName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isReadOnly() {
        return false;
    }

    public FileObject getRoot() {
        return this.root;
    }

    public FileObject findResource(String string) {
        if (BaseUtilities.isWindows()) {
            if ("".equals(string)) {
                return FileBasedFileSystem.getInstance().getRoot();
            }
        } else {
            string = string.startsWith("/") ? string : "/" + string;
        }
        File file = new File(string);
        if (string.contains("..") || string.contains("./") || string.contains("/.")) {
            file = FileUtil.normalizeFile((File)file);
        }
        return FileBasedFileSystem.getFileObject(file);
    }

    public FileObject getTempFolder() throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)new File(System.getProperty("java.io.tmpdir")));
        if (fileObject != null && fileObject.isFolder() && fileObject.isValid()) {
            return fileObject;
        }
        throw new IOException("Cannot find temporary folder");
    }

    public FileObject createTempFile(FileObject fileObject, String string, String string2, boolean bl) throws IOException {
        if (fileObject.isFolder() && fileObject.isValid()) {
            FileObject fileObject2;
            File file = File.createTempFile(string, string2, FileUtil.toFile((FileObject)fileObject));
            if (bl) {
                file.deleteOnExit();
            }
            if ((fileObject2 = FileUtil.toFileObject((File)file)) != null && fileObject2.isData() && fileObject2.isValid()) {
                return fileObject2;
            }
            file.delete();
        }
        throw new IOException("Cannot create temporary file");
    }

    public Lookup findExtrasFor(Set<FileObject> set) {
        return this.status.findExtrasFor(set);
    }

    public StatusDecorator getDecorator() {
        return this.status;
    }

    public Object writeReplace() throws ObjectStreamException {
        return new SerReplace();
    }

    public static class Factory
    implements MasterFileSystemFactory {
        @Override
        public FileBasedFileSystem createFileSystem() {
            return new FileBasedFileSystem();
        }
    }

    public static interface FSCallable<V> {
        public V call() throws IOException;
    }

    private static class SerReplace
    implements Serializable {
        static final long serialVersionUID = -3714631266626840241L;

        private SerReplace() {
        }

        public Object readResolve() throws ObjectStreamException {
            return FileBasedFileSystem.getInstance();
        }
    }

    public class StatusImpl
    implements StatusDecorator,
    LookupListener,
    FileStatusListener {
        protected Lookup.Result<BaseAnnotationProvider> annotationProviders;
        private Collection<? extends BaseAnnotationProvider> previousProviders;

        public StatusImpl() {
            try {
                Class.forName("org.netbeans.modules.masterfs.ui.Init", true, (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.annotationProviders = Lookup.getDefault().lookup(new Lookup.Template(BaseAnnotationProvider.class));
            this.annotationProviders.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }

        public ProvidedExtensions getExtensions() {
            Collection<Object> collection = this.previousProviders != null ? Collections.unmodifiableCollection(this.previousProviders) : Collections.emptyList();
            return new ProvidedExtensionsProxy(collection);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            HashSet<? extends BaseAnnotationProvider> hashSet;
            HashSet<? extends BaseAnnotationProvider> hashSet2 = this.annotationProviders.allInstances();
            if (this.previousProviders != null) {
                hashSet = new HashSet<BaseAnnotationProvider>(hashSet2);
                hashSet.removeAll(this.previousProviders);
                HashSet<? extends BaseAnnotationProvider> hashSet3 = new HashSet<BaseAnnotationProvider>(this.previousProviders);
                hashSet3.removeAll(hashSet2);
                Iterator object = hashSet3.iterator();
                while (object.hasNext()) {
                    BaseAnnotationProvider baseAnnotationProvider = (BaseAnnotationProvider)object.next();
                    baseAnnotationProvider.removeFileStatusListener(this);
                }
            } else {
                hashSet = hashSet2;
            }
            for (BaseAnnotationProvider baseAnnotationProvider : hashSet) {
                try {
                    baseAnnotationProvider.addFileStatusListener(this);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    Exceptions.printStackTrace((Throwable)tooManyListenersException);
                }
            }
            this.previousProviders = hashSet2;
        }

        public Lookup findExtrasFor(Set<FileObject> set) {
            ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
            for (BaseAnnotationProvider baseAnnotationProvider : this.annotationProviders.allInstances()) {
                Lookup lookup = baseAnnotationProvider.findExtrasFor(set);
                if (lookup == null) continue;
                arrayList.add(lookup);
            }
            return new ProxyLookup(arrayList.toArray(new Lookup[arrayList.size()]));
        }

        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            FileBasedFileSystem.this.fireFileStatusChanged(fileStatusEvent);
        }

        public String annotateName(String string, Set<? extends FileObject> set) {
            String string2 = null;
            Iterator iterator = this.annotationProviders.allInstances().iterator();
            while (string2 == null && iterator.hasNext()) {
                BaseAnnotationProvider baseAnnotationProvider = (BaseAnnotationProvider)iterator.next();
                string2 = baseAnnotationProvider.annotateName(string, set);
            }
            if (string2 != null) {
                return string2;
            }
            return string;
        }

        public String annotateNameHtml(String string, Set<? extends FileObject> set) {
            String string2 = null;
            Iterator iterator = this.annotationProviders.allInstances().iterator();
            while (string2 == null && iterator.hasNext()) {
                BaseAnnotationProvider baseAnnotationProvider = (BaseAnnotationProvider)iterator.next();
                string2 = baseAnnotationProvider.annotateNameHtml(string, set);
            }
            return string2;
        }
    }
}

