/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.node.AExpression;

public final class ENumeric
extends AExpression {
    private final String value;
    private int radix;

    public ENumeric(Location location, String value, int radix) {
        super(location);
        this.value = Objects.requireNonNull(value);
        this.radix = radix;
    }

    @Override
    void storeSettings(CompilerSettings settings) {
    }

    @Override
    void extractVariables(Set<String> variables) {
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        if (!this.read) {
            throw this.createError(new IllegalArgumentException("Must read from constant [" + this.value + "]."));
        }
        if (this.value.endsWith("d") || this.value.endsWith("D")) {
            if (this.radix != 10) {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
            try {
                this.constant = Double.parseDouble(this.value.substring(0, this.value.length() - 1));
                this.actual = Double.TYPE;
            }
            catch (NumberFormatException exception) {
                throw this.createError(new IllegalArgumentException("Invalid double constant [" + this.value + "]."));
            }
        }
        if (this.value.endsWith("f") || this.value.endsWith("F")) {
            if (this.radix != 10) {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
            try {
                this.constant = Float.valueOf(Float.parseFloat(this.value.substring(0, this.value.length() - 1)));
                this.actual = Float.TYPE;
            }
            catch (NumberFormatException exception) {
                throw this.createError(new IllegalArgumentException("Invalid float constant [" + this.value + "]."));
            }
        }
        if (this.value.endsWith("l") || this.value.endsWith("L")) {
            try {
                this.constant = Long.parseLong(this.value.substring(0, this.value.length() - 1), this.radix);
                this.actual = Long.TYPE;
            }
            catch (NumberFormatException exception) {
                throw this.createError(new IllegalArgumentException("Invalid long constant [" + this.value + "]."));
            }
        }
        try {
            Class sort = this.expected == null ? Integer.TYPE : this.expected;
            int integer = Integer.parseInt(this.value, this.radix);
            if (sort == Byte.TYPE && integer >= -128 && integer <= 127) {
                this.constant = (byte)integer;
                this.actual = Byte.TYPE;
            } else if (sort == Character.TYPE && integer >= 0 && integer <= 65535) {
                this.constant = Character.valueOf((char)integer);
                this.actual = Character.TYPE;
            } else if (sort == Short.TYPE && integer >= Short.MIN_VALUE && integer <= Short.MAX_VALUE) {
                this.constant = (short)integer;
                this.actual = Short.TYPE;
            } else {
                this.constant = integer;
                this.actual = Integer.TYPE;
            }
        }
        catch (NumberFormatException exception) {
            try {
                Long.parseLong(this.value, this.radix);
                throw this.createError(new IllegalArgumentException("Invalid int constant [" + this.value + "]. If you want a long constant then change it to [" + this.value + "L]."));
            }
            catch (NumberFormatException numberFormatException) {
                throw this.createError(new IllegalArgumentException("Invalid int constant [" + this.value + "]."));
            }
        }
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    public String toString() {
        if (this.radix != 10) {
            return this.singleLineToString(this.value, this.radix);
        }
        return this.singleLineToString(this.value);
    }
}

