/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class CertificateUtil {
    public static CRL getCRL(X509Certificate certificate) throws CertificateException, CRLException, IOException {
        return CertificateUtil.getCRL(CertificateUtil.getCRLURL(certificate));
    }

    public static String getCRLURL(X509Certificate certificate) throws CertificateParsingException {
        DistributionPoint[] dists;
        ASN1Primitive obj;
        try {
            obj = CertificateUtil.getExtensionValue(certificate, Extension.cRLDistributionPoints.getId());
        }
        catch (IOException e) {
            obj = null;
        }
        if (obj == null) {
            return null;
        }
        CRLDistPoint dist = CRLDistPoint.getInstance((Object)obj);
        for (DistributionPoint p : dists = dist.getDistributionPoints()) {
            GeneralName[] names;
            DistributionPointName distributionPointName = p.getDistributionPoint();
            if (0 != distributionPointName.getType()) continue;
            GeneralNames generalNames = (GeneralNames)distributionPointName.getName();
            for (GeneralName name : names = generalNames.getNames()) {
                if (name.getTagNo() != 6) continue;
                DERIA5String derStr = DERIA5String.getInstance((ASN1TaggedObject)((ASN1TaggedObject)name.toASN1Primitive()), (boolean)false);
                return derStr.getString();
            }
        }
        return null;
    }

    public static CRL getCRL(String url) throws IOException, CertificateException, CRLException {
        if (url == null) {
            return null;
        }
        InputStream is = new URL(url).openStream();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCRL(is);
    }

    public static String getOCSPURL(X509Certificate certificate) {
        try {
            ASN1Primitive obj = CertificateUtil.getExtensionValue(certificate, Extension.authorityInfoAccess.getId());
            if (obj == null) {
                return null;
            }
            ASN1Sequence AccessDescriptions = (ASN1Sequence)obj;
            for (int i = 0; i < AccessDescriptions.size(); ++i) {
                ASN1ObjectIdentifier id;
                ASN1Sequence AccessDescription = (ASN1Sequence)AccessDescriptions.getObjectAt(i);
                if (AccessDescription.size() != 2 || !(AccessDescription.getObjectAt(0) instanceof ASN1ObjectIdentifier) || !"1.3.6.1.5.5.7.48.1".equals((id = (ASN1ObjectIdentifier)AccessDescription.getObjectAt(0)).getId())) continue;
                ASN1Primitive description = (ASN1Primitive)AccessDescription.getObjectAt(1);
                String AccessLocation = CertificateUtil.getStringFromGeneralName(description);
                if (AccessLocation == null) {
                    return "";
                }
                return AccessLocation;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public static String getTSAURL(X509Certificate certificate) {
        byte[] der = certificate.getExtensionValue("1.2.840.113583.1.1.9.1");
        if (der == null) {
            return null;
        }
        try {
            ASN1Primitive asn1obj = ASN1Primitive.fromByteArray((byte[])der);
            DEROctetString octets = (DEROctetString)asn1obj;
            asn1obj = ASN1Primitive.fromByteArray((byte[])octets.getOctets());
            ASN1Sequence asn1seq = ASN1Sequence.getInstance((Object)asn1obj);
            return CertificateUtil.getStringFromGeneralName(asn1seq.getObjectAt(1).toASN1Primitive());
        }
        catch (IOException e) {
            return null;
        }
    }

    private static ASN1Primitive getExtensionValue(X509Certificate certificate, String oid) throws IOException {
        byte[] bytes = certificate.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(bytes));
        ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
        aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(octs.getOctets()));
        return aIn.readObject();
    }

    private static String getStringFromGeneralName(ASN1Primitive names) throws IOException {
        ASN1TaggedObject taggedObject = (ASN1TaggedObject)names;
        return new String(ASN1OctetString.getInstance((ASN1TaggedObject)taggedObject, (boolean)false).getOctets(), "ISO-8859-1");
    }
}

