/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;

public class ExporterCSV
implements GraphExporter,
CharacterExporter,
LongTask {
    private static final String SEPARATOR = ";";
    private static final String EOL = "\n";
    private boolean edgeWeight = true;
    private boolean writeZero = true;
    private boolean header = true;
    private boolean list = false;
    private Workspace workspace;
    private Writer writer;
    private boolean exportVisible;
    private boolean cancel = false;
    private ProgressTicket progressTicket;
    private static final DecimalFormat FORMAT = new DecimalFormat("0.######");

    public boolean execute() {
        GraphModel graphModel = (GraphModel)this.workspace.getLookup().lookup(GraphModel.class);
        Graph graph = this.exportVisible ? graphModel.getGraphVisible() : graphModel.getGraph();
        graph.readLock();
        try {
            this.exportData(graph);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            graph.readUnlock();
            Progress.finish((ProgressTicket)this.progressTicket);
        }
        return !this.cancel;
    }

    private void exportData(Graph graph) throws Exception {
        int max = graph.getNodeCount();
        Progress.start((ProgressTicket)this.progressTicket, (int)max);
        if (!this.list && this.header) {
            this.writer.append(SEPARATOR);
            int i = 0;
            NodeIterable itr = graph.getNodes();
            for (Node node : itr) {
                this.writeMatrixNode(node, i++ < max - 1);
                if (!this.cancel) continue;
                itr.doBreak();
                return;
            }
            this.writer.append(EOL);
        }
        if (this.list) {
            NodeIterable itr = graph.getNodes();
            for (Node n : itr) {
                ArrayList<Node> neighbours = new ArrayList<Node>();
                for (Edge e : graph.getEdges(n)) {
                    if (e.isDirected() && (!e.isDirected() || n != e.getSource())) continue;
                    Node m = graph.getOpposite(n, e);
                    neighbours.add(m);
                }
                this.writeListNode(n, !neighbours.isEmpty());
                for (int j = 0; j < neighbours.size(); ++j) {
                    this.writeListNode((Node)neighbours.get(j), j < neighbours.size() - 1);
                }
                this.writer.append(EOL);
                if (!this.cancel) continue;
                itr.doBreak();
                return;
            }
        } else {
            Node[] nodes;
            for (Node n : nodes = graph.getNodes().toArray()) {
                if (this.cancel) {
                    return;
                }
                this.writeMatrixNode(n, true);
                for (int j = 0; j < nodes.length; ++j) {
                    Node m = nodes[j];
                    EdgeIterable edges = graph.getEdges(n, m);
                    this.writeEdge(edges, j < nodes.length - 1);
                }
                Progress.progress((ProgressTicket)this.progressTicket);
                this.writer.append(EOL);
            }
        }
        Progress.finish((ProgressTicket)this.progressTicket);
    }

    private void writeEdge(EdgeIterable edges, boolean writeSeparator) throws IOException {
        float weight = 0.0f;
        boolean anyEdge = false;
        for (Edge edge : edges) {
            anyEdge = true;
            weight = (float)((double)weight + edge.getWeight());
        }
        if (anyEdge) {
            if (this.edgeWeight) {
                this.writer.append(FORMAT.format(weight));
            } else {
                this.writer.append(FORMAT.format(1.0));
            }
        } else if (this.writeZero) {
            this.writer.append("0");
        }
        if (writeSeparator) {
            this.writer.append(SEPARATOR);
        }
    }

    private void writeMatrixNode(Node node, boolean writeSeparator) throws IOException {
        if (this.header) {
            Object label = node.getId();
            this.writer.append(label.toString());
            if (writeSeparator) {
                this.writer.append(SEPARATOR);
            }
        }
    }

    private void writeListNode(Node node, boolean writeSeparator) throws IOException {
        Object label = node.getId();
        this.writer.append(label.toString());
        if (writeSeparator) {
            this.writer.append(SEPARATOR);
        }
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public boolean isEdgeWeight() {
        return this.edgeWeight;
    }

    public void setEdgeWeight(boolean edgeWeight) {
        this.edgeWeight = edgeWeight;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public boolean isWriteZero() {
        return this.writeZero;
    }

    public void setWriteZero(boolean writeZero) {
        this.writeZero = writeZero;
    }

    public boolean isList() {
        return this.list;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    static {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(Locale.ENGLISH);
        FORMAT.setDecimalFormatSymbols(symbols);
    }
}

