/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.CachingTaskInputFileCollection;
import org.gradle.api.internal.file.CalculatedTaskInputFileCollection;
import org.gradle.api.internal.file.DefaultFilePropertyFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.TaskFileVarFactory;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.provider.AbstractMappingProvider;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.provider.Provider;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.DeprecationLogger;

public class DefaultProjectLayout
extends DefaultFilePropertyFactory
implements ProjectLayout,
TaskFileVarFactory {
    private final DefaultFilePropertyFactory.FixedDirectory projectDir;
    private final DefaultFilePropertyFactory.DefaultDirectoryVar buildDir;
    private final TaskResolver taskResolver;
    private final FileResolver fileResolver;

    public DefaultProjectLayout(File projectDir, FileResolver resolver, TaskResolver taskResolver) {
        super(resolver);
        this.taskResolver = taskResolver;
        this.fileResolver = resolver;
        this.projectDir = new DefaultFilePropertyFactory.FixedDirectory(projectDir, resolver);
        this.buildDir = new DefaultFilePropertyFactory.DefaultDirectoryVar(resolver, "build");
    }

    public Directory getProjectDirectory() {
        return this.projectDir;
    }

    public DirectoryProperty getBuildDirectory() {
        return this.buildDir;
    }

    public DirectoryProperty directoryProperty() {
        DeprecationLogger.nagUserOfReplacedMethod((String)"ProjectLayout.directoryProperty()", (String)"ObjectFactory.directoryProperty()");
        return this.newDirectoryProperty();
    }

    public DirectoryProperty directoryProperty(Provider<? extends Directory> initialProvider) {
        DirectoryProperty result = this.directoryProperty();
        result.set(initialProvider);
        return result;
    }

    public RegularFileProperty fileProperty() {
        DeprecationLogger.nagUserOfReplacedMethod((String)"ProjectLayout.fileProperty()", (String)"ObjectFactory.fileProperty()");
        return this.newFileProperty();
    }

    public RegularFileProperty fileProperty(Provider<? extends RegularFile> initialProvider) {
        RegularFileProperty result = this.fileProperty();
        result.set(initialProvider);
        return result;
    }

    @Override
    public ConfigurableFileCollection newInputFileCollection(Task consumer) {
        return new CachingTaskInputFileCollection(consumer.getPath(), this.projectDir.fileResolver, this.taskResolver);
    }

    @Override
    public FileCollection newCalculatedInputFileCollection(Task consumer, MinimalFileSet calculatedFiles, FileCollection ... inputs) {
        return new CalculatedTaskInputFileCollection(consumer.getPath(), calculatedFiles, inputs);
    }

    public Provider<RegularFile> file(Provider<File> provider) {
        return new AbstractMappingProvider<RegularFile, File>(RegularFile.class, Providers.internal(provider)){

            protected RegularFile map(File file) {
                return new DefaultFilePropertyFactory.FixedFile(((DefaultProjectLayout)DefaultProjectLayout.this).projectDir.fileResolver.resolve((Object)file));
            }
        };
    }

    public FileCollection files(Object ... paths) {
        return ImmutableFileCollection.usingResolver((FileResolver)this.fileResolver, (Object[])paths);
    }

    public ConfigurableFileCollection configurableFiles(Object ... files) {
        return new DefaultConfigurableFileCollection((PathToFileResolver)this.fileResolver, this.taskResolver, files);
    }

    public void setBuildDirectory(Object value) {
        this.buildDir.resolveAndSet(value);
    }
}

