/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.util.concurrent.Callable;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.NameValidator;

public class TaskFactory
implements ITaskFactory {
    private final ProjectInternal project;
    private final Instantiator instantiator;

    public TaskFactory() {
        this(null, null);
    }

    private TaskFactory(ProjectInternal project, Instantiator instantiator) {
        this.project = project;
        this.instantiator = instantiator;
    }

    @Override
    public ITaskFactory createChild(ProjectInternal project, Instantiator instantiator) {
        return new TaskFactory(project, instantiator);
    }

    @Override
    public <S extends Task> S create(final TaskIdentity<S> identity, final Object ... args) {
        if (!Task.class.isAssignableFrom(identity.type)) {
            throw new InvalidUserDataException(String.format("Cannot create task of type '%s' as it does not implement the Task interface.", identity.type.getSimpleName()));
        }
        NameValidator.validate(identity.name, "task name", "");
        final Class implType = identity.type.isAssignableFrom(DefaultTask.class) ? DefaultTask.class : identity.type;
        return AbstractTask.injectIntoNewInstance(this.project, identity, new Callable<S>(){

            @Override
            public S call() {
                try {
                    return (Task)identity.type.cast(TaskFactory.this.instantiator.newInstance(implType, args));
                }
                catch (ObjectInstantiationException e) {
                    throw new TaskInstantiationException(String.format("Could not create task of type '%s'.", identity.type.getSimpleName()), e.getCause());
                }
            }
        });
    }
}

