/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.bind;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.ArgumentBinderRegistry;
import io.micronaut.core.bind.BoundExecutable;
import io.micronaut.core.bind.ExecutableBinder;
import io.micronaut.core.bind.exceptions.UnsatisfiedArgumentException;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class DefaultExecutableBinder<S>
implements ExecutableBinder<S> {
    private final Map<Argument<?>, Object> preBound;

    public DefaultExecutableBinder() {
        this.preBound = Collections.emptyMap();
    }

    public DefaultExecutableBinder(@Nullable Map<Argument<?>, Object> preBound) {
        this.preBound = preBound == null ? Collections.emptyMap() : preBound;
    }

    @Override
    public <T, R> BoundExecutable<T, R> bind(final Executable<T, R> target, ArgumentBinderRegistry<S> registry, S source) throws UnsatisfiedArgumentException {
        Argument[] arguments = target.getArguments();
        final Object[] boundArguments = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Argument argument = arguments[i];
            if (this.preBound.containsKey(argument)) {
                boundArguments[i] = this.preBound.get(argument);
                continue;
            }
            Optional argumentBinder = registry.findArgumentBinder(argument, source);
            if (argumentBinder.isPresent()) {
                ArgumentConversionContext conversionContext;
                ArgumentBinder binder = argumentBinder.get();
                ArgumentBinder.BindingResult bindingResult = binder.bind(conversionContext = ConversionContext.of(argument), source);
                if (!bindingResult.isPresentAndSatisfied()) {
                    if (argument.getAnnotationMetadata().hasAnnotation(Nullable.class)) {
                        boundArguments[i] = null;
                        continue;
                    }
                    Optional<ConversionError> lastError = conversionContext.getLastError();
                    if (lastError.isPresent()) {
                        throw new ConversionErrorException(argument, lastError.get());
                    }
                    throw new UnsatisfiedArgumentException(argument);
                }
                boundArguments[i] = bindingResult.get();
                continue;
            }
            throw new UnsatisfiedArgumentException(argument);
        }
        return new BoundExecutable<T, R>(){

            @Override
            public Executable<T, R> getTarget() {
                return target;
            }

            @Override
            public R invoke(T instance) {
                return target.invoke(instance, this.getBoundArguments());
            }

            @Override
            public Object[] getBoundArguments() {
                return boundArguments;
            }
        };
    }

    @Override
    public <T, R> BoundExecutable<T, R> tryBind(final Executable<T, R> target, ArgumentBinderRegistry<S> registry, S source) {
        Argument[] arguments = target.getArguments();
        final Object[] boundArguments = new Object[arguments.length];
        final ArrayList<Argument> unbound = new ArrayList<Argument>(arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            Argument argument = arguments[i];
            if (this.preBound.containsKey(argument)) {
                boundArguments[i] = this.preBound.get(argument);
                continue;
            }
            Optional argumentBinder = registry.findArgumentBinder(argument, source);
            if (argumentBinder.isPresent()) {
                ArgumentConversionContext conversionContext;
                ArgumentBinder binder = argumentBinder.get();
                ArgumentBinder.BindingResult bindingResult = binder.bind(conversionContext = ConversionContext.of(argument), source);
                if (!bindingResult.isPresentAndSatisfied()) {
                    if (argument.getAnnotationMetadata().hasAnnotation(Nullable.class)) {
                        boundArguments[i] = null;
                        continue;
                    }
                    boundArguments[i] = null;
                    unbound.add(argument);
                    continue;
                }
                boundArguments[i] = bindingResult.get();
                continue;
            }
            boundArguments[i] = null;
            unbound.add(argument);
        }
        return new BoundExecutable<T, R>(){

            @Override
            public List<Argument<?>> getUnboundArguments() {
                return Collections.unmodifiableList(unbound);
            }

            @Override
            public Executable<T, R> getTarget() {
                return target;
            }

            @Override
            public R invoke(T instance) {
                return target.invoke(instance, this.getBoundArguments());
            }

            @Override
            public Object[] getBoundArguments() {
                return boundArguments;
            }
        };
    }
}

