/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.reflect;

import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.util.ArgumentUtils;
import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantiationUtils {
    public static Optional<?> tryInstantiate(String name, ClassLoader classLoader) {
        try {
            return ClassUtils.forName(name, classLoader).flatMap(InstantiationUtils::tryInstantiate);
        }
        catch (Throwable e) {
            Logger log = LoggerFactory.getLogger(InstantiationUtils.class);
            if (log.isDebugEnabled()) {
                log.debug("Tried, but could not instantiate type: " + name, e);
            }
            return Optional.empty();
        }
    }

    @Nonnull
    public static <T> Optional<T> tryInstantiate(@Nonnull Class<T> type) {
        ArgumentUtils.requireNonNull("type", type);
        Supplier<Object> reflectionFallback = () -> {
            Logger logger = ClassUtils.REFLECTION_LOGGER;
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot instantiate type [{}] without reflection. Attempting reflective instantiation", (Object)type);
            }
            try {
                Object bean = type.newInstance();
                if (type.isInstance(bean)) {
                    return bean;
                }
                return null;
            }
            catch (Throwable e) {
                try {
                    Constructor defaultConstructor = type.getDeclaredConstructor(new Class[0]);
                    defaultConstructor.setAccessible(true);
                    return InstantiationUtils.tryInstantiate(defaultConstructor, new Object[0]).orElse(null);
                }
                catch (Throwable e1) {
                    Logger log = LoggerFactory.getLogger(InstantiationUtils.class);
                    if (log.isDebugEnabled()) {
                        log.debug("Tried, but could not instantiate type: " + type, e);
                    }
                    return null;
                }
            }
        };
        Object result = BeanIntrospector.SHARED.findIntrospection(type).map(introspection -> {
            try {
                return introspection.instantiate();
            }
            catch (InstantiationException e) {
                return reflectionFallback.get();
            }
        }).orElseGet(reflectionFallback);
        return Optional.ofNullable(result);
    }

    @Nonnull
    public static <T> Optional<T> tryInstantiate(@Nonnull Constructor<T> type, Object ... args) {
        try {
            return Optional.of(type.newInstance(args));
        }
        catch (Throwable e) {
            Logger log = ClassUtils.REFLECTION_LOGGER;
            if (log.isDebugEnabled()) {
                log.debug("Tried, but could not instantiate type: " + type, e);
            }
            return Optional.empty();
        }
    }

    public static <T> T instantiate(Class<T> type) {
        try {
            return (T)BeanIntrospector.SHARED.findIntrospection(type).map(BeanIntrospection::instantiate).orElseGet(() -> {
                try {
                    Logger log = ClassUtils.REFLECTION_LOGGER;
                    if (log.isDebugEnabled()) {
                        log.debug("Reflectively instantiating type: " + type);
                    }
                    return type.newInstance();
                }
                catch (Throwable e) {
                    throw new InstantiationException("Could not instantiate type [" + type.getName() + "]: " + e.getMessage(), e);
                }
            });
        }
        catch (Throwable e) {
            throw new InstantiationException("Could not instantiate type [" + type.getName() + "]: " + e.getMessage(), e);
        }
    }

    public static Object instantiate(String type, ClassLoader classLoader) {
        try {
            return ClassUtils.forName(type, classLoader).flatMap(InstantiationUtils::tryInstantiate).orElseThrow(() -> new InstantiationException("No class found for name: " + type));
        }
        catch (Throwable e) {
            throw new InstantiationException("Could not instantiate type [" + type + "]: " + e.getMessage(), e);
        }
    }

    public static <T> T instantiate(String type, Class<T> requiredType) {
        try {
            return (T)ClassUtils.forName(type, requiredType.getClassLoader()).flatMap(aClass -> {
                if (requiredType == aClass || requiredType.isAssignableFrom((Class<?>)aClass)) {
                    return InstantiationUtils.tryInstantiate(aClass);
                }
                return Optional.empty();
            }).orElseThrow(() -> new InstantiationException("No compatible class found for name: " + type));
        }
        catch (Throwable e) {
            throw new InstantiationException("Could not instantiate type [" + type + "]: " + e.getMessage(), e);
        }
    }
}

