/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.p2;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.p2.XMLInputParser;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.util.DelegatingHandler;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class P2CompositeParser
implements XMLInputParser {
    private Set<String> childLocations = new LinkedHashSet<String>();

    public Set<String> getChildLocations() {
        return this.childLocations;
    }

    @Override
    public void parse(InputStream in) throws ParseException, IOException, SAXException {
        RepositoryHandler handler = new RepositoryHandler();
        try {
            XMLHelper.parse(in, null, (DefaultHandler)handler, null);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        this.childLocations.addAll(handler.childLocations);
    }

    private static class ChildHandler
    extends DelegatingHandler {
        private static final String CHILD = "child";
        private static final String LOCATION = "location";
        String location;

        public ChildHandler() {
            super(CHILD);
        }

        @Override
        protected void handleAttributes(Attributes atts) {
            this.location = atts.getValue(LOCATION);
        }
    }

    private static class ChildrenHandler
    extends DelegatingHandler {
        private static final String CHILDREN = "children";
        private static final String SIZE = "size";
        List<String> childLocations;

        public ChildrenHandler() {
            super(CHILDREN);
            this.addChild(new ChildHandler(), new DelegatingHandler.ChildElementHandler<ChildHandler>(){

                @Override
                public void childHanlded(ChildHandler child) {
                    childLocations.add(child.location);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.childLocations = new ArrayList<String>(size);
        }
    }

    private static class RepositoryHandler
    extends DelegatingHandler {
        private static final String REPOSITORY = "repository";
        List<String> childLocations = Collections.emptyList();

        public RepositoryHandler() {
            super(REPOSITORY);
            this.addChild(new ChildrenHandler(), new DelegatingHandler.ChildElementHandler<ChildrenHandler>(){

                @Override
                public void childHanlded(ChildrenHandler child) {
                    childLocations = child.childLocations;
                }
            });
        }
    }
}

