#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 2.3.1
id: pandoc-2.3.1-6CDtCXgHPbREgb8Fo1S2W7
key: pandoc-2.3.1-6CDtCXgHPbREgb8Fo1S2W7
license: GPL-2.0-only
copyright: (c) 2006-2018 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
author: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: https://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook, JATS,
    MediaWiki markup, TWiki markup, TikiWiki markup, Creole 1.0,
    Haddock markup, OPML, Emacs Org-Mode, Emacs Muse, txt2tags,
    Vimwiki, Word Docx, ODT, EPUB, FictionBook2, and Textile,
    and it can write Markdown, reStructuredText, XHTML, HTML 5,
    LaTeX, ConTeXt, DocBook, JATS, OPML, TEI, OpenDocument,
    ODT, Word docx, RTF, MediaWiki, DokuWiki, ZimWiki, Textile,
    groff man, groff ms, plain text, Emacs Org-Mode, AsciiDoc,
    Haddock markup, EPUB (v2 and v3), FictionBook2, InDesign
    ICML, Muse, LaTeX beamer slides, PowerPoint, and several
    kinds of HTML/JavaScript slide shows (S5, Slidy, Slideous,
    DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
abi: 24a7f90f8dd83591ec07c99f9f3ab0be
exposed: True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.BCP47
    Text.Pandoc.Class Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Highlighting
    Text.Pandoc.ImageSize Text.Pandoc.Logging Text.Pandoc.Lua
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Pretty
    Text.Pandoc.Process Text.Pandoc.Readers
    Text.Pandoc.Readers.CommonMark Text.Pandoc.Readers.Creole
    Text.Pandoc.Readers.DocBook Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.FB2
    Text.Pandoc.Readers.HTML Text.Pandoc.Readers.Haddock
    Text.Pandoc.Readers.JATS Text.Pandoc.Readers.LaTeX
    Text.Pandoc.Readers.LaTeX.Types Text.Pandoc.Readers.Markdown
    Text.Pandoc.Readers.MediaWiki Text.Pandoc.Readers.Muse
    Text.Pandoc.Readers.Native Text.Pandoc.Readers.OPML
    Text.Pandoc.Readers.Odt Text.Pandoc.Readers.Org
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.TWiki
    Text.Pandoc.Readers.Textile Text.Pandoc.Readers.TikiWiki
    Text.Pandoc.Readers.Txt2Tags Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.SelfContained Text.Pandoc.Shared Text.Pandoc.Templates
    Text.Pandoc.UTF8 Text.Pandoc.Writers Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OOXML
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.Powerpoint
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.XML
hidden-modules: Text.Pandoc.Filter Text.Pandoc.Filter.JSON
                Text.Pandoc.Filter.Lua Text.Pandoc.Filter.Path
                Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
                Text.Pandoc.Readers.Docx.Parse Text.Pandoc.Readers.Docx.Util
                Text.Pandoc.Readers.Docx.StyleMap Text.Pandoc.Readers.Docx.Fields
                Text.Pandoc.Readers.LaTeX.Parsing Text.Pandoc.Readers.Odt.Base
                Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.DocumentTree
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
                Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
                Text.Pandoc.Readers.Org.Shared
                Text.Pandoc.Writers.Powerpoint.Presentation
                Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.Lua.Filter
                Text.Pandoc.Lua.Init Text.Pandoc.Lua.Module.MediaBag
                Text.Pandoc.Lua.Module.Pandoc Text.Pandoc.Lua.Module.Utils
                Text.Pandoc.Lua.Packages Text.Pandoc.Lua.StackInstances
                Text.Pandoc.Lua.Util Text.Pandoc.CSS Text.Pandoc.CSV
                Text.Pandoc.UUID Text.Pandoc.Translations Text.Pandoc.Slides
                Paths_pandoc
import-dirs: /usr/lib/ghc-8.6.1/site-local/pandoc-2.3.1
library-dirs: /usr/lib/ghc-8.6.1/site-local/pandoc-2.3.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-2.3.1-6CDtCXgHPbREgb8Fo1S2W7
depends:
    Glob-0.9.3-ZuJvRd05HoDrAIEWt8zdJ
    HTTP-4000.3.12-9BrPHnRObSNG793UAAmuGF
    HsYAML-0.1.1.2-Dlad6V2by3xG8PrxYsfprA
    JuicyPixels-3.3.2-98nCIHoiETt1g4NtZC29ex
    SHA-1.6.4.4-2lrCL5e5YA7sXuPdJWRCJ
    aeson-1.4.1.0-8dof3cdgEra8LhpTdWgCQb
    aeson-pretty-0.8.7-4fYut9GE12F21Rho2KOV8u base-4.12.0.0
    base64-bytestring-1.0.0.1-G3Br32Wzx6yIe8CvhfIHtS binary-0.8.6.0
    blaze-html-0.9.1.1-4nZ0gaFaE644t1em3oPaiM
    blaze-markup-0.8.2.2-IwLwNWRUxfsEuYbkQ0Gv5Q bytestring-0.10.8.2
    case-insensitive-1.2.0.11-F6T6GvbsLJXGLQlCHITWZu
    cmark-gfm-0.1.5-IHxDHcNrDeAGmrPDAXEakz containers-0.6.0.1
    data-default-0.7.1.1-9TvgjOMl8fiEDpKR9EhMBO deepseq-1.4.4.0
    directory-1.3.3.0 doctemplates-0.2.2.1-LBWv9UjuzvPFwOqIpdjCE6
    exceptions-0.10.0-6rXXyfyq3lH6yULL2y1jk1 filepath-1.4.2.1
    haddock-library-1.6.0-1ITETQWZNpjIfYEqz72Jyr
    hslua-1.0.1-cvr4tQA4cY4I3Z6RjJIq5
    hslua-module-text-0.2.0-AUrybmu0jiZlQgAJUSNuO
    http-client-0.5.13.1-JGMG19H06puCrA9dS2QxMP
    http-client-tls-0.3.5.3-G4cyYsCQRJg4zk1NdcpOQj
    http-types-0.12.2-7y1WXD0L0v0C6qVqQcEAzr mtl-2.2.2
    network-2.7.0.2-2yr2pvLPehY6oGeYQ5TSho
    network-uri-2.6.1.0-K75fCYvLQE41EntOQ30cqK
    pandoc-types-1.17.5.4-6YFuZX2xSMxEcFO8UrlmIz parsec-3.1.13.0
    process-1.6.3.0 random-1.1-3ypV4EIycgb35PKjTYYr5q
    safe-0.3.17-43oyx4B630gDZMbTh3Ttji
    skylighting-0.7.4-9AKwViVFTrz8LQ9r8wOZsI
    split-0.2.3.3-9O3ah5XNSacJuZjDAE6BjK syb-0.7-KRW1LCxdMiCJrmhxCvzo37
    tagsoup-0.14.7-H82R9HC8tY8BhIh7aVVhuZ
    temporary-1.3-Un1oDCk57QEl0lu9kbslG
    texmath-0.11.1.2-IbJtTKOyrtrK9WE4Zhlve text-1.2.3.1 time-1.8.0.2
    unix-2.7.2.2 unordered-containers-0.2.9.0-LB7iMl6A8usDj0EAzhnafU
    vector-0.12.0.1-BKWaeB2IPwRDyZEP11mv5m
    xml-1.3.14-ESp8cJy4XJ8BJKfvGeNymT
    zip-archive-0.3.3-9ZXjqhjfOlnGJKb3W7x2JJ
    zlib-0.6.2-3orZ4PtYssfHtZIGrJhHYA
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

