/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.node.AExpression;

final class EConstant
extends AExpression {
    EConstant(Location location, Object constant) {
        super(location);
        this.constant = constant;
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        throw new IllegalStateException("illegal tree structure");
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw new IllegalStateException("Illegal tree structure.");
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        if (this.constant instanceof String) {
            this.actual = String.class;
        } else if (this.constant instanceof Double) {
            this.actual = Double.TYPE;
        } else if (this.constant instanceof Float) {
            this.actual = Float.TYPE;
        } else if (this.constant instanceof Long) {
            this.actual = Long.TYPE;
        } else if (this.constant instanceof Integer) {
            this.actual = Integer.TYPE;
        } else if (this.constant instanceof Character) {
            this.actual = Character.TYPE;
        } else if (this.constant instanceof Short) {
            this.actual = Short.TYPE;
        } else if (this.constant instanceof Byte) {
            this.actual = Byte.TYPE;
        } else if (this.constant instanceof Boolean) {
            this.actual = Boolean.TYPE;
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        if (this.actual == String.class) {
            methodWriter.push((String)this.constant);
        } else if (this.actual == Double.TYPE) {
            methodWriter.push((Double)this.constant);
        } else if (this.actual == Float.TYPE) {
            methodWriter.push(((Float)this.constant).floatValue());
        } else if (this.actual == Long.TYPE) {
            methodWriter.push((Long)this.constant);
        } else if (this.actual == Integer.TYPE) {
            methodWriter.push((Integer)this.constant);
        } else if (this.actual == Character.TYPE) {
            methodWriter.push(((Character)this.constant).charValue());
        } else if (this.actual == Short.TYPE) {
            methodWriter.push(((Short)this.constant).shortValue());
        } else if (this.actual == Byte.TYPE) {
            methodWriter.push(((Byte)this.constant).byteValue());
        } else if (this.actual == Boolean.TYPE) {
            methodWriter.push((Boolean)this.constant);
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
    }

    @Override
    public String toString() {
        String c = this.constant.toString();
        if (this.constant instanceof String) {
            c = "'" + c + "'";
        }
        return this.singleLineToString(this.constant.getClass().getSimpleName(), c);
    }
}

