/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.ext.DoubleByte;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.MS932;
import sun.nio.cs.ext.SJIS_0213;

public class MS932_0213
extends Charset {
    public MS932_0213() {
        super("x-MS932_0213", ExtendedCharsets.aliasesFor("MS932_0213"));
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof MS932 || cs instanceof MS932_0213;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected static class Encoder
    extends SJIS_0213.Encoder {
        static DoubleByte.Encoder encMS932 = (DoubleByte.Encoder)new MS932().newEncoder();

        protected Encoder(Charset cs) {
            super(cs);
        }

        @Override
        protected int encodeChar(char ch) {
            int db = encMS932.encodeChar(ch);
            if (db == 65533) {
                return super.encodeChar(ch);
            }
            return db;
        }
    }

    protected static class Decoder
    extends SJIS_0213.Decoder {
        static DoubleByte.Decoder decMS932 = (DoubleByte.Decoder)new MS932().newDecoder();

        protected Decoder(Charset cs) {
            super(cs);
        }

        @Override
        protected char decodeDouble(int b1, int b2) {
            char c = decMS932.decodeDouble(b1, b2);
            if (c == '\ufffd') {
                return super.decodeDouble(b1, b2);
            }
            return c;
        }
    }
}

