﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/ce/CostExplorer_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ce/model/SavingsPlansCoverage.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace CostExplorer
{
namespace Model
{
  class AWS_COSTEXPLORER_API GetSavingsPlansCoverageResult
  {
  public:
    GetSavingsPlansCoverageResult();
    GetSavingsPlansCoverageResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    GetSavingsPlansCoverageResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>The amount of spend that your Savings Plans covered.</p>
     */
    inline const Aws::Vector<SavingsPlansCoverage>& GetSavingsPlansCoverages() const{ return m_savingsPlansCoverages; }

    /**
     * <p>The amount of spend that your Savings Plans covered.</p>
     */
    inline void SetSavingsPlansCoverages(const Aws::Vector<SavingsPlansCoverage>& value) { m_savingsPlansCoverages = value; }

    /**
     * <p>The amount of spend that your Savings Plans covered.</p>
     */
    inline void SetSavingsPlansCoverages(Aws::Vector<SavingsPlansCoverage>&& value) { m_savingsPlansCoverages = std::move(value); }

    /**
     * <p>The amount of spend that your Savings Plans covered.</p>
     */
    inline GetSavingsPlansCoverageResult& WithSavingsPlansCoverages(const Aws::Vector<SavingsPlansCoverage>& value) { SetSavingsPlansCoverages(value); return *this;}

    /**
     * <p>The amount of spend that your Savings Plans covered.</p>
     */
    inline GetSavingsPlansCoverageResult& WithSavingsPlansCoverages(Aws::Vector<SavingsPlansCoverage>&& value) { SetSavingsPlansCoverages(std::move(value)); return *this;}

    /**
     * <p>The amount of spend that your Savings Plans covered.</p>
     */
    inline GetSavingsPlansCoverageResult& AddSavingsPlansCoverages(const SavingsPlansCoverage& value) { m_savingsPlansCoverages.push_back(value); return *this; }

    /**
     * <p>The amount of spend that your Savings Plans covered.</p>
     */
    inline GetSavingsPlansCoverageResult& AddSavingsPlansCoverages(SavingsPlansCoverage&& value) { m_savingsPlansCoverages.push_back(std::move(value)); return *this; }


    /**
     * <p>The token to retrieve the next set of results. Amazon Web Services provides
     * the token when the response from a previous call has more results than the
     * maximum page size.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>The token to retrieve the next set of results. Amazon Web Services provides
     * the token when the response from a previous call has more results than the
     * maximum page size.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }

    /**
     * <p>The token to retrieve the next set of results. Amazon Web Services provides
     * the token when the response from a previous call has more results than the
     * maximum page size.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }

    /**
     * <p>The token to retrieve the next set of results. Amazon Web Services provides
     * the token when the response from a previous call has more results than the
     * maximum page size.</p>
     */
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }

    /**
     * <p>The token to retrieve the next set of results. Amazon Web Services provides
     * the token when the response from a previous call has more results than the
     * maximum page size.</p>
     */
    inline GetSavingsPlansCoverageResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>The token to retrieve the next set of results. Amazon Web Services provides
     * the token when the response from a previous call has more results than the
     * maximum page size.</p>
     */
    inline GetSavingsPlansCoverageResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>The token to retrieve the next set of results. Amazon Web Services provides
     * the token when the response from a previous call has more results than the
     * maximum page size.</p>
     */
    inline GetSavingsPlansCoverageResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}

  private:

    Aws::Vector<SavingsPlansCoverage> m_savingsPlansCoverages;

    Aws::String m_nextToken;
  };

} // namespace Model
} // namespace CostExplorer
} // namespace Aws
