﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/model/TopicRuleDestinationSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace IoT
{
namespace Model
{
  class AWS_IOT_API ListTopicRuleDestinationsResult
  {
  public:
    ListTopicRuleDestinationsResult();
    ListTopicRuleDestinationsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    ListTopicRuleDestinationsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>Information about a topic rule destination.</p>
     */
    inline const Aws::Vector<TopicRuleDestinationSummary>& GetDestinationSummaries() const{ return m_destinationSummaries; }

    /**
     * <p>Information about a topic rule destination.</p>
     */
    inline void SetDestinationSummaries(const Aws::Vector<TopicRuleDestinationSummary>& value) { m_destinationSummaries = value; }

    /**
     * <p>Information about a topic rule destination.</p>
     */
    inline void SetDestinationSummaries(Aws::Vector<TopicRuleDestinationSummary>&& value) { m_destinationSummaries = std::move(value); }

    /**
     * <p>Information about a topic rule destination.</p>
     */
    inline ListTopicRuleDestinationsResult& WithDestinationSummaries(const Aws::Vector<TopicRuleDestinationSummary>& value) { SetDestinationSummaries(value); return *this;}

    /**
     * <p>Information about a topic rule destination.</p>
     */
    inline ListTopicRuleDestinationsResult& WithDestinationSummaries(Aws::Vector<TopicRuleDestinationSummary>&& value) { SetDestinationSummaries(std::move(value)); return *this;}

    /**
     * <p>Information about a topic rule destination.</p>
     */
    inline ListTopicRuleDestinationsResult& AddDestinationSummaries(const TopicRuleDestinationSummary& value) { m_destinationSummaries.push_back(value); return *this; }

    /**
     * <p>Information about a topic rule destination.</p>
     */
    inline ListTopicRuleDestinationsResult& AddDestinationSummaries(TopicRuleDestinationSummary&& value) { m_destinationSummaries.push_back(std::move(value)); return *this; }


    /**
     * <p>The token to retrieve the next set of results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>The token to retrieve the next set of results.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }

    /**
     * <p>The token to retrieve the next set of results.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }

    /**
     * <p>The token to retrieve the next set of results.</p>
     */
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }

    /**
     * <p>The token to retrieve the next set of results.</p>
     */
    inline ListTopicRuleDestinationsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>The token to retrieve the next set of results.</p>
     */
    inline ListTopicRuleDestinationsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>The token to retrieve the next set of results.</p>
     */
    inline ListTopicRuleDestinationsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}

  private:

    Aws::Vector<TopicRuleDestinationSummary> m_destinationSummaries;

    Aws::String m_nextToken;
  };

} // namespace Model
} // namespace IoT
} // namespace Aws
