/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.accessibility.AccessibilityEventProducer;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.ElementMappingRegistry;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.render.intermediate.AffineTransformArrayParser;
import org.apache.fop.render.intermediate.IFConstants;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.intermediate.extensions.DocumentNavigationHandler;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.ColorUtil;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.fop.util.ContentHandlerFactoryRegistry;
import org.apache.fop.util.DOMBuilderContentHandlerFactory;
import org.apache.fop.util.DefaultErrorListener;
import org.apache.fop.util.LanguageTags;
import org.apache.fop.util.XMLConstants;
import org.apache.fop.util.XMLUtil;
import org.apache.xmlgraphics.util.QName;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class IFParser
implements IFConstants {
    protected static final Log log = LogFactory.getLog(IFParser.class);
    private static SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    private static Set<String> handledNamespaces = new HashSet<String>();

    public void parse(Source src, IFDocumentHandler documentHandler, FOUserAgent userAgent) throws TransformerException, IFException {
        try {
            Transformer transformer = tFactory.newTransformer();
            transformer.setErrorListener(new DefaultErrorListener(log));
            SAXResult res = new SAXResult(this.getContentHandler(documentHandler, userAgent));
            transformer.transform(src, res);
        }
        catch (TransformerException te) {
            SAXException se;
            Throwable cause = te.getCause();
            if (cause instanceof SAXException ? (cause = (se = (SAXException)cause).getCause()) instanceof IFException : cause instanceof IFException) {
                throw (IFException)cause;
            }
            throw te;
        }
    }

    public ContentHandler getContentHandler(IFDocumentHandler documentHandler, FOUserAgent userAgent) {
        ElementMappingRegistry elementMappingRegistry = userAgent.getElementMappingRegistry();
        return new Handler(documentHandler, userAgent, elementMappingRegistry);
    }

    static {
        handledNamespaces.add("http://www.w3.org/2000/xmlns/");
        handledNamespaces.add("http://www.w3.org/XML/1998/namespace");
        handledNamespaces.add("http://xmlgraphics.apache.org/fop/intermediate");
        handledNamespaces.add("http://www.w3.org/1999/xlink");
    }

    private static class Handler
    extends DefaultHandler {
        private Map<String, ElementHandler> elementHandlers = new HashMap<String, ElementHandler>();
        private IFDocumentHandler documentHandler;
        private IFPainter painter;
        private FOUserAgent userAgent;
        private ElementMappingRegistry elementMappingRegistry;
        private Attributes lastAttributes;
        private StringBuffer content = new StringBuffer();
        private boolean ignoreCharacters = true;
        private int delegateDepth;
        private ContentHandler delegate;
        private boolean inForeignObject;
        private Document foreignObject;
        private ContentHandler navParser;
        private StructureTreeHandler structureTreeHandler;
        private Attributes pageSequenceAttributes;
        private Map<String, StructureTreeElement> structureTreeElements = new HashMap<String, StructureTreeElement>();
        private static final String[] SIDES = new String[]{"top", "bottom", "left", "right"};

        public Handler(IFDocumentHandler documentHandler, FOUserAgent userAgent, ElementMappingRegistry elementMappingRegistry) {
            this.documentHandler = documentHandler;
            this.userAgent = userAgent;
            this.elementMappingRegistry = elementMappingRegistry;
            this.elementHandlers.put("document", new DocumentHandler());
            this.elementHandlers.put("header", new DocumentHeaderHandler());
            this.elementHandlers.put("locale", new LocaleHandler());
            this.elementHandlers.put("trailer", new DocumentTrailerHandler());
            this.elementHandlers.put("page-sequence", new PageSequenceHandler());
            this.elementHandlers.put("page", new PageHandler());
            this.elementHandlers.put("page-header", new PageHeaderHandler());
            this.elementHandlers.put("content", new PageContentHandler());
            this.elementHandlers.put("page-trailer", new PageTrailerHandler());
            this.elementHandlers.put("viewport", new ViewportHandler());
            this.elementHandlers.put("g", new GroupHandler());
            this.elementHandlers.put("id", new IDHandler());
            this.elementHandlers.put("font", new FontHandler());
            this.elementHandlers.put("text", new TextHandler());
            this.elementHandlers.put("clip-rect", new ClipRectHandler());
            this.elementHandlers.put("rect", new RectHandler());
            this.elementHandlers.put("line", new LineHandler());
            this.elementHandlers.put("border-rect", new BorderRectHandler());
            this.elementHandlers.put("image", new ImageHandler());
        }

        private void establishForeignAttributes(Map<QName, String> foreignAttributes) {
            this.documentHandler.getContext().setForeignAttributes(foreignAttributes);
        }

        private void resetForeignAttributes() {
            this.documentHandler.getContext().resetForeignAttributes();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.delegate != null) {
                ++this.delegateDepth;
                this.delegate.startElement(uri, localName, qName, attributes);
            } else {
                boolean handled = true;
                if ("http://xmlgraphics.apache.org/fop/intermediate".equals(uri)) {
                    if (localName.equals("page-sequence") && this.userAgent.isAccessibilityEnabled()) {
                        this.pageSequenceAttributes = new AttributesImpl(attributes);
                        Locale language = Handler.getLanguage(attributes);
                        this.structureTreeHandler = new MainStructureTreeHandler(this.userAgent.getStructureTreeEventHandler(), language);
                    } else if (localName.equals("structure-tree")) {
                        if (this.userAgent.isAccessibilityEnabled()) {
                            String type = attributes.getValue("type");
                            this.structureTreeHandler.startStructureTree(type);
                            this.delegate = this.structureTreeHandler;
                        } else {
                            this.delegate = new DefaultHandler();
                        }
                        ++this.delegateDepth;
                        this.delegate.startDocument();
                        this.delegate.startElement(uri, localName, qName, attributes);
                    } else {
                        if (this.pageSequenceAttributes != null) {
                            AccessibilityEventProducer.Provider.get(this.userAgent.getEventBroadcaster()).noStructureTreeInXML(this);
                        }
                        handled = this.startIFElement(localName, attributes);
                    }
                } else if ("http://xmlgraphics.apache.org/fop/intermediate/document-navigation".equals(uri)) {
                    if (this.navParser == null) {
                        this.navParser = new DocumentNavigationHandler(this.documentHandler.getDocumentNavigationHandler(), this.structureTreeElements);
                    }
                    this.delegate = this.navParser;
                    ++this.delegateDepth;
                    this.delegate.startDocument();
                    this.delegate.startElement(uri, localName, qName, attributes);
                } else {
                    ContentHandlerFactoryRegistry registry = this.userAgent.getContentHandlerFactoryRegistry();
                    ContentHandlerFactory factory = registry.getFactory(uri);
                    if (factory == null) {
                        DOMImplementation domImplementation = this.elementMappingRegistry.getDOMImplementationForNamespace(uri);
                        if (domImplementation == null) {
                            domImplementation = ElementMapping.getDefaultDOMImplementation();
                        }
                        factory = new DOMBuilderContentHandlerFactory(uri, domImplementation);
                    }
                    this.delegate = factory.createContentHandler();
                    ++this.delegateDepth;
                    this.delegate.startDocument();
                    this.delegate.startElement(uri, localName, qName, attributes);
                }
                if (!handled) {
                    if (uri == null || uri.length() == 0) {
                        throw new SAXException("Unhandled element " + localName + " in namespace: " + uri);
                    }
                    log.warn((Object)("Unhandled element " + localName + " in namespace: " + uri));
                }
            }
        }

        private static Locale getLanguage(Attributes attributes) {
            String xmllang = attributes.getValue("http://www.w3.org/XML/1998/namespace", "lang");
            return xmllang == null ? null : LanguageTags.toLocale(xmllang);
        }

        private boolean startIFElement(String localName, Attributes attributes) throws SAXException {
            this.lastAttributes = new AttributesImpl(attributes);
            ElementHandler elementHandler = this.elementHandlers.get(localName);
            this.content.setLength(0);
            this.ignoreCharacters = true;
            if (elementHandler != null) {
                this.ignoreCharacters = elementHandler.ignoreCharacters();
                try {
                    elementHandler.startElement(attributes);
                }
                catch (IFException ife) {
                    this.handleIFException(ife);
                }
                return true;
            }
            return false;
        }

        private void handleIFException(IFException ife) throws SAXException {
            Throwable cause = ife.getCause();
            if (cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            throw new SAXException(ife);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.delegate != null) {
                this.delegate.endElement(uri, localName, qName);
                --this.delegateDepth;
                if (this.delegateDepth == 0) {
                    this.delegate.endDocument();
                    if (this.delegate instanceof ContentHandlerFactory.ObjectSource) {
                        Object obj = ((ContentHandlerFactory.ObjectSource)((Object)this.delegate)).getObject();
                        if (this.inForeignObject) {
                            this.foreignObject = (Document)obj;
                        } else {
                            this.handleExternallyGeneratedObject(obj);
                        }
                    }
                    this.delegate = null;
                }
            } else if ("http://xmlgraphics.apache.org/fop/intermediate".equals(uri)) {
                ElementHandler elementHandler = this.elementHandlers.get(localName);
                if (elementHandler != null) {
                    try {
                        elementHandler.endElement();
                    }
                    catch (IFException ife) {
                        this.handleIFException(ife);
                    }
                    this.content.setLength(0);
                }
                this.ignoreCharacters = true;
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Ignoring " + localName + " in namespace: " + uri));
            }
        }

        protected void handleExternallyGeneratedObject(Object obj) throws SAXException {
            try {
                this.documentHandler.handleExtensionObject(obj);
            }
            catch (IFException ife) {
                this.handleIFException(ife);
            }
        }

        private Color getAttributeAsColor(Attributes attributes, String name) throws PropertyException {
            String s = attributes.getValue(name);
            if (s == null) {
                return null;
            }
            return ColorUtil.parseColorString(this.userAgent, s);
        }

        private static Map<QName, String> getForeignAttributes(Attributes atts) {
            HashMap<QName, String> foreignAttributes = null;
            int c = atts.getLength();
            for (int i = 0; i < c; ++i) {
                String ns = atts.getURI(i);
                if (ns.length() <= 0 || handledNamespaces.contains(ns)) continue;
                if (foreignAttributes == null) {
                    foreignAttributes = new HashMap<QName, String>();
                }
                QName qname = new QName(ns, atts.getQName(i));
                foreignAttributes.put(qname, atts.getValue(i));
            }
            return foreignAttributes;
        }

        private void establishStructureTreeElement(Attributes attributes) {
            StructureTreeElement element = this.getStructureTreeElement(attributes);
            if (element != null) {
                this.documentHandler.getContext().setStructureTreeElement(element);
            }
        }

        private StructureTreeElement getStructureTreeElement(Attributes attributes) {
            String structRef = attributes.getValue("http://xmlgraphics.apache.org/fop/internal", "struct-ref");
            if (structRef != null && structRef.length() > 0) {
                assert (this.structureTreeElements.containsKey(structRef));
                return this.structureTreeElements.get(structRef);
            }
            return null;
        }

        private void resetStructureTreeElement() {
            this.documentHandler.getContext().resetStructureTreeElement();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.delegate != null) {
                this.delegate.characters(ch, start, length);
            } else if (!this.ignoreCharacters) {
                this.content.append(ch, start, length);
            }
        }

        private class StructureTreeHandler
        extends DefaultHandler {
            protected final StructureTreeEventHandler structureTreeEventHandler;

            StructureTreeHandler(StructureTreeEventHandler structureTreeEventHandler) {
                this.structureTreeEventHandler = structureTreeEventHandler;
            }

            void startStructureTree(String type) {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (!"structure-tree".equals(localName)) {
                    if (localName.equals("marked-content")) {
                        localName = "#PCDATA";
                    }
                    StructureTreeElement parent = Handler.this.getStructureTreeElement(attributes);
                    String structID = attributes.getValue("http://xmlgraphics.apache.org/fop/internal", "struct-id");
                    if (structID == null) {
                        this.structureTreeEventHandler.startNode(localName, attributes, parent);
                    } else if (localName.equals("external-graphic") || localName.equals("instream-foreign-object")) {
                        StructureTreeElement structureTreeElement = this.structureTreeEventHandler.startImageNode(localName, attributes, parent);
                        Handler.this.structureTreeElements.put(structID, structureTreeElement);
                    } else {
                        StructureTreeElement structureTreeElement = this.structureTreeEventHandler.startReferencedNode(localName, attributes, parent);
                        Handler.this.structureTreeElements.put(structID, structureTreeElement);
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String arqNameg2) throws SAXException {
                if (!"structure-tree".equals(localName)) {
                    this.structureTreeEventHandler.endNode(localName);
                }
            }
        }

        private class DocumentHandler
        extends AbstractElementHandler {
            private DocumentHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                Handler.this.documentHandler.startDocument();
            }

            @Override
            public void endElement() throws IFException {
                Handler.this.documentHandler.endDocument();
            }
        }

        private class DocumentHeaderHandler
        extends AbstractElementHandler {
            private DocumentHeaderHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                Handler.this.documentHandler.startDocumentHeader();
            }

            @Override
            public void endElement() throws IFException {
                Handler.this.documentHandler.endDocumentHeader();
            }
        }

        private class LocaleHandler
        extends AbstractElementHandler {
            private LocaleHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                Handler.this.documentHandler.setDocumentLocale(Handler.getLanguage(attributes));
            }
        }

        private class DocumentTrailerHandler
        extends AbstractElementHandler {
            private DocumentTrailerHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                Handler.this.documentHandler.startDocumentTrailer();
            }

            @Override
            public void endElement() throws IFException {
                Handler.this.documentHandler.endDocumentTrailer();
            }
        }

        private class PageSequenceHandler
        extends AbstractElementHandler {
            private PageSequenceHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                String id = attributes.getValue("id");
                Locale language = Handler.getLanguage(attributes);
                if (language != null) {
                    Handler.this.documentHandler.getContext().setLanguage(language);
                }
                Map foreignAttributes = Handler.getForeignAttributes(Handler.this.lastAttributes);
                Handler.this.establishForeignAttributes(foreignAttributes);
                Handler.this.documentHandler.startPageSequence(id);
                Handler.this.resetForeignAttributes();
            }

            @Override
            public void endElement() throws IFException {
                Handler.this.documentHandler.endPageSequence();
                Handler.this.documentHandler.getContext().setLanguage(null);
            }
        }

        private class PageHandler
        extends AbstractElementHandler {
            private PageHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                int index = Integer.parseInt(attributes.getValue("index"));
                String name = attributes.getValue("name");
                String pageMasterName = attributes.getValue("page-master-name");
                int width = Integer.parseInt(attributes.getValue("width"));
                int height = Integer.parseInt(attributes.getValue("height"));
                Map foreignAttributes = Handler.getForeignAttributes(Handler.this.lastAttributes);
                Handler.this.establishForeignAttributes(foreignAttributes);
                Handler.this.documentHandler.startPage(index, name, pageMasterName, new Dimension(width, height));
                Handler.this.documentHandler.getContext().setPageNumber(index + 1);
                Handler.this.resetForeignAttributes();
            }

            @Override
            public void endElement() throws IFException {
                Handler.this.documentHandler.endPage();
            }
        }

        private class PageHeaderHandler
        extends AbstractElementHandler {
            private PageHeaderHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                Handler.this.documentHandler.startPageHeader();
                Handler.this.structureTreeHandler = new StructureTreeHandler(Handler.this.userAgent.getStructureTreeEventHandler());
            }

            @Override
            public void endElement() throws IFException {
                Handler.this.documentHandler.endPageHeader();
            }
        }

        private class PageContentHandler
        extends AbstractElementHandler {
            private PageContentHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                Handler.this.painter = Handler.this.documentHandler.startPageContent();
            }

            @Override
            public void endElement() throws IFException {
                Handler.this.painter = null;
                Handler.this.documentHandler.getContext().setID("");
                Handler.this.documentHandler.endPageContent();
            }
        }

        private class PageTrailerHandler
        extends AbstractElementHandler {
            private PageTrailerHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                Handler.this.documentHandler.startPageTrailer();
            }

            @Override
            public void endElement() throws IFException {
                Handler.this.documentHandler.endPageTrailer();
            }
        }

        private class ViewportHandler
        extends AbstractElementHandler {
            private ViewportHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                String transform = attributes.getValue("transform");
                AffineTransform[] transforms = AffineTransformArrayParser.createAffineTransform(transform);
                int width = Integer.parseInt(attributes.getValue("width"));
                int height = Integer.parseInt(attributes.getValue("height"));
                Rectangle clipRect = XMLUtil.getAttributeAsRectangle(attributes, "clip-rect");
                Handler.this.painter.startViewport(transforms, new Dimension(width, height), clipRect);
            }

            @Override
            public void endElement() throws IFException {
                Handler.this.painter.endViewport();
            }
        }

        private class GroupHandler
        extends AbstractElementHandler {
            private GroupHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                String transform = attributes.getValue("transform");
                AffineTransform[] transforms = AffineTransformArrayParser.createAffineTransform(transform);
                String layer = attributes.getValue("layer");
                Handler.this.painter.startGroup(transforms, layer);
            }

            @Override
            public void endElement() throws IFException {
                Handler.this.painter.endGroup();
            }
        }

        private class IDHandler
        extends AbstractElementHandler {
            private IDHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException, SAXException {
                String id = attributes.getValue("name");
                Handler.this.documentHandler.getContext().setID(id);
            }
        }

        private class FontHandler
        extends AbstractElementHandler {
            private FontHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                Color color;
                String family = attributes.getValue("family");
                String style = attributes.getValue("style");
                Integer weight = XMLUtil.getAttributeAsInteger(attributes, "weight");
                String variant = attributes.getValue("variant");
                Integer size = XMLUtil.getAttributeAsInteger(attributes, "size");
                try {
                    color = Handler.this.getAttributeAsColor(attributes, "color");
                }
                catch (PropertyException pe) {
                    throw new IFException("Error parsing the color attribute", pe);
                }
                Handler.this.painter.setFont(family, style, weight, variant, size, color);
            }
        }

        private class TextHandler
        extends AbstractElementHandler {
            private TextHandler() {
            }

            @Override
            public void endElement() throws IFException {
                int x = Integer.parseInt(Handler.this.lastAttributes.getValue("x"));
                int y = Integer.parseInt(Handler.this.lastAttributes.getValue("y"));
                String s = Handler.this.lastAttributes.getValue("letter-spacing");
                int letterSpacing = s != null ? Integer.parseInt(s) : 0;
                s = Handler.this.lastAttributes.getValue("word-spacing");
                int wordSpacing = s != null ? Integer.parseInt(s) : 0;
                int[] dx = XMLUtil.getAttributeAsIntArray(Handler.this.lastAttributes, "dx");
                int[][] dp = XMLUtil.getAttributeAsPositionAdjustments(Handler.this.lastAttributes, "dp");
                if (dp == null && dx != null) {
                    dp = IFUtil.convertDXToDP(dx);
                }
                Handler.this.establishStructureTreeElement(Handler.this.lastAttributes);
                boolean isHyphenated = Boolean.valueOf(Handler.this.lastAttributes.getValue("hyphenated"));
                if (isHyphenated) {
                    Handler.this.documentHandler.getContext().setHyphenated(isHyphenated);
                }
                boolean nextIsSpace = Boolean.valueOf(Handler.this.lastAttributes.getValue("next-is-space"));
                Handler.this.painter.drawText(x, y, letterSpacing, wordSpacing, dp, Handler.this.content.toString(), nextIsSpace);
                Handler.this.documentHandler.getContext().setHyphenated(false);
                Handler.this.resetStructureTreeElement();
            }

            @Override
            public boolean ignoreCharacters() {
                return false;
            }
        }

        private class ClipRectHandler
        extends AbstractElementHandler {
            private ClipRectHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                int x = Integer.parseInt(attributes.getValue("x"));
                int y = Integer.parseInt(attributes.getValue("y"));
                int width = Integer.parseInt(attributes.getValue("width"));
                int height = Integer.parseInt(attributes.getValue("height"));
                BorderProps[] borders = new BorderProps[4];
                for (int i = 0; i < 4; ++i) {
                    String b = attributes.getValue(SIDES[i]);
                    if (b == null) continue;
                    borders[i] = BorderProps.valueOf(Handler.this.userAgent, b);
                }
                if (borders[0] != null || borders[1] != null || borders[2] != null || borders[3] != null) {
                    Handler.this.painter.clipBackground(new Rectangle(x, y, width, height), borders[0], borders[1], borders[2], borders[3]);
                }
                Handler.this.painter.clipRect(new Rectangle(x, y, width, height));
            }
        }

        private class RectHandler
        extends AbstractElementHandler {
            private RectHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                Color fillColor;
                int x = Integer.parseInt(attributes.getValue("x"));
                int y = Integer.parseInt(attributes.getValue("y"));
                int width = Integer.parseInt(attributes.getValue("width"));
                int height = Integer.parseInt(attributes.getValue("height"));
                try {
                    fillColor = Handler.this.getAttributeAsColor(attributes, "fill");
                }
                catch (PropertyException pe) {
                    throw new IFException("Error parsing the fill attribute", pe);
                }
                Rectangle rectangularArea = new Rectangle(x, y, width, height);
                BorderProps[] borders = new BorderProps[4];
                for (int i = 0; i < 4; ++i) {
                    String b = attributes.getValue(SIDES[i]);
                    if (b == null) continue;
                    borders[i] = BorderProps.valueOf(Handler.this.userAgent, b);
                }
                if (borders[0] != null || borders[1] != null || borders[2] != null || borders[3] != null) {
                    Handler.this.painter.clipBackground(rectangularArea, borders[0], borders[1], borders[2], borders[3]);
                }
                Handler.this.painter.fillRect(rectangularArea, fillColor);
            }
        }

        private class LineHandler
        extends AbstractElementHandler {
            private LineHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                Color color;
                int x1 = Integer.parseInt(attributes.getValue("x1"));
                int y1 = Integer.parseInt(attributes.getValue("y1"));
                int x2 = Integer.parseInt(attributes.getValue("x2"));
                int y2 = Integer.parseInt(attributes.getValue("y2"));
                int width = Integer.parseInt(attributes.getValue("stroke-width"));
                try {
                    color = Handler.this.getAttributeAsColor(attributes, "color");
                }
                catch (PropertyException pe) {
                    throw new IFException("Error parsing the fill attribute", pe);
                }
                RuleStyle style = RuleStyle.valueOf(attributes.getValue("style"));
                Handler.this.painter.drawLine(new Point(x1, y1), new Point(x2, y2), width, color, style);
            }
        }

        private class BorderRectHandler
        extends AbstractElementHandler {
            private BorderRectHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                Color backgroundColor;
                int x = Integer.parseInt(attributes.getValue("x"));
                int y = Integer.parseInt(attributes.getValue("y"));
                int width = Integer.parseInt(attributes.getValue("width"));
                int height = Integer.parseInt(attributes.getValue("height"));
                BorderProps[] borders = new BorderProps[4];
                for (int i = 0; i < 4; ++i) {
                    String b = attributes.getValue(SIDES[i]);
                    if (b == null) continue;
                    borders[i] = BorderProps.valueOf(Handler.this.userAgent, b);
                }
                try {
                    backgroundColor = Handler.this.getAttributeAsColor(attributes, "inner-background-color");
                }
                catch (PropertyException pe) {
                    throw new IFException("Error parsing the color attribute", pe);
                }
                Handler.this.painter.drawBorderRect(new Rectangle(x, y, width, height), borders[0], borders[1], borders[2], borders[3], backgroundColor);
            }
        }

        private class ImageHandler
        extends AbstractElementHandler {
            private ImageHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException {
                Handler.this.inForeignObject = true;
            }

            @Override
            public void endElement() throws IFException {
                int x = Integer.parseInt(Handler.this.lastAttributes.getValue("x"));
                int y = Integer.parseInt(Handler.this.lastAttributes.getValue("y"));
                int width = Integer.parseInt(Handler.this.lastAttributes.getValue("width"));
                int height = Integer.parseInt(Handler.this.lastAttributes.getValue("height"));
                Map foreignAttributes = Handler.getForeignAttributes(Handler.this.lastAttributes);
                Handler.this.establishForeignAttributes(foreignAttributes);
                Handler.this.establishStructureTreeElement(Handler.this.lastAttributes);
                if (Handler.this.foreignObject != null) {
                    Handler.this.painter.drawImage(Handler.this.foreignObject, new Rectangle(x, y, width, height));
                    Handler.this.foreignObject = null;
                } else {
                    String uri = Handler.this.lastAttributes.getValue(XMLConstants.XLINK_HREF.getNamespaceURI(), XMLConstants.XLINK_HREF.getLocalName());
                    if (uri == null) {
                        throw new IFException("xlink:href is missing on image", null);
                    }
                    Handler.this.painter.drawImage(uri, new Rectangle(x, y, width, height));
                }
                Handler.this.resetStructureTreeElement();
                Handler.this.resetForeignAttributes();
                Handler.this.inForeignObject = false;
            }

            @Override
            public boolean ignoreCharacters() {
                return false;
            }
        }

        private class MainStructureTreeHandler
        extends StructureTreeHandler {
            private final Locale pageSequenceLanguage;

            MainStructureTreeHandler(StructureTreeEventHandler structureTreeEventHandler, Locale pageSequenceLanguage) throws SAXException {
                super(structureTreeEventHandler);
                this.pageSequenceLanguage = pageSequenceLanguage;
            }

            @Override
            void startStructureTree(String type) {
                this.structureTreeEventHandler.startPageSequence(this.pageSequenceLanguage, type);
            }

            @Override
            public void endDocument() throws SAXException {
                Handler.this.startIFElement("page-sequence", Handler.this.pageSequenceAttributes);
                Handler.this.pageSequenceAttributes = null;
            }
        }

        private static interface ElementHandler {
            public void startElement(Attributes var1) throws IFException, SAXException;

            public void endElement() throws IFException;

            public boolean ignoreCharacters();
        }

        private abstract class AbstractElementHandler
        implements ElementHandler {
            private AbstractElementHandler() {
            }

            @Override
            public void startElement(Attributes attributes) throws IFException, SAXException {
            }

            @Override
            public void endElement() throws IFException {
            }

            @Override
            public boolean ignoreCharacters() {
                return true;
            }
        }
    }
}

