/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg12;

import java.util.HashSet;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.events.EventListenerList;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg12.XBLOMHandlerGroupElement;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.dom.xbl.NodeXBL;
import org.apache.batik.dom.xbl.ShadowTreeEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MutationEvent;

public class XBLEventSupport
extends EventSupport {
    protected HashTable capturingImplementationListeners;
    protected HashTable bubblingImplementationListeners;
    protected static HashTable eventTypeAliases = new HashTable();

    public XBLEventSupport(AbstractNode n) {
        super(n);
    }

    public void addEventListenerNS(String namespaceURI, String type, EventListener listener, boolean useCapture, Object group) {
        String alias;
        super.addEventListenerNS(namespaceURI, type, listener, useCapture, group);
        if ((namespaceURI == null || namespaceURI.equals("http://www.w3.org/2001/xml-events")) && (alias = (String)eventTypeAliases.get((Object)type)) != null) {
            super.addEventListenerNS(namespaceURI, alias, listener, useCapture, group);
        }
    }

    public void removeEventListenerNS(String namespaceURI, String type, EventListener listener, boolean useCapture) {
        String alias;
        super.removeEventListenerNS(namespaceURI, type, listener, useCapture);
        if ((namespaceURI == null || namespaceURI.equals("http://www.w3.org/2001/xml-events")) && (alias = (String)eventTypeAliases.get((Object)type)) != null) {
            super.removeEventListenerNS(namespaceURI, alias, listener, useCapture);
        }
    }

    public void addImplementationEventListenerNS(String namespaceURI, String type, EventListener listener, boolean useCapture) {
        HashTable listeners;
        if (useCapture) {
            if (this.capturingImplementationListeners == null) {
                this.capturingImplementationListeners = new HashTable();
            }
            listeners = this.capturingImplementationListeners;
        } else {
            if (this.bubblingImplementationListeners == null) {
                this.bubblingImplementationListeners = new HashTable();
            }
            listeners = this.bubblingImplementationListeners;
        }
        EventListenerList list = (EventListenerList)listeners.get((Object)type);
        if (list == null) {
            list = new EventListenerList();
            listeners.put((Object)type, (Object)list);
        }
        list.addListener(namespaceURI, null, listener);
    }

    public void removeImplementationEventListenerNS(String namespaceURI, String type, EventListener listener, boolean useCapture) {
        HashTable listeners;
        HashTable hashTable = listeners = useCapture ? this.capturingImplementationListeners : this.bubblingImplementationListeners;
        if (listeners == null) {
            return;
        }
        EventListenerList list = (EventListenerList)listeners.get((Object)type);
        if (list == null) {
            return;
        }
        list.removeListener(namespaceURI, listener);
        if (list.size() == 0) {
            listeners.remove((Object)type);
        }
    }

    public void moveEventListeners(EventSupport other) {
        super.moveEventListeners(other);
        XBLEventSupport es = (XBLEventSupport)other;
        es.capturingImplementationListeners = this.capturingImplementationListeners;
        es.bubblingImplementationListeners = this.bubblingImplementationListeners;
        this.capturingImplementationListeners = null;
        this.bubblingImplementationListeners = null;
    }

    public boolean dispatchEvent(NodeEventTarget target, Event evt) throws EventException {
        if (evt == null) {
            return false;
        }
        if (!(evt instanceof AbstractEvent)) {
            throw this.createEventException((short)9, "unsupported.event", new Object[0]);
        }
        AbstractEvent e = (AbstractEvent)evt;
        String type = e.getType();
        if (type == null || type.length() == 0) {
            throw this.createEventException((short)0, "unspecified.event", new Object[0]);
        }
        this.setTarget(e, target);
        this.stopPropagation(e, false);
        this.stopImmediatePropagation(e, false);
        this.preventDefault(e, false);
        NodeEventTarget[] ancestors = this.getAncestors(target);
        int bubbleLimit = e.getBubbleLimit();
        int minAncestor = 0;
        if (this.isSingleScopeEvent((Event)e)) {
            AbstractNode targetNode = (AbstractNode)target;
            Element boundElement = targetNode.getXblBoundElement();
            if (boundElement != null) {
                minAncestor = ancestors.length;
                while (minAncestor > 0) {
                    AbstractNode ancestorNode = (AbstractNode)ancestors[minAncestor - 1];
                    if (ancestorNode.getXblBoundElement() == boundElement) {
                        --minAncestor;
                        continue;
                    }
                    break;
                }
            }
        } else if (bubbleLimit != 0 && (minAncestor = ancestors.length - bubbleLimit + 1) < 0) {
            minAncestor = 0;
        }
        AbstractEvent[] es = this.getRetargettedEvents(target, ancestors, e);
        boolean preventDefault = false;
        HashSet stoppedGroups = new HashSet();
        HashSet toBeStoppedGroups = new HashSet();
        int i = 0;
        while (i < minAncestor) {
            NodeEventTarget node = ancestors[i];
            this.setCurrentTarget(es[i], node);
            this.setEventPhase(es[i], (short)1);
            this.fireImplementationEventListeners(node, es[i], true);
            ++i;
        }
        int i2 = minAncestor;
        while (i2 < ancestors.length) {
            NodeEventTarget node = ancestors[i2];
            this.setCurrentTarget(es[i2], node);
            this.setEventPhase(es[i2], (short)1);
            this.fireImplementationEventListeners(node, es[i2], true);
            this.fireEventListeners(node, es[i2], true, stoppedGroups, toBeStoppedGroups);
            this.fireHandlerGroupEventListeners(node, es[i2], true, stoppedGroups, toBeStoppedGroups);
            preventDefault = preventDefault || es[i2].getDefaultPrevented();
            stoppedGroups.addAll(toBeStoppedGroups);
            toBeStoppedGroups.clear();
            ++i2;
        }
        this.setEventPhase(e, (short)2);
        this.setCurrentTarget(e, target);
        this.fireImplementationEventListeners(target, e, false);
        this.fireEventListeners(target, e, false, stoppedGroups, toBeStoppedGroups);
        this.fireHandlerGroupEventListeners((NodeEventTarget)this.node, e, false, stoppedGroups, toBeStoppedGroups);
        stoppedGroups.addAll(toBeStoppedGroups);
        toBeStoppedGroups.clear();
        boolean bl = preventDefault = preventDefault || e.getDefaultPrevented();
        if (e.getBubbles()) {
            int i3 = ancestors.length - 1;
            while (i3 >= minAncestor) {
                NodeEventTarget node = ancestors[i3];
                this.setCurrentTarget(es[i3], node);
                this.setEventPhase(es[i3], (short)3);
                this.fireImplementationEventListeners(node, es[i3], false);
                this.fireEventListeners(node, es[i3], false, stoppedGroups, toBeStoppedGroups);
                this.fireHandlerGroupEventListeners(node, es[i3], false, stoppedGroups, toBeStoppedGroups);
                preventDefault = preventDefault || es[i3].getDefaultPrevented();
                stoppedGroups.addAll(toBeStoppedGroups);
                toBeStoppedGroups.clear();
                --i3;
            }
            int i4 = minAncestor - 1;
            while (i4 >= 0) {
                NodeEventTarget node = ancestors[i4];
                this.setCurrentTarget(es[i4], node);
                this.setEventPhase(es[i4], (short)3);
                this.fireImplementationEventListeners(node, es[i4], false);
                preventDefault = preventDefault || es[i4].getDefaultPrevented();
                --i4;
            }
        }
        if (!preventDefault) {
            this.runDefaultActions(e);
        }
        return preventDefault;
    }

    protected void fireHandlerGroupEventListeners(NodeEventTarget node, AbstractEvent e, boolean useCapture, HashSet stoppedGroups, HashSet toBeStoppedGroups) {
        NodeList defs = ((NodeXBL)node).getXblDefinitions();
        int j = 0;
        while (j < defs.getLength()) {
            Node n = defs.item(j).getFirstChild();
            while (n != null && !(n instanceof XBLOMHandlerGroupElement)) {
                n = n.getNextSibling();
            }
            if (n != null) {
                node = (NodeEventTarget)n;
                String type = e.getType();
                EventSupport support = node.getEventSupport();
                if (support != null) {
                    EventListenerList list = support.getEventListeners(type, useCapture);
                    if (list == null) {
                        return;
                    }
                    EventListenerList.Entry[] listeners = list.getEventListeners();
                    this.fireEventListeners(node, e, listeners, stoppedGroups, toBeStoppedGroups);
                }
            }
            ++j;
        }
    }

    protected boolean isSingleScopeEvent(Event evt) {
        return evt instanceof MutationEvent || evt instanceof ShadowTreeEvent;
    }

    protected AbstractEvent[] getRetargettedEvents(NodeEventTarget target, NodeEventTarget[] ancestors, AbstractEvent e) {
        boolean singleScope = this.isSingleScopeEvent((Event)e);
        AbstractNode targetNode = (AbstractNode)target;
        AbstractEvent[] es = new AbstractEvent[ancestors.length];
        if (ancestors.length > 0) {
            int index = ancestors.length - 1;
            Element boundElement = targetNode.getXblBoundElement();
            AbstractNode ancestorNode = (AbstractNode)ancestors[index];
            es[index] = !singleScope && ancestorNode.getXblBoundElement() != boundElement ? this.retargetEvent(e, ancestors[index]) : e;
            while (--index >= 0) {
                ancestorNode = (AbstractNode)ancestors[index + 1];
                boundElement = ancestorNode.getXblBoundElement();
                AbstractNode nextAncestorNode = (AbstractNode)ancestors[index];
                Element nextBoundElement = nextAncestorNode.getXblBoundElement();
                es[index] = !singleScope && nextBoundElement != boundElement ? this.retargetEvent(es[index + 1], ancestors[index]) : es[index + 1];
            }
        }
        return es;
    }

    protected AbstractEvent retargetEvent(AbstractEvent e, NodeEventTarget target) {
        AbstractEvent clonedEvent = e.cloneEvent();
        this.setTarget(clonedEvent, target);
        return clonedEvent;
    }

    public EventListenerList getImplementationEventListeners(String type, boolean useCapture) {
        HashTable listeners;
        HashTable hashTable = listeners = useCapture ? this.capturingImplementationListeners : this.bubblingImplementationListeners;
        if (listeners == null) {
            return null;
        }
        return (EventListenerList)listeners.get((Object)type);
    }

    protected void fireImplementationEventListeners(NodeEventTarget node, AbstractEvent e, boolean useCapture) {
        String type = e.getType();
        XBLEventSupport support = (XBLEventSupport)node.getEventSupport();
        if (support == null) {
            return;
        }
        EventListenerList list = support.getImplementationEventListeners(type, useCapture);
        if (list == null) {
            return;
        }
        EventListenerList.Entry[] listeners = list.getEventListeners();
        this.fireEventListeners(node, e, listeners, null, null);
    }

    static {
        eventTypeAliases.put((Object)"SVGLoad", (Object)"load");
        eventTypeAliases.put((Object)"SVGUnoad", (Object)"unload");
        eventTypeAliases.put((Object)"SVGAbort", (Object)"abort");
        eventTypeAliases.put((Object)"SVGError", (Object)"error");
        eventTypeAliases.put((Object)"SVGResize", (Object)"resize");
        eventTypeAliases.put((Object)"SVGScroll", (Object)"scroll");
        eventTypeAliases.put((Object)"SVGZoom", (Object)"zoom");
    }
}

