/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.ChangePropertyKeyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.Entities;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.Check;
import org.openstreetmap.josm.gui.tagging.presets.items.CheckGroup;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.widgets.EditableList;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public class TagChecker
extends Test.TagTest {
    public static final String IGNORE_FILE = "resource://data/validator/ignoretags.cfg";
    public static final String SPELL_FILE = "resource://data/validator/words.cfg";
    private static final Map<String, String> harmonizedKeys = new HashMap<String, String>();
    private static volatile HashSet<String> additionalPresetsValueData;
    private static volatile MultiMap<String, String> oftenUsedTags;
    private static final Pattern UNWANTED_NON_PRINTING_CONTROL_CHARACTERS;
    private static final List<String> ignoreDataStartsWith;
    private static final Set<String> ignoreDataEquals;
    private static final List<String> ignoreDataEndsWith;
    private static final List<Tag> ignoreDataTag;
    private static final Set<String> ignoreForLevenshtein;
    protected static final String PREFIX;
    public static final String PREF_CHECK_VALUES;
    public static final String PREF_CHECK_KEYS;
    public static final String PREF_CHECK_COMPLEX;
    public static final String PREF_CHECK_FIXMES;
    public static final String PREF_SOURCES;
    private static final String BEFORE_UPLOAD = "BeforeUpload";
    public static final String PREF_CHECK_KEYS_BEFORE_UPLOAD;
    public static final String PREF_CHECK_VALUES_BEFORE_UPLOAD;
    public static final String PREF_CHECK_COMPLEX_BEFORE_UPLOAD;
    public static final String PREF_CHECK_FIXMES_BEFORE_UPLOAD;
    private static final int MAX_LEVENSHTEIN_DISTANCE = 2;
    protected boolean checkKeys;
    protected boolean checkValues;
    protected boolean checkComplex;
    protected boolean checkFixmes;
    protected JCheckBox prefCheckKeys;
    protected JCheckBox prefCheckValues;
    protected JCheckBox prefCheckComplex;
    protected JCheckBox prefCheckFixmes;
    protected JCheckBox prefCheckPaint;
    protected JCheckBox prefCheckKeysBeforeUpload;
    protected JCheckBox prefCheckValuesBeforeUpload;
    protected JCheckBox prefCheckComplexBeforeUpload;
    protected JCheckBox prefCheckFixmesBeforeUpload;
    protected JCheckBox prefCheckPaintBeforeUpload;
    protected static final int EMPTY_VALUES = 1200;
    protected static final int INVALID_KEY = 1201;
    protected static final int INVALID_VALUE = 1202;
    protected static final int FIXME = 1203;
    protected static final int INVALID_SPACE = 1204;
    protected static final int INVALID_KEY_SPACE = 1205;
    protected static final int INVALID_HTML = 1206;
    protected static final int LONG_VALUE = 1208;
    protected static final int LONG_KEY = 1209;
    protected static final int LOW_CHAR_VALUE = 1210;
    protected static final int LOW_CHAR_KEY = 1211;
    protected static final int MISSPELLED_VALUE = 1212;
    protected static final int MISSPELLED_KEY = 1213;
    protected static final int MULTIPLE_SPACES = 1214;
    protected static final int MISSPELLED_VALUE_NO_FIX = 1215;
    protected static final int UNUSUAL_UNICODE_CHAR_VALUE = 1216;
    protected EditableList sourcesList;
    private static final List<String> DEFAULT_SOURCES;

    public TagChecker() {
        super(I18n.tr("Tag checker", new Object[0]), I18n.tr("This test checks for errors in tag keys and values.", new Object[0]));
    }

    @Override
    public void initialize() throws IOException {
        TagChecker.initializeData();
        TagChecker.initializePresets();
        TagChecker.analysePresets();
    }

    private static void analysePresets() {
        for (String key : TaggingPresets.getPresetKeys()) {
            if (TagChecker.isKeyIgnored(key)) continue;
            boolean allNumerical = true;
            Set<String> values = TaggingPresets.getPresetValues(key);
            if (values.isEmpty()) {
                allNumerical = false;
            }
            for (String val : values) {
                if (TagChecker.isNum(val)) continue;
                allNumerical = false;
                break;
            }
            if (!allNumerical) continue;
            ignoreForLevenshtein.add(key);
        }
    }

    private static void initializeData() throws IOException {
        ignoreDataStartsWith.clear();
        ignoreDataEquals.clear();
        ignoreDataEndsWith.clear();
        ignoreDataTag.clear();
        harmonizedKeys.clear();
        ignoreForLevenshtein.clear();
        oftenUsedTags.clear();
        StringBuilder errorSources = new StringBuilder();
        for (String source : Config.getPref().getList(PREF_SOURCES, DEFAULT_SOURCES)) {
            try (CachedFile cf = new CachedFile(source);){
                BufferedReader reader = cf.getContentReader();
                Throwable throwable = null;
                try {
                    String line;
                    String okValue = null;
                    boolean tagcheckerfile = false;
                    boolean ignorefile = false;
                    boolean isFirstLine = true;
                    while ((line = reader.readLine()) != null) {
                        if (!line.isEmpty()) {
                            if (line.startsWith("#")) {
                                if (line.startsWith("# JOSM TagChecker")) {
                                    tagcheckerfile = true;
                                    Logging.error(I18n.tr("Ignoring {0}. Support was dropped", source));
                                } else if (line.startsWith("# JOSM IgnoreTags")) {
                                    ignorefile = true;
                                    if (!DEFAULT_SOURCES.contains(source)) {
                                        Logging.info(I18n.tr("Adding {0} to ignore tags", source));
                                    }
                                }
                            } else if (ignorefile) {
                                TagChecker.parseIgnoreFileLine(source, line);
                            } else if (!tagcheckerfile) {
                                if (line.charAt(0) == '+') {
                                    okValue = line.substring(1);
                                } else if (line.charAt(0) == '-' && okValue != null) {
                                    String hk = TagChecker.harmonizeKey(line.substring(1));
                                    if (!okValue.equals(hk) && harmonizedKeys.put(hk, okValue) != null) {
                                        Logging.debug(I18n.tr("Line was ignored: {0}", line));
                                    }
                                } else {
                                    Logging.error(I18n.tr("Invalid spellcheck line: {0}", line));
                                }
                            }
                        }
                        if (!isFirstLine) continue;
                        isFirstLine = false;
                        if (tagcheckerfile || ignorefile || DEFAULT_SOURCES.contains(source)) continue;
                        Logging.info(I18n.tr("Adding {0} to spellchecker", source));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    TagChecker.$closeResource(throwable, reader);
                }
            }
            catch (IOException e) {
                Logging.error(e);
                errorSources.append(source).append('\n');
            }
        }
        if (errorSources.length() > 0) {
            throw new IOException(I18n.tr("Could not access data file(s):\n{0}", errorSources));
        }
    }

    private static void parseIgnoreFileLine(String source, String line) {
        if ((line = line.trim()).length() < 4) {
            return;
        }
        try {
            String key = line.substring(0, 2);
            line = line.substring(2);
            switch (key) {
                case "S:": {
                    ignoreDataStartsWith.add(line);
                    break;
                }
                case "E:": {
                    ignoreDataEquals.add(line);
                    TagChecker.addToKeyDictionary(line);
                    break;
                }
                case "F:": {
                    ignoreDataEndsWith.add(line);
                    break;
                }
                case "K:": {
                    Tag tag = Tag.ofString(line);
                    ignoreDataTag.add(tag);
                    oftenUsedTags.put(tag.getKey(), tag.getValue());
                    TagChecker.addToKeyDictionary(tag.getKey());
                    break;
                }
                default: {
                    if (!key.startsWith(";")) {
                        Logging.warn("Unsupported TagChecker key: " + key);
                    }
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            Logging.error("Invalid line in {0} : {1}", source, e.getMessage());
            Logging.trace(e);
        }
    }

    private static void addToKeyDictionary(String key) {
        String hk;
        if (key != null && !key.equals(hk = TagChecker.harmonizeKey(key))) {
            harmonizedKeys.put(hk, key);
        }
    }

    public static void initializePresets() {
        if (!Config.getPref().getBoolean(PREF_CHECK_VALUES, true)) {
            return;
        }
        Collection<TaggingPreset> presets = TaggingPresets.getTaggingPresets();
        if (!presets.isEmpty()) {
            TagChecker.initAdditionalPresetsValueData();
            for (TaggingPreset p : presets) {
                for (TaggingPresetItem i : p.data) {
                    if (i instanceof KeyedItem) {
                        TagChecker.addPresetValue((KeyedItem)i);
                        continue;
                    }
                    if (!(i instanceof CheckGroup)) continue;
                    for (Check c : ((CheckGroup)i).checks) {
                        TagChecker.addPresetValue(c);
                    }
                }
            }
        }
    }

    private static void initAdditionalPresetsValueData() {
        additionalPresetsValueData = new HashSet();
        for (String a : AbstractPrimitive.getUninterestingKeys()) {
            additionalPresetsValueData.add(a);
        }
        for (String a : Config.getPref().getList("validator.knownkeys", Arrays.asList("is_in", "int_ref", "fixme", "population"))) {
            additionalPresetsValueData.add(a);
        }
    }

    private static void addPresetValue(KeyedItem ky) {
        if (ky.key != null && ky.getValues() != null) {
            TagChecker.addToKeyDictionary(ky.key);
        }
    }

    static boolean containsUnwantedNonPrintingControlCharacter(String s) {
        return s != null && !s.isEmpty() && (TagChecker.isJoiningChar(s.charAt(0)) || TagChecker.isJoiningChar(s.charAt(s.length() - 1)) || s.chars().anyMatch(c -> TagChecker.isAsciiControlChar(c) && !TagChecker.isNewLineChar(c) || TagChecker.isBidiControlChar(c)));
    }

    private static boolean isAsciiControlChar(int c) {
        return c < 32 || c == 127;
    }

    private static boolean isNewLineChar(int c) {
        return c == 10 || c == 13;
    }

    private static boolean isJoiningChar(int c) {
        return c == 8204 || c == 8205;
    }

    private static boolean isBidiControlChar(int c) {
        return c >= 8206 && c <= 8207 || c >= 8234 && c <= 8238;
    }

    static String removeUnwantedNonPrintingControlCharacters(String s) {
        String result = UNWANTED_NON_PRINTING_CONTROL_CHARACTERS.matcher(s).replaceAll("");
        while (!result.isEmpty() && TagChecker.isJoiningChar(result.charAt(0))) {
            result = result.substring(1);
        }
        while (!result.isEmpty() && TagChecker.isJoiningChar(result.charAt(result.length() - 1))) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    static boolean containsUnusualUnicodeCharacter(String key, String value) {
        return value != null && value.chars().anyMatch(c -> TagChecker.isUnusualUnicodeBlock(key, Character.UnicodeBlock.of(c)));
    }

    private static boolean isUnusualUnicodeBlock(String key, Character.UnicodeBlock b) {
        return TagChecker.isUnusualPhoneticUse(key, b) || TagChecker.isUnusualBmpUse(b) || TagChecker.isUnusualSmpUse(b);
    }

    private static boolean isUnusualPhoneticUse(String key, Character.UnicodeBlock b) {
        return (b == Character.UnicodeBlock.IPA_EXTENSIONS || b == Character.UnicodeBlock.PHONETIC_EXTENSIONS || b == Character.UnicodeBlock.PHONETIC_EXTENSIONS_SUPPLEMENT) && !key.endsWith(":pronunciation");
    }

    private static boolean isUnusualBmpUse(Character.UnicodeBlock b) {
        return b == Character.UnicodeBlock.COMBINING_MARKS_FOR_SYMBOLS || b == Character.UnicodeBlock.MATHEMATICAL_OPERATORS || b == Character.UnicodeBlock.ENCLOSED_ALPHANUMERICS || b == Character.UnicodeBlock.BOX_DRAWING || b == Character.UnicodeBlock.GEOMETRIC_SHAPES || b == Character.UnicodeBlock.DINGBATS || b == Character.UnicodeBlock.MISCELLANEOUS_SYMBOLS_AND_ARROWS || b == Character.UnicodeBlock.GLAGOLITIC || b == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || b == Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS || b == Character.UnicodeBlock.LATIN_EXTENDED_D || b == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || b == Character.UnicodeBlock.ALPHABETIC_PRESENTATION_FORMS || b == Character.UnicodeBlock.VARIATION_SELECTORS || b == Character.UnicodeBlock.SPECIALS;
    }

    private static boolean isUnusualSmpUse(Character.UnicodeBlock b) {
        return b == Character.UnicodeBlock.MUSICAL_SYMBOLS || b == Character.UnicodeBlock.ENCLOSED_ALPHANUMERIC_SUPPLEMENT || b == Character.UnicodeBlock.EMOTICONS || b == Character.UnicodeBlock.TRANSPORT_AND_MAP_SYMBOLS;
    }

    private static Set<String> getPresetValues(String key) {
        Set<String> res = TaggingPresets.getPresetValues(key);
        if (res != null) {
            return res;
        }
        if (additionalPresetsValueData.contains(key)) {
            return Collections.emptySet();
        }
        return null;
    }

    public static boolean isKeyInPresets(String key) {
        return TaggingPresets.getPresetValues(key) != null;
    }

    public static boolean isTagInPresets(String key, String value) {
        Set<String> values = TagChecker.getPresetValues(key);
        return values != null && values.contains(value);
    }

    public static List<Tag> getIgnoredTags() {
        return new ArrayList<Tag>(ignoreDataTag);
    }

    private static boolean isKeyIgnored(String key) {
        if (ignoreDataEquals.contains(key)) {
            return true;
        }
        for (String a : ignoreDataStartsWith) {
            if (!key.startsWith(a)) continue;
            return true;
        }
        for (String a : ignoreDataEndsWith) {
            if (!key.endsWith(a)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTagIgnored(String key, String value) {
        if (TagChecker.isKeyIgnored(key)) {
            return true;
        }
        Set<String> values = TagChecker.getPresetValues(key);
        if (values != null && values.isEmpty()) {
            return true;
        }
        if (!TagChecker.isTagInPresets(key, value)) {
            for (Tag a : ignoreDataTag) {
                if (!key.equals(a.getKey()) || !value.equals(a.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void check(OsmPrimitive p) {
        if (!p.isTagged()) {
            return;
        }
        MultiMap<OsmPrimitive, String> withErrors = new MultiMap<OsmPrimitive, String>();
        for (Map.Entry<String, String> prop : p.getKeys().entrySet()) {
            String s = I18n.marktr("Tag ''{0}'' invalid.");
            String key = prop.getKey();
            String value = prop.getValue();
            if (this.checkKeys) {
                this.checkSingleTagKeySimple(withErrors, p, s, key);
            }
            if (this.checkValues) {
                this.checkSingleTagValueSimple(withErrors, p, s, key, value);
                this.checkSingleTagComplex(withErrors, p, key, value);
            }
            if (!this.checkFixmes || key == null || value == null || value.isEmpty() || !TagChecker.isFixme(key, value) || withErrors.contains(p, "FIXME")) continue;
            this.errors.add(TestError.builder(this, Severity.OTHER, 1203).message(I18n.tr("FIXMES", new Object[0])).primitives(p).build());
            withErrors.put(p, "FIXME");
        }
    }

    private void checkSingleTagValueSimple(MultiMap<OsmPrimitive, String> withErrors, OsmPrimitive p, String s, String key, String value) {
        if (!this.checkValues || value == null) {
            return;
        }
        if (TagChecker.containsUnwantedNonPrintingControlCharacter(value) && !withErrors.contains(p, "ICV")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1210).message(I18n.tr("Tag value contains non-printing (usually invisible) character", new Object[0]), s, key).primitives(p).fix(() -> new ChangePropertyCommand(p, key, TagChecker.removeUnwantedNonPrintingControlCharacters(value))).build());
            withErrors.put(p, "ICV");
        }
        if (TagChecker.containsUnusualUnicodeCharacter(key, value) && !withErrors.contains(p, "UUCV")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1216).message(I18n.tr("Tag value contains unusual Unicode character", new Object[0]), s, key).primitives(p).build());
            withErrors.put(p, "UUCV");
        }
        if (value.length() > 255 && !withErrors.contains(p, "LV")) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1208).message(I18n.tr("Tag value longer than {0} characters ({1} characters)", 255, value.length()), s, key).primitives(p).build());
            withErrors.put(p, "LV");
        }
        if (value.trim().isEmpty() && !withErrors.contains(p, "EV")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1200).message(I18n.tr("Tags with empty values", new Object[0]), s, key).primitives(p).build());
            withErrors.put(p, "EV");
        }
        String errTypeSpace = "SPACE";
        if ((value.startsWith(" ") || value.endsWith(" ")) && !withErrors.contains(p, "SPACE")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1204).message(I18n.tr("Property values start or end with white space", new Object[0]), s, key).primitives(p).build());
            withErrors.put(p, "SPACE");
        }
        if (value.contains("  ") && !withErrors.contains(p, "SPACE")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1214).message(I18n.tr("Property values contain multiple white spaces", new Object[0]), s, key).primitives(p).build());
            withErrors.put(p, "SPACE");
        }
        if (!value.equals(Entities.unescape(value)) && !withErrors.contains(p, "HTML")) {
            this.errors.add(TestError.builder(this, Severity.OTHER, 1206).message(I18n.tr("Property values contain HTML entity", new Object[0]), s, key).primitives(p).build());
            withErrors.put(p, "HTML");
        }
    }

    private void checkSingleTagKeySimple(MultiMap<OsmPrimitive, String> withErrors, OsmPrimitive p, String s, String key) {
        if (!this.checkKeys || key == null) {
            return;
        }
        if (TagChecker.containsUnwantedNonPrintingControlCharacter(key) && !withErrors.contains(p, "ICK")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1211).message(I18n.tr("Tag key contains non-printing character", new Object[0]), s, key).primitives(p).fix(() -> new ChangePropertyCommand(p, key, TagChecker.removeUnwantedNonPrintingControlCharacters(key))).build());
            withErrors.put(p, "ICK");
        }
        if (key.length() > 255 && !withErrors.contains(p, "LK")) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1209).message(I18n.tr("Tag key longer than {0} characters ({1} characters)", 255, key.length()), s, key).primitives(p).build());
            withErrors.put(p, "LK");
        }
        if (key.indexOf(32) >= 0 && !withErrors.contains(p, "IPK")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1205).message(I18n.tr("Invalid white space in property key", new Object[0]), s, key).primitives(p).build());
            withErrors.put(p, "IPK");
        }
    }

    private void checkSingleTagComplex(MultiMap<OsmPrimitive, String> withErrors, OsmPrimitive p, String key, String value) {
        if (!this.checkValues || key == null || value == null || value.isEmpty()) {
            return;
        }
        if (additionalPresetsValueData != null && !TagChecker.isTagIgnored(key, value)) {
            if (!TagChecker.isKeyInPresets(key)) {
                this.spellCheckKey(withErrors, p, key);
            } else if (!TagChecker.isTagInPresets(key, value)) {
                if (oftenUsedTags.contains(key, value)) {
                    this.errors.add(TestError.builder(this, Severity.OTHER, 1202).message(I18n.tr("Presets do not contain property value", new Object[0]), I18n.marktr("Value ''{0}'' for key ''{1}'' not in presets, but is known."), value, key).primitives(p).build());
                    withErrors.put(p, "UPV");
                } else {
                    this.tryGuess(p, key, value, withErrors);
                }
            }
        }
    }

    private void spellCheckKey(MultiMap<OsmPrimitive, String> withErrors, OsmPrimitive p, String key) {
        String fixedKey;
        String prettifiedKey = TagChecker.harmonizeKey(key);
        if (ignoreDataEquals.contains(prettifiedKey)) {
            fixedKey = prettifiedKey;
        } else {
            String string = fixedKey = TagChecker.isKeyInPresets(prettifiedKey) ? prettifiedKey : harmonizedKeys.get(prettifiedKey);
        }
        if (fixedKey == null) {
            for (Tag a : ignoreDataTag) {
                if (!a.getKey().equals(prettifiedKey)) continue;
                fixedKey = prettifiedKey;
                break;
            }
        }
        if (fixedKey != null && !"".equals(fixedKey) && !fixedKey.equals(key)) {
            String proposedKey = fixedKey;
            TestError.Builder error = TestError.builder(this, Severity.WARNING, 1213).message(I18n.tr("Misspelled property key", new Object[0]), I18n.marktr("Key ''{0}'' looks like ''{1}''."), key, proposedKey).primitives(p);
            if (p.hasKey(fixedKey)) {
                this.errors.add(error.build());
            } else {
                this.errors.add(error.fix(() -> new ChangePropertyKeyCommand(p, key, proposedKey)).build());
            }
            withErrors.put(p, "WPK");
        } else {
            this.errors.add(TestError.builder(this, Severity.OTHER, 1201).message(I18n.tr("Presets do not contain property key", new Object[0]), I18n.marktr("Key ''{0}'' not in presets."), key).primitives(p).build());
            withErrors.put(p, "UPK");
        }
    }

    private void tryGuess(OsmPrimitive p, String key, String value, MultiMap<OsmPrimitive, String> withErrors) {
        Set<String> usedValues;
        String harmonizedValue = TagChecker.harmonizeValue(value);
        if (harmonizedValue == null || harmonizedValue.isEmpty()) {
            return;
        }
        String fixedValue = null;
        ArrayList<Set<String>> sets = new ArrayList<Set<String>>();
        Set<String> presetValues = TagChecker.getPresetValues(key);
        if (presetValues != null) {
            sets.add(presetValues);
        }
        if ((usedValues = oftenUsedTags.get(key)) != null) {
            sets.add(usedValues);
        }
        for (Set set : sets) {
            if (!set.contains(harmonizedValue)) continue;
            fixedValue = harmonizedValue;
            break;
        }
        if (fixedValue == null && !ignoreForLevenshtein.contains(key)) {
            int maxPresetValueLen = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            int minDist = 3;
            String closest = null;
            for (Set set : sets) {
                for (String possibleVal : set) {
                    int dist;
                    if (possibleVal.isEmpty()) continue;
                    maxPresetValueLen = Math.max(maxPresetValueLen, possibleVal.length());
                    if (harmonizedValue.length() < 3 && possibleVal.length() >= harmonizedValue.length() + 2 || (dist = Utils.getLevenshteinDistance(possibleVal, harmonizedValue)) >= harmonizedValue.length()) continue;
                    if (dist < minDist) {
                        closest = possibleVal;
                        minDist = dist;
                        arrayList.clear();
                        arrayList.add(possibleVal);
                        continue;
                    }
                    if (dist != minDist) continue;
                    arrayList.add(possibleVal);
                }
            }
            if (minDist <= 2 && maxPresetValueLen > 2 && (harmonizedValue.length() > 3 || minDist < 2)) {
                if (arrayList.size() < 2) {
                    fixedValue = closest;
                } else {
                    Collections.sort(arrayList);
                    this.errors.add(TestError.builder(this, Severity.WARNING, 1215).message(I18n.tr("Unknown property value", new Object[0]), I18n.marktr("Value ''{0}'' for key ''{1}'' is unknown, maybe one of {2} is meant?"), value, key, arrayList).primitives(p).build());
                    withErrors.put(p, "WPV");
                    return;
                }
            }
        }
        if (fixedValue != null && !fixedValue.equals(value)) {
            String newValue = fixedValue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 1212).message(I18n.tr("Unknown property value", new Object[0]), I18n.marktr("Value ''{0}'' for key ''{1}'' is unknown, maybe ''{2}'' is meant?"), value, key, newValue).primitives(p).build());
            withErrors.put(p, "WPV");
        } else {
            this.errors.add(TestError.builder(this, Severity.OTHER, 1202).message(I18n.tr("Presets do not contain property value", new Object[0]), I18n.marktr("Value ''{0}'' for key ''{1}'' not in presets."), value, key).primitives(p).build());
            withErrors.put(p, "UPV");
        }
    }

    private static boolean isNum(String harmonizedValue) {
        try {
            Double.parseDouble(harmonizedValue);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isFixme(String key, String value) {
        return key.toLowerCase(Locale.ENGLISH).contains("fixme") || key.contains("todo") || value.toLowerCase(Locale.ENGLISH).contains("fixme") || value.contains("check and delete");
    }

    private static String harmonizeKey(String key) {
        return Utils.strip(key.toLowerCase(Locale.ENGLISH).replace('-', '_').replace(':', '_').replace(' ', '_'), "-_;:,");
    }

    private static String harmonizeValue(String value) {
        return Utils.strip(value.toLowerCase(Locale.ENGLISH).replace('-', '_').replace(' ', '_'), "-_;:,");
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.checkKeys = Config.getPref().getBoolean(PREF_CHECK_KEYS, true);
        if (this.isBeforeUpload) {
            this.checkKeys = this.checkKeys && Config.getPref().getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true);
        }
        this.checkValues = Config.getPref().getBoolean(PREF_CHECK_VALUES, true);
        if (this.isBeforeUpload) {
            this.checkValues = this.checkValues && Config.getPref().getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true);
        }
        this.checkComplex = Config.getPref().getBoolean(PREF_CHECK_COMPLEX, true);
        if (this.isBeforeUpload) {
            this.checkComplex = this.checkComplex && Config.getPref().getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true);
        }
        this.checkFixmes = Config.getPref().getBoolean(PREF_CHECK_FIXMES, true);
        if (this.isBeforeUpload) {
            this.checkFixmes = this.checkFixmes && Config.getPref().getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true);
        }
    }

    @Override
    public void visit(Collection<OsmPrimitive> selection) {
        if (this.checkKeys || this.checkValues || this.checkComplex || this.checkFixmes) {
            super.visit(selection);
        }
    }

    @Override
    public void addGui(JPanel testPanel) {
        GBC a = GBC.eol();
        a.anchor = 13;
        testPanel.add((Component)new JLabel(this.name + " :"), GBC.eol().insets(3, 0, 0, 0));
        this.prefCheckKeys = new JCheckBox(I18n.tr("Check property keys.", new Object[0]), Config.getPref().getBoolean(PREF_CHECK_KEYS, true));
        this.prefCheckKeys.setToolTipText(I18n.tr("Validate that property keys are valid checking against list of words.", new Object[0]));
        testPanel.add((Component)this.prefCheckKeys, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckKeysBeforeUpload = new JCheckBox();
        this.prefCheckKeysBeforeUpload.setSelected(Config.getPref().getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckKeysBeforeUpload, a);
        this.prefCheckComplex = new JCheckBox(I18n.tr("Use complex property checker.", new Object[0]), Config.getPref().getBoolean(PREF_CHECK_COMPLEX, true));
        this.prefCheckComplex.setToolTipText(I18n.tr("Validate property values and tags using complex rules.", new Object[0]));
        testPanel.add((Component)this.prefCheckComplex, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckComplexBeforeUpload = new JCheckBox();
        this.prefCheckComplexBeforeUpload.setSelected(Config.getPref().getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckComplexBeforeUpload, a);
        List<String> sources = Config.getPref().getList(PREF_SOURCES, DEFAULT_SOURCES);
        this.sourcesList = new EditableList(I18n.tr("TagChecker source", new Object[0]));
        this.sourcesList.setItems(sources);
        testPanel.add((Component)new JLabel(I18n.tr("Data sources ({0})", "*.cfg")), GBC.eol().insets(23, 0, 0, 0));
        testPanel.add((Component)this.sourcesList, GBC.eol().fill(2).insets(23, 0, 0, 0));
        ActionListener disableCheckActionListener = e -> this.handlePrefEnable();
        this.prefCheckKeys.addActionListener(disableCheckActionListener);
        this.prefCheckKeysBeforeUpload.addActionListener(disableCheckActionListener);
        this.prefCheckComplex.addActionListener(disableCheckActionListener);
        this.prefCheckComplexBeforeUpload.addActionListener(disableCheckActionListener);
        this.handlePrefEnable();
        this.prefCheckValues = new JCheckBox(I18n.tr("Check property values.", new Object[0]), Config.getPref().getBoolean(PREF_CHECK_VALUES, true));
        this.prefCheckValues.setToolTipText(I18n.tr("Validate that property values are valid checking against presets.", new Object[0]));
        testPanel.add((Component)this.prefCheckValues, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckValuesBeforeUpload = new JCheckBox();
        this.prefCheckValuesBeforeUpload.setSelected(Config.getPref().getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckValuesBeforeUpload, a);
        this.prefCheckFixmes = new JCheckBox(I18n.tr("Check for FIXMES.", new Object[0]), Config.getPref().getBoolean(PREF_CHECK_FIXMES, true));
        this.prefCheckFixmes.setToolTipText(I18n.tr("Looks for nodes or ways with FIXME in any property value.", new Object[0]));
        testPanel.add((Component)this.prefCheckFixmes, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckFixmesBeforeUpload = new JCheckBox();
        this.prefCheckFixmesBeforeUpload.setSelected(Config.getPref().getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckFixmesBeforeUpload, a);
    }

    public void handlePrefEnable() {
        boolean selected = this.prefCheckKeys.isSelected() || this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        this.sourcesList.setEnabled(selected);
    }

    @Override
    public boolean ok() {
        this.enabled = this.prefCheckKeys.isSelected() || this.prefCheckValues.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckFixmes.isSelected();
        this.testBeforeUpload = this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckValuesBeforeUpload.isSelected() || this.prefCheckFixmesBeforeUpload.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        Config.getPref().putBoolean(PREF_CHECK_VALUES, this.prefCheckValues.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_COMPLEX, this.prefCheckComplex.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_KEYS, this.prefCheckKeys.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_FIXMES, this.prefCheckFixmes.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, this.prefCheckValuesBeforeUpload.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, this.prefCheckComplexBeforeUpload.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, this.prefCheckKeysBeforeUpload.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, this.prefCheckFixmesBeforeUpload.isSelected());
        return Config.getPref().putList(PREF_SOURCES, this.sourcesList.getItems());
    }

    @Override
    public Command fixError(TestError testError) {
        ArrayList<Command> commands = new ArrayList<Command>(50);
        Collection<? extends OsmPrimitive> primitives = testError.getPrimitives();
        for (OsmPrimitive osmPrimitive : primitives) {
            TagMap tags = osmPrimitive.getKeys();
            if (tags.isEmpty()) continue;
            for (Map.Entry prop : tags.entrySet()) {
                String key = (String)prop.getKey();
                String value = (String)prop.getValue();
                if (value == null || value.trim().isEmpty()) {
                    commands.add(new ChangePropertyCommand(osmPrimitive, key, null));
                    continue;
                }
                if (value.startsWith(" ") || value.endsWith(" ") || value.contains("  ")) {
                    commands.add(new ChangePropertyCommand(osmPrimitive, key, Utils.removeWhiteSpaces(value)));
                    continue;
                }
                if (key.startsWith(" ") || key.endsWith(" ") || key.contains("  ")) {
                    commands.add(new ChangePropertyKeyCommand(osmPrimitive, key, Utils.removeWhiteSpaces(key)));
                    continue;
                }
                String evalue = Entities.unescape(value);
                if (evalue.equals(value)) continue;
                commands.add(new ChangePropertyCommand(osmPrimitive, key, evalue));
            }
        }
        if (commands.isEmpty()) {
            return null;
        }
        if (commands.size() == 1) {
            return (Command)commands.get(0);
        }
        return new SequenceCommand(I18n.tr("Fix tags", new Object[0]), commands);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof TagChecker) {
            int code = testError.getCode();
            return code == 1200 || code == 1204 || code == 1205 || code == 1206 || code == 1214;
        }
        return false;
    }

    static {
        oftenUsedTags = new MultiMap();
        UNWANTED_NON_PRINTING_CONTROL_CHARACTERS = Pattern.compile("[\\x00-\\x09\\x0B\\x0C\\x0E-\\x1F\\x7F\\u200e-\\u200f\\u202a-\\u202e]");
        ignoreDataStartsWith = new ArrayList<String>();
        ignoreDataEquals = new HashSet<String>();
        ignoreDataEndsWith = new ArrayList<String>();
        ignoreDataTag = new ArrayList<Tag>();
        ignoreForLevenshtein = new HashSet<String>();
        PREFIX = "validator." + TagChecker.class.getSimpleName();
        PREF_CHECK_VALUES = PREFIX + ".checkValues";
        PREF_CHECK_KEYS = PREFIX + ".checkKeys";
        PREF_CHECK_COMPLEX = PREFIX + ".checkComplex";
        PREF_CHECK_FIXMES = PREFIX + ".checkFixmes";
        PREF_SOURCES = PREFIX + ".source";
        PREF_CHECK_KEYS_BEFORE_UPLOAD = PREF_CHECK_KEYS + BEFORE_UPLOAD;
        PREF_CHECK_VALUES_BEFORE_UPLOAD = PREF_CHECK_VALUES + BEFORE_UPLOAD;
        PREF_CHECK_COMPLEX_BEFORE_UPLOAD = PREF_CHECK_COMPLEX + BEFORE_UPLOAD;
        PREF_CHECK_FIXMES_BEFORE_UPLOAD = PREF_CHECK_FIXMES + BEFORE_UPLOAD;
        DEFAULT_SOURCES = Arrays.asList(IGNORE_FILE, SPELL_FILE);
    }
}

