/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedClassConstructorDescriptor;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrConstructorImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsVisitor;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002$%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\fJ\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0012\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 *\u00020\rH\u0002J\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0 *\u00020\rH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\r\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassConstructorTransformer;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "enumEntries", "", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "Lkotlin/internal/NoInfer;", "loweredEnumConstructors", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "fixReferencesToConstructorParameters", "", "insertInstanceInitializer", "lowerEnumConstructorsBody", "lowerEnumConstructorsSignature", "lowerEnumEntryClassConstructors", "lowerEnumEntryInitializerExpression", "transform", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "transformEnumConstructor", "enumConstructor", "enumClass", "getNameExpression", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "getOrdinalExpression", "", "IrEnumClassConstructorTransformer", "IrEnumEntryClassConstructorTransformer", "backend.js"})
public final class EnumClassConstructorTransformer {
    private final DeclarationIrBuilder builder;
    private final List<IrEnumEntry> enumEntries;
    private final HashMap<IrConstructorSymbol, IrConstructor> loweredEnumConstructors;
    @NotNull
    private final CommonBackendContext context;
    private final IrClass irClass;

    @NotNull
    public final List<IrDeclaration> transform() {
        this.insertInstanceInitializer();
        this.lowerEnumConstructorsSignature();
        this.lowerEnumConstructorsBody();
        this.fixReferencesToConstructorParameters();
        this.lowerEnumEntryClassConstructors();
        this.lowerEnumEntryInitializerExpression();
        return CollectionsKt.listOf(this.irClass);
    }

    private final void insertInstanceInitializer() {
        IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new IrElementTransformerVoid(this){
            final /* synthetic */ EnumClassConstructorTransformer this$0;

            @NotNull
            public IrClass visitClass(@NotNull IrClass declaration2) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                return declaration2;
            }

            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration2) {
                IrStatement it;
                boolean bl;
                IrBlockBody blockBody;
                block9: {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementTransformerVoidKt.transformChildrenVoid(declaration2, this);
                    IrBody irBody = declaration2.getBody();
                    if (irBody == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                    }
                    blockBody = (IrBlockBody)irBody;
                    Iterable $this$any$iv = blockBody.getStatements();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (IrStatement)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof IrInstanceInitializerCall)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    List<IrStatement> $this$transformFlat$iv = blockBody.getStatements();
                    boolean $i$f$transformFlat = false;
                    int i$iv = 0;
                    while (i$iv < $this$transformFlat$iv.size()) {
                        Integer n;
                        List<IrExpression> transformed$iv;
                        IrStatement item$iv;
                        it = item$iv = $this$transformFlat$iv.get(i$iv);
                        boolean bl3 = false;
                        List<IrExpression> list2 = transformed$iv = it instanceof IrEnumConstructorCall ? CollectionsKt.listOf((IrExpression)it, new IrInstanceInitializerCallImpl(declaration2.getStartOffset(), declaration2.getStartOffset(), (IrClassSymbol)EnumClassConstructorTransformer.access$getIrClass$p(this.this$0).getSymbol(), this.this$0.getContext().getIrBuiltIns().getUnitType())) : null;
                        Integer n2 = n = list2 != null ? Integer.valueOf(list2.size()) : null;
                        if (n == null) {
                            ++i$iv;
                            continue;
                        }
                        if (n == 0) {
                            $this$transformFlat$iv.remove(i$iv);
                            continue;
                        }
                        if (n == 1) {
                            $this$transformFlat$iv.set(i$iv++, (IrStatement)CollectionsKt.first(transformed$iv));
                            continue;
                        }
                        $this$transformFlat$iv.addAll(i$iv, (Collection<IrStatement>)transformed$iv);
                        $this$transformFlat$iv.remove(i$iv += transformed$iv.size());
                    }
                }
                return declaration2;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void lowerEnumConstructorsSignature() {
        List<IrDeclaration> $this$transform$iv = this.irClass.getDeclarations();
        boolean $i$f$transform = false;
        Iterable $this$forEachIndexed$iv$iv = $this$transform$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            void declaration2;
            IrElement irElement;
            void item$iv;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            IrElement irElement2 = (IrElement)item$iv$iv;
            int i$iv = n2;
            boolean bl2 = false;
            IrDeclaration irDeclaration2 = (IrDeclaration)item$iv;
            int n3 = i$iv;
            List<IrDeclaration> list2 = $this$transform$iv;
            boolean bl3 = false;
            IrElement irElement3 = irElement = (IrElement)(declaration2 instanceof IrConstructor ? (IrDeclaration)this.transformEnumConstructor((IrConstructor)declaration2, this.irClass) : declaration2);
            if (irElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            }
            list2.set(n3, (IrDeclaration)irElement3);
        }
    }

    private final IrConstructor transformEnumConstructor(IrConstructor enumConstructor, IrClass enumClass2) {
        WrappedClassConstructorDescriptor loweredConstructorDescriptor = new WrappedClassConstructorDescriptor(null, null, 3, null);
        IrConstructorSymbolImpl loweredConstructorSymbol = new IrConstructorSymbolImpl(loweredConstructorDescriptor);
        IrConstructorImpl irConstructorImpl = new IrConstructorImpl(enumConstructor.getStartOffset(), enumConstructor.getEndOffset(), enumConstructor.getOrigin(), loweredConstructorSymbol, enumConstructor.getName(), enumConstructor.getVisibility(), enumConstructor.getReturnType(), enumConstructor.isInline(), enumConstructor.isExternal(), enumConstructor.isPrimary());
        boolean bl = false;
        boolean bl2 = false;
        IrConstructorImpl $this$apply = irConstructorImpl;
        boolean bl3 = false;
        loweredConstructorDescriptor.bind((IrDeclaration)$this$apply);
        $this$apply.setParent(enumClass2);
        Collection collection = $this$apply.getValueParameters();
        IrValueParameter irValueParameter = JsIrBuilder.INSTANCE.buildValueParameter("name", 0, this.context.getIrBuiltIns().getStringType());
        boolean bl4 = false;
        boolean bl5 = false;
        IrValueParameter it = irValueParameter;
        boolean bl6 = false;
        it.setParent($this$apply);
        bl4 = false;
        collection.add(irValueParameter);
        collection = $this$apply.getValueParameters();
        irValueParameter = JsIrBuilder.INSTANCE.buildValueParameter("ordinal", 1, this.context.getIrBuiltIns().getIntType());
        bl4 = false;
        bl5 = false;
        it = irValueParameter;
        boolean bl7 = false;
        it.setParent($this$apply);
        bl4 = false;
        collection.add(irValueParameter);
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyParameterDeclarationsFrom($this$apply, enumConstructor);
        $this$apply.setBody(enumConstructor.getBody());
        ((Map)this.loweredEnumConstructors).put(enumConstructor.getSymbol(), $this$apply);
        IrElementVisitorVoidKt.acceptVoid($this$apply, new PatchDeclarationParentsVisitor(enumClass2));
        return irConstructorImpl;
    }

    /*
     * WARNING - void declaration
     */
    private final void lowerEnumConstructorsBody() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.irClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrConstructor it = (IrConstructor)element$iv;
            boolean bl = false;
            new IrEnumClassConstructorTransformer(it).transformBody();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fixReferencesToConstructorParameters() {
        boolean bl = false;
        Map fromOldToNewParameter = new LinkedHashMap();
        Map $this$forEach$iv = this.loweredEnumConstructors;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl2 = false;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$oldCtorSymbol$newCtor = element$iv = iterator2.next();
            boolean bl3 = false;
            Map.Entry entry = $dstr$oldCtorSymbol$newCtor;
            boolean bl4 = false;
            IrConstructorSymbol oldCtorSymbol = (IrConstructorSymbol)entry.getKey();
            entry = $dstr$oldCtorSymbol$newCtor;
            bl4 = false;
            IrConstructor newCtor = (IrConstructor)entry.getValue();
            List<IrValueParameter> oldParameters = ((IrConstructor)oldCtorSymbol.getOwner()).getValueParameters();
            List<IrValueParameter> newParameters = newCtor.getValueParameters();
            Iterable $this$forEach$iv2 = oldParameters;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                void $this$single$iv;
                IrValueParameter old = (IrValueParameter)element$iv2;
                boolean bl5 = false;
                Iterable iterable = newParameters;
                Object s = old.getSymbol();
                Map map3 = fromOldToNewParameter;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv3 : $this$single$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv3;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual(it.getName(), old.getName())) continue;
                    if (found$iv) {
                        throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv3;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Object v = single$iv;
                map3.put(s, v);
            }
        }
        IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new IrElementTransformerVoid(this, fromOldToNewParameter){
            final /* synthetic */ EnumClassConstructorTransformer this$0;
            final /* synthetic */ Map $fromOldToNewParameter;

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Object object = this.$fromOldToNewParameter;
                IrValueSymbol irValueSymbol = expression2.getSymbol();
                boolean bl = false;
                IrValueParameter irValueParameter = (IrValueParameter)object.get(irValueSymbol);
                if (irValueParameter != null) {
                    object = irValueParameter;
                    boolean bl2 = false;
                    bl = false;
                    Object it = object;
                    boolean bl3 = false;
                    return ExpressionHelpersKt.irGet(EnumClassConstructorTransformer.access$getBuilder$p(this.this$0), (IrValueDeclaration)it);
                }
                return super.visitGetValue(expression2);
            }
            {
                this.this$0 = $outer;
                this.$fromOldToNewParameter = $captured_local_variable$1;
            }
        });
    }

    private final void lowerEnumEntryClassConstructors() {
        for (IrEnumEntry entry : this.enumEntries) {
            Object object = entry.getCorrespondingClass();
            if (object == null || (object = IrUtilsKt.getConstructors((IrClass)object)) == null) continue;
            Object $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                IrConstructor it = (IrConstructor)element$iv;
                boolean bl = false;
                IrElementTransformerVoidKt.transformChildrenVoid(it, new IrEnumEntryClassConstructorTransformer(entry, true));
            }
        }
    }

    private final void lowerEnumEntryInitializerExpression() {
        for (IrEnumEntry entry : this.enumEntries) {
            IrExpression irExpression = entry.getInitializerExpression();
            entry.setInitializerExpression(irExpression != null ? irExpression.transform(new IrEnumEntryClassConstructorTransformer(entry, false), null) : null);
        }
    }

    private final IrConstImpl<String> getNameExpression(@NotNull IrEnumEntry $this$getNameExpression) {
        IrBuilderWithScope irBuilderWithScope = this.builder;
        String string2 = $this$getNameExpression.getName().getIdentifier();
        Intrinsics.checkExpressionValueIsNotNull(string2, "this.name.identifier");
        return ExpressionHelpersKt.irString(irBuilderWithScope, string2);
    }

    private final IrConstImpl<Integer> getOrdinalExpression(@NotNull IrEnumEntry $this$getOrdinalExpression) {
        return ExpressionHelpersKt.irInt(this.builder, this.enumEntries.indexOf($this$getOrdinalExpression));
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public EnumClassConstructorTransformer(@NotNull CommonBackendContext context2, @NotNull IrClass irClass) {
        List list2;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(irClass, "irClass");
        this.context = context2;
        this.irClass = irClass;
        this.builder = LowerUtilsKt.createIrBuilder$default(this.context, this.irClass.getSymbol(), 0, 0, 6, null);
        Iterable iterable = this.irClass.getDeclarations();
        EnumClassConstructorTransformer enumClassConstructorTransformer = this;
        boolean $i$f$filterIsInstance = false;
        void var5_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        enumClassConstructorTransformer.enumEntries = list2 = (List)destination$iv$iv;
        this.loweredEnumConstructors = new HashMap();
    }

    public static final /* synthetic */ IrClass access$getIrClass$p(EnumClassConstructorTransformer $this) {
        return $this.irClass;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0012H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassConstructorTransformer$IrEnumClassConstructorTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassConstructorTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;)V", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "getBuilder", "()Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "getConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "transformBody", "", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "backend.js"})
    private final class IrEnumClassConstructorTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final DeclarationIrBuilder builder;
        @NotNull
        private final IrConstructor constructor;

        @NotNull
        public final DeclarationIrBuilder getBuilder() {
            return this.builder;
        }

        public final void transformBody() {
            block0: {
                IrBody irBody = this.constructor.getBody();
                if (irBody == null) break block0;
                IrElementTransformerVoidKt.transformChildrenVoid(irBody, this);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrDelegatingConstructorCall visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrDelegatingConstructorCall irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall(this.builder, (IrConstructor)expression2.getSymbol().getOwner());
            boolean bl = false;
            boolean bl2 = false;
            IrDelegatingConstructorCall $this$apply = irDelegatingConstructorCall;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = true;
            while (bl4 <= bl5) {
                void i;
                $this$apply.putValueArgument((int)i, ExpressionHelpersKt.irGet(this.builder, this.constructor.getValueParameters().get((int)i)));
                ++i;
            }
            return irDelegatingConstructorCall;
        }

        @Override
        @NotNull
        public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            int i;
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrConstructor delegatingConstructor = (IrConstructor)expression2.getSymbol().getOwner();
            Object object = EnumClassConstructorTransformer.this.loweredEnumConstructors;
            IrFunctionSymbol irFunctionSymbol = delegatingConstructor.getSymbol();
            boolean bl = false;
            Map map2 = object;
            boolean bl2 = false;
            boolean constructorWasTransformed = map2.containsKey(irFunctionSymbol);
            if (constructorWasTransformed) {
                Object v = EnumClassConstructorTransformer.this.loweredEnumConstructors.get(delegatingConstructor.getSymbol());
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                delegatingConstructor = (IrConstructor)v;
            }
            object = ExpressionHelpersKt.irDelegatingConstructorCall(this.builder, delegatingConstructor);
            boolean bl3 = false;
            bl = false;
            Object $this$apply = object;
            boolean bl4 = false;
            int valueArgIdx = 0;
            int n = 0;
            int n2 = 1;
            while (n <= n2) {
                $this$apply.putValueArgument(valueArgIdx++, ExpressionHelpersKt.irGet(this.builder, this.constructor.getValueParameters().get(i)));
                ++i;
            }
            n2 = expression2.getValueArgumentsCount();
            for (i = 0; i < n2; ++i) {
                $this$apply.putValueArgument(valueArgIdx++, expression2.getValueArgument(i));
            }
            return (IrExpression)object;
        }

        @NotNull
        public final IrConstructor getConstructor() {
            return this.constructor;
        }

        public IrEnumClassConstructorTransformer(IrConstructor constructor) {
            Intrinsics.checkParameterIsNotNull(constructor, "constructor");
            this.constructor = constructor;
            this.builder = LowerUtilsKt.createIrBuilder$default(EnumClassConstructorTransformer.this.getContext(), this.constructor.getSymbol(), 0, 0, 6, null);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassConstructorTransformer$IrEnumEntryClassConstructorTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "entry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "isInsideConstructor", "", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassConstructorTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;Z)V", "getEntry", "()Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "()Z", "buildConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "backend.js"})
    private final class IrEnumEntryClassConstructorTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final IrEnumEntry entry;
        private final boolean isInsideConstructor;

        private final IrFunctionAccessExpression buildConstructorCall(IrConstructor constructor) {
            return this.isInsideConstructor ? (IrFunctionAccessExpression)ExpressionHelpersKt.irDelegatingConstructorCall(EnumClassConstructorTransformer.this.builder, constructor) : ExpressionHelpersKt.irCall((IrBuilderWithScope)EnumClassConstructorTransformer.this.builder, constructor);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrConstructor constructor = (IrConstructor)expression2.getSymbol().getOwner();
            Object object = EnumClassConstructorTransformer.this.loweredEnumConstructors;
            IrFunctionSymbol irFunctionSymbol = constructor.getSymbol();
            boolean bl = false;
            Map map2 = object;
            boolean bl2 = false;
            boolean constructorWasTransformed = map2.containsKey(irFunctionSymbol);
            if (constructorWasTransformed) {
                Object v = EnumClassConstructorTransformer.this.loweredEnumConstructors.get(constructor.getSymbol());
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                constructor = (IrConstructor)v;
            }
            object = this.buildConstructorCall(constructor);
            boolean bl3 = false;
            bl = false;
            Object $this$apply = object;
            boolean bl4 = false;
            int valueArgIdx = 0;
            if (constructorWasTransformed) {
                $this$apply.putValueArgument(valueArgIdx++, EnumClassConstructorTransformer.this.getNameExpression(this.entry));
                $this$apply.putValueArgument(valueArgIdx++, EnumClassConstructorTransformer.this.getOrdinalExpression(this.entry));
            }
            int n = 0;
            int n2 = expression2.getValueArgumentsCount();
            while (n < n2) {
                void i;
                $this$apply.putValueArgument(valueArgIdx++, expression2.getValueArgument((int)i));
                ++i;
            }
            return (IrExpression)object;
        }

        @NotNull
        public final IrEnumEntry getEntry() {
            return this.entry;
        }

        public final boolean isInsideConstructor() {
            return this.isInsideConstructor;
        }

        public IrEnumEntryClassConstructorTransformer(IrEnumEntry entry, boolean isInsideConstructor) {
            Intrinsics.checkParameterIsNotNull(entry, "entry");
            this.entry = entry;
            this.isInsideConstructor = isInsideConstructor;
        }
    }
}

