/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.plugin;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUtilities {
    private final Logger logger = LoggerFactory.getLogger((String)PluginUtilities.class.getName());
    private static PluginUtilities instance;
    private BundleContext context;
    private ServiceTracker registryServiceTracker;
    private ServiceTracker packageServiceTracker;

    private PluginUtilities() {
    }

    public static synchronized PluginUtilities getInstance() {
        if (instance == null) {
            instance = new PluginUtilities();
        }
        return instance;
    }

    public void dispose() {
        if (this.registryServiceTracker != null) {
            this.registryServiceTracker.close();
        }
        if (this.packageServiceTracker != null) {
            this.packageServiceTracker.close();
        }
        instance = null;
    }

    public BundleContext getApplicationContext() {
        return this.context;
    }

    public Bundle getApplicationBundle() {
        return this.context.getBundle();
    }

    public void initialise(BundleContext context) {
        this.context = context;
    }

    public Bundle getBundle(IExtension extension) {
        IContributor contributor = extension.getContributor();
        return this.getBundle(contributor);
    }

    public Bundle getExtensionPointBundle(IExtension extension) {
        IExtensionRegistry registry = this.getExtensionRegistry();
        String extensionPtId = extension.getExtensionPointUniqueIdentifier();
        IExtensionPoint extensionPt = registry.getExtensionPoint(extensionPtId);
        IContributor contributor = extensionPt.getContributor();
        return this.getBundle(contributor);
    }

    public Bundle getBundle(IContributor contributor) {
        String name = contributor.getName();
        PackageAdmin admin = this.getPackageAdmin();
        Bundle[] bundles = admin.getBundles(name, null);
        if (bundles == null || bundles.length == 0) {
            return null;
        }
        return bundles[0];
    }

    public IExtensionRegistry getExtensionRegistry() {
        if (this.registryServiceTracker == null) {
            this.registryServiceTracker = new ServiceTracker(this.context, IExtensionRegistry.class.getName(), null);
            this.registryServiceTracker.open();
        }
        return (IExtensionRegistry)this.registryServiceTracker.getService();
    }

    public PackageAdmin getPackageAdmin() {
        if (this.packageServiceTracker == null) {
            this.packageServiceTracker = new ServiceTracker(this.context, PackageAdmin.class.getName(), null);
            this.packageServiceTracker.open();
        }
        return (PackageAdmin)this.packageServiceTracker.getService();
    }

    public static Map<String, String> getAttributes(IExtension ext) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (IConfigurationElement config : ext.getConfigurationElements()) {
            String id = config.getName();
            String value = config.getAttribute("value");
            attributes.put(id, value);
        }
        return attributes;
    }

    public static String getAttribute(IExtension ext, String key) {
        return PluginUtilities.getAttributes(ext).get(key);
    }

    public Object getExtensionObject(IExtension ext, String property) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Bundle b = this.getBundle(ext);
        return b.loadClass(PluginUtilities.getAttribute(ext, property)).newInstance();
    }

    public static Version getBundleVersion(Bundle b) {
        return new Version((String)b.getHeaders().get("Bundle-Version"));
    }

    public static String getBuildNumber(Bundle b) {
        return (String)b.getHeaders().get("Build-Number");
    }

    public String getDocumentation(IExtension extension) {
        this.logger.error("Don't know how to get documentation yet");
        return "";
    }
}

