/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.widgets;

import java.io.File;
import java.nio.file.Files;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;

public class WritableFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -8600149638325315049L;
    private static final int MINIMUM_SPACE_REQUIREMENT_MB = 5000000;

    public WritableFileChooser() {
    }

    public WritableFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    @Override
    public void approveSelection() {
        int result;
        File selectedFile = this.getSelectedFile();
        File checkFile = selectedFile;
        boolean fileExists = checkFile.exists();
        if (!fileExists) {
            checkFile = checkFile.getParentFile();
        }
        if (checkFile.getUsableSpace() < 5000000L && (result = JOptionPane.showConfirmDialog(this, Constant.messages.getString("report.write.diskspace.warning.dialog.message"), Constant.messages.getString("report.write.diskspace.warning.dialog.title"), 0)) != 0) {
            return;
        }
        if (!Files.isWritable(selectedFile.getParentFile().toPath())) {
            this.warnNotWritable("report.write.permission.dir.dialog.message", selectedFile.getParentFile().getAbsolutePath());
            return;
        }
        if (fileExists) {
            if (!Files.isWritable(selectedFile.toPath())) {
                this.warnNotWritable("report.write.permission.file.dialog.message", selectedFile.getAbsolutePath());
                return;
            }
            result = JOptionPane.showConfirmDialog(this, Constant.messages.getString("report.write.overwrite.dialog.message"), Constant.messages.getString("report.write.overwrite.dialog.title"), 0);
            if (result == 1 || result == -1) {
                return;
            }
        }
        Model.getSingleton().getOptionsParam().setUserDirectory(this.getCurrentDirectory());
        super.approveSelection();
    }

    protected void showErrorDialog(String message, String title) {
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    private void warnNotWritable(String i18nKeyMessage, String path) {
        this.showErrorDialog(Constant.messages.getString(i18nKeyMessage, path), Constant.messages.getString("report.write.permission.dialog.title"));
    }
}

