/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.DispatchDescriptor;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStatusListener;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.Factory;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.URL;
import com.sun.star.wiki.Helper;
import com.sun.star.wiki.Settings;
import com.sun.star.wiki.WikiArticle;
import com.sun.star.wiki.WikiCancelException;
import com.sun.star.wiki.WikiDialog;
import com.sun.star.wiki.WikiOptionsEventHandlerImpl;
import com.sun.star.wiki.WikiPropDialog;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WikiEditorImpl
extends WeakBase
implements XServiceInfo,
XDispatchProvider,
XDispatch,
XInitialization {
    private static final String m_implementationName = WikiEditorImpl.class.getName();
    private static final String[] m_serviceNames = new String[]{"com.sun.star.wiki.WikiEditor"};
    private static final String protocolName = "vnd.com.sun.star.wiki:";
    private final XComponentContext m_xContext;
    private XFrame m_xFrame;
    private XModel m_xModel;
    private final Settings m_aSettings;
    private String m_aFilterName;

    public WikiEditorImpl(XComponentContext xContext) {
        this.m_xContext = xContext;
        this.m_aSettings = Settings.getSettings(this.m_xContext);
    }

    public static XSingleComponentFactory __getComponentFactory(String sImplementationName) {
        XSingleComponentFactory xFactory = null;
        if (sImplementationName.equals(m_implementationName)) {
            xFactory = Factory.createComponentFactory(WikiEditorImpl.class, (String[])m_serviceNames);
        } else if (sImplementationName.equals(WikiOptionsEventHandlerImpl.m_sImplementationName)) {
            xFactory = Factory.createComponentFactory(WikiOptionsEventHandlerImpl.class, (String[])WikiOptionsEventHandlerImpl.m_pServiceNames);
        }
        return xFactory;
    }

    public String getImplementationName() {
        return m_implementationName;
    }

    public boolean supportsService(String sService) {
        int len = m_serviceNames.length;
        for (int i = 0; i < len; ++i) {
            if (!sService.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_serviceNames;
    }

    public synchronized void initialize(Object[] args) throws com.sun.star.uno.Exception {
        if (args.length > 0) {
            this.m_xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)args[0]);
        }
    }

    public void dispatch(URL aURL, PropertyValue[] propertyValue) {
        URL myURL = aURL;
        if (aURL.Protocol.equals(protocolName)) {
            try {
                if (myURL.Path.equals("send")) {
                    this.sendArticle();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public XDispatch queryDispatch(URL aURL, String str, int param) {
        if (aURL.Protocol.equals(protocolName)) {
            return this;
        }
        return null;
    }

    public XDispatch[] queryDispatches(DispatchDescriptor[] seqDescripts) {
        int nCount = seqDescripts.length;
        XDispatch[] lDispatcher = new XDispatch[nCount];
        for (int i = 0; i < nCount; ++i) {
            lDispatcher[i] = this.queryDispatch(seqDescripts[i].FeatureURL, seqDescripts[i].FrameName, seqDescripts[i].SearchFlags);
        }
        return lDispatcher;
    }

    public void removeStatusListener(XStatusListener xStatusListener, URL aURL) {
    }

    public void addStatusListener(XStatusListener listener, URL url) {
    }

    private void sendArticle() {
        if (this.m_xFrame != null) {
            WikiDialog aSendDialog = null;
            try {
                XController xController;
                if (this.m_xModel == null && (xController = this.m_xFrame.getController()) != null) {
                    this.m_xModel = xController.getModel();
                }
                if (this.m_xModel != null) {
                    String aServiceName = Helper.GetDocServiceName(this.m_xContext, this.m_xModel);
                    this.m_aFilterName = Helper.GetFilterName(this.m_xContext, "MediaWiki", aServiceName);
                    if (this.m_aFilterName == null || this.m_aFilterName.length() == 0) {
                        Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 1, null, false);
                        throw new RuntimeException();
                    }
                    this.m_aSettings.loadConfiguration();
                    aSendDialog = new WikiPropDialog(this.m_xContext, "vnd.sun.star.script:WikiEditor.SendToMediaWiki?location=application", this);
                    ((WikiPropDialog)aSendDialog).fillWikiList();
                    ((WikiPropDialog)aSendDialog).SetWikiTitle(Helper.GetDocTitle(this.m_xModel));
                    ((WikiPropDialog)aSendDialog).show();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (aSendDialog != null) {
                    aSendDialog.DisposeDialog();
                }
            }
        }
    }

    public boolean SendArticleImpl(WikiPropDialog aSendDialog, Map<String, String> aWikiSetting) {
        boolean bResult = false;
        if (aSendDialog != null) {
            String sTemp2Url = null;
            try {
                WikiArticle aArticle = new WikiArticle(this.m_xContext, aSendDialog.GetWikiTitle(), aWikiSetting, true, aSendDialog);
                boolean bAllowSending = true;
                if (!aArticle.NotExist()) {
                    aSendDialog.SetThrobberActive(false);
                    bAllowSending = Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 32, aSendDialog.GetWikiTitle(), true);
                    aSendDialog.SetThrobberActive(true);
                }
                if (bAllowSending) {
                    PropertyValue[] lProperties = new PropertyValue[2];
                    lProperties[0] = new PropertyValue();
                    lProperties[0].Name = "FilterName";
                    lProperties[0].Value = this.m_aFilterName;
                    lProperties[1] = new PropertyValue();
                    lProperties[1].Name = "Overwrite";
                    lProperties[1].Value = Boolean.TRUE;
                    sTemp2Url = Helper.CreateTempFile(this.m_xContext);
                    XStorable xStore = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.m_xModel);
                    if (xStore == null) {
                        throw new RuntimeException();
                    }
                    xStore.storeToURL(sTemp2Url, lProperties);
                    String sWikiCode = Helper.EachLine(sTemp2Url);
                    if (aArticle.setArticle(sWikiCode, aSendDialog.m_sWikiComment, aSendDialog.m_bWikiMinorEdit)) {
                        bResult = true;
                        Helper.SetDocTitle(this.m_xModel, aArticle.GetTitle());
                        HashMap<String, Object> aDocInfo = new HashMap<String, Object>();
                        aDocInfo.put("Doc", aArticle.GetTitle());
                        aDocInfo.put("Url", aArticle.GetMainURL());
                        aDocInfo.put("CompleteUrl", aArticle.GetMainURL() + aArticle.GetTitle());
                        this.m_aSettings.addWikiDoc(aDocInfo);
                        this.m_aSettings.storeConfiguration();
                    } else {
                        Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 0, null, false);
                    }
                }
            }
            catch (WikiCancelException aArticle) {
            }
            catch (SSLException essl) {
                if (Helper.IsConnectionAllowed()) {
                    Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 25, null, false);
                }
            }
            catch (Exception e) {
                if (Helper.IsConnectionAllowed()) {
                    Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 0, null, false);
                }
                e.printStackTrace();
            }
            if (sTemp2Url != null) {
                try {
                    File aFile = new File(new URI(sTemp2Url));
                    if (!aFile.delete()) {
                        throw new Exception("could not remove" + sTemp2Url);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return bResult;
    }
}

