'''OpenGL extension NV.half_float

This module customises the behaviour of the 
OpenGL.raw.GL.NV.half_float to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension introduces a new storage format and data type for
	half-precision (16-bit) floating-point quantities.  The floating-point
	format is very similar to the IEEE single-precision floating-point
	standard, except that it has only 5 exponent bits and 10 mantissa bits.
	Half-precision floats are smaller than full precision floats and provide a
	larger dynamic range than similarly-sized normalized scalar data types.
	
	This extension allows applications to use half-precision floating point
	data when specifying vertices or pixel data.  It adds new commands to
	specify vertex attributes using the new data type, and extends the
	existing vertex array and image specification commands to accept the new
	data type.
	
	This storage format is also used to represent 16-bit components in the
	floating-point frame buffers, as defined in the NV_float_buffer extension.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/half_float.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.half_float import *
from OpenGL.raw.GL.NV.half_float import _EXTENSION_NAME

def glInitHalfFloatNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

glVertex2hvNV=wrapper.wrapper(glVertex2hvNV).setInputArraySize(
    'v', 2
)
glVertex3hvNV=wrapper.wrapper(glVertex3hvNV).setInputArraySize(
    'v', 3
)
glVertex4hvNV=wrapper.wrapper(glVertex4hvNV).setInputArraySize(
    'v', 4
)
glNormal3hvNV=wrapper.wrapper(glNormal3hvNV).setInputArraySize(
    'v', 3
)
glColor3hvNV=wrapper.wrapper(glColor3hvNV).setInputArraySize(
    'v', 3
)
glColor4hvNV=wrapper.wrapper(glColor4hvNV).setInputArraySize(
    'v', 4
)
glTexCoord1hvNV=wrapper.wrapper(glTexCoord1hvNV).setInputArraySize(
    'v', 1
)
glTexCoord2hvNV=wrapper.wrapper(glTexCoord2hvNV).setInputArraySize(
    'v', 2
)
glTexCoord3hvNV=wrapper.wrapper(glTexCoord3hvNV).setInputArraySize(
    'v', 3
)
glTexCoord4hvNV=wrapper.wrapper(glTexCoord4hvNV).setInputArraySize(
    'v', 4
)
glMultiTexCoord1hvNV=wrapper.wrapper(glMultiTexCoord1hvNV).setInputArraySize(
    'v', 1
)
glMultiTexCoord2hvNV=wrapper.wrapper(glMultiTexCoord2hvNV).setInputArraySize(
    'v', 2
)
glMultiTexCoord3hvNV=wrapper.wrapper(glMultiTexCoord3hvNV).setInputArraySize(
    'v', 3
)
glMultiTexCoord4hvNV=wrapper.wrapper(glMultiTexCoord4hvNV).setInputArraySize(
    'v', 4
)
glFogCoordhvNV=wrapper.wrapper(glFogCoordhvNV).setInputArraySize(
    'fog', 1
)
glSecondaryColor3hvNV=wrapper.wrapper(glSecondaryColor3hvNV).setInputArraySize(
    'v', 3
)
glVertexWeighthvNV=wrapper.wrapper(glVertexWeighthvNV).setInputArraySize(
    'weight', 1
)
glVertexAttrib1hvNV=wrapper.wrapper(glVertexAttrib1hvNV).setInputArraySize(
    'v', 1
)
glVertexAttrib2hvNV=wrapper.wrapper(glVertexAttrib2hvNV).setInputArraySize(
    'v', 2
)
glVertexAttrib3hvNV=wrapper.wrapper(glVertexAttrib3hvNV).setInputArraySize(
    'v', 3
)
glVertexAttrib4hvNV=wrapper.wrapper(glVertexAttrib4hvNV).setInputArraySize(
    'v', 4
)
# INPUT glVertexAttribs1hvNV.v size not checked against n
glVertexAttribs1hvNV=wrapper.wrapper(glVertexAttribs1hvNV).setInputArraySize(
    'v', None
)
# INPUT glVertexAttribs2hvNV.v size not checked against n
glVertexAttribs2hvNV=wrapper.wrapper(glVertexAttribs2hvNV).setInputArraySize(
    'v', None
)
# INPUT glVertexAttribs3hvNV.v size not checked against n
glVertexAttribs3hvNV=wrapper.wrapper(glVertexAttribs3hvNV).setInputArraySize(
    'v', None
)
# INPUT glVertexAttribs4hvNV.v size not checked against n
glVertexAttribs4hvNV=wrapper.wrapper(glVertexAttribs4hvNV).setInputArraySize(
    'v', None
)
### END AUTOGENERATED SECTION