/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

import ch.qos.cal10n.Locale;
import ch.qos.cal10n.LocaleData;
import ch.qos.cal10n.util.AnnotationExtractor;

public abstract class AbstractAnnotationExtractor
implements AnnotationExtractor {
    protected abstract LocaleData extractLocaleData();

    public Locale[] extractLocales() {
        LocaleData localeData = this.extractLocaleData();
        if (localeData == null) {
            return null;
        }
        return localeData.value();
    }

    public String[] extractLocaleNames() {
        Locale[] localeDataArray = this.extractLocales();
        if (localeDataArray == null) {
            return null;
        }
        String[] names = new String[localeDataArray.length];
        for (int i = 0; i < localeDataArray.length; ++i) {
            names[i] = localeDataArray[i].value();
        }
        return names;
    }

    public String extractCharset(java.util.Locale juLocale) {
        LocaleData localeData = this.extractLocaleData();
        if (localeData == null) {
            return "";
        }
        String defaultCharset = localeData.defaultCharset();
        Locale la = AbstractAnnotationExtractor.findLocaleAnnotation(juLocale, localeData);
        String localeCharset = null;
        if (la != null) {
            localeCharset = la.charset();
        }
        if (!AbstractAnnotationExtractor.isEmptyString(localeCharset)) {
            return localeCharset;
        }
        return defaultCharset;
    }

    static Locale findLocaleAnnotation(java.util.Locale juLocale, LocaleData localeData) {
        Locale[] localeAnnotationArray = localeData.value();
        if (localeAnnotationArray == null) {
            return null;
        }
        for (Locale la : localeAnnotationArray) {
            if (!la.value().equals(juLocale.toString())) continue;
            return la;
        }
        return null;
    }

    static boolean isEmptyString(String s) {
        return s == null || s.length() == 0;
    }
}

