/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.awt;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.InterruptedRuntimeException;
import com.jogamp.common.util.RunnableTask;
import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.newt.util.EDTUtil;
import java.awt.EventQueue;
import java.io.PrintStream;
import jogamp.newt.Debug;

public class AWTEDTUtil
implements EDTUtil {
    public static final boolean DEBUG = Debug.debug("EDT");
    private final Object edtLock = new Object();
    private final ThreadGroup threadGroup;
    private final String name;
    private final Runnable dispatchMessages;
    private NEDT nedt = null;
    private int start_iter = 0;
    private static long pollPeriod = 10L;

    public AWTEDTUtil(ThreadGroup threadGroup, String string, Runnable runnable) {
        this.threadGroup = threadGroup;
        this.name = Thread.currentThread().getName() + "-" + string + "-EDT-";
        this.dispatchMessages = runnable;
        this.nedt = new NEDT(this.threadGroup, this.name);
        this.nedt.setDaemon(true);
    }

    @Override
    public final long getPollPeriod() {
        return pollPeriod;
    }

    @Override
    public final void setPollPeriod(long l) {
        pollPeriod = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() throws IllegalStateException {
        Object object = this.edtLock;
        synchronized (object) {
            if (this.nedt.isRunning()) {
                throw new IllegalStateException("EDT still running and not subject to stop. Curr " + Thread.currentThread().getName() + ", NEDT " + this.nedt.getName() + ", isRunning " + this.nedt.isRunning + ", shouldStop " + this.nedt.shouldStop + ", on AWT-EDT " + EventQueue.isDispatchThread());
            }
            if (DEBUG) {
                System.err.println(Thread.currentThread() + ": AWT-EDT reset - edt: " + (Object)((Object)this.nedt));
            }
            if (this.nedt.getState() != Thread.State.NEW) {
                this.nedt = new NEDT(this.threadGroup, this.name);
                this.nedt.setDaemon(true);
            }
            this.startImpl();
        }
        if (!this.nedt.isRunning()) {
            throw new RuntimeException("EDT could not be started: " + (Object)((Object)this.nedt));
        }
    }

    private final void startImpl() {
        if (this.nedt.isAlive()) {
            throw new RuntimeException("AWT-EDT Thread.isAlive(): true, isRunning: " + this.nedt.isRunning + ", shouldStop " + this.nedt.shouldStop + ", edt: " + (Object)((Object)this.nedt));
        }
        ++this.start_iter;
        this.nedt.setName(this.name + this.start_iter);
        if (DEBUG) {
            System.err.println(Thread.currentThread() + ": AWT-EDT START - edt: " + (Object)((Object)this.nedt));
        }
        this.nedt.start();
    }

    @Override
    public final boolean isCurrentThreadEDT() {
        return EventQueue.isDispatchThread();
    }

    @Override
    public final boolean isCurrentThreadNEDT() {
        return this.nedt == Thread.currentThread();
    }

    @Override
    public final boolean isCurrentThreadEDTorNEDT() {
        return EventQueue.isDispatchThread() || this.nedt == Thread.currentThread();
    }

    @Override
    public final boolean isRunning() {
        return this.nedt.isRunning();
    }

    @Override
    public final boolean invokeStop(boolean bl, Runnable runnable) {
        return this.invokeImpl(bl, runnable, true);
    }

    @Override
    public final boolean invoke(boolean bl, Runnable runnable) {
        return this.invokeImpl(bl, runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean invokeImpl(boolean bl, Runnable runnable, boolean bl2) {
        Object object;
        Object object2 = object = new Object();
        synchronized (object2) {
            RunnableTask runnableTask;
            Object object3 = this.edtLock;
            synchronized (object3) {
                if (this.nedt.shouldStop) {
                    System.err.println(Thread.currentThread() + ": Warning: AWT-EDT about (1) to stop, won't enqueue new task: " + (Object)((Object)this.nedt));
                    if (DEBUG) {
                        ExceptionUtils.dumpStack((PrintStream)System.err);
                    }
                    return false;
                }
                if (this.isCurrentThreadEDT()) {
                    if (null != runnable) {
                        runnable.run();
                    }
                    bl = false;
                    runnableTask = null;
                    if (bl2) {
                        this.nedt.shouldStop = true;
                    }
                } else {
                    if (!this.nedt.isRunning) {
                        if (null != runnable) {
                            if (bl2) {
                                System.err.println(Thread.currentThread() + ": Warning: AWT-EDT is about (3) to stop and stopped already, dropping task. NEDT " + (Object)((Object)this.nedt));
                            } else {
                                System.err.println(Thread.currentThread() + ": Warning: AWT-EDT is not running, dropping task. NEDT " + (Object)((Object)this.nedt));
                            }
                            if (DEBUG) {
                                ExceptionUtils.dumpStack((PrintStream)System.err);
                            }
                        }
                        return false;
                    }
                    if (bl2) {
                        if (DEBUG) {
                            System.err.println(Thread.currentThread() + ": AWT-EDT signal STOP (on edt: " + this.isCurrentThreadEDT() + ") - " + (Object)((Object)this.nedt) + ", isRunning " + this.nedt.isRunning + ", shouldStop " + this.nedt.shouldStop);
                        }
                        Object object4 = this.nedt.sync;
                        synchronized (object4) {
                            this.nedt.shouldStop = true;
                            this.nedt.sync.notifyAll();
                        }
                    }
                    if (null != runnable) {
                        runnableTask = new RunnableTask(runnable, bl ? object : null, true, bl ? null : System.err);
                        AWTEDTExecutor.singleton.invoke(false, (Runnable)runnableTask);
                    } else {
                        bl = false;
                        runnableTask = null;
                    }
                }
            }
            if (bl) {
                try {
                    while (runnableTask.isInQueue()) {
                        object.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedRuntimeException(interruptedException);
                }
                object3 = runnableTask.getThrowable();
                if (null != object3) {
                    if (object3 instanceof NativeWindowException) {
                        throw (NativeWindowException)object3;
                    }
                    throw new RuntimeException((Throwable)object3);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean waitUntilIdle() {
        NEDT nEDT;
        Object object = this.edtLock;
        synchronized (object) {
            nEDT = this.nedt;
        }
        if (!nEDT.isRunning || nEDT == Thread.currentThread() || EventQueue.isDispatchThread()) {
            return false;
        }
        try {
            AWTEDTExecutor.singleton.invoke(true, new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean waitUntilStopped() {
        Object object = this.edtLock;
        synchronized (object) {
            if (this.nedt.isRunning && this.nedt != Thread.currentThread() && !EventQueue.isDispatchThread()) {
                try {
                    while (this.nedt.isRunning) {
                        this.edtLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedRuntimeException(interruptedException);
                }
                return true;
            }
            return false;
        }
    }

    class NEDT
    extends InterruptSource.Thread {
        volatile boolean shouldStop;
        volatile boolean isRunning;
        Object sync;

        public NEDT(ThreadGroup threadGroup, String string) {
            super(threadGroup, null, string);
            this.shouldStop = false;
            this.isRunning = false;
            this.sync = new Object();
        }

        public final boolean isRunning() {
            return this.isRunning && !this.shouldStop;
        }

        public final void start() throws IllegalThreadStateException {
            this.isRunning = true;
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            Object object;
            if (DEBUG) {
                System.err.println(this.getName() + ": AWT-EDT run() START " + this.getName());
            }
            RuntimeException runtimeException = null;
            try {
                do {
                    if (!this.shouldStop) {
                        AWTEDTExecutor.singleton.invoke(true, AWTEDTUtil.this.dispatchMessages);
                    }
                    object = this.sync;
                    synchronized (object) {
                        if (!this.shouldStop) {
                            try {
                                this.sync.wait(pollPeriod);
                            }
                            catch (InterruptedException interruptedException) {
                                throw new InterruptedRuntimeException(interruptedException);
                            }
                        }
                    }
                } while (!this.shouldStop);
            }
            catch (Throwable throwable) {
                this.shouldStop = true;
                if (throwable instanceof RuntimeException) {
                    runtimeException = (RuntimeException)throwable;
                }
                runtimeException = new RuntimeException("Within AWT-EDT", throwable);
            }
            finally {
                if (DEBUG) {
                    System.err.println(this.getName() + ": AWT-EDT run() END " + this.getName() + ", " + runtimeException);
                }
                object = AWTEDTUtil.this.edtLock;
                synchronized (object) {
                    this.isRunning = false;
                    AWTEDTUtil.this.edtLock.notifyAll();
                }
                if (DEBUG) {
                    System.err.println(this.getName() + ": AWT-EDT run() EXIT " + this.getName() + ", exception: " + runtimeException);
                }
                if (null != runtimeException) {
                    throw runtimeException;
                }
            }
        }
    }
}

