/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.math;

import org.sunflow.math.Point2;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public final class PerlinScalar {
    private static final float[] G1 = new float[]{-1.0f, 1.0f};
    private static final float[][] G2 = new float[][]{{1.0f, 0.0f}, {-1.0f, 0.0f}, {0.0f, 1.0f}, {0.0f, -1.0f}};
    private static final float[][] G3 = new float[][]{{1.0f, 1.0f, 0.0f}, {-1.0f, 1.0f, 0.0f}, {1.0f, -1.0f, 0.0f}, {-1.0f, -1.0f, 0.0f}, {1.0f, 0.0f, 1.0f}, {-1.0f, 0.0f, 1.0f}, {1.0f, 0.0f, -1.0f}, {-1.0f, 0.0f, -1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, -1.0f, 1.0f}, {0.0f, 1.0f, -1.0f}, {0.0f, -1.0f, -1.0f}, {1.0f, 1.0f, 0.0f}, {-1.0f, 1.0f, 0.0f}, {0.0f, -1.0f, 1.0f}, {0.0f, -1.0f, -1.0f}};
    private static final float[][] G4 = new float[][]{{-1.0f, -1.0f, -1.0f, 0.0f}, {-1.0f, -1.0f, 1.0f, 0.0f}, {-1.0f, 1.0f, -1.0f, 0.0f}, {-1.0f, 1.0f, 1.0f, 0.0f}, {1.0f, -1.0f, -1.0f, 0.0f}, {1.0f, -1.0f, 1.0f, 0.0f}, {1.0f, 1.0f, -1.0f, 0.0f}, {1.0f, 1.0f, 1.0f, 0.0f}, {-1.0f, -1.0f, 0.0f, -1.0f}, {-1.0f, 1.0f, 0.0f, -1.0f}, {1.0f, -1.0f, 0.0f, -1.0f}, {1.0f, 1.0f, 0.0f, -1.0f}, {-1.0f, -1.0f, 0.0f, 1.0f}, {-1.0f, 1.0f, 0.0f, 1.0f}, {1.0f, -1.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 0.0f, 1.0f}, {-1.0f, 0.0f, -1.0f, -1.0f}, {1.0f, 0.0f, -1.0f, -1.0f}, {-1.0f, 0.0f, -1.0f, 1.0f}, {1.0f, 0.0f, -1.0f, 1.0f}, {-1.0f, 0.0f, 1.0f, -1.0f}, {1.0f, 0.0f, 1.0f, -1.0f}, {-1.0f, 0.0f, 1.0f, 1.0f}, {1.0f, 0.0f, 1.0f, 1.0f}, {0.0f, -1.0f, -1.0f, -1.0f}, {0.0f, -1.0f, -1.0f, 1.0f}, {0.0f, -1.0f, 1.0f, -1.0f}, {0.0f, -1.0f, 1.0f, 1.0f}, {0.0f, 1.0f, -1.0f, -1.0f}, {0.0f, 1.0f, -1.0f, 1.0f}, {0.0f, 1.0f, 1.0f, -1.0f}, {0.0f, 1.0f, 1.0f, 1.0f}};
    private static final int[] p = new int[]{151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180, 151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180};

    public static final float snoise(float f) {
        int n = (int)Math.floor(f);
        int n2 = n & 0xFF;
        float f2 = PerlinScalar.fade(f -= (float)n);
        int n3 = p[n2];
        int n4 = p[n2 + 1];
        return PerlinScalar.lerp(f2, PerlinScalar.grad(p[n3], f), PerlinScalar.grad(p[n4], f - 1.0f));
    }

    public static final float snoise(float f, float f2) {
        int n = (int)Math.floor(f);
        int n2 = (int)Math.floor(f2);
        int n3 = n & 0xFF;
        int n4 = n2 & 0xFF;
        float f3 = PerlinScalar.fade(f -= (float)n);
        float f4 = PerlinScalar.fade(f2 -= (float)n2);
        int n5 = p[n3] + n4;
        int n6 = p[n3 + 1] + n4;
        return PerlinScalar.lerp(f4, PerlinScalar.lerp(f3, PerlinScalar.grad(p[n5], f, f2), PerlinScalar.grad(p[n6], f - 1.0f, f2)), PerlinScalar.lerp(f3, PerlinScalar.grad(p[n5 + 1], f, f2 - 1.0f), PerlinScalar.grad(p[n6 + 1], f - 1.0f, f2 - 1.0f)));
    }

    public static final float snoise(float f, float f2, float f3) {
        int n = (int)Math.floor(f);
        int n2 = (int)Math.floor(f2);
        int n3 = (int)Math.floor(f3);
        int n4 = n & 0xFF;
        int n5 = n2 & 0xFF;
        int n6 = n3 & 0xFF;
        float f4 = PerlinScalar.fade(f -= (float)n);
        float f5 = PerlinScalar.fade(f2 -= (float)n2);
        float f6 = PerlinScalar.fade(f3 -= (float)n3);
        int n7 = p[n4] + n5;
        int n8 = p[n7] + n6;
        int n9 = p[n7 + 1] + n6;
        int n10 = p[n4 + 1] + n5;
        int n11 = p[n10] + n6;
        int n12 = p[n10 + 1] + n6;
        return PerlinScalar.lerp(f6, PerlinScalar.lerp(f5, PerlinScalar.lerp(f4, PerlinScalar.grad(p[n8], f, f2, f3), PerlinScalar.grad(p[n11], f - 1.0f, f2, f3)), PerlinScalar.lerp(f4, PerlinScalar.grad(p[n9], f, f2 - 1.0f, f3), PerlinScalar.grad(p[n12], f - 1.0f, f2 - 1.0f, f3))), PerlinScalar.lerp(f5, PerlinScalar.lerp(f4, PerlinScalar.grad(p[n8 + 1], f, f2, f3 - 1.0f), PerlinScalar.grad(p[n11 + 1], f - 1.0f, f2, f3 - 1.0f)), PerlinScalar.lerp(f4, PerlinScalar.grad(p[n9 + 1], f, f2 - 1.0f, f3 - 1.0f), PerlinScalar.grad(p[n12 + 1], f - 1.0f, f2 - 1.0f, f3 - 1.0f))));
    }

    public static final float snoise(float f, float f2, float f3, float f4) {
        int n = (int)Math.floor(f);
        int n2 = (int)Math.floor(f2);
        int n3 = (int)Math.floor(f3);
        int n4 = (int)Math.floor(f4);
        int n5 = n & 0xFF;
        int n6 = n2 & 0xFF;
        int n7 = n3 & 0xFF;
        int n8 = n4 & 0xFF;
        float f5 = PerlinScalar.fade(f -= (float)n);
        float f6 = PerlinScalar.fade(f2 -= (float)n2);
        float f7 = PerlinScalar.fade(f3 -= (float)n3);
        float f8 = PerlinScalar.fade(f4 -= (float)n4);
        int n9 = p[n5] + n6;
        int n10 = p[n9] + n7;
        int n11 = p[n9 + 1] + n7;
        int n12 = p[n5 + 1] + n6;
        int n13 = p[n12] + n7;
        int n14 = p[n12 + 1] + n7;
        int n15 = p[n10] + n8;
        int n16 = p[n10 + 1] + n8;
        int n17 = p[n11] + n8;
        int n18 = p[n11 + 1] + n8;
        int n19 = p[n13] + n8;
        int n20 = p[n13 + 1] + n8;
        int n21 = p[n14] + n8;
        int n22 = p[n14 + 1] + n8;
        return PerlinScalar.lerp(f8, PerlinScalar.lerp(f7, PerlinScalar.lerp(f6, PerlinScalar.lerp(f5, PerlinScalar.grad(p[n15], f, f2, f3, f4), PerlinScalar.grad(p[n19], f - 1.0f, f2, f3, f4)), PerlinScalar.lerp(f5, PerlinScalar.grad(p[n17], f, f2 - 1.0f, f3, f4), PerlinScalar.grad(p[n21], f - 1.0f, f2 - 1.0f, f3, f4))), PerlinScalar.lerp(f6, PerlinScalar.lerp(f5, PerlinScalar.grad(p[n16], f, f2, f3 - 1.0f, f4), PerlinScalar.grad(p[n20], f - 1.0f, f2, f3 - 1.0f, f4)), PerlinScalar.lerp(f5, PerlinScalar.grad(p[n18], f, f2 - 1.0f, f3 - 1.0f, f4), PerlinScalar.grad(p[n22], f - 1.0f, f2 - 1.0f, f3 - 1.0f, f4)))), PerlinScalar.lerp(f7, PerlinScalar.lerp(f6, PerlinScalar.lerp(f5, PerlinScalar.grad(p[n15 + 1], f, f2, f3, f4 - 1.0f), PerlinScalar.grad(p[n19 + 1], f - 1.0f, f2, f3, f4 - 1.0f)), PerlinScalar.lerp(f5, PerlinScalar.grad(p[n17 + 1], f, f2 - 1.0f, f3, f4 - 1.0f), PerlinScalar.grad(p[n21 + 1], f - 1.0f, f2 - 1.0f, f3, f4 - 1.0f))), PerlinScalar.lerp(f6, PerlinScalar.lerp(f5, PerlinScalar.grad(p[n16 + 1], f, f2, f3 - 1.0f, f4 - 1.0f), PerlinScalar.grad(p[n20 + 1], f - 1.0f, f2, f3 - 1.0f, f4 - 1.0f)), PerlinScalar.lerp(f5, PerlinScalar.grad(p[n18 + 1], f, f2 - 1.0f, f3 - 1.0f, f4 - 1.0f), PerlinScalar.grad(p[n22 + 1], f - 1.0f, f2 - 1.0f, f3 - 1.0f, f4 - 1.0f)))));
    }

    public static final float snoise(Point2 point2) {
        return PerlinScalar.snoise(point2.x, point2.y);
    }

    public static final float snoise(Point3 point3) {
        return PerlinScalar.snoise(point3.x, point3.y, point3.z);
    }

    public static final float snoise(Point3 point3, float f) {
        return PerlinScalar.snoise(point3.x, point3.y, point3.z, f);
    }

    public static final float noise(float f) {
        return 0.5f + 0.5f * PerlinScalar.snoise(f);
    }

    public static final float noise(float f, float f2) {
        return 0.5f + 0.5f * PerlinScalar.snoise(f, f2);
    }

    public static final float noise(float f, float f2, float f3) {
        return 0.5f + 0.5f * PerlinScalar.snoise(f, f2, f3);
    }

    public static final float noise(float f, float f2, float f3, float f4) {
        return 0.5f + 0.5f * PerlinScalar.snoise(f, f2, f3, f4);
    }

    public static final float noise(Point2 point2) {
        return 0.5f + 0.5f * PerlinScalar.snoise(point2.x, point2.y);
    }

    public static final float noise(Point3 point3) {
        return 0.5f + 0.5f * PerlinScalar.snoise(point3.x, point3.y, point3.z);
    }

    public static final float noise(Point3 point3, float f) {
        return 0.5f + 0.5f * PerlinScalar.snoise(point3.x, point3.y, point3.z, f);
    }

    public static final float pnoise(float f, float f2) {
        float f3 = f % f2 + (f < 0.0f ? f2 : 0.0f);
        return ((f2 - f3) * PerlinScalar.noise(f3) + f3 * PerlinScalar.noise(f3 - f2)) / f2;
    }

    public static final float pnoise(float f, float f2, float f3, float f4) {
        float f5 = f % f3 + (f < 0.0f ? f3 : 0.0f);
        float f6 = f2 % f4 + (f2 < 0.0f ? f4 : 0.0f);
        float f7 = f3 - f5;
        float f8 = f4 - f6;
        float f9 = f5 - f3;
        float f10 = f6 - f4;
        return (PerlinScalar.noise(f5, f6) * f7 * f8 + PerlinScalar.noise(f9, f6) * f5 * f8 + PerlinScalar.noise(f9, f10) * f5 * f6 + PerlinScalar.noise(f5, f10) * f7 * f6) / (f3 * f4);
    }

    public static final float pnoise(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f % f4 + (f < 0.0f ? f4 : 0.0f);
        float f8 = f2 % f5 + (f2 < 0.0f ? f5 : 0.0f);
        float f9 = f3 % f6 + (f3 < 0.0f ? f6 : 0.0f);
        float f10 = f4 - f7;
        float f11 = f5 - f8;
        float f12 = f6 - f9;
        float f13 = f7 - f4;
        float f14 = f8 - f5;
        float f15 = f9 - f6;
        float f16 = f7 * f8;
        float f17 = f11 * f12;
        float f18 = f11 * f9;
        float f19 = f10 * f8;
        return (PerlinScalar.noise(f7, f8, f9) * f10 * f17 + PerlinScalar.noise(f7, f14, f9) * f19 * f12 + PerlinScalar.noise(f13, f8, f9) * f7 * f17 + PerlinScalar.noise(f13, f14, f9) * f16 * f12 + PerlinScalar.noise(f13, f14, f15) * f16 * f9 + PerlinScalar.noise(f7, f8, f15) * f10 * f18 + PerlinScalar.noise(f7, f14, f15) * f19 * f9 + PerlinScalar.noise(f13, f8, f15) * f7 * f18) / (f4 * f5 * f6);
    }

    public static final float pnoise(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = f % f5 + (f < 0.0f ? f5 : 0.0f);
        float f10 = f2 % f6 + (f2 < 0.0f ? f6 : 0.0f);
        float f11 = f3 % f7 + (f3 < 0.0f ? f7 : 0.0f);
        float f12 = f4 % f8 + (f4 < 0.0f ? f8 : 0.0f);
        float f13 = f5 - f9;
        float f14 = f6 - f10;
        float f15 = f7 - f11;
        float f16 = f8 - f12;
        float f17 = f9 - f5;
        float f18 = f10 - f6;
        float f19 = f11 - f7;
        float f20 = f12 - f8;
        float f21 = f9 * f10;
        float f22 = f15 * f16;
        float f23 = f11 * f16;
        float f24 = f11 * f12;
        float f25 = f15 * f12;
        float f26 = f13 * f10;
        float f27 = f13 * f14;
        float f28 = f9 * f14;
        return (PerlinScalar.noise(f9, f10, f11, f12) * f27 * f22 + PerlinScalar.noise(f17, f10, f11, f12) * f28 * f22 + PerlinScalar.noise(f17, f18, f11, f12) * f21 * f22 + PerlinScalar.noise(f9, f18, f11, f12) * f26 * f22 + PerlinScalar.noise(f17, f18, f19, f12) * f21 * f23 + PerlinScalar.noise(f9, f10, f19, f12) * f27 * f23 + PerlinScalar.noise(f9, f18, f19, f12) * f26 * f23 + PerlinScalar.noise(f17, f10, f19, f12) * f28 * f23 + PerlinScalar.noise(f9, f10, f11, f20) * f27 * f25 + PerlinScalar.noise(f17, f10, f11, f20) * f28 * f25 + PerlinScalar.noise(f17, f18, f11, f20) * f21 * f25 + PerlinScalar.noise(f9, f18, f11, f20) * f26 * f25 + PerlinScalar.noise(f17, f18, f19, f20) * f21 * f24 + PerlinScalar.noise(f9, f10, f19, f20) * f27 * f24 + PerlinScalar.noise(f9, f18, f19, f20) * f26 * f24 + PerlinScalar.noise(f17, f10, f19, f20) * f28 * f24) / (f5 * f6 * f7 * f12);
    }

    public static final float pnoise(Point2 point2, float f, float f2) {
        return PerlinScalar.pnoise(point2.x, point2.y, f, f2);
    }

    public static final float pnoise(Point3 point3, Vector3 vector3) {
        return PerlinScalar.pnoise(point3.x, point3.y, point3.z, vector3.x, vector3.y, vector3.z);
    }

    public static final float pnoise(Point3 point3, float f, Vector3 vector3, float f2) {
        return PerlinScalar.pnoise(point3.x, point3.y, point3.z, f, vector3.x, vector3.y, vector3.z, f2);
    }

    public static final float spnoise(float f, float f2) {
        float f3 = f % f2 + (f < 0.0f ? f2 : 0.0f);
        return ((f2 - f3) * PerlinScalar.snoise(f3) + f3 * PerlinScalar.snoise(f3 - f2)) / f2;
    }

    public static final float spnoise(float f, float f2, float f3, float f4) {
        float f5 = f % f3 + (f < 0.0f ? f3 : 0.0f);
        float f6 = f2 % f4 + (f2 < 0.0f ? f4 : 0.0f);
        float f7 = f3 - f5;
        float f8 = f4 - f6;
        float f9 = f5 - f3;
        float f10 = f6 - f4;
        return (PerlinScalar.snoise(f5, f6) * f7 * f8 + PerlinScalar.snoise(f9, f6) * f5 * f8 + PerlinScalar.snoise(f9, f10) * f5 * f6 + PerlinScalar.snoise(f5, f10) * f7 * f6) / (f3 * f4);
    }

    public static final float spnoise(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f % f4 + (f < 0.0f ? f4 : 0.0f);
        float f8 = f2 % f5 + (f2 < 0.0f ? f5 : 0.0f);
        float f9 = f3 % f6 + (f3 < 0.0f ? f6 : 0.0f);
        float f10 = f4 - f7;
        float f11 = f5 - f8;
        float f12 = f6 - f9;
        float f13 = f7 - f4;
        float f14 = f8 - f5;
        float f15 = f9 - f6;
        float f16 = f7 * f8;
        float f17 = f11 * f12;
        float f18 = f11 * f9;
        float f19 = f10 * f8;
        return (PerlinScalar.snoise(f7, f8, f9) * f10 * f17 + PerlinScalar.snoise(f7, f14, f9) * f19 * f12 + PerlinScalar.snoise(f13, f8, f9) * f7 * f17 + PerlinScalar.snoise(f13, f14, f9) * f16 * f12 + PerlinScalar.snoise(f13, f14, f15) * f16 * f9 + PerlinScalar.snoise(f7, f8, f15) * f10 * f18 + PerlinScalar.snoise(f7, f14, f15) * f19 * f9 + PerlinScalar.snoise(f13, f8, f15) * f7 * f18) / (f4 * f5 * f6);
    }

    public static final float spnoise(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = f % f5 + (f < 0.0f ? f5 : 0.0f);
        float f10 = f2 % f6 + (f2 < 0.0f ? f6 : 0.0f);
        float f11 = f3 % f7 + (f3 < 0.0f ? f7 : 0.0f);
        float f12 = f4 % f8 + (f4 < 0.0f ? f8 : 0.0f);
        float f13 = f5 - f9;
        float f14 = f6 - f10;
        float f15 = f7 - f11;
        float f16 = f8 - f12;
        float f17 = f9 - f5;
        float f18 = f10 - f6;
        float f19 = f11 - f7;
        float f20 = f12 - f8;
        float f21 = f9 * f10;
        float f22 = f15 * f16;
        float f23 = f11 * f16;
        float f24 = f11 * f12;
        float f25 = f15 * f12;
        float f26 = f13 * f10;
        float f27 = f13 * f14;
        float f28 = f9 * f14;
        return (PerlinScalar.snoise(f9, f10, f11, f12) * f27 * f22 + PerlinScalar.snoise(f17, f10, f11, f12) * f28 * f22 + PerlinScalar.snoise(f17, f18, f11, f12) * f21 * f22 + PerlinScalar.snoise(f9, f18, f11, f12) * f26 * f22 + PerlinScalar.snoise(f17, f18, f19, f12) * f21 * f23 + PerlinScalar.snoise(f9, f10, f19, f12) * f27 * f23 + PerlinScalar.snoise(f9, f18, f19, f12) * f26 * f23 + PerlinScalar.snoise(f17, f10, f19, f12) * f28 * f23 + PerlinScalar.snoise(f9, f10, f11, f20) * f27 * f25 + PerlinScalar.snoise(f17, f10, f11, f20) * f28 * f25 + PerlinScalar.snoise(f17, f18, f11, f20) * f21 * f25 + PerlinScalar.snoise(f9, f18, f11, f20) * f26 * f25 + PerlinScalar.snoise(f17, f18, f19, f20) * f21 * f24 + PerlinScalar.snoise(f9, f10, f19, f20) * f27 * f24 + PerlinScalar.snoise(f9, f18, f19, f20) * f26 * f24 + PerlinScalar.snoise(f17, f10, f19, f20) * f28 * f24) / (f5 * f6 * f7 * f12);
    }

    public static final float spnoise(Point2 point2, float f, float f2) {
        return PerlinScalar.spnoise(point2.x, point2.y, f, f2);
    }

    public static final float spnoise(Point3 point3, Vector3 vector3) {
        return PerlinScalar.spnoise(point3.x, point3.y, point3.z, vector3.x, vector3.y, vector3.z);
    }

    public static final float spnoise(Point3 point3, float f, Vector3 vector3, float f2) {
        return PerlinScalar.spnoise(point3.x, point3.y, point3.z, f, vector3.x, vector3.y, vector3.z, f2);
    }

    private static final float fade(float f) {
        return f * f * f * (f * (f * 6.0f - 15.0f) + 10.0f);
    }

    private static final float lerp(float f, float f2, float f3) {
        return f2 + f * (f3 - f2);
    }

    private static final float grad(int n, float f) {
        int n2 = n & 1;
        return f * G1[n2];
    }

    private static final float grad(int n, float f, float f2) {
        int n2 = n & 3;
        return f * G2[n2][0] + f2 * G2[n2][1];
    }

    private static final float grad(int n, float f, float f2, float f3) {
        int n2 = n & 0xF;
        return f * G3[n2][0] + f2 * G3[n2][1] + f3 * G3[n2][2];
    }

    private static final float grad(int n, float f, float f2, float f3, float f4) {
        int n2 = n & 0x1F;
        return f * G4[n2][0] + f2 * G4[n2][1] + f3 * G4[n2][2] + f4 * G4[n2][3];
    }
}

