/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.node.AStatement;

public final class SBlock
extends AStatement {
    final List<AStatement> statements;

    public SBlock(Location location, List<AStatement> statements) {
        super(location);
        this.statements = Collections.unmodifiableList(statements);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        for (AStatement statement : this.statements) {
            statement.storeSettings(settings);
        }
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AStatement statement : this.statements) {
            statement.extractVariables(variables);
        }
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        if (this.statements == null || this.statements.isEmpty()) {
            throw this.createError(new IllegalArgumentException("A block must contain at least one statement."));
        }
        AStatement last = this.statements.get(this.statements.size() - 1);
        for (AStatement statement : this.statements) {
            if (this.allEscape) {
                throw this.createError(new IllegalArgumentException("Unreachable statement."));
            }
            statement.inLoop = this.inLoop;
            statement.lastSource = this.lastSource && statement == last;
            statement.lastLoop = (this.beginLoop || this.lastLoop) && statement == last;
            statement.analyze(scriptRoot, locals);
            this.methodEscape = statement.methodEscape;
            this.loopEscape = statement.loopEscape;
            this.allEscape = statement.allEscape;
            this.anyContinue |= statement.anyContinue;
            this.anyBreak |= statement.anyBreak;
            this.statementCount += statement.statementCount;
        }
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        for (AStatement statement : this.statements) {
            statement.continu = this.continu;
            statement.brake = this.brake;
            statement.write(classWriter, methodWriter, globals);
        }
    }

    @Override
    public String toString() {
        return this.multilineToString(Collections.emptyList(), this.statements);
    }
}

