/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseContext;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.transport.Transport;

final class CanMatchPreFilterSearchPhase
extends AbstractSearchAsyncAction<SearchService.CanMatchResponse> {
    private final Function<GroupShardsIterator<SearchShardIterator>, SearchPhase> phaseFactory;
    private final GroupShardsIterator<SearchShardIterator> shardsIts;

    CanMatchPreFilterSearchPhase(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, long clusterStateVersion, SearchTask task, Function<GroupShardsIterator<SearchShardIterator>, SearchPhase> phaseFactory, SearchResponse.Clusters clusters) {
        super("can_match", logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, indexRoutings, executor, request, listener, shardsIts, timeProvider, clusterStateVersion, task, new BitSetSearchPhaseResults(shardsIts.size()), shardsIts.size(), clusters);
        this.phaseFactory = phaseFactory;
        this.shardsIts = shardsIts;
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, ShardRouting shard, SearchActionListener<SearchService.CanMatchResponse> listener) {
        this.getSearchTransport().sendCanMatch(this.getConnection(shardIt.getClusterAlias(), shard.currentNodeId()), this.buildShardSearchRequest(shardIt), this.getTask(), listener);
    }

    @Override
    protected SearchPhase getNextPhase(SearchPhaseResults<SearchService.CanMatchResponse> results, SearchPhaseContext context) {
        return this.phaseFactory.apply(this.getIterator((BitSetSearchPhaseResults)results, this.shardsIts));
    }

    private GroupShardsIterator<SearchShardIterator> getIterator(BitSetSearchPhaseResults results, GroupShardsIterator<SearchShardIterator> shardsIts) {
        int cardinality = results.getNumPossibleMatches();
        FixedBitSet possibleMatches = results.getPossibleMatches();
        if (cardinality == 0) {
            possibleMatches.set(0);
        }
        int i = 0;
        for (SearchShardIterator iter : shardsIts) {
            if (possibleMatches.get(i++)) {
                iter.reset();
                continue;
            }
            iter.resetAndSkip();
        }
        return shardsIts;
    }

    private static final class BitSetSearchPhaseResults
    extends SearchPhaseResults<SearchService.CanMatchResponse> {
        private final FixedBitSet possibleMatches;
        private int numPossibleMatches;

        BitSetSearchPhaseResults(int size) {
            super(size);
            this.possibleMatches = new FixedBitSet(size);
        }

        @Override
        void consumeResult(SearchService.CanMatchResponse result) {
            if (result.canMatch()) {
                this.consumeShardFailure(result.getShardIndex());
            }
        }

        @Override
        boolean hasResult(int shardIndex) {
            return false;
        }

        @Override
        synchronized void consumeShardFailure(int shardIndex) {
            this.possibleMatches.set(shardIndex);
            ++this.numPossibleMatches;
        }

        synchronized int getNumPossibleMatches() {
            return this.numPossibleMatches;
        }

        synchronized FixedBitSet getPossibleMatches() {
            return this.possibleMatches;
        }

        @Override
        Stream<SearchService.CanMatchResponse> getSuccessfulResults() {
            return Stream.empty();
        }
    }
}

