/*
 * Decompiled with CFR 0.152.
 */
package com.lizardworks.util;

public class MemoryFileInputFilter {
    private byte[] bytesArray;
    private boolean isIntel;
    private int currentPos;
    public static final int BYTE_SIZE = 1;
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;

    public MemoryFileInputFilter(byte[] bytesArray, boolean isIntel) {
        this.bytesArray = bytesArray;
        this.isIntel = isIntel;
        this.currentPos = 0;
    }

    public MemoryFileInputFilter(byte[] bytesArray) {
        this.bytesArray = bytesArray;
        this.isIntel = false;
        this.currentPos = 0;
    }

    public long getFilePointer() {
        return this.currentPos;
    }

    public boolean isIntel() {
        return this.isIntel;
    }

    public void setByteOrder(boolean isIntel) {
        this.isIntel = isIntel;
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public char readChar() {
        char c = '\u0000';
        short l = this.readUnsignedByte();
        short h = this.readUnsignedByte();
        c = this.isIntel ? (char)(((h & 0xFF) << 8) + (l & 0xFF)) : (char)(((l & 0xFF) << 8) + (h & 0xFF));
        return c;
    }

    public short readUnsignedByte() {
        short b = (short)(this.bytesArray[this.currentPos] & 0xFF);
        ++this.currentPos;
        return b;
    }

    public byte readByte() {
        byte b = this.bytesArray[this.currentPos];
        ++this.currentPos;
        return b;
    }

    public short readShort() {
        short s = 0;
        short l = this.readUnsignedByte();
        short h = this.readUnsignedByte();
        s = this.isIntel ? (short)(((h & 0xFF) << 8) + (l & 0xFF)) : (short)(((l & 0xFF) << 8) + (h & 0xFF));
        return s;
    }

    public int readUnsignedShort() {
        int s = 0;
        short l = this.readUnsignedByte();
        short h = this.readUnsignedByte();
        s = this.isIntel ? ((h & 0xFF) << 8) + (l & 0xFF) : ((l & 0xFF) << 8) + (h & 0xFF);
        return s;
    }

    public long readInt() {
        long i = 0L;
        short b1 = this.readUnsignedByte();
        short b2 = this.readUnsignedByte();
        short b3 = this.readUnsignedByte();
        short b4 = this.readUnsignedByte();
        i = this.isIntel ? (long)(((b4 & 0xFF) << 24) + ((b3 & 0xFF) << 16) + ((b2 & 0xFF) << 8) + (b1 & 0xFF)) : (long)(((b1 & 0xFF) << 24) + ((b2 & 0xFF) << 16) + ((b3 & 0xFF) << 8) + (b4 & 0xFF));
        return i;
    }

    public long readLong() {
        long i = 0L;
        short b1 = this.readUnsignedByte();
        short b2 = this.readUnsignedByte();
        short b3 = this.readUnsignedByte();
        short b4 = this.readUnsignedByte();
        short b5 = this.readUnsignedByte();
        short b6 = this.readUnsignedByte();
        short b7 = this.readUnsignedByte();
        short b8 = this.readUnsignedByte();
        i = this.isIntel ? ((long)b8 << 56) + ((long)b7 << 48) + ((long)b6 << 40) + ((long)b5 << 32) + ((long)b4 << 24) + ((long)b3 << 16) + ((long)b2 << 8) + (long)b1 : ((long)b1 << 56) + ((long)b2 << 48) + ((long)b3 << 40) + ((long)b4 << 32) + ((long)b5 << 24) + ((long)b6 << 16) + ((long)b7 << 8) + (long)b8;
        return i;
    }

    public float readFloat() {
        return Float.intBitsToFloat((int)this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public int read() {
        return this.currentPos < this.bytesArray.length ? (int)this.readByte() : -1;
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) {
        this.currentPos = off;
        if (this.currentPos + len < this.bytesArray.length) {
            System.arraycopy(this.bytesArray, this.currentPos, b, 0, len);
            return len;
        }
        if (this.currentPos < this.bytesArray.length) {
            len = this.bytesArray.length - this.currentPos;
            System.arraycopy(this.bytesArray, this.currentPos, b, 0, len);
            return len;
        }
        return -1;
    }

    public void readFully(byte[] b) {
        this.readFully(b, this.currentPos, b.length);
    }

    public void readFully(byte[] b, int off, int len) {
        System.arraycopy(this.bytesArray, off, b, 0, len);
        this.currentPos += len;
    }

    public void readProperly(byte[] bytes, int typeSize, int len) {
        if (!this.isIntel || typeSize < 2) {
            this.readFully(bytes, this.currentPos + 0, len);
        } else {
            int n = 0;
            while (n < len) {
                switch (typeSize) {
                    case 2: {
                        bytes[n + 1] = this.bytesArray[this.currentPos];
                        ++this.currentPos;
                        bytes[n] = this.bytesArray[this.currentPos];
                        ++this.currentPos;
                        break;
                    }
                    case 4: {
                        bytes[n + 3] = this.readByte();
                        bytes[n + 2] = this.readByte();
                        bytes[n + 1] = this.readByte();
                        bytes[n] = this.readByte();
                        break;
                    }
                    case 8: {
                        bytes[n + 7] = this.readByte();
                        bytes[n + 6] = this.readByte();
                        bytes[n + 5] = this.readByte();
                        bytes[n + 4] = this.readByte();
                        bytes[n + 3] = this.readByte();
                        bytes[n + 2] = this.readByte();
                        bytes[n + 1] = this.readByte();
                        bytes[n] = this.readByte();
                    }
                }
                n += typeSize;
            }
        }
    }

    public void seek(long pos) {
        this.currentPos = (int)pos;
    }

    public long length() {
        return this.bytesArray.length;
    }

    public void close() {
        this.bytesArray = null;
    }
}

