/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.binding;

import com.headius.backport9.modules.Modules;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.invokers.ConstructorInvoker;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.binding.AssignedName;
import org.jruby.javasupport.binding.ConstantField;
import org.jruby.javasupport.binding.InstanceFieldGetterInstaller;
import org.jruby.javasupport.binding.InstanceFieldSetterInstaller;
import org.jruby.javasupport.binding.InstanceMethodInvokerInstaller;
import org.jruby.javasupport.binding.MethodInstaller;
import org.jruby.javasupport.binding.NamedInstaller;
import org.jruby.javasupport.binding.Priority;
import org.jruby.javasupport.binding.SingletonMethodInvokerInstaller;
import org.jruby.javasupport.binding.StaticFieldGetterInstaller;
import org.jruby.javasupport.binding.StaticFieldSetterInstaller;
import org.jruby.javasupport.binding.StaticMethodInvokerInstaller;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IdUtil;

public class MethodGatherer {
    private static final boolean DEBUG_SCALA = false;
    private static final String METHOD_MANGLE = "__method";
    private static final String CONSTRUCTOR_NAME = "__jcreate!";
    private static final Method[] EMPTY_METHODS = new Method[0];
    private static final int ACC_BRIDGE = 64;
    private static final Map<String, String> SCALA_OPERATORS;
    private final Map<String, AssignedName> staticNames;
    private final Map<String, AssignedName> instanceNames;
    private static final Map<String, AssignedName> STATIC_RESERVED_NAMES;
    private static final Map<String, AssignedName> INSTANCE_RESERVED_NAMES;
    private Map<String, NamedInstaller> staticInstallers = Collections.EMPTY_MAP;
    private Map<String, NamedInstaller> instanceInstallers = Collections.EMPTY_MAP;
    final List<ConstantField> constantFields = new ArrayList<ConstantField>();
    final Ruby runtime;
    public static final ClassValue<Method[]> DECLARED_METHODS;
    private static final ClassValue<PartitionedMethods> FILTERED_DECLARED_METHODS;
    private static final ClassValue<Method[]> METHODS;
    private static final ClassValue<PartitionedMethods> FILTERED_METHODS;
    private static final ClassValue<Class<?>[]> INTERFACES;
    private static final ClassValue<Boolean> IS_SCALA;

    private static Map<String, AssignedName> newReservedNamesMap(int size2) {
        HashMap<String, AssignedName> RESERVED_NAMES = new HashMap<String, AssignedName>(size2 + 4, 1.0f);
        RESERVED_NAMES.put("__id__", new AssignedName("__id__", Priority.RESERVED));
        RESERVED_NAMES.put("__send__", new AssignedName("__send__", Priority.RESERVED));
        RESERVED_NAMES.put("instance_of?", new AssignedName("instance_of?", Priority.RESERVED));
        return RESERVED_NAMES;
    }

    MethodGatherer(Ruby runtime2, Class superClass) {
        this.runtime = runtime2;
        if (superClass == null) {
            this.staticNames = new HashMap<String, AssignedName>(STATIC_RESERVED_NAMES);
            this.instanceNames = new HashMap<String, AssignedName>(INSTANCE_RESERVED_NAMES);
        } else {
            JavaSupport javaSupport = runtime2.getJavaSupport();
            Map<String, AssignedName> staticAssignedNames = javaSupport.getStaticAssignedNames().get(superClass);
            this.staticNames = new HashMap<String, AssignedName>(staticAssignedNames.size() + STATIC_RESERVED_NAMES.size());
            Map<String, AssignedName> instanceAssignedNames = javaSupport.getInstanceAssignedNames().get(superClass);
            this.instanceNames = new HashMap<String, AssignedName>(instanceAssignedNames.size() + INSTANCE_RESERVED_NAMES.size());
            this.staticNames.putAll(STATIC_RESERVED_NAMES);
            this.staticNames.putAll(staticAssignedNames);
            this.instanceNames.putAll(INSTANCE_RESERVED_NAMES);
            this.instanceNames.putAll(instanceAssignedNames);
        }
    }

    void initialize(Class<?> javaClass, RubyModule proxy2) {
        this.setupFieldsAndConstants(javaClass);
        this.setupMethods(javaClass);
        this.setupScalaSingleton(javaClass);
        this.assignStaticAliases();
        JavaSupport javaSupport = this.runtime.getJavaSupport();
        javaSupport.getStaticAssignedNames().get(javaClass).putAll(this.staticNames);
        Map<String, AssignedName> instanceAssignedNames = javaSupport.getInstanceAssignedNames().get(javaClass);
        if (javaClass.isInterface()) {
            instanceAssignedNames.clear();
        } else {
            this.assignInstanceAliases();
            instanceAssignedNames.putAll(this.instanceNames);
            this.installInstanceMethods(proxy2);
            this.installConstructors(javaClass, proxy2);
        }
        this.installConstants(proxy2);
        this.installClassMethods(proxy2);
        this.installInnerClasses(javaClass, proxy2);
    }

    static Map<String, List<Method>> getMethods(Class<?> javaClass) {
        HashMap<String, List<Method>> nameMethods = new HashMap<String, List<Method>>(32);
        for (Class<?> klass = javaClass; klass != null; klass = klass.getSuperclass()) {
            if (!Modifier.isPublic(klass.getModifiers())) {
                // empty if block
            }
            try {
                PartitionedMethods filteredMethods = FILTERED_DECLARED_METHODS.get(klass);
                MethodGatherer.addNewMethods(nameMethods, filteredMethods.instanceMethods, true);
                if (klass == javaClass) {
                    MethodGatherer.addNewMethods(nameMethods, filteredMethods.staticMethods, true);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            for (Class<?> iface : INTERFACES.get(klass)) {
                try {
                    PartitionedMethods filteredMethods = FILTERED_METHODS.get(iface);
                    MethodGatherer.addNewMethods(nameMethods, filteredMethods.instanceMethods, false);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return nameMethods;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean methodsAreEquivalent(Method child, Method parent) {
        if (!parent.getDeclaringClass().isAssignableFrom(child.getDeclaringClass())) return false;
        if (child.getReturnType() != parent.getReturnType()) return false;
        if (child.isVarArgs() != parent.isVarArgs()) return false;
        int childModifiers = child.getModifiers();
        int parentModifiers = parent.getModifiers();
        if (Modifier.isPublic(childModifiers) != Modifier.isPublic(parentModifiers)) return false;
        if (Modifier.isProtected(childModifiers) != Modifier.isProtected(parentModifiers)) return false;
        if (Modifier.isStatic(childModifiers) != Modifier.isStatic(parentModifiers)) return false;
        if (!Arrays.equals(child.getParameterTypes(), parent.getParameterTypes())) return false;
        return true;
    }

    private static void addNewMethods(HashMap<String, List<Method>> nameMethods, Method[] methods2, boolean removeDuplicate) {
        block0: for (Method method2 : methods2) {
            List<Method> childMethods = nameMethods.get(method2.getName());
            if (childMethods == null) {
                childMethods = new ArrayList<Method>(4);
                childMethods.add(method2);
                nameMethods.put(method2.getName(), childMethods);
                continue;
            }
            for (int i2 = 0; i2 < childMethods.size(); ++i2) {
                Method current2 = childMethods.get(i2);
                if (!MethodGatherer.methodsAreEquivalent(current2, method2)) continue;
                if (!removeDuplicate) continue block0;
                childMethods.set(i2, method2);
                continue block0;
            }
            childMethods.add(method2);
        }
    }

    protected void installInnerClasses(Class<?> javaClass, RubyModule proxy2) {
        Class<?>[] classes2 = JavaClass.getDeclaredClasses(javaClass);
        Ruby runtime2 = proxy2.getRuntime();
        int i2 = classes2.length;
        while (--i2 >= 0) {
            String simpleName;
            Class<?> clazz = classes2[i2];
            if (javaClass != clazz.getDeclaringClass() || !Modifier.isPublic(clazz.getModifiers()) || (simpleName = JavaClass.getSimpleName(clazz)).length() == 0) continue;
            final RubyModule innerProxy = Java.getProxyClass(runtime2, JavaClass.get(runtime2, clazz));
            if (IdUtil.isConstant(simpleName)) {
                if (proxy2.getConstantAt(simpleName) != null) continue;
                proxy2.const_set(runtime2.newString(simpleName), innerProxy);
                continue;
            }
            if (proxy2.respondsTo(simpleName)) continue;
            proxy2.getSingletonClass().addMethod(simpleName, new JavaMethod.JavaMethodZero(proxy2.getSingletonClass(), Visibility.PUBLIC, simpleName){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
                    return innerProxy;
                }
            });
        }
    }

    protected void setupScalaSingleton(Class<?> javaClass) {
        if (javaClass.isInterface()) {
            return;
        }
        try {
            ClassLoader loader = javaClass.getClassLoader();
            if (loader == null) {
                return;
            }
            if (!IS_SCALA.get(javaClass).booleanValue()) {
                return;
            }
            Class<?> companionClass = loader.loadClass(javaClass.getName() + '$');
            Field field2 = companionClass.getField("MODULE$");
            Object singleton = field2.get(null);
            if (singleton == null) {
                return;
            }
            MethodGatherer.getMethods(companionClass).forEach((name2, methods2) -> {
                for (int j = 0; j < methods2.size(); ++j) {
                    Method method2 = (Method)methods2.get(j);
                    if (name2.indexOf(36) >= 0) {
                        name2 = MethodGatherer.fixScalaNames(name2);
                    }
                    if (Modifier.isStatic(method2.getModifiers())) continue;
                    AssignedName assignedName = this.staticNames.get(name2);
                    if (INSTANCE_RESERVED_NAMES.containsKey(method2.getName())) {
                        this.setupSingletonMethods(this.staticInstallers, javaClass, singleton, method2, name2 + METHOD_MANGLE);
                        continue;
                    }
                    if (assignedName == null) {
                        this.staticNames.put((String)name2, new AssignedName((String)name2, Priority.METHOD));
                    } else {
                        if (Priority.METHOD.lessImportantThan(assignedName)) continue;
                        if (!Priority.METHOD.asImportantAs(assignedName)) {
                            this.staticInstallers.remove(name2);
                            this.staticInstallers.remove(name2 + '=');
                            this.staticNames.put((String)name2, new AssignedName((String)name2, Priority.METHOD));
                        }
                    }
                    this.setupSingletonMethods(this.staticInstallers, javaClass, singleton, method2, (String)name2);
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    protected static String fixScalaNames(String name2) {
        String s2 = name2;
        for (Map.Entry<String, String> entry : SCALA_OPERATORS.entrySet()) {
            s2 = s2.replaceAll(entry.getKey(), entry.getValue());
        }
        return s2;
    }

    protected void installConstants(RubyModule proxy2) {
        this.constantFields.forEach(field2 -> field2.install(proxy2));
    }

    protected void installClassMethods(RubyModule proxy2) {
        this.getStaticInstallers().forEach(($, value2) -> value2.install(proxy2));
    }

    void installConstructors(Class<?> javaClass, RubyModule proxy2) {
        Constructor[] constructors2 = JavaClass.getConstructors(javaClass);
        boolean localConstructor = false;
        for (Constructor constructor2 : constructors2) {
            localConstructor |= javaClass == constructor2.getDeclaringClass();
        }
        if (localConstructor) {
            proxy2.addMethod(CONSTRUCTOR_NAME, new ConstructorInvoker(proxy2, javaClass::getConstructors, CONSTRUCTOR_NAME));
        } else {
            proxy2.addMethod(CONSTRUCTOR_NAME, new NoConstructorMethod(proxy2, CONSTRUCTOR_NAME));
        }
    }

    protected void prepareStaticMethod(Class<?> javaClass, Method method2, String name2) {
        this.prepareMethod(javaClass, method2, name2, this.getStaticInstallersForWrite(), STATIC_RESERVED_NAMES, this.staticNames, StaticMethodInvokerInstaller::new);
    }

    protected void prepareInstanceMethod(Class<?> javaClass, Method method2, String name2) {
        this.prepareMethod(javaClass, method2, name2, this.getInstanceInstallersForWrite(), INSTANCE_RESERVED_NAMES, this.instanceNames, InstanceMethodInvokerInstaller::new);
    }

    protected void prepareMethod(Class<?> javaClass, Method method2, String name2, Map<String, NamedInstaller> installers, Map<String, AssignedName> reservedNames, Map<String, AssignedName> names2, Function<String, NamedInstaller> constructor2) {
        if (reservedNames.containsKey(method2.getName())) {
            name2 = name2 + METHOD_MANGLE;
        } else if (this.lowerPriority(name2, installers, names2)) {
            return;
        }
        NamedInstaller invoker = installers.get(name2);
        if (invoker == null) {
            invoker = constructor2.apply(name2);
            installers.put(name2, invoker);
        }
        ((MethodInstaller)invoker).addMethod(method2, javaClass);
    }

    private boolean lowerPriority(String name2, Map<String, NamedInstaller> installers, Map<String, AssignedName> names2) {
        AssignedName assignedName = names2.get(name2);
        if (assignedName == null) {
            names2.put(name2, new AssignedName(name2, Priority.METHOD));
        } else {
            if (Priority.METHOD.lessImportantThan(assignedName)) {
                return true;
            }
            if (!Priority.METHOD.asImportantAs(assignedName)) {
                installers.remove(name2);
                installers.remove(name2 + '=');
                names2.put(name2, new AssignedName(name2, Priority.METHOD));
            }
        }
        return false;
    }

    Map<String, NamedInstaller> getStaticInstallers() {
        return this.staticInstallers;
    }

    Map<String, NamedInstaller> getStaticInstallersForWrite() {
        Map<String, NamedInstaller> staticInstallers = this.staticInstallers;
        return staticInstallers == Collections.EMPTY_MAP ? (this.staticInstallers = new HashMap<String, NamedInstaller>()) : staticInstallers;
    }

    Map<String, NamedInstaller> getInstanceInstallers() {
        return this.instanceInstallers;
    }

    Map<String, NamedInstaller> getInstanceInstallersForWrite() {
        Map<String, NamedInstaller> instanceInstallers = this.instanceInstallers;
        return instanceInstallers == Collections.EMPTY_MAP ? (this.instanceInstallers = new HashMap<String, NamedInstaller>()) : instanceInstallers;
    }

    void setupFieldsAndConstants(Class<?> javaClass) {
        Field[] fields2;
        boolean isInterface = javaClass.isInterface();
        for (Field field2 : fields2 = JavaClass.getDeclaredFields(javaClass)) {
            boolean constant;
            int modifiers2;
            boolean isPublic;
            if (javaClass != field2.getDeclaringClass() || !(isPublic = Modifier.isPublic(modifiers2 = field2.getModifiers()))) continue;
            boolean isStatic = Modifier.isStatic(modifiers2);
            boolean isFinal = Modifier.isFinal(modifiers2);
            boolean bl = constant = isPublic && isStatic && isFinal && Character.isUpperCase(field2.getName().charAt(0));
            if (constant) {
                this.constantFields.add(new ConstantField(field2));
                if (!isInterface) continue;
            }
            if (isStatic) {
                MethodGatherer.addField(this.getStaticInstallersForWrite(), this.staticNames, field2, isFinal, true, constant);
                continue;
            }
            MethodGatherer.addField(this.getInstanceInstallersForWrite(), this.instanceNames, field2, isFinal, false, false);
        }
    }

    void setupMethods(Class<?> javaClass) {
        boolean isInterface = javaClass.isInterface();
        MethodGatherer.getMethods(javaClass).forEach((name2, methods2) -> {
            int i2 = methods2.size();
            while (--i2 >= 0) {
                Method method2 = (Method)methods2.get(i2);
                if (Modifier.isStatic(method2.getModifiers())) {
                    this.prepareStaticMethod(javaClass, method2, (String)name2);
                    continue;
                }
                if (isInterface) continue;
                this.prepareInstanceMethod(javaClass, method2, (String)name2);
            }
        });
    }

    private void setupSingletonMethods(Map<String, NamedInstaller> methodCallbacks, Class<?> javaClass, Object singleton, Method method2, String name2) {
        NamedInstaller invoker = methodCallbacks.get(name2);
        if (invoker == null) {
            invoker = new SingletonMethodInvokerInstaller(name2, singleton);
            methodCallbacks.put(name2, invoker);
        }
        ((MethodInstaller)invoker).addMethod(method2, javaClass);
    }

    private void assignStaticAliases() {
        this.getStaticInstallers().forEach((name2, installer) -> {
            if (installer.type == 2 && installer.hasLocalMethod()) {
                if (name2.endsWith(METHOD_MANGLE)) {
                    return;
                }
                MethodInstaller methodInstaller = (MethodInstaller)installer;
                methodInstaller.assignAliases(this.staticNames);
            }
        });
    }

    private void assignInstanceAliases() {
        this.getInstanceInstallers().forEach((name2, installer) -> {
            if (installer.type == 4) {
                if (name2.endsWith(METHOD_MANGLE)) {
                    return;
                }
                MethodInstaller methodInstaller = (MethodInstaller)installer;
                if (installer.hasLocalMethod()) {
                    methodInstaller.assignAliases(this.instanceNames);
                }
                if (name2.equals("equals")) {
                    methodInstaller.setLocalMethod(true);
                    methodInstaller.addAlias("==");
                }
            }
        });
    }

    protected static void addField(Map callbacks, Map<String, AssignedName> names2, Field field2, boolean isFinal, boolean isStatic, boolean isConstant) {
        String name2 = field2.getName();
        if (Priority.FIELD.lessImportantThan(names2.get(name2))) {
            return;
        }
        names2.put(name2, new AssignedName(name2, Priority.FIELD));
        callbacks.put(name2, isStatic ? new StaticFieldGetterInstaller(name2, field2, isConstant) : new InstanceFieldGetterInstaller(name2, field2));
        if (!isFinal) {
            String setName2 = name2 + '=';
            callbacks.put(setName2, isStatic ? new StaticFieldSetterInstaller(setName2, field2) : new InstanceFieldSetterInstaller(setName2, field2));
        }
    }

    void installInstanceMethods(RubyModule proxy2) {
        this.getInstanceInstallers().forEach(($, value2) -> value2.install(proxy2));
    }

    static {
        HashMap<String, String> scalaOperators = new HashMap<String, String>(24, 1.0f);
        scalaOperators.put("\\$plus", "+");
        scalaOperators.put("\\$minus", "-");
        scalaOperators.put("\\$colon", ":");
        scalaOperators.put("\\$div", "/");
        scalaOperators.put("\\$eq", "=");
        scalaOperators.put("\\$less", "<");
        scalaOperators.put("\\$greater", ">");
        scalaOperators.put("\\$bslash", "\\\\");
        scalaOperators.put("\\$hash", "#");
        scalaOperators.put("\\$times", "*");
        scalaOperators.put("\\$bang", "!");
        scalaOperators.put("\\$at", "@");
        scalaOperators.put("\\$percent", "%");
        scalaOperators.put("\\$up", "^");
        scalaOperators.put("\\$amp", "&");
        scalaOperators.put("\\$tilde", "~");
        scalaOperators.put("\\$qmark", "?");
        scalaOperators.put("\\$bar", "|");
        SCALA_OPERATORS = Collections.unmodifiableMap(scalaOperators);
        STATIC_RESERVED_NAMES = MethodGatherer.newReservedNamesMap(1);
        STATIC_RESERVED_NAMES.put("new", new AssignedName("new", Priority.RESERVED));
        INSTANCE_RESERVED_NAMES = MethodGatherer.newReservedNamesMap(2);
        INSTANCE_RESERVED_NAMES.put("class", new AssignedName("class", Priority.RESERVED));
        INSTANCE_RESERVED_NAMES.put("initialize", new AssignedName("initialize", Priority.RESERVED));
        DECLARED_METHODS = new ClassValue<Method[]>(){

            @Override
            public Method[] computeValue(Class cls) {
                try {
                    return cls.getDeclaredMethods();
                }
                catch (SecurityException se) {
                    return EMPTY_METHODS;
                }
            }
        };
        FILTERED_DECLARED_METHODS = new ClassValue<PartitionedMethods>(){

            @Override
            public PartitionedMethods computeValue(Class cls) {
                return new PartitionedMethods(DECLARED_METHODS.get(cls));
            }
        };
        METHODS = new ClassValue<Method[]>(){

            @Override
            public Method[] computeValue(Class cls) {
                try {
                    return cls.getMethods();
                }
                catch (SecurityException se) {
                    return EMPTY_METHODS;
                }
            }
        };
        FILTERED_METHODS = new ClassValue<PartitionedMethods>(){

            @Override
            public PartitionedMethods computeValue(Class cls) {
                return new PartitionedMethods((Method[])METHODS.get(cls));
            }
        };
        INTERFACES = new ClassValue<Class<?>[]>(){

            @Override
            public Class<?>[] computeValue(Class cls) {
                return cls.getInterfaces();
            }
        };
        IS_SCALA = new ClassValue<Boolean>(){

            @Override
            protected Boolean computeValue(Class<?> type2) {
                if (type2.isInterface()) {
                    return false;
                }
                boolean scalaAnno = false;
                for (Annotation anno : type2.getDeclaredAnnotations()) {
                    Package pkg = anno.annotationType().getPackage();
                    if (pkg == null || pkg.getName() == null || !pkg.getName().startsWith("scala.")) continue;
                    scalaAnno = true;
                    break;
                }
                return scalaAnno;
            }
        };
    }

    private static class PartitionedMethods {
        final Method[] instanceMethods;
        final Method[] staticMethods;

        PartitionedMethods(Method[] methods2) {
            ArrayList<Method> instanceMethods = Collections.EMPTY_LIST;
            ArrayList<Method> staticMethods = Collections.EMPTY_LIST;
            for (Method m : methods2) {
                int modifiers2 = m.getModifiers();
                if (!PartitionedMethods.filterAccessible(m, modifiers2)) continue;
                if (Modifier.isStatic(modifiers2)) {
                    if (staticMethods == Collections.EMPTY_LIST) {
                        staticMethods = new ArrayList<Method>();
                    }
                    staticMethods.add(m);
                    continue;
                }
                if (instanceMethods == Collections.EMPTY_LIST) {
                    instanceMethods = new ArrayList<Method>();
                }
                instanceMethods.add(m);
            }
            this.instanceMethods = instanceMethods.toArray(new Method[instanceMethods.size()]);
            this.staticMethods = staticMethods.toArray(new Method[staticMethods.size()]);
        }

        private static boolean filterAccessible(Method method2, int mod) {
            if (Modifier.isPrivate(mod)) {
                return false;
            }
            if (!Modifier.isPublic(mod) && !Modules.trySetAccessible(method2, Java.class)) {
                return false;
            }
            return (mod & 0x40) == 0;
        }
    }

    static class NoConstructorMethod
    extends JavaMethod {
        NoConstructorMethod(RubyModule proxy2, String name2) {
            super(proxy2, Visibility.PUBLIC, name2);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            throw context.runtime.newTypeError("no public constructors for " + clazz);
        }
    }
}

