# -*- coding: utf-8 -*-
info = {
    "name": "en",
    "date_order": "MDY",
    "january": [
        "january",
        "jan"
    ],
    "february": [
        "february",
        "feb"
    ],
    "march": [
        "march",
        "mar"
    ],
    "april": [
        "april",
        "apr"
    ],
    "may": [
        "may"
    ],
    "june": [
        "june",
        "jun"
    ],
    "july": [
        "july",
        "jul"
    ],
    "august": [
        "august",
        "aug"
    ],
    "september": [
        "september",
        "sep",
        "sept"
    ],
    "october": [
        "october",
        "oct"
    ],
    "november": [
        "november",
        "nov"
    ],
    "december": [
        "december",
        "dec"
    ],
    "monday": [
        "monday",
        "mon"
    ],
    "tuesday": [
        "tuesday",
        "tue",
        "Tues"
    ],
    "wednesday": [
        "wednesday",
        "wed"
    ],
    "thursday": [
        "thursday",
        "thu"
    ],
    "friday": [
        "friday",
        "fri"
    ],
    "saturday": [
        "saturday",
        "sat"
    ],
    "sunday": [
        "sunday",
        "sun"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "year",
        "yr",
        "years"
    ],
    "month": [
        "month",
        "mo",
        "months"
    ],
    "week": [
        "week",
        "wk",
        "weeks"
    ],
    "day": [
        "day",
        "days"
    ],
    "hour": [
        "hour",
        "hr",
        "h",
        "hours",
        "hrs"
    ],
    "minute": [
        "minute",
        "min",
        "m",
        "minutes",
        "mins"
    ],
    "second": [
        "second",
        "sec",
        "s",
        "seconds",
        "secs"
    ],
    "relative-type": {
        "1 year ago": [
            "last year",
            "last yr"
        ],
        "0 year ago": [
            "this year",
            "this yr"
        ],
        "in 1 year": [
            "next year",
            "next yr"
        ],
        "1 month ago": [
            "last month",
            "last mo"
        ],
        "0 month ago": [
            "this month",
            "this mo"
        ],
        "in 1 month": [
            "next month",
            "next mo"
        ],
        "1 week ago": [
            "last week",
            "last wk"
        ],
        "0 week ago": [
            "this week",
            "this wk"
        ],
        "in 1 week": [
            "next week",
            "next wk"
        ],
        "1 day ago": [
            "yesterday"
        ],
        "0 day ago": [
            "today"
        ],
        "in 1 day": [
            "tomorrow"
        ],
        "0 hour ago": [
            "this hour"
        ],
        "0 minute ago": [
            "this minute"
        ],
        "0 second ago": [
            "now"
        ],
        "2 day ago": [
            "day before yesterday"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "in (\\d+) year",
            "in (\\d+) years",
            "in (\\d+) yr"
        ],
        "\\1 year ago": [
            "(\\d+) year ago",
            "(\\d+) years ago",
            "(\\d+) yr ago"
        ],
        "in \\1 month": [
            "in (\\d+) month",
            "in (\\d+) months",
            "in (\\d+) mo"
        ],
        "\\1 month ago": [
            "(\\d+) month ago",
            "(\\d+) months ago",
            "(\\d+) mo ago"
        ],
        "in \\1 week": [
            "in (\\d+) week",
            "in (\\d+) weeks",
            "in (\\d+) wk"
        ],
        "\\1 week ago": [
            "(\\d+) week ago",
            "(\\d+) weeks ago",
            "(\\d+) wk ago"
        ],
        "in \\1 day": [
            "in (\\d+) day",
            "in (\\d+) days"
        ],
        "\\1 day ago": [
            "(\\d+) day ago",
            "(\\d+) days ago"
        ],
        "in \\1 hour": [
            "in (\\d+) hour",
            "in (\\d+) hours",
            "in (\\d+) hr"
        ],
        "\\1 hour ago": [
            "(\\d+) hour ago",
            "(\\d+) hours ago",
            "(\\d+) hr ago"
        ],
        "in \\1 minute": [
            "in (\\d+) minute",
            "in (\\d+) minutes",
            "in (\\d+) min"
        ],
        "\\1 minute ago": [
            "(\\d+) minute ago",
            "(\\d+) minutes ago",
            "(\\d+) min ago"
        ],
        "in \\1 second": [
            "in (\\d+) second",
            "in (\\d+) seconds",
            "in (\\d+) sec"
        ],
        "\\1 second ago": [
            "(\\d+) second ago",
            "(\\d+) seconds ago",
            "(\\d+) sec ago"
        ]
    },
    "locale_specific": {
        "en-SD": {
            "name": "en-SD",
            "date_order": "DMY"
        },
        "en-TT": {
            "name": "en-TT",
            "date_order": "DMY"
        },
        "en-BE": {
            "name": "en-BE",
            "date_order": "DMY"
        },
        "en-CH": {
            "name": "en-CH",
            "date_order": "DMY"
        },
        "en-MG": {
            "name": "en-MG",
            "date_order": "DMY"
        },
        "en-ZM": {
            "name": "en-ZM",
            "date_order": "DMY"
        },
        "en-BW": {
            "name": "en-BW",
            "date_order": "DMY"
        },
        "en-DM": {
            "name": "en-DM",
            "date_order": "DMY"
        },
        "en-BS": {
            "name": "en-BS",
            "date_order": "DMY"
        },
        "en-MY": {
            "name": "en-MY",
            "date_order": "DMY"
        },
        "en-RW": {
            "name": "en-RW",
            "date_order": "DMY"
        },
        "en-UG": {
            "name": "en-UG",
            "date_order": "DMY"
        },
        "en-JM": {
            "name": "en-JM",
            "date_order": "DMY"
        },
        "en-AI": {
            "name": "en-AI",
            "date_order": "DMY"
        },
        "en-CA": {
            "name": "en-CA",
            "date_order": "YMD",
            "relative-type-regex": {
                "in \\1 year": [
                    "in (\\d+) yrs"
                ],
                "\\1 year ago": [
                    "(\\d+) yrs ago"
                ],
                "in \\1 month": [
                    "in (\\d+) mos"
                ],
                "\\1 month ago": [
                    "(\\d+) mos ago"
                ],
                "in \\1 week": [
                    "in (\\d+) wks"
                ],
                "\\1 week ago": [
                    "(\\d+) wks ago"
                ],
                "in \\1 hour": [
                    "in (\\d+) hrs"
                ],
                "\\1 hour ago": [
                    "(\\d+) hrs ago"
                ],
                "in \\1 minute": [
                    "in (\\d+) mins"
                ],
                "\\1 minute ago": [
                    "(\\d+) mins ago"
                ],
                "in \\1 second": [
                    "in (\\d+) secs"
                ],
                "\\1 second ago": [
                    "(\\d+) secs ago"
                ]
            }
        },
        "en-SB": {
            "name": "en-SB",
            "date_order": "DMY"
        },
        "en-MW": {
            "name": "en-MW",
            "date_order": "DMY"
        },
        "en-PW": {
            "name": "en-PW",
            "date_order": "DMY"
        },
        "en-GY": {
            "name": "en-GY",
            "date_order": "DMY"
        },
        "en-150": {
            "name": "en-150",
            "date_order": "DMY"
        },
        "en-LR": {
            "name": "en-LR",
            "date_order": "DMY"
        },
        "en-GD": {
            "name": "en-GD",
            "date_order": "DMY"
        },
        "en-KE": {
            "name": "en-KE",
            "date_order": "DMY"
        },
        "en-NF": {
            "name": "en-NF",
            "date_order": "DMY"
        },
        "en-MU": {
            "name": "en-MU",
            "date_order": "DMY"
        },
        "en-CY": {
            "name": "en-CY",
            "date_order": "DMY"
        },
        "en-LS": {
            "name": "en-LS",
            "date_order": "DMY"
        },
        "en-BI": {
            "name": "en-BI"
        },
        "en-NL": {
            "name": "en-NL",
            "date_order": "DMY"
        },
        "en-KI": {
            "name": "en-KI",
            "date_order": "DMY"
        },
        "en-AG": {
            "name": "en-AG",
            "date_order": "DMY"
        },
        "en-SL": {
            "name": "en-SL",
            "date_order": "DMY"
        },
        "en-VI": {
            "name": "en-VI"
        },
        "en-JE": {
            "name": "en-JE",
            "date_order": "DMY"
        },
        "en-MS": {
            "name": "en-MS",
            "date_order": "DMY"
        },
        "en-GU": {
            "name": "en-GU"
        },
        "en-IO": {
            "name": "en-IO",
            "date_order": "DMY"
        },
        "en-KY": {
            "name": "en-KY",
            "date_order": "DMY"
        },
        "en-ZW": {
            "name": "en-ZW",
            "date_order": "DMY"
        },
        "en-NR": {
            "name": "en-NR",
            "date_order": "DMY"
        },
        "en-PN": {
            "name": "en-PN",
            "date_order": "DMY"
        },
        "en-CX": {
            "name": "en-CX",
            "date_order": "DMY"
        },
        "en-ER": {
            "name": "en-ER",
            "date_order": "DMY"
        },
        "en-FK": {
            "name": "en-FK",
            "date_order": "DMY"
        },
        "en-PG": {
            "name": "en-PG",
            "date_order": "DMY"
        },
        "en-IE": {
            "name": "en-IE",
            "date_order": "DMY"
        },
        "en-SG": {
            "name": "en-SG",
            "date_order": "DMY",
            "month": [
                "mth"
            ],
            "relative-type": {
                "1 month ago": [
                    "last mth"
                ],
                "0 month ago": [
                    "this mth"
                ],
                "in 1 month": [
                    "next mth"
                ]
            },
            "relative-type-regex": {
                "in \\1 month": [
                    "in (\\d+) mth"
                ],
                "\\1 month ago": [
                    "(\\d+) mth ago"
                ]
            }
        },
        "en-TO": {
            "name": "en-TO",
            "date_order": "DMY"
        },
        "en-AS": {
            "name": "en-AS"
        },
        "en-001": {
            "name": "en-001",
            "date_order": "DMY"
        },
        "en-DE": {
            "name": "en-DE",
            "date_order": "DMY"
        },
        "en-GI": {
            "name": "en-GI",
            "date_order": "DMY"
        },
        "en-NU": {
            "name": "en-NU",
            "date_order": "DMY"
        },
        "en-VU": {
            "name": "en-VU",
            "date_order": "DMY"
        },
        "en-SS": {
            "name": "en-SS",
            "date_order": "DMY"
        },
        "en-SX": {
            "name": "en-SX",
            "date_order": "DMY"
        },
        "en-TC": {
            "name": "en-TC",
            "date_order": "DMY"
        },
        "en-KN": {
            "name": "en-KN",
            "date_order": "DMY"
        },
        "en-MP": {
            "name": "en-MP"
        },
        "en-CC": {
            "name": "en-CC",
            "date_order": "DMY"
        },
        "en-CM": {
            "name": "en-CM",
            "date_order": "DMY"
        },
        "en-GG": {
            "name": "en-GG",
            "date_order": "DMY"
        },
        "en-SI": {
            "name": "en-SI",
            "date_order": "DMY"
        },
        "en-BM": {
            "name": "en-BM",
            "date_order": "DMY"
        },
        "en-GH": {
            "name": "en-GH",
            "date_order": "DMY"
        },
        "en-IN": {
            "name": "en-IN",
            "date_order": "DMY"
        },
        "en-SE": {
            "name": "en-SE",
            "date_order": "YMD"
        },
        "en-BB": {
            "name": "en-BB",
            "date_order": "DMY"
        },
        "en-IL": {
            "name": "en-IL",
            "date_order": "DMY"
        },
        "en-PH": {
            "name": "en-PH",
            "date_order": "DMY"
        },
        "en-FM": {
            "name": "en-FM",
            "date_order": "DMY"
        },
        "en-PK": {
            "name": "en-PK",
            "date_order": "DMY"
        },
        "en-TZ": {
            "name": "en-TZ",
            "date_order": "DMY"
        },
        "en-GB": {
            "name": "en-GB",
            "date_order": "DMY"
        },
        "en-WS": {
            "name": "en-WS",
            "date_order": "DMY"
        },
        "en-MT": {
            "name": "en-MT",
            "date_order": "DMY"
        },
        "en-IM": {
            "name": "en-IM",
            "date_order": "DMY"
        },
        "en-DK": {
            "name": "en-DK",
            "date_order": "DMY"
        },
        "en-UM": {
            "name": "en-UM"
        },
        "en-TK": {
            "name": "en-TK",
            "date_order": "DMY"
        },
        "en-NA": {
            "name": "en-NA",
            "date_order": "DMY"
        },
        "en-PR": {
            "name": "en-PR"
        },
        "en-LC": {
            "name": "en-LC",
            "date_order": "DMY"
        },
        "en-BZ": {
            "name": "en-BZ",
            "date_order": "DMY"
        },
        "en-VG": {
            "name": "en-VG",
            "date_order": "DMY"
        },
        "en-SZ": {
            "name": "en-SZ",
            "date_order": "DMY"
        },
        "en-CK": {
            "name": "en-CK",
            "date_order": "DMY"
        },
        "en-ZA": {
            "name": "en-ZA",
            "date_order": "YMD"
        },
        "en-MH": {
            "name": "en-MH"
        },
        "en-MO": {
            "name": "en-MO",
            "date_order": "DMY"
        },
        "en-DG": {
            "name": "en-DG",
            "date_order": "DMY"
        },
        "en-VC": {
            "name": "en-VC",
            "date_order": "DMY"
        },
        "en-NG": {
            "name": "en-NG",
            "date_order": "DMY"
        },
        "en-SH": {
            "name": "en-SH",
            "date_order": "DMY"
        },
        "en-HK": {
            "name": "en-HK",
            "date_order": "DMY"
        },
        "en-TV": {
            "name": "en-TV",
            "date_order": "DMY"
        },
        "en-FJ": {
            "name": "en-FJ",
            "date_order": "DMY"
        },
        "en-FI": {
            "name": "en-FI",
            "date_order": "DMY"
        },
        "en-SC": {
            "name": "en-SC",
            "date_order": "DMY"
        },
        "en-GM": {
            "name": "en-GM",
            "date_order": "DMY"
        },
        "en-AT": {
            "name": "en-AT",
            "date_order": "DMY"
        },
        "en-AU": {
            "name": "en-AU",
            "date_order": "DMY",
            "hour": [
                "h"
            ]
        },
        "en-NZ": {
            "name": "en-NZ",
            "date_order": "DMY"
        }
    },
    "skip": [
        "at",
        "on",
        "and",
        "ad",
        "m",
        "of",
        "st",
        "nd",
        "rd",
        "th",
        "about",
        "the",
        "just",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "pertain": [
        "of"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "ago"
    ],
    "in": [
        "in",
        "from now"
    ],
    "simplifications": [
        {
            "an": "1"
        },
        {
            "a": "1"
        },
        {
            "(?:12\\s+)?noon": "12:00"
        },
        {
            "(?:12\\s+)?midnight": "00:00"
        },
        {
            "(\\d+)h(\\d+)m?": "\\1:\\2"
        },
        {
            "(?<=from\\s+)now": "in"
        },
        {
            "less than 1 minute ago": "45 second ago"
        },
        {
            "two": "2"
        },
        {
            "three": "3"
        },
        {
            "four": "4"
        },
        {
            "five": "5"
        },
        {
            "six": "6"
        },
        {
            "seven": "7"
        },
        {
            "eight": "8"
        },
        {
            "nine": "9"
        },
        {
            "ten": "10"
        },
        {
            "eleven": "11"
        },
        {
            "twelve": "12"
        }
    ]
}