/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.quicksearch.CategoryResult;
import org.netbeans.modules.quicksearch.QuickSearchComboBar;
import org.netbeans.modules.quicksearch.QuickSearchPopup;
import org.netbeans.modules.quicksearch.ResultsModel;
import org.openide.awt.HtmlRenderer;
import org.openide.util.Utilities;

class SearchResultRender
extends JLabel
implements ListCellRenderer {
    private QuickSearchPopup popup;
    private JLabel categoryLabel;
    private JPanel rendererComponent;
    private JLabel resultLabel;
    private JLabel shortcutLabel;
    private JPanel dividerLine;
    private JPanel itemPanel;
    private JPanel itemLinePanel;
    private JLabel cutLabel;

    public SearchResultRender(QuickSearchPopup quickSearchPopup) {
        this.popup = quickSearchPopup;
        this.configRenderer();
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (!(object instanceof ResultsModel.ItemResult)) {
            return new JLabel();
        }
        ResultsModel.ItemResult itemResult = (ResultsModel.ItemResult)object;
        List<? extends KeyStroke> list = itemResult.getShortcut();
        this.resultLabel.setText(itemResult.getDisplayName());
        if (list != null && list.size() > 0 && list.get(0) != null) {
            this.shortcutLabel.setText(SearchResultRender.getKeyStrokeAsText(list.get(0)));
            this.itemPanel.add((Component)this.shortcutLabel, "East");
        } else {
            this.itemPanel.remove(this.shortcutLabel);
        }
        CategoryResult categoryResult = itemResult.getCategory();
        if (categoryResult.isFirstItem(itemResult)) {
            this.categoryLabel.setText(categoryResult.getCategory().getDisplayName());
            if (n > 0) {
                this.rendererComponent.add((Component)this.dividerLine, "North");
            }
        } else {
            this.categoryLabel.setText("");
            this.rendererComponent.remove(this.dividerLine);
        }
        this.categoryLabel.setPreferredSize(new Dimension(this.popup.getCategoryWidth(), this.categoryLabel.getPreferredSize().height));
        this.itemPanel.setPreferredSize(new Dimension(this.popup.getResultWidth(), this.itemPanel.getPreferredSize().height));
        if (this.isCut(itemResult.getDisplayName(), this.resultLabel.getWidth())) {
            this.itemLinePanel.add((Component)this.cutLabel, "East");
        } else {
            this.itemLinePanel.remove(this.cutLabel);
        }
        if (bl) {
            this.resultLabel.setBackground(jList.getSelectionBackground());
            this.resultLabel.setForeground(jList.getSelectionForeground());
            this.shortcutLabel.setBackground(jList.getSelectionBackground());
            this.shortcutLabel.setForeground(jList.getSelectionForeground());
            this.cutLabel.setBackground(jList.getSelectionBackground());
            this.cutLabel.setForeground(jList.getSelectionForeground());
        } else {
            this.resultLabel.setBackground(QuickSearchComboBar.getResultBackground());
            this.resultLabel.setForeground(jList.getForeground());
            this.shortcutLabel.setBackground(QuickSearchComboBar.getResultBackground());
            this.shortcutLabel.setForeground(jList.getForeground());
            this.cutLabel.setBackground(QuickSearchComboBar.getResultBackground());
            this.cutLabel.setForeground(jList.getForeground());
        }
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.rendererComponent.setOpaque(false);
        }
        return this.rendererComponent;
    }

    private boolean isCut(String string, int n) {
        double d = HtmlRenderer.renderHTML((String)string, (Graphics)this.resultLabel.getGraphics(), (int)0, (int)10, (int)Integer.MAX_VALUE, (int)20, (Font)this.resultLabel.getFont(), (Color)Color.BLACK, (int)0, (boolean)false);
        return (int)d > n - 4;
    }

    private void configRenderer() {
        this.categoryLabel = new JLabel();
        this.categoryLabel.setFont(this.categoryLabel.getFont().deriveFont(1));
        this.categoryLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.categoryLabel.setForeground(QuickSearchComboBar.getCategoryTextColor());
        this.resultLabel = HtmlRenderer.createLabel();
        ((HtmlRenderer.Renderer)this.resultLabel).setHtml(true);
        ((HtmlRenderer.Renderer)this.resultLabel).setRenderStyle(0);
        this.resultLabel.setOpaque(true);
        this.resultLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.shortcutLabel = new JLabel();
        this.shortcutLabel.setOpaque(true);
        this.shortcutLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.cutLabel = new JLabel("...");
        this.cutLabel.setOpaque(true);
        this.cutLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.itemLinePanel = new JPanel();
        this.itemLinePanel.setBackground(QuickSearchComboBar.getResultBackground());
        this.itemLinePanel.setLayout(new BorderLayout());
        this.itemLinePanel.add((Component)this.resultLabel, "Center");
        this.itemPanel = new JPanel();
        this.itemPanel.setBackground(QuickSearchComboBar.getResultBackground());
        this.itemPanel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 3));
        this.itemPanel.setLayout(new BorderLayout());
        this.itemPanel.add((Component)this.itemLinePanel, "Center");
        this.dividerLine = new JPanel();
        this.dividerLine.setBackground(QuickSearchComboBar.getPopupBorderColor());
        this.dividerLine.setPreferredSize(new Dimension(this.dividerLine.getPreferredSize().width, 1));
        this.rendererComponent = new JPanel();
        this.rendererComponent.setLayout(new BorderLayout());
        this.rendererComponent.add((Component)this.itemPanel, "Center");
        this.rendererComponent.add((Component)this.categoryLabel, "West");
    }

    static String getKeyStrokeAsText(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return "";
        }
        int n = keyStroke.getModifiers();
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 0x80) > 0) {
            stringBuffer.append("Ctrl+");
        }
        if ((n & 0x200) > 0) {
            stringBuffer.append("Alt+");
        }
        if ((n & 0x40) > 0) {
            stringBuffer.append("Shift+");
        }
        if ((n & 0x100) > 0) {
            if (Utilities.isMac()) {
                stringBuffer.append("\u2318+");
            } else if (SearchResultRender.isSolaris()) {
                stringBuffer.append("\u25c6+");
            } else {
                stringBuffer.append("Meta+");
            }
        }
        if (keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 18 && keyStroke.getKeyCode() != 65406) {
            stringBuffer.append(Utilities.keyToString((KeyStroke)KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0)));
        }
        return stringBuffer.toString();
    }

    private static boolean isSolaris() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith("SunOS");
    }
}

