/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.SheetTable;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

abstract class BaseTable
extends JTable
implements FocusListener {
    protected static final String SYSPROP_PS_QUICK_SEARCH_DISABLED_GLOBAL = "ps.quickSearch.disabled.global";
    protected static final String ACTION_NEXT = "next";
    protected static final String ACTION_PREV = "prev";
    protected static final String ACTION_INLINE_EDITOR = "invokeInlineEditor";
    protected static final String ACTION_CANCEL_EDIT = "cancelEditing";
    protected static final String ACTION_ENTER = "enterPressed";
    protected static final String ACTION_FOCUS_NEXT = "focusNext";
    private static final int centerLineFudgeFactor = 3;
    protected static Action editAction = null;
    protected static Action cancelAction = null;
    protected static Action enterAction = null;
    protected LineDragListener dragListener;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    boolean needCalcRowHeight = true;
    private boolean inSetUI = false;
    private boolean allowQuickSearch = true;
    private int editRequests = 0;
    private int editorRemoveRequests = 0;
    private int editorChangeRequests = 0;
    private boolean searchArmed = false;
    private transient SearchField searchField = null;
    private transient JPanel searchpanel = null;
    private transient ChangeListener viewportListener;
    private transient Point prevViewPosition = null;
    WL parentListener;

    public BaseTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.getSelectionModel().setSelectionMode(0);
        this.setSurrendersFocusOnKeystroke(true);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.setAutoResizeMode(1);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.putClientProperty("terminateEditOnFocusLost", PropUtils.psCommitOnFocusLoss ? Boolean.FALSE : Boolean.TRUE);
        this.dragListener = new LineDragListener();
        this.addMouseListener(this.dragListener);
        this.addMouseMotionListener(this.dragListener);
        this.setFocusCycleRoot(true);
        this.enableEvents(4L);
        if (this.getClass() != SheetTable.class) {
            throw new NoClassDefFoundError("Only SheetTable may subclass BaseTable, for good reasons");
        }
    }

    protected void initKeysAndActions() {
        this.setFocusTraversalKeys(0, Collections.emptySet());
        this.setFocusTraversalKeys(1, Collections.emptySet());
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 1));
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        if (!GraphicsEnvironment.isHeadless()) {
            inputMap.put(KeyStroke.getKeyStroke(9, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1, false), ACTION_FOCUS_NEXT);
            inputMap.put(KeyStroke.getKeyStroke(9, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false), ACTION_FOCUS_NEXT);
        }
        CTRLTabAction cTRLTabAction = new CTRLTabAction();
        actionMap.put(ACTION_FOCUS_NEXT, cTRLTabAction);
        inputMap.put(KeyStroke.getKeyStroke(9, 0), ACTION_NEXT);
        inputMap.put(KeyStroke.getKeyStroke(9, 64), ACTION_PREV);
        actionMap.put(ACTION_NEXT, new NavigationAction(true));
        actionMap.put(ACTION_PREV, new NavigationAction(false));
        inputMap.put(KeyStroke.getKeyStroke(32, 0), ACTION_INLINE_EDITOR);
        inputMap.put(KeyStroke.getKeyStroke(113, 0), ACTION_INLINE_EDITOR);
        actionMap.put(ACTION_INLINE_EDITOR, BaseTable.getEditAction());
        inputMap.put(KeyStroke.getKeyStroke(10, 0), ACTION_ENTER);
        actionMap.put(ACTION_ENTER, BaseTable.getEnterAction());
        InputMap inputMap2 = this.getInputMap(1);
        inputMap2.put(KeyStroke.getKeyStroke(27, 0), ACTION_CANCEL_EDIT);
        actionMap.put(ACTION_CANCEL_EDIT, new CancelAction());
        inputMap2.put(KeyStroke.getKeyStroke(27, 0), ACTION_CANCEL_EDIT);
    }

    protected static final void cleanup() {
        editAction = null;
        cancelAction = null;
        enterAction = null;
    }

    @Override
    public void setFont(Font font) {
        this.needCalcRowHeight = true;
        super.setFont(font);
    }

    private static Action getEditAction() {
        if (editAction == null) {
            editAction = new EditAction();
        }
        return editAction;
    }

    private static Action getEnterAction() {
        if (enterAction == null) {
            enterAction = new EnterAction();
        }
        return enterAction;
    }

    private void calcRowHeight(Graphics graphics) {
        int n;
        Integer n2 = (Integer)UIManager.get("netbeans.ps.rowheight");
        if (n2 != null) {
            n = n2;
        } else {
            Font font = this.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            n = Math.max(fontMetrics.getHeight() + 3, PropUtils.getSpinnerHeight());
        }
        this.needCalcRowHeight = false;
        this.setRowHeight(n);
    }

    protected int getFirstVisibleRow() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            return this.rowAtPoint(jViewport.getViewPosition());
        }
        Insets insets = this.getInsets();
        return this.rowAtPoint(new Point(insets.left, insets.top));
    }

    protected int getVisibleRowCount() {
        int n = this.getRowCount();
        int n2 = this.getRowHeight();
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            int n3 = Math.min(n, jViewport.getExtentSize().height / n2 + 1);
            return n3;
        }
        return Math.min(n, this.getHeight() / n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    @Override
    public final void requestFocus() {
        if (this.isEditing()) {
            if (PropUtils.isLoggable(BaseTable.class)) {
                PropUtils.log(BaseTable.class, "RequestFocus on table delegating to editor component");
            }
            this.editorComp.requestFocus();
        } else if (!this.inEditorChangeRequest()) {
            if (PropUtils.isLoggable(BaseTable.class)) {
                PropUtils.log(BaseTable.class, "RequestFocus on table with no editor present");
            }
            super.requestFocus();
        }
    }

    @Override
    public final boolean requestFocusInWindow() {
        if (this.isEditing()) {
            if (PropUtils.isLoggable(BaseTable.class)) {
                PropUtils.log(BaseTable.class, "RequestFocusInWindow on table delegating to editor");
            }
            return this.editorComp.requestFocusInWindow();
        }
        if (!this.inEditorChangeRequest()) {
            if (PropUtils.isLoggable(BaseTable.class)) {
                PropUtils.log(BaseTable.class, "RequestFocusInWindow on table with no editor present");
            }
            boolean bl = super.requestFocusInWindow();
            if (PropUtils.isLoggable(BaseTable.class)) {
                PropUtils.log(BaseTable.class, "  RequestFocusInWindow result " + bl);
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl;
        this.enterEditRequest();
        if (eventObject instanceof MouseEvent) {
            Component component;
            if (PropUtils.isLoggable(BaseTable.class)) {
                PropUtils.log(BaseTable.class, "editCellAt " + n + "," + n2 + " triggered by mouse event");
            }
            if ((component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner()) != this && !this.requestFocusInWindow()) {
                this.requestFocus();
            }
        } else if (PropUtils.isLoggable(BaseTable.class)) {
            PropUtils.log(BaseTable.class, "editCellAt " + n + "," + n2 + " triggered by (null = kbd evt)" + eventObject);
        }
        boolean bl2 = this.isEditing();
        if (bl2) {
            if (PropUtils.isLoggable(BaseTable.class)) {
                PropUtils.log(BaseTable.class, "  was already editing, removing the editor");
            }
            this.removeEditor();
        }
        int n3 = this.getSelectedRow();
        this.changeSelection(n, n2, false, false);
        boolean bl3 = false;
        boolean bl4 = bl = bl2 && this.isCellEditable(n, n2);
        if (bl) {
            this.enterEditorChangeRequest();
        }
        try {
            bl3 = super.editCellAt(n, n2, eventObject);
            if (PropUtils.isLoggable(BaseTable.class)) {
                PropUtils.log(BaseTable.class, "  Result of super.editCellAt is " + bl3);
            }
            if (this.editorComp != null) {
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                this.editorComp.addFocusListener(this);
            }
        }
        finally {
            try {
                this.exitEditRequest();
            }
            finally {
                if (bl) {
                    this.exitEditorChangeRequest();
                }
            }
        }
        return bl3;
    }

    protected final void enterEditRequest() {
        ++this.editRequests;
        if (PropUtils.isLoggable(BaseTable.class)) {
            PropUtils.log(BaseTable.class, " entering edit request");
        }
    }

    protected final void enterEditorRemoveRequest() {
        ++this.editorRemoveRequests;
        if (PropUtils.isLoggable(BaseTable.class)) {
            PropUtils.log(BaseTable.class, " entering editor remove request");
        }
    }

    protected final void enterEditorChangeRequest() {
        ++this.editorChangeRequests;
        if (PropUtils.isLoggable(BaseTable.class)) {
            PropUtils.log(BaseTable.class, " entering editor change request");
        }
    }

    protected final void exitEditRequest() {
        --this.editRequests;
        if (PropUtils.isLoggable(BaseTable.class)) {
            PropUtils.log(BaseTable.class, " exiting edit change request");
        }
        assert (this.editRequests >= 0);
    }

    protected final void exitEditorRemoveRequest() {
        --this.editorRemoveRequests;
        PropUtils.log(BaseTable.class, " exiting editor remove request");
        assert (this.editorRemoveRequests >= 0);
    }

    protected final void exitEditorChangeRequest() {
        --this.editorChangeRequests;
        if (PropUtils.isLoggable(BaseTable.class)) {
            PropUtils.log(BaseTable.class, " exiting editor change request");
        }
        assert (this.editorRemoveRequests >= 0);
    }

    protected final boolean inEditRequest() {
        return this.editRequests > 0;
    }

    protected final boolean inEditorChangeRequest() {
        return this.editorChangeRequests > 0;
    }

    protected final boolean inEditorRemoveRequest() {
        return this.editorRemoveRequests > 0;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = tableCellEditor.getTableCellEditorComponent(this, this.getValueAt(n, n2), false, n, n2);
        if (component != null) {
            component.setBackground(this.getSelectionBackground());
            component.setForeground(this.getSelectionForeground());
            component.setFont(this.getFont());
        }
        return component;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Color color;
        Object object = this.getValueAt(n, n2);
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean bl = this.isSelected(n, component);
        Component component2 = tableCellRenderer.getTableCellRendererComponent(this, object, bl, false, n, n2);
        if (PropUtils.isNimbus && !bl && null != (color = this.getBackground())) {
            component2.setBackground(new Color(color.getRGB()));
        }
        return component2;
    }

    protected boolean isSelected(int n, Component component) {
        return (this.getSelectedRow() == n || this.editingRow == n && !this.inEditorRemoveRequest()) && (this.hasFocus() || this.isKnownComponent(component) || this.inEditRequest());
    }

    @Override
    public void setUI(TableUI tableUI) {
        this.needCalcRowHeight = true;
        this.inSetUI = true;
        super.setUI(tableUI);
        this.inSetUI = false;
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        if (!this.inSetUI) {
            super.addFocusListener(focusListener);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.initKeysAndActions();
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.needCalcRowHeight) {
            this.calcRowHeight(graphics);
            return;
        }
        super.paint(graphics);
    }

    protected void paintRow(int n) {
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.getCellRect(n, 0, false);
        rectangle.x = 0;
        rectangle.width = this.getWidth();
        this.repaint(rectangle);
    }

    protected void paintSelectionRow() {
        this.paintRow(this.getSelectedRow());
    }

    @Override
    public void removeEditor() {
        this.enterEditorRemoveRequest();
        try {
            int n = this.editingRow;
            if (this.editorComp != null) {
                this.editorComp.removeFocusListener(this);
            }
            if (PropUtils.isLoggable(BaseTable.class)) {
                PropUtils.log(BaseTable.class, " removing editor");
            }
            super.removeEditor();
            if (n != -1) {
                this.paintRow(n);
            }
        }
        finally {
            this.exitEditorRemoveRequest();
        }
    }

    @Override
    protected final void configureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setColumnHeaderView(this.getTableHeader());
        }
    }

    protected final boolean onCenterLine(int n) {
        int n2 = this.getColumnModel().getColumn(0).getWidth();
        return n > n2 - 3 && n < n2 + 3;
    }

    protected final boolean onCenterLine(MouseEvent mouseEvent) {
        int n = mouseEvent.getPoint().x;
        return this.onCenterLine(n);
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        if (this.dragListener != null && this.dragListener.isArmed()) {
            return;
        }
        if (PropUtils.isLoggable(BaseTable.class)) {
            PropUtils.log(BaseTable.class, "ChangeSelection to " + n + "," + n2);
        }
        super.changeSelection(n, n2, bl, bl2);
        this.fireChange();
    }

    protected void focusLostCancel() {
        this.removeEditor();
    }

    @Override
    public void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (PropUtils.isLoggable(BaseTable.class)) {
            PropUtils.log(BaseTable.class, "processFocusEvent - ");
            PropUtils.log(BaseTable.class, focusEvent);
        }
        if ((!this.isAncestorOf(focusEvent.getOppositeComponent()) || focusEvent.getOppositeComponent() == null) && this.isEditing()) {
            if (focusEvent.getID() == 1005) {
                if (PropUtils.isLoggable(BaseTable.class)) {
                    PropUtils.log(BaseTable.class, "ProcessFocusEvent got focus lost to unknown component, removing editor");
                }
                this.focusLostCancel();
            }
        }
        if (!this.inEditorRemoveRequest() && !this.inEditRequest()) {
            if (focusEvent.getOppositeComponent() == null) {
                if (focusEvent.getID() == 1005) {
                    return;
                }
            }
            this.paintSelectionRow();
        } else {
            this.paintSelectionRow();
        }
    }

    protected boolean isQuickSearchAllowed() {
        String string = System.getProperty(SYSPROP_PS_QUICK_SEARCH_DISABLED_GLOBAL, "false");
        if (Boolean.parseBoolean(string)) {
            return false;
        }
        return this.allowQuickSearch;
    }

    protected void setQuickSearchAllowed(boolean bl) {
        this.allowQuickSearch = bl;
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.dragListener.isArmed()) {
            this.dragListener.setArmed(false);
        }
        boolean bl = this.searchField != null && this.searchField.isShowing() && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40);
        if (keyEvent.getKeyCode() != 9) {
            if (!bl) {
                super.processKeyEvent(keyEvent);
            }
            if (!keyEvent.isConsumed()) {
                if (keyEvent.getID() == 401 && !this.isEditing()) {
                    int n = keyEvent.getModifiers();
                    int n2 = keyEvent.getKeyCode();
                    if (n > 0 && n != 1 || keyEvent.isActionKey()) {
                        return;
                    }
                    char c = keyEvent.getKeyChar();
                    if (!Character.isISOControl(c) && n2 != 16 && n2 != 27) {
                        this.searchArmed = true;
                        keyEvent.consume();
                    }
                } else if (this.searchArmed && keyEvent.getID() == 400) {
                    this.passToSearchField(keyEvent);
                    keyEvent.consume();
                    this.searchArmed = false;
                } else {
                    this.searchArmed = false;
                }
            }
        } else {
            this.processKeyBinding(KeyStroke.getKeyStroke(9, keyEvent.getModifiersEx(), keyEvent.getID() == 402), keyEvent, 0, keyEvent.getID() == 401);
        }
    }

    void passToSearchField(KeyEvent keyEvent) {
        if (!this.isQuickSearchAllowed()) {
            return;
        }
        if (!(keyEvent.getKeyCode() != 9 && keyEvent.getKeyCode() != 10 && (keyEvent.getKeyCode() != 38 && keyEvent.getKeyCode() != 40 || this.searchField != null && this.searchField.isShowing()))) {
            return;
        }
        if (this.getRowCount() == 0) {
            return;
        }
        if (this.searchField == null || !this.searchField.isShowing()) {
            this.showSearchField();
            this.searchField.setText(String.valueOf(keyEvent.getKeyChar()));
        }
    }

    private void showSearchField() {
        Point point;
        JComponent jComponent;
        if (this.searchField == null) {
            this.searchField = new SearchField();
            this.searchpanel = new JPanel();
            jComponent = new JLabel(NbBundle.getMessage(BaseTable.class, (String)"LBL_QUICKSEARCH"));
            this.searchpanel.setLayout(new BoxLayout(this.searchpanel, 0));
            this.searchpanel.add(jComponent);
            this.searchpanel.add(this.searchField);
            ((JLabel)jComponent).setLabelFor(this.searchField);
            this.searchpanel.setBorder(BorderFactory.createRaisedBevelBorder());
            jComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }
        jComponent = this.getRootPane().getLayeredPane();
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            point = jViewport.getViewPosition();
            point.x += this.getColumnModel().getColumn(0).getWidth();
            this.viewportListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (null != BaseTable.this.searchField && BaseTable.this.searchField.isVisible()) {
                        if (null != BaseTable.this.prevViewPosition) {
                            BaseTable.this.repaint(0, ((BaseTable)BaseTable.this).prevViewPosition.y, BaseTable.this.getWidth(), BaseTable.this.searchpanel.getHeight());
                        }
                        assert (BaseTable.this.getParent() instanceof JViewport);
                        BaseTable.this.prevViewPosition = new Point(((JViewport)BaseTable.this.getParent()).getViewPosition());
                    }
                }
            };
            jViewport.addChangeListener(this.viewportListener);
            this.prevViewPosition = new Point(point);
        } else {
            point = new Point(this.getColumnModel().getColumn(0).getWidth(), this.getRowHeight() / 2);
        }
        point = SwingUtilities.convertPoint(this, point, jComponent);
        int n = this.getColumnModel().getColumn(1).getWidth();
        int n2 = this.getRowHeight() + 5;
        if (n < 120) {
            n = 160;
            point.x -= 160;
        }
        this.searchpanel.setBounds(point.x, point.y, n, n2);
        jComponent.add(this.searchpanel);
        this.getParent().addComponentListener(this.searchField);
        this.searchpanel.setVisible(true);
        this.searchField.requestFocus();
    }

    private void hideSearchField() {
        if (this.searchField == null) {
            return;
        }
        this.searchpanel.setVisible(false);
        if (this.getParent() instanceof JViewport && null != this.viewportListener) {
            JViewport jViewport = (JViewport)this.getParent();
            jViewport.removeChangeListener(this.viewportListener);
            this.viewportListener = null;
        }
        this.getParent().removeComponentListener(this.searchField);
        if (this.searchpanel.getParent() != null) {
            this.searchpanel.getParent().remove(this.searchpanel);
        }
        this.paintSelectionRow();
    }

    protected boolean matchText(Object object, String string) {
        if (object != null) {
            return object.toString().startsWith(string);
        }
        return false;
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        if (this.searchField != null && this.searchField.isShowing()) {
            return false;
        }
        return super.isOptimizedDrawingEnabled();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.searchField != null && this.searchField.isVisible()) {
            this.searchpanel.repaint();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        this.fireChange();
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    void fireChange() {
        if (this.cs != null) {
            this.cs.fireChange();
        }
    }

    protected boolean isKnownComponent(Component component) {
        if (component == null) {
            return false;
        }
        if (component == this) {
            return true;
        }
        if (component == this.editorComp) {
            return true;
        }
        if (component == this.searchField) {
            return true;
        }
        if (component == this.getRootPane()) {
            return true;
        }
        if (component instanceof Container && ((Container)component).isAncestorOf(this)) {
            return true;
        }
        return this.editorComp instanceof Container && ((Container)this.editorComp).isAncestorOf(component);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getOppositeComponent();
        PropUtils.log(BaseTable.class, focusEvent);
        if (!this.isKnownComponent(component)) {
            this.fireChange();
        }
        if (!this.inEditRequest() && !this.inEditorRemoveRequest() && focusEvent.getComponent() == this) {
            this.paintSelectionRow();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.dragListener != null && this.dragListener.isDragging()) {
            this.dragListener.abortDrag();
        }
        PropUtils.log(BaseTable.class, focusEvent);
        if (focusEvent.isTemporary()) {
            return;
        }
        Component component = focusEvent.getOppositeComponent();
        if (!this.isKnownComponent(component)) {
            this.doFocusLost(component);
        }
    }

    private void doFocusLost(Component component) {
        PropUtils.log(BaseTable.class, " removing editor due to focus change");
        if (PropUtils.psCommitOnFocusLoss && this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        } else {
            this.removeEditor();
        }
        if (component != null) {
            this.fireChange();
        }
        this.paintSelectionRow();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container container = this.getTopLevelAncestor();
        if (container instanceof Window) {
            this.parentListener = new WL();
            ((Window)container).addWindowListener(this.parentListener);
        }
    }

    @Override
    public void removeNotify() {
        Container container = this.getTopLevelAncestor();
        if (container instanceof Window && this.parentListener != null) {
            ((Window)container).removeWindowListener(this.parentListener);
            this.parentListener = null;
        }
        super.removeNotify();
    }

    private class CTRLTabAction
    extends AbstractAction {
        private CTRLTabAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseTable.this.setFocusCycleRoot(false);
            try {
                Container container = BaseTable.this.getFocusCycleRootAncestor();
                if (container != null) {
                    Component component;
                    Container container2 = BaseTable.this;
                    if (BaseTable.this.getParent() instanceof JViewport && (container2 = BaseTable.this.getParent().getParent()) == container) {
                        container2 = BaseTable.this;
                    }
                    AWTEvent aWTEvent = EventQueue.getCurrentEvent();
                    boolean bl = false;
                    if (aWTEvent instanceof KeyEvent) {
                        bl = (((KeyEvent)aWTEvent).getModifiers() & 1) != 0 && (((KeyEvent)aWTEvent).getModifiersEx() & 0x40) != 0;
                    }
                    Component component2 = component = bl ? container.getFocusTraversalPolicy().getComponentAfter(container, BaseTable.this) : container.getFocusTraversalPolicy().getComponentAfter(container, BaseTable.this);
                    if (component == BaseTable.this) {
                        component = bl ? container.getFocusTraversalPolicy().getFirstComponent(container) : container.getFocusTraversalPolicy().getLastComponent(container);
                    }
                    component.requestFocus();
                }
            }
            finally {
                BaseTable.this.setFocusCycleRoot(true);
            }
        }
    }

    final class LineDragListener
    extends MouseAdapter
    implements MouseMotionListener {
        private long dragStartTime = -1L;
        boolean armed;
        boolean dragging;
        int pos = -1;

        LineDragListener() {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.setArmed(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.isArmed() && BaseTable.this.onCenterLine(mouseEvent)) {
                this.beginDrag();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isDragging()) {
                this.finishDrag();
                this.setArmed(false);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.setArmed(!BaseTable.this.isEditing() && BaseTable.this.onCenterLine(mouseEvent));
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.armed && !this.dragging) {
                return;
            }
            int n = mouseEvent.getPoint().x;
            TableColumn tableColumn = BaseTable.this.getColumnModel().getColumn(0);
            TableColumn tableColumn2 = BaseTable.this.getColumnModel().getColumn(1);
            int n2 = Math.max(tableColumn.getMinWidth(), BaseTable.this.getWidth() - tableColumn2.getMaxWidth());
            int n3 = Math.min(tableColumn.getMaxWidth(), BaseTable.this.getWidth() - tableColumn2.getMinWidth());
            if (n >= n2 && n <= n3) {
                this.pos = n;
                this.update();
            }
        }

        public boolean isArmed() {
            return this.armed;
        }

        public boolean isDragging() {
            return this.dragging;
        }

        public void setArmed(boolean bl) {
            if (bl != this.armed) {
                this.armed = bl;
                if (this.armed) {
                    BaseTable.this.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    BaseTable.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }

        private void beginDrag() {
            this.dragging = true;
            this.dragStartTime = System.currentTimeMillis();
        }

        public void abortDrag() {
            this.dragging = false;
            this.setArmed(false);
            BaseTable.this.repaint();
        }

        private void finishDrag() {
            this.dragging = false;
            if (System.currentTimeMillis() - this.dragStartTime < 400L) {
                this.update();
            } else {
                this.abortDrag();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            if (this.pos < 0 || this.pos > BaseTable.this.getWidth()) {
                BaseTable.this.repaint();
                return;
            }
            int n = this.pos;
            int n2 = BaseTable.this.getWidth() - this.pos;
            Object object = BaseTable.this.getTreeLock();
            synchronized (object) {
                BaseTable.this.getColumnModel().getColumn(0).setWidth(n);
                BaseTable.this.getColumnModel().getColumn(1).setWidth(n2);
                BaseTable.this.getColumnModel().getColumn(0).setPreferredWidth(n);
                BaseTable.this.getColumnModel().getColumn(1).setPreferredWidth(n2);
            }
            BaseTable.this.repaint();
        }
    }

    private final class NavigationAction
    extends AbstractAction {
        private boolean direction;

        public NavigationAction(boolean bl) {
            this.direction = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = BaseTable.this.getSelectedRow() + (this.direction ? 1 : -1);
            if (n >= BaseTable.this.getRowCount() || n < 0) {
                if (!(BaseTable.this.getTopLevelAncestor() instanceof Dialog)) {
                    n = n >= BaseTable.this.getRowCount() ? 0 : BaseTable.this.getRowCount() - 1;
                } else if (n >= BaseTable.this.getRowCount() || n < 0) {
                    JButton jButton;
                    Container container;
                    Component component;
                    Container container2 = BaseTable.this.getFocusCycleRootAncestor();
                    Component component2 = component = this.direction ? container2.getFocusTraversalPolicy().getComponentAfter(container2, BaseTable.this.getParent()) : container2.getFocusTraversalPolicy().getComponentBefore(container2, BaseTable.this);
                    if (component == BaseTable.this && (container = container2.getFocusCycleRootAncestor()) != null) {
                        component = this.direction ? container.getFocusTraversalPolicy().getComponentAfter(container, container2) : container.getFocusTraversalPolicy().getComponentBefore(container, container2);
                        container2 = container;
                    }
                    if (component == BaseTable.this && container2.getFocusTraversalPolicy().getFirstComponent(container2) != null) {
                        component = container2.getFocusTraversalPolicy().getFirstComponent(container2);
                    }
                    if (component == BaseTable.this && (jButton = ((JRootPane)(container = BaseTable.this.getRootPane())).getDefaultButton()) != null) {
                        component = jButton;
                    }
                    if (component != null) {
                        if (component == BaseTable.this) {
                            BaseTable.this.changeSelection(this.direction ? 0 : BaseTable.this.getRowCount() - 1, this.direction ? 0 : BaseTable.this.getColumnCount() - 1, false, false);
                        } else {
                            component.requestFocus();
                        }
                        return;
                    }
                }
                BaseTable.this.changeSelection(n, BaseTable.this.getSelectedColumn(), false, false);
            }
            if (BaseTable.this.getSelectionModel().getAnchorSelectionIndex() < 0) {
                BaseTable.this.getSelectionModel().setAnchorSelectionIndex(n);
            }
            BaseTable.this.getSelectionModel().setLeadSelectionIndex(n);
        }
    }

    private static class EnterAction
    extends AbstractAction {
        private EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof BaseTable) {
                BaseTable baseTable = (BaseTable)actionEvent.getSource();
                if (baseTable.isEditing()) {
                    return;
                }
                this.trySendEnterToDialog(baseTable);
            }
        }

        private void trySendEnterToDialog(BaseTable baseTable) {
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getKeyCode() == 10) {
                JButton jButton;
                if (aWTEvent.getSource() instanceof JComboBox && ((JComboBox)aWTEvent.getSource()).isPopupVisible()) {
                    return;
                }
                if (aWTEvent.getSource() instanceof JTextComponent && ((JTextComponent)aWTEvent.getSource()).getParent() instanceof JComboBox && ((JComboBox)((JTextComponent)aWTEvent.getSource()).getParent()).isPopupVisible()) {
                    return;
                }
                JRootPane jRootPane = baseTable.getRootPane();
                if (jRootPane != null && (jButton = jRootPane.getDefaultButton()) != null && jButton.isEnabled()) {
                    jButton.doClick();
                }
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            if (jTable != null) {
                if (jTable.isEditing()) {
                    TableCellEditor tableCellEditor = jTable.getCellEditor();
                    if (PropUtils.isLoggable(BaseTable.class)) {
                        PropUtils.log(BaseTable.class, "Cancelling edit due to keyboard event");
                    }
                    if (tableCellEditor != null) {
                        jTable.getCellEditor().cancelCellEditing();
                    }
                } else {
                    this.trySendEscToDialog(jTable);
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return BaseTable.this.isEditing();
        }

        private void trySendEscToDialog(JTable jTable) {
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getKeyCode() == 27) {
                Action action;
                if (aWTEvent.getSource() instanceof JComboBox && ((JComboBox)aWTEvent.getSource()).isPopupVisible()) {
                    return;
                }
                if (aWTEvent.getSource() instanceof JTextComponent && ((JTextComponent)aWTEvent.getSource()).getParent() instanceof JComboBox && ((JComboBox)((JTextComponent)aWTEvent.getSource()).getParent()).isPopupVisible()) {
                    return;
                }
                InputMap inputMap = jTable.getRootPane().getInputMap(1);
                ActionMap actionMap = jTable.getRootPane().getActionMap();
                KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
                Object object = inputMap.get(keyStroke);
                if (object != null && (action = actionMap.get(object)) != null) {
                    String string;
                    if (Boolean.getBoolean("netbeans.proppanel.logDialogActions")) {
                        System.err.println("Action bound to escape key is " + action);
                    }
                    if ((string = (String)action.getValue("ActionCommandKey")) == null) {
                        string = "cancel";
                    }
                    action.actionPerformed(new ActionEvent(this, 1001, string));
                }
            }
        }
    }

    private static class EditAction
    extends AbstractAction {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            int n = jTable.getSelectedRow();
            int n2 = jTable.getSelectedColumn();
            if (n != -1 && n2 != -1) {
                if (PropUtils.isLoggable(BaseTable.class)) {
                    PropUtils.log(BaseTable.class, "Starting edit due to key event for row " + n);
                }
                jTable.editCellAt(n, 1, null);
                jTable.requestFocus();
            }
        }
    }

    private class SearchField
    extends JTextField
    implements ActionListener,
    FocusListener,
    ComponentListener {
        private int selectionBeforeLastShow = -1;

        public SearchField() {
            this.addActionListener(this);
            this.addFocusListener(this);
            this.setFont(BaseTable.this.getFont());
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.selectionBeforeLastShow = BaseTable.this.getSelectedRow();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            if (!this.isShowing()) {
                super.processKeyEvent(keyEvent);
                return;
            }
            if (keyEvent.getKeyCode() == 27) {
                BaseTable.this.changeSelection(this.selectionBeforeLastShow, 0, false, false);
                BaseTable.this.requestFocus();
                keyEvent.consume();
                return;
            }
            if (keyEvent.getKeyCode() == 38) {
                if (keyEvent.getID() == 401) {
                    this.reverseSearch(this.getText());
                    return;
                }
            }
            if (keyEvent.getKeyCode() == 40) {
                if (keyEvent.getID() == 401) {
                    this.forwardSearch(this.getText());
                    return;
                }
            }
            super.processKeyEvent(keyEvent);
            if (keyEvent.getKeyCode() == 38) return;
            if (keyEvent.getKeyCode() == 40) return;
            this.processSearchText(this.getText());
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                BaseTable.this.hideSearchField();
                keyEvent.consume();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.processSearchText(((JTextField)keyEvent.getSource()).getText());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.processSearchText(((JTextField)actionEvent.getSource()).getText());
            BaseTable.this.requestFocus();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.processSearchText(((JTextField)focusEvent.getSource()).getText());
            JRootPane jRootPane = this.getRootPane();
            if (jRootPane != null) {
                jRootPane.getLayeredPane().repaint();
            }
            this.setCaretPosition(this.getText().length());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            BaseTable.this.hideSearchField();
        }

        private void processSearchText(String string) {
            if (string == null || string.length() == 0) {
                return;
            }
            int n = BaseTable.this.getRowCount();
            int n2 = BaseTable.this.getSelectedRow();
            if (n2 == n - 1 || n2 < 0) {
                n2 = 0;
            }
            for (int i = 0; i < n; ++i) {
                boolean bl = BaseTable.this.matchText(BaseTable.this.getValueAt(i, 0), string);
                if (bl) {
                    BaseTable.this.changeSelection(i, 0, false, false);
                    this.getRootPane().getLayeredPane().repaint();
                    break;
                }
                if (n2++ != n - 1) continue;
                n2 = 0;
            }
        }

        private void forwardSearch(String string) {
            if (string == null || string.length() == 0) {
                return;
            }
            int n = BaseTable.this.getRowCount();
            int n2 = BaseTable.this.getSelectedRow() + 1;
            if (n2 == n - 1 || n2 < 0) {
                n2 = 0;
            }
            for (int i = n2; i < n; ++i) {
                boolean bl = BaseTable.this.matchText(BaseTable.this.getValueAt(i, 0), string);
                if (!bl) continue;
                BaseTable.this.changeSelection(i, 0, false, false);
                this.repaint();
                break;
            }
        }

        private void reverseSearch(String string) {
            if (string == null || string.length() == 0) {
                return;
            }
            int n = BaseTable.this.getRowCount();
            int n2 = BaseTable.this.getSelectedRow();
            if (n2 < 1) {
                n2 = n - 1;
            }
            for (int i = n2 - 1; i >= 0; --i) {
                boolean bl = BaseTable.this.matchText(BaseTable.this.getValueAt(i, 0), string);
                if (!bl) continue;
                BaseTable.this.changeSelection(i, 0, false, false);
                this.repaint();
                break;
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            BaseTable.this.hideSearchField();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            BaseTable.this.hideSearchField();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            BaseTable.this.hideSearchField();
        }
    }

    private class WL
    extends WindowAdapter {
        private WL() {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            BaseTable.this.doFocusLost(windowEvent.getOppositeWindow());
        }
    }
}

