/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsReader;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SoftDeletesRetentionMergePolicy;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.InfoStream;
import org.elasticsearch.Assertions;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.LoggerInfoStream;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.lucene.uid.VersionsAndSeqNoResolver;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.CombinedDeletionPolicy;
import org.elasticsearch.index.engine.CombinedDocValues;
import org.elasticsearch.index.engine.DeleteVersionValue;
import org.elasticsearch.index.engine.ElasticsearchConcurrentMergeScheduler;
import org.elasticsearch.index.engine.ElasticsearchReaderManager;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.IndexVersionValue;
import org.elasticsearch.index.engine.LiveVersionMap;
import org.elasticsearch.index.engine.LuceneChangesSnapshot;
import org.elasticsearch.index.engine.PrunePostingsMergePolicy;
import org.elasticsearch.index.engine.RamAccountingRefreshListener;
import org.elasticsearch.index.engine.RecoverySourcePruneMergePolicy;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.SafeCommitInfo;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.engine.SoftDeletesPolicy;
import org.elasticsearch.index.engine.TranslogLeafReader;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.engine.VersionValue;
import org.elasticsearch.index.fieldvisitor.IdOnlyFieldVisitor;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.ElasticsearchMergePolicy;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.FsDirectoryFactory;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogCorruptedException;
import org.elasticsearch.index.translog.TranslogDeletionPolicy;
import org.elasticsearch.index.translog.TranslogStats;

public class InternalEngine
extends Engine {
    private volatile long lastDeleteVersionPruneTimeMSec;
    private final Translog translog;
    private final ElasticsearchConcurrentMergeScheduler mergeScheduler;
    private final IndexWriter indexWriter;
    private final ExternalReaderManager externalReaderManager;
    private final ElasticsearchReaderManager internalReaderManager;
    private final Lock flushLock;
    private final ReentrantLock optimizeLock;
    private final LiveVersionMap versionMap;
    private volatile SegmentInfos lastCommittedSegmentInfos;
    private final Engine.IndexThrottle throttle;
    private final LocalCheckpointTracker localCheckpointTracker;
    private final CombinedDeletionPolicy combinedDeletionPolicy;
    private final AtomicInteger throttleRequestCount;
    private final AtomicBoolean pendingTranslogRecovery;
    private final AtomicLong maxUnsafeAutoIdTimestamp;
    private final AtomicLong maxSeenAutoIdTimestamp;
    private final AtomicLong maxSeqNoOfUpdatesOrDeletes;
    private final CounterMetric numVersionLookups;
    private final CounterMetric numIndexVersionsLookups;
    private final CounterMetric numDocDeletes;
    private final CounterMetric numDocAppends;
    private final CounterMetric numDocUpdates;
    private final NumericDocValuesField softDeletesField;
    private final boolean softDeleteEnabled;
    private final SoftDeletesPolicy softDeletesPolicy;
    private final LastRefreshedCheckpointListener lastRefreshedCheckpointListener;
    private final AtomicBoolean trackTranslogLocation;
    private final KeyedLock<Long> noOpKeyedLock;
    private final AtomicBoolean shouldPeriodicallyFlushAfterBigMerge;
    @Nullable
    private final String historyUUID;
    private final Object refreshIfNeededMutex;

    public InternalEngine(EngineConfig engineConfig) {
        this(engineConfig, LocalCheckpointTracker::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InternalEngine(EngineConfig engineConfig, BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier) {
        block24: {
            super(engineConfig);
            this.flushLock = new ReentrantLock();
            this.optimizeLock = new ReentrantLock();
            this.versionMap = new LiveVersionMap();
            this.throttleRequestCount = new AtomicInteger();
            this.pendingTranslogRecovery = new AtomicBoolean(false);
            this.maxUnsafeAutoIdTimestamp = new AtomicLong(-1L);
            this.maxSeenAutoIdTimestamp = new AtomicLong(-1L);
            this.numVersionLookups = new CounterMetric();
            this.numIndexVersionsLookups = new CounterMetric();
            this.numDocDeletes = new CounterMetric();
            this.numDocAppends = new CounterMetric();
            this.numDocUpdates = new CounterMetric();
            this.softDeletesField = Lucene.newSoftDeletesField();
            this.trackTranslogLocation = new AtomicBoolean(false);
            this.noOpKeyedLock = new KeyedLock();
            this.shouldPeriodicallyFlushAfterBigMerge = new AtomicBoolean(false);
            this.refreshIfNeededMutex = new Object();
            if (!engineConfig.isAutoGeneratedIDsOptimizationEnabled()) {
                this.updateAutoIdTimestamp(Long.MAX_VALUE, true);
            }
            TranslogDeletionPolicy translogDeletionPolicy = new TranslogDeletionPolicy(engineConfig.getIndexSettings().getTranslogRetentionSize().getBytes(), engineConfig.getIndexSettings().getTranslogRetentionAge().getMillis(), engineConfig.getIndexSettings().getTranslogRetentionTotalFiles());
            this.store.incRef();
            IndexWriter writer = null;
            Translog translog = null;
            ExternalReaderManager externalReaderManager = null;
            ElasticsearchReaderManager internalReaderManager = null;
            EngineMergeScheduler scheduler = null;
            boolean success = false;
            try {
                this.lastDeleteVersionPruneTimeMSec = engineConfig.getThreadPool().relativeTimeInMillis();
                scheduler = new EngineMergeScheduler(engineConfig.getShardId(), engineConfig.getIndexSettings());
                this.mergeScheduler = scheduler;
                this.throttle = new Engine.IndexThrottle();
                try {
                    InternalEngine.trimUnsafeCommits(engineConfig);
                    translog = this.openTranslog(engineConfig, translogDeletionPolicy, engineConfig.getGlobalCheckpointSupplier(), seqNo -> {
                        LocalCheckpointTracker tracker = this.getLocalCheckpointTracker();
                        assert (tracker != null || !this.getTranslog().isOpen());
                        if (tracker != null) {
                            tracker.markSeqNoAsPersisted(seqNo);
                        }
                    });
                    assert (translog.getGeneration() != null);
                    this.translog = translog;
                    this.softDeleteEnabled = engineConfig.getIndexSettings().isSoftDeleteEnabled();
                    this.softDeletesPolicy = this.newSoftDeletesPolicy();
                    this.combinedDeletionPolicy = new CombinedDeletionPolicy(this.logger, translogDeletionPolicy, this.softDeletesPolicy, translog::getLastSyncedGlobalCheckpoint);
                    this.localCheckpointTracker = this.createLocalCheckpointTracker(localCheckpointTrackerSupplier);
                    writer = this.createWriter();
                    this.bootstrapAppendOnlyInfoFromWriter(writer);
                    this.historyUUID = this.loadHistoryUUID(writer);
                    this.indexWriter = writer;
                }
                catch (IOException | TranslogCorruptedException e) {
                    throw new EngineCreationFailureException(this.shardId, "failed to create engine", e);
                }
                catch (AssertionError e) {
                    if (ExceptionsHelper.stackTrace((Throwable)((Object)e)).contains("org.apache.lucene.index.IndexWriter.filesExist")) {
                        throw new EngineCreationFailureException(this.shardId, "failed to create engine", (Throwable)((Object)e));
                    }
                    throw e;
                }
                externalReaderManager = this.createReaderManager(new RefreshWarmerListener(this.logger, this.isClosed, engineConfig));
                this.internalReaderManager = internalReaderManager = externalReaderManager.internalReaderManager;
                this.externalReaderManager = externalReaderManager;
                internalReaderManager.addListener(this.versionMap);
                assert (!this.pendingTranslogRecovery.get()) : "translog recovery can't be pending before we set it";
                this.pendingTranslogRecovery.set(true);
                for (ReferenceManager.RefreshListener listener : engineConfig.getExternalRefreshListener()) {
                    this.externalReaderManager.addListener(listener);
                }
                for (ReferenceManager.RefreshListener listener : engineConfig.getInternalRefreshListener()) {
                    this.internalReaderManager.addListener(listener);
                }
                this.lastRefreshedCheckpointListener = new LastRefreshedCheckpointListener(this.localCheckpointTracker.getProcessedCheckpoint());
                this.internalReaderManager.addListener(this.lastRefreshedCheckpointListener);
                this.maxSeqNoOfUpdatesOrDeletes = new AtomicLong(SequenceNumbers.max(this.localCheckpointTracker.getMaxSeqNo(), translog.getMaxSeqNo()));
                if (this.softDeleteEnabled && this.localCheckpointTracker.getPersistedCheckpoint() < this.localCheckpointTracker.getMaxSeqNo()) {
                    try (Engine.Searcher searcher = this.acquireSearcher("restore_version_map_and_checkpoint_tracker", Engine.SearcherScope.INTERNAL);){
                        this.restoreVersionMapAndCheckpointTracker(Lucene.wrapAllDocsLive(searcher.getDirectoryReader()));
                    }
                    catch (IOException e) {
                        throw new EngineCreationFailureException(this.config().getShardId(), "failed to restore version map and local checkpoint tracker", e);
                    }
                }
                if (success = true) break block24;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{writer, translog, internalReaderManager, externalReaderManager, scheduler});
                    if (!this.isClosed.get()) {
                        this.store.decRef();
                    }
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{writer, translog, internalReaderManager, externalReaderManager, scheduler});
            if (!this.isClosed.get()) {
                this.store.decRef();
            }
        }
        this.logger.trace("created new InternalEngine");
    }

    private LocalCheckpointTracker createLocalCheckpointTracker(BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier) throws IOException {
        SequenceNumbers.CommitInfo seqNoStats = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.store.readLastCommittedSegmentsInfo().userData.entrySet());
        long maxSeqNo = seqNoStats.maxSeqNo;
        long localCheckpoint = seqNoStats.localCheckpoint;
        this.logger.trace("recovered maximum sequence number [{}] and local checkpoint [{}]", (Object)maxSeqNo, (Object)localCheckpoint);
        return localCheckpointTrackerSupplier.apply(maxSeqNo, localCheckpoint);
    }

    private SoftDeletesPolicy newSoftDeletesPolicy() throws IOException {
        Map commitUserData = this.store.readLastCommittedSegmentsInfo().userData;
        long lastMinRetainedSeqNo = commitUserData.containsKey("min_retained_seq_no") ? Long.parseLong((String)commitUserData.get("min_retained_seq_no")) : Long.parseLong((String)commitUserData.get("max_seq_no")) + 1L;
        return new SoftDeletesPolicy(this.translog::getLastSyncedGlobalCheckpoint, lastMinRetainedSeqNo, this.engineConfig.getIndexSettings().getSoftDeleteRetentionOperations(), this.engineConfig.retentionLeasesSupplier());
    }

    @Override
    final boolean assertSearcherIsWarmedUp(String source, Engine.SearcherScope scope) {
        if (scope == Engine.SearcherScope.EXTERNAL) {
            switch (source) {
                case "segments": 
                case "segments_stats": {
                    break;
                }
                default: {
                    assert (this.externalReaderManager.isWarmedUp) : "searcher was not warmed up yet for source[" + source + "]";
                    break;
                }
            }
        }
        return true;
    }

    @Override
    public int restoreLocalHistoryFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner) throws IOException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            int n;
            block12: {
                this.ensureOpen();
                long localCheckpoint = this.localCheckpointTracker.getProcessedCheckpoint();
                Translog.Snapshot snapshot = this.getTranslog().newSnapshotFromMinSeqNo(localCheckpoint + 1L);
                try {
                    n = translogRecoveryRunner.run(this, snapshot);
                    if (snapshot == null) break block12;
                }
                catch (Throwable throwable) {
                    if (snapshot != null) {
                        try {
                            snapshot.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                snapshot.close();
            }
            return n;
        }
    }

    @Override
    public int fillSeqNoGaps(long primaryTerm) throws IOException {
        try (ReleasableLock ignored = this.writeLock.acquire();){
            this.ensureOpen();
            long localCheckpoint = this.localCheckpointTracker.getProcessedCheckpoint();
            long maxSeqNo = this.localCheckpointTracker.getMaxSeqNo();
            int numNoOpsAdded = 0;
            long seqNo = localCheckpoint + 1L;
            while (seqNo <= maxSeqNo) {
                this.innerNoOp(new Engine.NoOp(seqNo, primaryTerm, Engine.Operation.Origin.PRIMARY, System.nanoTime(), "filling gaps"));
                ++numNoOpsAdded;
                assert (seqNo <= this.localCheckpointTracker.getProcessedCheckpoint()) : "local checkpoint did not advance; was [" + seqNo + "], now [" + this.localCheckpointTracker.getProcessedCheckpoint() + "]";
                seqNo = this.localCheckpointTracker.getProcessedCheckpoint() + 1L;
            }
            this.syncTranslog();
            assert (this.localCheckpointTracker.getPersistedCheckpoint() == maxSeqNo) : "persisted local checkpoint did not advance to max seq no; is [" + this.localCheckpointTracker.getPersistedCheckpoint() + "], max seq no [" + maxSeqNo + "]";
            int n = numNoOpsAdded;
            return n;
        }
    }

    private void bootstrapAppendOnlyInfoFromWriter(IndexWriter writer) {
        for (Map.Entry entry : writer.getLiveCommitData()) {
            if (!"max_unsafe_auto_id_timestamp".equals(entry.getKey())) continue;
            assert (this.maxUnsafeAutoIdTimestamp.get() == -1L) : "max unsafe timestamp was assigned already [" + this.maxUnsafeAutoIdTimestamp.get() + "]";
            this.updateAutoIdTimestamp(Long.parseLong((String)entry.getValue()), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalEngine recoverFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner, long recoverUpToSeqNo) throws IOException {
        this.flushLock.lock();
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            if (!this.pendingTranslogRecovery.get()) {
                throw new IllegalStateException("Engine has already been recovered");
            }
            try {
                this.recoverFromTranslogInternal(translogRecoveryRunner, recoverUpToSeqNo);
            }
            catch (Exception e) {
                try {
                    this.pendingTranslogRecovery.set(true);
                    this.failEngine("failed to recover from translog", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw e;
            }
        }
        finally {
            this.flushLock.unlock();
        }
        return this;
    }

    @Override
    public void skipTranslogRecovery() {
        assert (this.pendingTranslogRecovery.get()) : "translogRecovery is not pending but should be";
        this.pendingTranslogRecovery.set(false);
    }

    private void recoverFromTranslogInternal(Engine.TranslogRecoveryRunner translogRecoveryRunner, long recoverUpToSeqNo) throws IOException {
        int opsRecovered;
        Translog.TranslogGeneration translogGeneration = this.translog.getGeneration();
        long translogFileGen = Long.parseLong((String)this.lastCommittedSegmentInfos.getUserData().get("translog_generation"));
        try (Translog.Snapshot snapshot = this.translog.newSnapshotFromGen(new Translog.TranslogGeneration(this.translog.getTranslogUUID(), translogFileGen), recoverUpToSeqNo);){
            opsRecovered = translogRecoveryRunner.run(this, snapshot);
        }
        catch (Exception e) {
            throw new EngineException(this.shardId, "failed to recover from translog", e, new Object[0]);
        }
        assert (this.pendingTranslogRecovery.get()) : "translogRecovery is not pending but should be";
        this.pendingTranslogRecovery.set(false);
        if (opsRecovered > 0) {
            this.logger.trace("flushing post recovery from translog. ops recovered [{}]. committed translog id [{}]. current id [{}]", (Object)opsRecovered, (Object)(translogGeneration == null ? null : Long.valueOf(translogGeneration.translogFileGeneration)), (Object)this.translog.currentFileGeneration());
            this.commitIndexWriter(this.indexWriter, this.translog, null);
            this.refreshLastCommittedSegmentInfos();
            this.refresh("translog_recovery");
        }
        this.translog.trimUnreferencedReaders();
    }

    private Translog openTranslog(EngineConfig engineConfig, TranslogDeletionPolicy translogDeletionPolicy, LongSupplier globalCheckpointSupplier, LongConsumer persistedSequenceNumberConsumer) throws IOException {
        TranslogConfig translogConfig = engineConfig.getTranslogConfig();
        String translogUUID = this.loadTranslogUUIDFromLastCommit();
        return new Translog(translogConfig, translogUUID, translogDeletionPolicy, globalCheckpointSupplier, engineConfig.getPrimaryTermSupplier(), persistedSequenceNumberConsumer);
    }

    Translog getTranslog() {
        this.ensureOpen();
        return this.translog;
    }

    boolean hasSnapshottedCommits() {
        return this.combinedDeletionPolicy.hasSnapshottedCommits();
    }

    @Override
    public boolean isTranslogSyncNeeded() {
        return this.getTranslog().syncNeeded();
    }

    @Override
    public boolean ensureTranslogSynced(Stream<Translog.Location> locations) throws IOException {
        boolean synced = this.translog.ensureSynced(locations);
        if (synced) {
            this.revisitIndexDeletionPolicyOnTranslogSynced();
        }
        return synced;
    }

    @Override
    public void syncTranslog() throws IOException {
        this.translog.sync();
        this.revisitIndexDeletionPolicyOnTranslogSynced();
    }

    @Override
    public Translog.Snapshot readHistoryOperations(String reason, Engine.HistorySource historySource, MapperService mapperService, long startingSeqNo) throws IOException {
        if (historySource == Engine.HistorySource.INDEX) {
            this.ensureSoftDeletesEnabled();
            return this.newChangesSnapshot(reason, mapperService, Math.max(0L, startingSeqNo), Long.MAX_VALUE, false);
        }
        return this.getTranslog().newSnapshotFromMinSeqNo(startingSeqNo);
    }

    @Override
    public int estimateNumberOfHistoryOperations(String reason, Engine.HistorySource historySource, MapperService mapperService, long startingSeqNo) throws IOException {
        if (historySource == Engine.HistorySource.INDEX) {
            this.ensureSoftDeletesEnabled();
            try (Translog.Snapshot snapshot = this.newChangesSnapshot(reason, mapperService, Math.max(0L, startingSeqNo), Long.MAX_VALUE, false);){
                int n = snapshot.totalOperations();
                return n;
            }
        }
        return this.getTranslog().estimateTotalOperationsFromMinSeq(startingSeqNo);
    }

    @Override
    public TranslogStats getTranslogStats() {
        return this.getTranslog().stats();
    }

    @Override
    public Translog.Location getTranslogLastWriteLocation() {
        return this.getTranslog().getLastWriteLocation();
    }

    private void revisitIndexDeletionPolicyOnTranslogSynced() throws IOException {
        if (this.combinedDeletionPolicy.hasUnreferencedCommits()) {
            this.indexWriter.deleteUnusedFiles();
            this.translog.trimUnreferencedReaders();
        }
    }

    @Override
    public String getHistoryUUID() {
        return this.historyUUID;
    }

    @Override
    public long getWritingBytes() {
        return this.indexWriter.getFlushingBytes() + this.versionMap.getRefreshingBytes();
    }

    @Nullable
    private String loadTranslogUUIDFromLastCommit() throws IOException {
        Map commitUserData = this.store.readLastCommittedSegmentsInfo().getUserData();
        if (!commitUserData.containsKey("translog_generation")) {
            throw new IllegalStateException("commit doesn't contain translog generation id");
        }
        return (String)commitUserData.get("translog_uuid");
    }

    private String loadHistoryUUID(IndexWriter writer) {
        String uuid = InternalEngine.commitDataAsMap(writer).get("history_uuid");
        if (uuid == null) {
            throw new IllegalStateException("commit doesn't contain history uuid");
        }
        return uuid;
    }

    private ExternalReaderManager createReaderManager(RefreshWarmerListener externalRefreshListener) throws EngineException {
        ExternalReaderManager externalReaderManager;
        block7: {
            boolean success = false;
            ElasticsearchReaderManager internalReaderManager = null;
            try {
                ElasticsearchDirectoryReader directoryReader = ElasticsearchDirectoryReader.wrap(DirectoryReader.open((IndexWriter)this.indexWriter), this.shardId);
                internalReaderManager = new ElasticsearchReaderManager(directoryReader, new RamAccountingRefreshListener(this.engineConfig.getCircuitBreakerService()));
                this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
                ExternalReaderManager externalReaderManager2 = new ExternalReaderManager(internalReaderManager, externalRefreshListener);
                success = true;
                externalReaderManager = externalReaderManager2;
                if (success) break block7;
            }
            catch (IOException e) {
                try {
                    this.maybeFailEngine("start", e);
                    try {
                        this.indexWriter.rollback();
                    }
                    catch (IOException inner) {
                        e.addSuppressed(inner);
                    }
                    throw new EngineCreationFailureException(this.shardId, "failed to open reader on writer", e);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{internalReaderManager, this.indexWriter});
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{internalReaderManager, this.indexWriter});
        }
        return externalReaderManager;
    }

    @Override
    public Engine.GetResult get(Engine.Get get, BiFunction<String, Engine.SearcherScope, Engine.Searcher> searcherFactory) throws EngineException {
        assert (Objects.equals(get.uid().field(), "_id")) : get.uid().field();
        try (ReleasableLock ignored = this.readLock.acquire();){
            Engine.SearcherScope scope;
            this.ensureOpen();
            if (get.realtime()) {
                VersionValue versionValue = null;
                try (Releasable ignore = this.versionMap.acquireLock(get.uid().bytes());){
                    versionValue = this.getVersionFromMap(get.uid().bytes());
                }
                if (versionValue != null) {
                    block28: {
                        if (versionValue.isDelete()) {
                            ignore = Engine.GetResult.NOT_EXISTS;
                            return ignore;
                        }
                        if (get.versionType().isVersionConflictForReads(versionValue.version, get.version())) {
                            throw new VersionConflictEngineException(this.shardId, get.id(), get.versionType().explainConflictForReads(versionValue.version, get.version()));
                        }
                        if (get.getIfSeqNo() != -2L && (get.getIfSeqNo() != versionValue.seqNo || get.getIfPrimaryTerm() != versionValue.term)) {
                            throw new VersionConflictEngineException(this.shardId, get.id(), get.getIfSeqNo(), get.getIfPrimaryTerm(), versionValue.seqNo, versionValue.term);
                        }
                        if (get.isReadFromTranslog()) {
                            if (versionValue.getLocation() != null) {
                                try {
                                    Translog.Operation operation = this.translog.readOperation(versionValue.getLocation());
                                    if (operation != null) {
                                        Translog.Index index = (Translog.Index)operation;
                                        TranslogLeafReader reader = new TranslogLeafReader(index);
                                        Engine.GetResult getResult = new Engine.GetResult(new Engine.Searcher("realtime_get", (IndexReader)reader, IndexSearcher.getDefaultSimilarity(), null, IndexSearcher.getDefaultQueryCachingPolicy(), (Closeable)((Object)reader)), new VersionsAndSeqNoResolver.DocIdAndVersion(0, index.version(), index.seqNo(), index.primaryTerm(), reader, 0));
                                        return getResult;
                                    }
                                    break block28;
                                }
                                catch (IOException e) {
                                    this.maybeFailEngine("realtime_get", e);
                                    throw new EngineException(this.shardId, "failed to read operation from translog", e, new Object[0]);
                                }
                            }
                            this.trackTranslogLocation.set(true);
                        }
                    }
                    assert (versionValue.seqNo >= 0L) : versionValue;
                    this.refreshIfNeeded("realtime_get", versionValue.seqNo);
                }
                scope = Engine.SearcherScope.INTERNAL;
            } else {
                scope = Engine.SearcherScope.EXTERNAL;
            }
            Engine.GetResult getResult = this.getFromSearcher(get, searcherFactory, scope);
            return getResult;
        }
    }

    private static OpVsLuceneDocStatus compareOpToVersionMapOnSeqNo(String id, long seqNo, long primaryTerm, VersionValue versionValue) {
        Objects.requireNonNull(versionValue);
        if (seqNo > versionValue.seqNo) {
            return OpVsLuceneDocStatus.OP_NEWER;
        }
        if (seqNo == versionValue.seqNo) {
            assert (versionValue.term == primaryTerm) : "primary term not matched; id=" + id + " seq_no=" + seqNo + " op_term=" + primaryTerm + " existing_term=" + versionValue.term;
            return OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
        }
        return OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
    }

    private OpVsLuceneDocStatus compareOpToLuceneDocBasedOnSeqNo(Engine.Operation op) throws IOException {
        OpVsLuceneDocStatus status;
        assert (op.seqNo() != -2L) : "resolving ops based on seq# but no seqNo is found";
        VersionValue versionValue = this.getVersionFromMap(op.uid().bytes());
        assert (this.incrementVersionLookup());
        if (versionValue != null) {
            status = InternalEngine.compareOpToVersionMapOnSeqNo(op.id(), op.seqNo(), op.primaryTerm(), versionValue);
        } else {
            assert (this.incrementIndexVersionLookup());
            try (Engine.Searcher searcher = this.acquireSearcher("load_seq_no", Engine.SearcherScope.INTERNAL);){
                VersionsAndSeqNoResolver.DocIdAndSeqNo docAndSeqNo = VersionsAndSeqNoResolver.loadDocIdAndSeqNo(searcher.getIndexReader(), op.uid());
                if (docAndSeqNo == null) {
                    status = OpVsLuceneDocStatus.LUCENE_DOC_NOT_FOUND;
                } else if (op.seqNo() > docAndSeqNo.seqNo) {
                    status = OpVsLuceneDocStatus.OP_NEWER;
                } else if (op.seqNo() == docAndSeqNo.seqNo) {
                    assert (this.localCheckpointTracker.hasProcessed(op.seqNo()) || !this.softDeleteEnabled) : "local checkpoint tracker is not updated seq_no=" + op.seqNo() + " id=" + op.id();
                    status = OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
                } else {
                    status = OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
                }
            }
        }
        return status;
    }

    private VersionValue resolveDocVersion(Engine.Operation op, boolean loadSeqNo) throws IOException {
        assert (this.incrementVersionLookup());
        VersionValue versionValue = this.getVersionFromMap(op.uid().bytes());
        if (versionValue == null) {
            VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion;
            assert (this.incrementIndexVersionLookup());
            try (Engine.Searcher searcher = this.acquireSearcher("load_version", Engine.SearcherScope.INTERNAL);){
                docIdAndVersion = VersionsAndSeqNoResolver.loadDocIdAndVersion(searcher.getIndexReader(), op.uid(), loadSeqNo);
            }
            if (docIdAndVersion != null) {
                versionValue = new IndexVersionValue(null, docIdAndVersion.version, docIdAndVersion.seqNo, docIdAndVersion.primaryTerm);
            }
        } else if (this.engineConfig.isEnableGcDeletes() && versionValue.isDelete() && this.engineConfig.getThreadPool().relativeTimeInMillis() - ((DeleteVersionValue)versionValue).time > this.getGcDeletesInMillis()) {
            versionValue = null;
        }
        return versionValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VersionValue getVersionFromMap(BytesRef id) {
        if (this.versionMap.isUnsafe()) {
            LiveVersionMap liveVersionMap = this.versionMap;
            synchronized (liveVersionMap) {
                if (this.versionMap.isUnsafe()) {
                    this.refresh("unsafe_version_map", Engine.SearcherScope.INTERNAL, true);
                }
                this.versionMap.enforceSafeAccess();
            }
        }
        return this.versionMap.getUnderLock(id);
    }

    private boolean canOptimizeAddDocument(Engine.Index index) {
        if (index.getAutoGeneratedIdTimestamp() != -1L) {
            assert (index.getAutoGeneratedIdTimestamp() >= 0L) : "autoGeneratedIdTimestamp must be positive but was: " + index.getAutoGeneratedIdTimestamp();
            switch (index.origin()) {
                case PRIMARY: {
                    assert (this.assertPrimaryCanOptimizeAddDocument(index));
                    return true;
                }
                case PEER_RECOVERY: 
                case REPLICA: {
                    assert (index.version() == 1L && index.versionType() == null) : "version: " + index.version() + " type: " + index.versionType();
                    return true;
                }
                case LOCAL_TRANSLOG_RECOVERY: 
                case LOCAL_RESET: {
                    assert (index.isRetry());
                    return true;
                }
            }
            throw new IllegalArgumentException("unknown origin " + (Object)((Object)index.origin()));
        }
        return false;
    }

    protected boolean assertPrimaryCanOptimizeAddDocument(Engine.Index index) {
        assert ((index.version() == -4L || index.version() == -3L) && index.versionType() == VersionType.INTERNAL) : "version: " + index.version() + " type: " + index.versionType();
        return true;
    }

    private boolean assertIncomingSequenceNumber(Engine.Operation.Origin origin, long seqNo) {
        if (origin == Engine.Operation.Origin.PRIMARY) {
            assert (this.assertPrimaryIncomingSequenceNumber(origin, seqNo));
        } else assert (seqNo >= 0L) : "recovery or replica ops should have an assigned seq no.; origin: " + (Object)((Object)origin);
        return true;
    }

    protected boolean assertPrimaryIncomingSequenceNumber(Engine.Operation.Origin origin, long seqNo) {
        assert (seqNo == -2L) : "primary operations must never have an assigned sequence number but was [" + seqNo + "]";
        return true;
    }

    protected long generateSeqNoForOperationOnPrimary(Engine.Operation operation) {
        assert (operation.origin() == Engine.Operation.Origin.PRIMARY);
        assert (operation.seqNo() == -2L) : "ops should not have an assigned seq no. but was: " + operation.seqNo();
        return this.doGenerateSeqNoForOperation(operation);
    }

    protected void advanceMaxSeqNoOfUpdatesOrDeletesOnPrimary(long seqNo) {
        this.advanceMaxSeqNoOfUpdatesOrDeletes(seqNo);
    }

    long doGenerateSeqNoForOperation(Engine.Operation operation) {
        return this.localCheckpointTracker.generateSeqNo();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Engine.IndexResult index(Engine.Index index) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final IndexingStrategy planIndexingAsNonPrimary(Engine.Index index) throws IOException {
        IndexingStrategy plan;
        assert (this.assertNonPrimaryOrigin(index));
        if (this.canOptimizeAddDocument(index)) {
            this.mayHaveBeenIndexedBefore(index);
        }
        long maxSeqNoOfUpdatesOrDeletes = this.getMaxSeqNoOfUpdatesOrDeletes();
        if (this.hasBeenProcessedBefore(index)) {
            plan = IndexingStrategy.processButSkipLucene(false, index.version());
        } else if (maxSeqNoOfUpdatesOrDeletes <= this.localCheckpointTracker.getProcessedCheckpoint()) {
            assert (maxSeqNoOfUpdatesOrDeletes < index.seqNo()) : index.seqNo() + ">=" + maxSeqNoOfUpdatesOrDeletes;
            plan = IndexingStrategy.optimizedAppendOnly(index.version());
        } else {
            this.versionMap.enforceSafeAccess();
            OpVsLuceneDocStatus opVsLucene = this.compareOpToLuceneDocBasedOnSeqNo(index);
            plan = opVsLucene == OpVsLuceneDocStatus.OP_STALE_OR_EQUAL ? IndexingStrategy.processAsStaleOp(this.softDeleteEnabled, index.version()) : IndexingStrategy.processNormally(opVsLucene == OpVsLuceneDocStatus.LUCENE_DOC_NOT_FOUND, index.version());
        }
        return plan;
    }

    protected IndexingStrategy indexingStrategyForOperation(Engine.Index index) throws IOException {
        if (index.origin() == Engine.Operation.Origin.PRIMARY) {
            return this.planIndexingAsPrimary(index);
        }
        return this.planIndexingAsNonPrimary(index);
    }

    private IndexingStrategy planIndexingAsPrimary(Engine.Index index) throws IOException {
        IndexingStrategy plan;
        assert (index.origin() == Engine.Operation.Origin.PRIMARY) : "planing as primary but origin isn't. got " + (Object)((Object)index.origin());
        boolean canOptimizeAddDocument = this.canOptimizeAddDocument(index);
        if (canOptimizeAddDocument && !this.mayHaveBeenIndexedBefore(index)) {
            plan = IndexingStrategy.optimizedAppendOnly(1L);
        } else {
            boolean currentNotFoundOrDeleted;
            long currentVersion;
            this.versionMap.enforceSafeAccess();
            VersionValue versionValue = this.resolveDocVersion(index, index.getIfSeqNo() != -2L);
            if (versionValue == null) {
                currentVersion = -1L;
                currentNotFoundOrDeleted = true;
            } else {
                currentVersion = versionValue.version;
                currentNotFoundOrDeleted = versionValue.isDelete();
            }
            if (index.getIfSeqNo() != -2L && versionValue == null) {
                VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, index.id(), index.getIfSeqNo(), index.getIfPrimaryTerm(), -2L, 0L);
                plan = IndexingStrategy.skipDueToVersionConflict(e, true, currentVersion);
            } else if (index.getIfSeqNo() != -2L && (versionValue.seqNo != index.getIfSeqNo() || versionValue.term != index.getIfPrimaryTerm())) {
                VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, index.id(), index.getIfSeqNo(), index.getIfPrimaryTerm(), versionValue.seqNo, versionValue.term);
                plan = IndexingStrategy.skipDueToVersionConflict(e, currentNotFoundOrDeleted, currentVersion);
            } else if (index.versionType().isVersionConflictForWrites(currentVersion, index.version(), currentNotFoundOrDeleted)) {
                VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, index, currentVersion, currentNotFoundOrDeleted);
                plan = IndexingStrategy.skipDueToVersionConflict(e, currentNotFoundOrDeleted, currentVersion);
            } else {
                plan = IndexingStrategy.processNormally(currentNotFoundOrDeleted, canOptimizeAddDocument ? 1L : index.versionType().updateVersion(currentVersion, index.version()));
            }
        }
        return plan;
    }

    private Engine.IndexResult indexIntoLucene(Engine.Index index, IndexingStrategy plan) throws IOException {
        assert (index.seqNo() >= 0L) : "ops should have an assigned seq no.; origin: " + (Object)((Object)index.origin());
        assert (plan.versionForIndexing >= 0L) : "version must be set. got " + plan.versionForIndexing;
        assert (plan.indexIntoLucene || plan.addStaleOpToLucene);
        index.parsedDoc().updateSeqID(index.seqNo(), index.primaryTerm());
        index.parsedDoc().version().setLongValue(plan.versionForIndexing);
        try {
            if (plan.addStaleOpToLucene) {
                this.addStaleDocs(index.docs(), this.indexWriter);
            } else if (plan.useLuceneUpdateDocument) {
                assert (this.assertMaxSeqNoOfUpdatesIsAdvanced(index.uid(), index.seqNo(), true, true));
                this.updateDocs(index.uid(), index.docs(), this.indexWriter);
            } else {
                assert (this.assertDocDoesNotExist(index, !this.canOptimizeAddDocument(index)));
                this.addDocs(index.docs(), this.indexWriter);
            }
            return new Engine.IndexResult(plan.versionForIndexing, index.primaryTerm(), index.seqNo(), plan.currentNotFoundOrDeleted);
        }
        catch (Exception ex) {
            if (!(ex instanceof AlreadyClosedException) && this.indexWriter.getTragicException() == null && !this.treatDocumentFailureAsTragicError(index)) {
                return new Engine.IndexResult(ex, -3L, index.primaryTerm(), index.seqNo());
            }
            throw ex;
        }
    }

    private boolean treatDocumentFailureAsTragicError(Engine.Index index) {
        return index.origin() == Engine.Operation.Origin.REPLICA || index.origin() == Engine.Operation.Origin.PEER_RECOVERY || index.origin() == Engine.Operation.Origin.LOCAL_RESET;
    }

    private boolean mayHaveBeenIndexedBefore(Engine.Index index) {
        boolean mayHaveBeenIndexBefore;
        assert (this.canOptimizeAddDocument(index));
        if (index.isRetry()) {
            mayHaveBeenIndexBefore = true;
            this.updateAutoIdTimestamp(index.getAutoGeneratedIdTimestamp(), true);
            assert (this.maxUnsafeAutoIdTimestamp.get() >= index.getAutoGeneratedIdTimestamp());
        } else {
            mayHaveBeenIndexBefore = this.maxUnsafeAutoIdTimestamp.get() >= index.getAutoGeneratedIdTimestamp();
            this.updateAutoIdTimestamp(index.getAutoGeneratedIdTimestamp(), false);
        }
        return mayHaveBeenIndexBefore;
    }

    private void addDocs(List<ParseContext.Document> docs, IndexWriter indexWriter) throws IOException {
        if (docs.size() > 1) {
            indexWriter.addDocuments(docs);
        } else {
            indexWriter.addDocument((Iterable)docs.get(0));
        }
        this.numDocAppends.inc(docs.size());
    }

    private void addStaleDocs(List<ParseContext.Document> docs, IndexWriter indexWriter) throws IOException {
        assert (this.softDeleteEnabled) : "Add history documents but soft-deletes is disabled";
        for (ParseContext.Document doc : docs) {
            doc.add((IndexableField)this.softDeletesField);
        }
        if (docs.size() > 1) {
            indexWriter.addDocuments(docs);
        } else {
            indexWriter.addDocument((Iterable)docs.get(0));
        }
    }

    private boolean assertDocDoesNotExist(Engine.Index index, boolean allowDeleted) throws IOException {
        VersionValue versionValue = this.versionMap.getVersionForAssert(index.uid().bytes());
        if (versionValue != null) {
            if (!versionValue.isDelete() || !allowDeleted) {
                throw new AssertionError((Object)("doc [" + index.type() + "][" + index.id() + "] exists in version map (version " + versionValue + ")"));
            }
        } else {
            try (Engine.Searcher searcher = this.acquireSearcher("assert doc doesn't exist", Engine.SearcherScope.INTERNAL);){
                long docsWithId = searcher.count((Query)new TermQuery(index.uid()));
                if (docsWithId > 0L) {
                    throw new AssertionError((Object)("doc [" + index.type() + "][" + index.id() + "] exists [" + docsWithId + "] times in index"));
                }
            }
        }
        return true;
    }

    private void updateDocs(Term uid, List<ParseContext.Document> docs, IndexWriter indexWriter) throws IOException {
        if (this.softDeleteEnabled) {
            if (docs.size() > 1) {
                indexWriter.softUpdateDocuments(uid, docs, new Field[]{this.softDeletesField});
            } else {
                indexWriter.softUpdateDocument(uid, (Iterable)docs.get(0), new Field[]{this.softDeletesField});
            }
        } else if (docs.size() > 1) {
            indexWriter.updateDocuments(uid, docs);
        } else {
            indexWriter.updateDocument(uid, (Iterable)docs.get(0));
        }
        this.numDocUpdates.inc(docs.size());
    }

    @Override
    public Engine.DeleteResult delete(Engine.Delete delete) throws IOException {
        Engine.DeleteResult deleteResult;
        this.versionMap.enforceSafeAccess();
        assert (Objects.equals(delete.uid().field(), "_id")) : delete.uid().field();
        assert (this.assertIncomingSequenceNumber(delete.origin(), delete.seqNo()));
        try (ReleasableLock ignored = this.readLock.acquire();
             Releasable ignored2 = this.versionMap.acquireLock(delete.uid().bytes());){
            this.ensureOpen();
            this.lastWriteNanos = delete.startTime();
            DeletionStrategy plan = this.deletionStrategyForOperation(delete);
            if (plan.earlyResultOnPreflightError.isPresent()) {
                deleteResult = plan.earlyResultOnPreflightError.get();
            } else {
                if (delete.origin() == Engine.Operation.Origin.PRIMARY) {
                    delete = new Engine.Delete(delete.type(), delete.id(), delete.uid(), this.generateSeqNoForOperationOnPrimary(delete), delete.primaryTerm(), delete.version(), delete.versionType(), delete.origin(), delete.startTime(), delete.getIfSeqNo(), delete.getIfPrimaryTerm());
                    this.advanceMaxSeqNoOfUpdatesOrDeletesOnPrimary(delete.seqNo());
                } else {
                    this.markSeqNoAsSeen(delete.seqNo());
                }
                assert (delete.seqNo() >= 0L) : "ops should have an assigned seq no.; origin: " + (Object)((Object)delete.origin());
                deleteResult = plan.deleteFromLucene || plan.addStaleOpToLucene ? this.deleteInLucene(delete, plan) : new Engine.DeleteResult(plan.versionOfDeletion, delete.primaryTerm(), delete.seqNo(), !plan.currentlyDeleted);
            }
            if (!delete.origin().isFromTranslog() && deleteResult.getResultType() == Engine.Result.Type.SUCCESS) {
                Translog.Location location = this.translog.add(new Translog.Delete(delete, deleteResult));
                deleteResult.setTranslogLocation(location);
            }
            this.localCheckpointTracker.markSeqNoAsProcessed(deleteResult.getSeqNo());
            if (deleteResult.getTranslogLocation() == null) {
                assert (delete.origin().isFromTranslog() || deleteResult.getSeqNo() == -2L);
                this.localCheckpointTracker.markSeqNoAsPersisted(deleteResult.getSeqNo());
            }
            deleteResult.setTook(System.nanoTime() - delete.startTime());
            deleteResult.freeze();
        }
        catch (IOException | RuntimeException e) {
            try {
                this.maybeFailEngine("delete", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
        this.maybePruneDeletes();
        return deleteResult;
    }

    protected DeletionStrategy deletionStrategyForOperation(Engine.Delete delete) throws IOException {
        if (delete.origin() == Engine.Operation.Origin.PRIMARY) {
            return this.planDeletionAsPrimary(delete);
        }
        return this.planDeletionAsNonPrimary(delete);
    }

    protected final DeletionStrategy planDeletionAsNonPrimary(Engine.Delete delete) throws IOException {
        OpVsLuceneDocStatus opVsLucene;
        assert (this.assertNonPrimaryOrigin(delete));
        DeletionStrategy plan = this.hasBeenProcessedBefore(delete) ? DeletionStrategy.processButSkipLucene(false, delete.version()) : ((opVsLucene = this.compareOpToLuceneDocBasedOnSeqNo(delete)) == OpVsLuceneDocStatus.OP_STALE_OR_EQUAL ? DeletionStrategy.processAsStaleOp(this.softDeleteEnabled, delete.version()) : DeletionStrategy.processNormally(opVsLucene == OpVsLuceneDocStatus.LUCENE_DOC_NOT_FOUND, delete.version()));
        return plan;
    }

    protected boolean assertNonPrimaryOrigin(Engine.Operation operation) {
        assert (operation.origin() != Engine.Operation.Origin.PRIMARY) : "planing as primary but got " + (Object)((Object)operation.origin());
        return true;
    }

    private DeletionStrategy planDeletionAsPrimary(Engine.Delete delete) throws IOException {
        DeletionStrategy plan;
        boolean currentlyDeleted;
        long currentVersion;
        assert (delete.origin() == Engine.Operation.Origin.PRIMARY) : "planing as primary but got " + (Object)((Object)delete.origin());
        VersionValue versionValue = this.resolveDocVersion(delete, delete.getIfSeqNo() != -2L);
        assert (this.incrementVersionLookup());
        if (versionValue == null) {
            currentVersion = -1L;
            currentlyDeleted = true;
        } else {
            currentVersion = versionValue.version;
            currentlyDeleted = versionValue.isDelete();
        }
        if (delete.getIfSeqNo() != -2L && versionValue == null) {
            VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, delete.id(), delete.getIfSeqNo(), delete.getIfPrimaryTerm(), -2L, 0L);
            plan = DeletionStrategy.skipDueToVersionConflict(e, currentVersion, true);
        } else if (delete.getIfSeqNo() != -2L && (versionValue.seqNo != delete.getIfSeqNo() || versionValue.term != delete.getIfPrimaryTerm())) {
            VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, delete.id(), delete.getIfSeqNo(), delete.getIfPrimaryTerm(), versionValue.seqNo, versionValue.term);
            plan = DeletionStrategy.skipDueToVersionConflict(e, currentVersion, currentlyDeleted);
        } else if (delete.versionType().isVersionConflictForWrites(currentVersion, delete.version(), currentlyDeleted)) {
            VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, delete, currentVersion, currentlyDeleted);
            plan = DeletionStrategy.skipDueToVersionConflict(e, currentVersion, currentlyDeleted);
        } else {
            plan = DeletionStrategy.processNormally(currentlyDeleted, delete.versionType().updateVersion(currentVersion, delete.version()));
        }
        return plan;
    }

    private Engine.DeleteResult deleteInLucene(Engine.Delete delete, DeletionStrategy plan) throws IOException {
        assert (this.assertMaxSeqNoOfUpdatesIsAdvanced(delete.uid(), delete.seqNo(), false, false));
        try {
            if (this.softDeleteEnabled) {
                ParsedDocument tombstone = this.engineConfig.getTombstoneDocSupplier().newDeleteTombstoneDoc(delete.type(), delete.id());
                assert (tombstone.docs().size() == 1) : "Tombstone doc should have single doc [" + tombstone + "]";
                tombstone.updateSeqID(delete.seqNo(), delete.primaryTerm());
                tombstone.version().setLongValue(plan.versionOfDeletion);
                ParseContext.Document doc = tombstone.docs().get(0);
                assert (doc.getField("_tombstone") != null) : "Delete tombstone document but _tombstone field is not set [" + doc + " ]";
                doc.add((IndexableField)this.softDeletesField);
                if (plan.addStaleOpToLucene || plan.currentlyDeleted) {
                    this.indexWriter.addDocument((Iterable)doc);
                } else {
                    this.indexWriter.softUpdateDocument(delete.uid(), (Iterable)doc, new Field[]{this.softDeletesField});
                }
            } else if (!plan.currentlyDeleted) {
                this.indexWriter.deleteDocuments(new Term[]{delete.uid()});
            }
            if (plan.deleteFromLucene) {
                this.numDocDeletes.inc();
                this.versionMap.putDeleteUnderLock(delete.uid().bytes(), new DeleteVersionValue(plan.versionOfDeletion, delete.seqNo(), delete.primaryTerm(), this.engineConfig.getThreadPool().relativeTimeInMillis()));
            }
            return new Engine.DeleteResult(plan.versionOfDeletion, delete.primaryTerm(), delete.seqNo(), !plan.currentlyDeleted);
        }
        catch (Exception ex) {
            if (!(ex instanceof AlreadyClosedException) && this.indexWriter.getTragicException() == null) {
                String reason = String.format(Locale.ROOT, "delete id[%s] origin [%s] seq#[%d] failed at the document level", new Object[]{delete.id(), delete.origin(), delete.seqNo()});
                this.failEngine(reason, ex);
            }
            throw ex;
        }
    }

    @Override
    public void maybePruneDeletes() {
        if (this.engineConfig.isEnableGcDeletes() && (double)(this.engineConfig.getThreadPool().relativeTimeInMillis() - this.lastDeleteVersionPruneTimeMSec) > (double)this.getGcDeletesInMillis() * 0.25) {
            this.pruneDeletedTombstones();
        }
    }

    @Override
    public Engine.NoOpResult noOp(Engine.NoOp noOp) throws IOException {
        Engine.NoOpResult noOpResult;
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            noOpResult = this.innerNoOp(noOp);
        }
        catch (Exception e) {
            try {
                this.maybeFailEngine("noop", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
        return noOpResult;
    }

    private Engine.NoOpResult innerNoOp(Engine.NoOp noOp) throws IOException {
        assert (this.readLock.isHeldByCurrentThread() || this.writeLock.isHeldByCurrentThread());
        assert (noOp.seqNo() > -1L);
        long seqNo = noOp.seqNo();
        try (Releasable ignored = this.noOpKeyedLock.acquire(seqNo);){
            Engine.NoOpResult noOpResult;
            Optional<Exception> preFlightError = this.preFlightCheckForNoOp(noOp);
            if (preFlightError.isPresent()) {
                noOpResult = new Engine.NoOpResult(0L, -2L, preFlightError.get());
            } else {
                this.markSeqNoAsSeen(noOp.seqNo());
                if (this.softDeleteEnabled && !this.hasBeenProcessedBefore(noOp)) {
                    try {
                        ParsedDocument tombstone = this.engineConfig.getTombstoneDocSupplier().newNoopTombstoneDoc(noOp.reason());
                        tombstone.updateSeqID(noOp.seqNo(), noOp.primaryTerm());
                        tombstone.version().setLongValue(1L);
                        assert (tombstone.docs().size() == 1) : "Tombstone should have a single doc [" + tombstone + "]";
                        ParseContext.Document doc = tombstone.docs().get(0);
                        assert (doc.getField("_tombstone") != null) : "Noop tombstone document but _tombstone field is not set [" + doc + " ]";
                        doc.add((IndexableField)this.softDeletesField);
                        this.indexWriter.addDocument((Iterable)doc);
                    }
                    catch (Exception ex) {
                        if (!(ex instanceof AlreadyClosedException) && this.indexWriter.getTragicException() == null) {
                            this.failEngine("no-op origin[" + (Object)((Object)noOp.origin()) + "] seq#[" + noOp.seqNo() + "] failed at document level", ex);
                        }
                        throw ex;
                    }
                }
                noOpResult = new Engine.NoOpResult(noOp.primaryTerm(), noOp.seqNo());
                if (!noOp.origin().isFromTranslog() && noOpResult.getResultType() == Engine.Result.Type.SUCCESS) {
                    Translog.Location location = this.translog.add(new Translog.NoOp(noOp.seqNo(), noOp.primaryTerm(), noOp.reason()));
                    noOpResult.setTranslogLocation(location);
                }
            }
            this.localCheckpointTracker.markSeqNoAsProcessed(noOpResult.getSeqNo());
            if (noOpResult.getTranslogLocation() == null) {
                assert (noOp.origin().isFromTranslog() || noOpResult.getSeqNo() == -2L);
                this.localCheckpointTracker.markSeqNoAsPersisted(noOpResult.getSeqNo());
            }
            noOpResult.setTook(System.nanoTime() - noOp.startTime());
            noOpResult.freeze();
            Engine.NoOpResult noOpResult2 = noOpResult;
            return noOpResult2;
        }
    }

    protected Optional<Exception> preFlightCheckForNoOp(Engine.NoOp noOp) throws IOException {
        return Optional.empty();
    }

    @Override
    public void refresh(String source) throws EngineException {
        this.refresh(source, Engine.SearcherScope.EXTERNAL, true);
    }

    @Override
    public boolean maybeRefresh(String source) throws EngineException {
        return this.refresh(source, Engine.SearcherScope.EXTERNAL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean refresh(String source, Engine.SearcherScope scope, boolean block) throws EngineException {
        boolean refreshed;
        long localCheckpointBeforeRefresh;
        block14: {
            localCheckpointBeforeRefresh = this.localCheckpointTracker.getProcessedCheckpoint();
            try {
                if (this.store.tryIncRef()) {
                    try {
                        ReferenceManager<ElasticsearchDirectoryReader> referenceManager = this.getReferenceManager(scope);
                        if (block) {
                            referenceManager.maybeRefreshBlocking();
                            refreshed = true;
                        } else {
                            refreshed = referenceManager.maybeRefresh();
                        }
                    }
                    finally {
                        this.store.decRef();
                    }
                    if (refreshed) {
                        this.lastRefreshedCheckpointListener.updateRefreshedCheckpoint(localCheckpointBeforeRefresh);
                    }
                    break block14;
                }
                refreshed = false;
            }
            catch (AlreadyClosedException e) {
                this.failOnTragicEvent(e);
                throw e;
            }
            catch (Exception e) {
                try {
                    this.failEngine("refresh failed source[" + source + "]", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
            }
        }
        assert (!refreshed || this.lastRefreshedCheckpoint() >= localCheckpointBeforeRefresh) : "refresh checkpoint was not advanced; local_checkpoint=" + localCheckpointBeforeRefresh + " refresh_checkpoint=" + this.lastRefreshedCheckpoint();
        this.maybePruneDeletes();
        this.mergeScheduler.refreshConfig();
        return refreshed;
    }

    @Override
    public void writeIndexingBuffer() throws EngineException {
        this.refresh("write indexing buffer", Engine.SearcherScope.INTERNAL, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Engine.SyncedFlushResult syncFlush(String syncId, Engine.CommitId expectedCommitId) throws EngineException {
        this.ensureOpen();
        if (this.indexWriter.hasUncommittedChanges()) {
            this.logger.trace("can't sync commit [{}]. have pending changes", (Object)syncId);
            return Engine.SyncedFlushResult.PENDING_OPERATIONS;
        }
        if (!expectedCommitId.idsEqual(this.lastCommittedSegmentInfos.getId())) {
            this.logger.trace("can't sync commit [{}]. current commit id is not equal to expected.", (Object)syncId);
            return Engine.SyncedFlushResult.COMMIT_MISMATCH;
        }
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            this.ensureCanFlush();
            this.refresh("sync_flush", Engine.SearcherScope.INTERNAL, true);
            if (this.indexWriter.hasUncommittedChanges()) {
                this.logger.trace("can't sync commit [{}]. have pending changes", (Object)syncId);
                Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.PENDING_OPERATIONS;
                return syncedFlushResult;
            }
            if (!expectedCommitId.idsEqual(this.lastCommittedSegmentInfos.getId())) {
                this.logger.trace("can't sync commit [{}]. current commit id is not equal to expected.", (Object)syncId);
                Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.COMMIT_MISMATCH;
                return syncedFlushResult;
            }
            this.logger.trace("starting sync commit [{}]", (Object)syncId);
            this.commitIndexWriter(this.indexWriter, this.translog, syncId);
            this.logger.debug("successfully sync committed. sync id [{}].", (Object)syncId);
            this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
            Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.SUCCESS;
            return syncedFlushResult;
        }
        catch (IOException ex) {
            this.maybeFailEngine("sync commit", ex);
            throw new EngineException(this.shardId, "failed to sync commit", ex, new Object[0]);
        }
    }

    final boolean tryRenewSyncCommit() {
        boolean renewed = false;
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            this.ensureCanFlush();
            String syncId = (String)this.lastCommittedSegmentInfos.getUserData().get("sync_id");
            long translogGenOfLastCommit = Long.parseLong((String)this.lastCommittedSegmentInfos.userData.get("translog_generation"));
            if (syncId != null && this.indexWriter.hasUncommittedChanges() && this.translog.totalOperationsByMinGen(translogGenOfLastCommit) == 0) {
                this.logger.trace("start renewing sync commit [{}]", (Object)syncId);
                this.commitIndexWriter(this.indexWriter, this.translog, syncId);
                this.logger.debug("successfully sync committed. sync id [{}].", (Object)syncId);
                this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
                renewed = true;
            }
        }
        catch (IOException ex) {
            this.maybeFailEngine("renew sync commit", ex);
            throw new EngineException(this.shardId, "failed to renew sync commit", ex, new Object[0]);
        }
        if (renewed) {
            this.refresh("renew sync commit", Engine.SearcherScope.INTERNAL, true);
        }
        return renewed;
    }

    @Override
    public boolean shouldPeriodicallyFlush() {
        this.ensureOpen();
        if (this.shouldPeriodicallyFlushAfterBigMerge.get()) {
            return true;
        }
        long translogGenerationOfLastCommit = Long.parseLong((String)this.lastCommittedSegmentInfos.userData.get("translog_generation"));
        long flushThreshold = this.config().getIndexSettings().getFlushThresholdSize().getBytes();
        if (this.translog.sizeInBytesByMinGen(translogGenerationOfLastCommit) < flushThreshold) {
            return false;
        }
        long translogGenerationOfNewCommit = this.translog.getMinGenerationForSeqNo((long)(this.localCheckpointTracker.getProcessedCheckpoint() + 1L)).translogFileGeneration;
        return translogGenerationOfLastCommit < translogGenerationOfNewCommit || this.localCheckpointTracker.getProcessedCheckpoint() == this.localCheckpointTracker.getMaxSeqNo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Engine.CommitId flush(boolean force, boolean waitIfOngoing) throws EngineException {
        byte[] newCommitId;
        this.ensureOpen();
        if (force && !waitIfOngoing) {
            if ($assertionsDisabled) throw new IllegalArgumentException("wait_if_ongoing must be true for a force flush: force=" + force + " wait_if_ongoing=" + waitIfOngoing);
            throw new AssertionError((Object)("wait_if_ongoing must be true for a force flush: force=" + force + " wait_if_ongoing=" + waitIfOngoing));
        }
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            if (!this.flushLock.tryLock()) {
                if (!waitIfOngoing) {
                    Engine.CommitId commitId = new Engine.CommitId(this.lastCommittedSegmentInfos.getId());
                    return commitId;
                }
                this.logger.trace("waiting for in-flight flush to finish");
                this.flushLock.lock();
                this.logger.trace("acquired flush lock after blocking");
            } else {
                this.logger.trace("acquired flush lock immediately");
            }
            try {
                boolean hasUncommittedChanges = this.indexWriter.hasUncommittedChanges();
                boolean shouldPeriodicallyFlush = this.shouldPeriodicallyFlush();
                if (hasUncommittedChanges || force || shouldPeriodicallyFlush) {
                    this.ensureCanFlush();
                    try {
                        this.translog.rollGeneration();
                        this.logger.trace("starting commit for flush; commitTranslog=true");
                        this.commitIndexWriter(this.indexWriter, this.translog, null);
                        this.logger.trace("finished commit for flush");
                        this.logger.debug("new commit on flush, hasUncommittedChanges:{}, force:{}, shouldPeriodicallyFlush:{}", (Object)hasUncommittedChanges, (Object)force, (Object)shouldPeriodicallyFlush);
                        this.refresh("version_table_flush", Engine.SearcherScope.INTERNAL, true);
                        this.translog.trimUnreferencedReaders();
                    }
                    catch (AlreadyClosedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                    }
                    this.refreshLastCommittedSegmentInfos();
                }
                newCommitId = this.lastCommittedSegmentInfos.getId();
            }
            catch (FlushFailedEngineException ex) {
                this.maybeFailEngine("flush", ex);
                throw ex;
            }
            finally {
                this.flushLock.unlock();
            }
        }
        if (!this.engineConfig.isEnableGcDeletes()) return new Engine.CommitId(newCommitId);
        this.pruneDeletedTombstones();
        return new Engine.CommitId(newCommitId);
    }

    private void refreshLastCommittedSegmentInfos() {
        block8: {
            this.store.incRef();
            try {
                this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
            }
            catch (Exception e) {
                if (this.isClosed.get()) break block8;
                try {
                    this.logger.warn("failed to read latest segment infos on flush", (Throwable)e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                if (Lucene.isCorruptionException(e)) {
                    throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                }
            }
            finally {
                this.store.decRef();
            }
        }
    }

    @Override
    public void rollTranslogGeneration() throws EngineException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            this.translog.rollGeneration();
            this.translog.trimUnreferencedReaders();
        }
        catch (AlreadyClosedException e) {
            this.failOnTragicEvent(e);
            throw e;
        }
        catch (Exception e) {
            try {
                this.failEngine("translog trimming failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new EngineException(this.shardId, "failed to roll translog", e, new Object[0]);
        }
    }

    @Override
    public void trimUnreferencedTranslogFiles() throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.translog.trimUnreferencedReaders();
        }
        catch (AlreadyClosedException e) {
            this.failOnTragicEvent(e);
            throw e;
        }
        catch (Exception e) {
            try {
                this.failEngine("translog trimming failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new EngineException(this.shardId, "failed to trim translog", e, new Object[0]);
        }
    }

    @Override
    public boolean shouldRollTranslogGeneration() {
        return this.getTranslog().shouldRollGeneration();
    }

    @Override
    public void trimOperationsFromTranslog(long belowTerm, long aboveSeqNo) throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.translog.trimOperations(belowTerm, aboveSeqNo);
        }
        catch (AlreadyClosedException e) {
            this.failOnTragicEvent(e);
            throw e;
        }
        catch (Exception e) {
            try {
                this.failEngine("translog operations trimming failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new EngineException(this.shardId, "failed to trim translog operations", e, new Object[0]);
        }
    }

    private void pruneDeletedTombstones() {
        long timeMSec = this.engineConfig.getThreadPool().relativeTimeInMillis();
        long maxTimestampToPrune = timeMSec - this.engineConfig.getIndexSettings().getGcDeletesInMillis();
        this.versionMap.pruneTombstones(maxTimestampToPrune, this.localCheckpointTracker.getProcessedCheckpoint());
        this.lastDeleteVersionPruneTimeMSec = timeMSec;
    }

    void clearDeletedTombstones() {
        this.versionMap.pruneTombstones(Long.MAX_VALUE, this.localCheckpointTracker.getMaxSeqNo());
    }

    final Map<BytesRef, VersionValue> getVersionMap() {
        return Stream.concat(this.versionMap.getAllCurrent().entrySet().stream(), this.versionMap.getAllTombstones().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade, boolean upgradeOnlyAncientSegments) throws EngineException, IOException {
        assert (this.indexWriter.getConfig().getMergePolicy() instanceof ElasticsearchMergePolicy) : "MergePolicy is " + this.indexWriter.getConfig().getMergePolicy().getClass().getName();
        ElasticsearchMergePolicy mp = (ElasticsearchMergePolicy)this.indexWriter.getConfig().getMergePolicy();
        this.optimizeLock.lock();
        try {
            this.ensureOpen();
            if (upgrade) {
                this.logger.info("starting segment upgrade upgradeOnlyAncientSegments={}", (Object)upgradeOnlyAncientSegments);
                mp.setUpgradeInProgress(true, upgradeOnlyAncientSegments);
            }
            this.store.incRef();
            try {
                if (onlyExpungeDeletes) {
                    assert (!upgrade);
                    this.indexWriter.forceMergeDeletes(true);
                } else if (maxNumSegments <= 0) {
                    assert (!upgrade);
                    this.indexWriter.maybeMerge();
                } else {
                    this.indexWriter.forceMerge(maxNumSegments, true);
                }
                if (flush && !this.tryRenewSyncCommit()) {
                    this.flush(false, true);
                }
                if (upgrade) {
                    this.logger.info("finished segment upgrade");
                }
            }
            finally {
                this.store.decRef();
            }
        }
        catch (AlreadyClosedException ex) {
            this.ensureOpen((Exception)((Object)ex));
            this.failOnTragicEvent(ex);
            throw ex;
        }
        catch (Exception e) {
            try {
                this.maybeFailEngine("force merge", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
        finally {
            try {
                mp.setUpgradeInProgress(false, false);
            }
            finally {
                this.optimizeLock.unlock();
            }
        }
    }

    @Override
    public Engine.IndexCommitRef acquireLastIndexCommit(boolean flushFirst) throws EngineException {
        if (flushFirst) {
            this.logger.trace("start flush for snapshot");
            this.flush(false, true);
            this.logger.trace("finish flush for snapshot");
        }
        IndexCommit lastCommit = this.combinedDeletionPolicy.acquireIndexCommit(false);
        return new Engine.IndexCommitRef(lastCommit, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.releaseIndexCommit(lastCommit)));
    }

    @Override
    public Engine.IndexCommitRef acquireSafeIndexCommit() throws EngineException {
        IndexCommit safeCommit = this.combinedDeletionPolicy.acquireIndexCommit(true);
        return new Engine.IndexCommitRef(safeCommit, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.releaseIndexCommit(safeCommit)));
    }

    private void releaseIndexCommit(IndexCommit snapshot) throws IOException {
        if (this.combinedDeletionPolicy.releaseCommit(snapshot)) {
            this.ensureOpen();
            this.indexWriter.deleteUnusedFiles();
        }
    }

    @Override
    public SafeCommitInfo getSafeCommitInfo() {
        return this.combinedDeletionPolicy.getSafeCommitInfo();
    }

    private boolean failOnTragicEvent(AlreadyClosedException ex) {
        boolean engineFailed;
        if (!this.indexWriter.isOpen() && this.indexWriter.getTragicException() != null) {
            Exception tragicException = this.indexWriter.getTragicException() instanceof Exception ? (Exception)this.indexWriter.getTragicException() : new RuntimeException(this.indexWriter.getTragicException());
            this.failEngine("already closed by tragic event on the index writer", tragicException);
            engineFailed = true;
        } else if (!this.translog.isOpen() && this.translog.getTragicException() != null) {
            this.failEngine("already closed by tragic event on the translog", this.translog.getTragicException());
            engineFailed = true;
        } else {
            if (this.failedEngine.get() == null && !this.isClosed.get()) {
                throw new AssertionError("Unexpected AlreadyClosedException", ex);
            }
            engineFailed = false;
        }
        return engineFailed;
    }

    @Override
    protected boolean maybeFailEngine(String source, Exception e) {
        boolean shouldFail = super.maybeFailEngine(source, e);
        if (shouldFail) {
            return true;
        }
        if (e instanceof AlreadyClosedException) {
            return this.failOnTragicEvent((AlreadyClosedException)((Object)e));
        }
        if (e != null && (!this.indexWriter.isOpen() && this.indexWriter.getTragicException() == e || !this.translog.isOpen() && this.translog.getTragicException() == e)) {
            this.failEngine(source, e);
            return true;
        }
        return false;
    }

    @Override
    protected SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    @Override
    protected final void writerSegmentStats(SegmentsStats stats) {
        stats.addVersionMapMemoryInBytes(this.versionMap.ramBytesUsed());
        stats.addIndexWriterMemoryInBytes(this.indexWriter.ramBytesUsed());
        stats.updateMaxUnsafeAutoIdTimestamp(this.maxUnsafeAutoIdTimestamp.get());
    }

    @Override
    public long getIndexBufferRAMBytesUsed() {
        return this.indexWriter.ramBytesUsed() + this.versionMap.ramBytesUsedForRefresh();
    }

    @Override
    public List<Segment> segments(boolean verbose) {
        try (ReleasableLock lock = this.readLock.acquire();){
            Segment[] segmentsArr = this.getSegmentInfo(this.lastCommittedSegmentInfos, verbose);
            Set<OnGoingMerge> onGoingMerges = this.mergeScheduler.onGoingMerges();
            for (OnGoingMerge onGoingMerge : onGoingMerges) {
                block6: for (SegmentCommitInfo segmentInfoPerCommit : onGoingMerge.getMergedSegments()) {
                    for (Segment segment : segmentsArr) {
                        if (!segment.getName().equals(segmentInfoPerCommit.info.name)) continue;
                        segment.mergeId = onGoingMerge.getId();
                        continue block6;
                    }
                }
            }
            List<Segment> list = Arrays.asList(segmentsArr);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void closeNoLock(String reason, CountDownLatch closedLatch) {
        if (this.isClosed.compareAndSet(false, true)) {
            assert (this.rwl.isWriteLockedByCurrentThread() || this.failEngineLock.isHeldByCurrentThread()) : "Either the write lock must be held or the engine must be currently be failing itself";
            try {
                this.versionMap.clear();
                if (this.internalReaderManager != null) {
                    this.internalReaderManager.removeListener(this.versionMap);
                }
                try {
                    IOUtils.close((Closeable[])new Closeable[]{this.externalReaderManager, this.internalReaderManager});
                }
                catch (Exception e) {
                    this.logger.warn("Failed to close ReaderManager", (Throwable)e);
                }
                try {
                    IOUtils.close((Closeable[])new Closeable[]{this.translog});
                }
                catch (Exception e) {
                    this.logger.warn("Failed to close translog", (Throwable)e);
                }
                this.logger.trace("rollback indexWriter");
                try {
                    this.indexWriter.rollback();
                }
                catch (AlreadyClosedException ex) {
                    this.failOnTragicEvent(ex);
                    throw ex;
                }
                this.logger.trace("rollback indexWriter done");
            }
            catch (Exception e) {
                this.logger.warn("failed to rollback writer on close", (Throwable)e);
            }
            finally {
                try {
                    this.store.decRef();
                    this.logger.debug("engine closed [{}]", (Object)reason);
                }
                finally {
                    closedLatch.countDown();
                }
            }
        }
    }

    @Override
    protected final ReferenceManager<ElasticsearchDirectoryReader> getReferenceManager(Engine.SearcherScope scope) {
        switch (scope) {
            case INTERNAL: {
                return this.internalReaderManager;
            }
            case EXTERNAL: {
                return this.externalReaderManager;
            }
        }
        throw new IllegalStateException("unknown scope: " + (Object)((Object)scope));
    }

    private IndexWriter createWriter() throws IOException {
        try {
            IndexWriterConfig iwc = this.getIndexWriterConfig();
            return this.createWriter(this.store.directory(), iwc);
        }
        catch (LockObtainFailedException ex) {
            this.logger.warn("could not lock IndexWriter", (Throwable)ex);
            throw ex;
        }
    }

    IndexWriter createWriter(Directory directory, IndexWriterConfig iwc) throws IOException {
        if (Assertions.ENABLED) {
            return new AssertingIndexWriter(directory, iwc);
        }
        return new IndexWriter(directory, iwc);
    }

    static Map<String, String> getReaderAttributes(Directory directory) {
        Directory unwrap = FilterDirectory.unwrap((Directory)directory);
        boolean defaultOffHeap = FsDirectoryFactory.isHybridFs(unwrap) || unwrap instanceof MMapDirectory;
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("blocktree.terms.fst", defaultOffHeap ? BlockTreeTermsReader.FSTLoadMode.OFF_HEAP.name() : BlockTreeTermsReader.FSTLoadMode.ON_HEAP.name());
        map.put("blocktree.terms.fst._id", BlockTreeTermsReader.FSTLoadMode.ON_HEAP.name());
        return Collections.unmodifiableMap(map);
    }

    private IndexWriterConfig getIndexWriterConfig() {
        IndexWriterConfig iwc = new IndexWriterConfig(this.engineConfig.getAnalyzer());
        iwc.setCommitOnClose(false);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.APPEND);
        iwc.setReaderAttributes(InternalEngine.getReaderAttributes(this.store.directory()));
        iwc.setIndexDeletionPolicy((IndexDeletionPolicy)this.combinedDeletionPolicy);
        boolean verbose = false;
        try {
            verbose = Boolean.parseBoolean(System.getProperty("tests.verbose"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        iwc.setInfoStream((InfoStream)(verbose ? InfoStream.getDefault() : new LoggerInfoStream(this.logger)));
        iwc.setMergeScheduler((MergeScheduler)this.mergeScheduler);
        Object mergePolicy = this.config().getMergePolicy();
        iwc.setSoftDeletesField("__soft_deletes");
        if (this.softDeleteEnabled) {
            mergePolicy = new RecoverySourcePruneMergePolicy("_recovery_source", this.softDeletesPolicy::getRetentionQuery, (MergePolicy)new SoftDeletesRetentionMergePolicy("__soft_deletes", this.softDeletesPolicy::getRetentionQuery, (MergePolicy)new PrunePostingsMergePolicy((MergePolicy)mergePolicy, "_id")));
        }
        iwc.setMergePolicy((MergePolicy)new ElasticsearchMergePolicy((MergePolicy)mergePolicy));
        iwc.setSimilarity(this.engineConfig.getSimilarity());
        iwc.setRAMBufferSizeMB(this.engineConfig.getIndexingBufferSize().getMbFrac());
        iwc.setCodec(this.engineConfig.getCodec());
        iwc.setUseCompoundFile(true);
        if (this.config().getIndexSort() != null) {
            iwc.setIndexSort(this.config().getIndexSort());
        }
        return iwc;
    }

    @Override
    public void activateThrottling() {
        int count = this.throttleRequestCount.incrementAndGet();
        assert (count >= 1) : "invalid post-increment throttleRequestCount=" + count;
        if (count == 1) {
            this.throttle.activate();
        }
    }

    @Override
    public void deactivateThrottling() {
        int count = this.throttleRequestCount.decrementAndGet();
        assert (count >= 0) : "invalid post-decrement throttleRequestCount=" + count;
        if (count == 0) {
            this.throttle.deactivate();
        }
    }

    @Override
    public boolean isThrottled() {
        return this.throttle.isThrottled();
    }

    @Override
    public long getIndexThrottleTimeInMillis() {
        return this.throttle.getThrottleTimeInMillis();
    }

    long getGcDeletesInMillis() {
        return this.engineConfig.getIndexSettings().getGcDeletesInMillis();
    }

    LiveIndexWriterConfig getCurrentIndexWriterConfig() {
        return this.indexWriter.getConfig();
    }

    protected void commitIndexWriter(IndexWriter writer, Translog translog, @Nullable String syncId) throws IOException {
        this.ensureCanFlush();
        try {
            long localCheckpoint = this.localCheckpointTracker.getProcessedCheckpoint();
            Translog.TranslogGeneration translogGeneration = translog.getMinGenerationForSeqNo(localCheckpoint + 1L);
            String translogFileGeneration = Long.toString(translogGeneration.translogFileGeneration);
            String translogUUID = translogGeneration.translogUUID;
            String localCheckpointValue = Long.toString(localCheckpoint);
            writer.setLiveCommitData(() -> {
                HashMap<String, String> commitData = new HashMap<String, String>(8);
                commitData.put("translog_generation", translogFileGeneration);
                commitData.put("translog_uuid", translogUUID);
                commitData.put("local_checkpoint", localCheckpointValue);
                if (syncId != null) {
                    commitData.put("sync_id", syncId);
                }
                commitData.put("max_seq_no", Long.toString(this.localCheckpointTracker.getMaxSeqNo()));
                commitData.put("max_unsafe_auto_id_timestamp", Long.toString(this.maxUnsafeAutoIdTimestamp.get()));
                commitData.put("history_uuid", this.historyUUID);
                if (this.softDeleteEnabled) {
                    commitData.put("min_retained_seq_no", Long.toString(this.softDeletesPolicy.getMinRetainedSeqNo()));
                }
                this.logger.trace("committing writer with commit data [{}]", commitData);
                return commitData.entrySet().iterator();
            });
            this.shouldPeriodicallyFlushAfterBigMerge.set(false);
            writer.commit();
        }
        catch (Exception ex) {
            try {
                this.failEngine("lucene commit failed", ex);
            }
            catch (Exception inner) {
                ex.addSuppressed(inner);
            }
            throw ex;
        }
        catch (AssertionError e) {
            if (ExceptionsHelper.stackTrace((Throwable)((Object)e)).contains("org.apache.lucene.index.IndexWriter.filesExist")) {
                EngineException engineException = new EngineException(this.shardId, "failed to commit engine", (Throwable)((Object)e), new Object[0]);
                try {
                    this.failEngine("lucene commit failed", engineException);
                }
                catch (Exception inner) {
                    engineException.addSuppressed(inner);
                }
                throw engineException;
            }
            throw e;
        }
    }

    final void ensureCanFlush() {
        if (this.pendingTranslogRecovery.get()) {
            throw new IllegalStateException(this.shardId.toString() + " flushes are disabled - pending translog recovery");
        }
    }

    @Override
    public void onSettingsChanged(TimeValue translogRetentionAge, ByteSizeValue translogRetentionSize, long softDeletesRetentionOps) {
        this.mergeScheduler.refreshConfig();
        this.maybePruneDeletes();
        if (!this.engineConfig.isAutoGeneratedIDsOptimizationEnabled()) {
            this.updateAutoIdTimestamp(Long.MAX_VALUE, true);
        }
        TranslogDeletionPolicy translogDeletionPolicy = this.translog.getDeletionPolicy();
        translogDeletionPolicy.setRetentionAgeInMillis(translogRetentionAge.millis());
        translogDeletionPolicy.setRetentionSizeInBytes(translogRetentionSize.getBytes());
        this.softDeletesPolicy.setRetentionOperations(softDeletesRetentionOps);
    }

    @Override
    public MergeStats getMergeStats() {
        return this.mergeScheduler.stats();
    }

    LocalCheckpointTracker getLocalCheckpointTracker() {
        return this.localCheckpointTracker;
    }

    @Override
    public long getLastSyncedGlobalCheckpoint() {
        return this.getTranslog().getLastSyncedGlobalCheckpoint();
    }

    public long getProcessedLocalCheckpoint() {
        return this.localCheckpointTracker.getProcessedCheckpoint();
    }

    @Override
    public long getPersistedLocalCheckpoint() {
        return this.localCheckpointTracker.getPersistedCheckpoint();
    }

    protected final void markSeqNoAsSeen(long seqNo) {
        this.localCheckpointTracker.advanceMaxSeqNo(seqNo);
    }

    protected final boolean hasBeenProcessedBefore(Engine.Operation op) {
        if (Assertions.ENABLED) {
            assert (op.seqNo() != -2L) : "operation is not assigned seq_no";
            if (op.operationType() == Engine.Operation.TYPE.NO_OP ? !$assertionsDisabled && !this.noOpKeyedLock.isHeldByCurrentThread(op.seqNo()) : !$assertionsDisabled && !this.versionMap.assertKeyedLockHeldByCurrentThread(op.uid().bytes())) {
                throw new AssertionError();
            }
        }
        return this.localCheckpointTracker.hasProcessed(op.seqNo());
    }

    @Override
    public SeqNoStats getSeqNoStats(long globalCheckpoint) {
        return this.localCheckpointTracker.getStats(globalCheckpoint);
    }

    long getNumIndexVersionsLookups() {
        return this.numIndexVersionsLookups.count();
    }

    long getNumVersionLookups() {
        return this.numVersionLookups.count();
    }

    private boolean incrementVersionLookup() {
        this.numVersionLookups.inc();
        return true;
    }

    private boolean incrementIndexVersionLookup() {
        this.numIndexVersionsLookups.inc();
        return true;
    }

    boolean isSafeAccessRequired() {
        return this.versionMap.isSafeAccessRequired();
    }

    long getNumDocDeletes() {
        return this.numDocDeletes.count();
    }

    long getNumDocAppends() {
        return this.numDocAppends.count();
    }

    long getNumDocUpdates() {
        return this.numDocUpdates.count();
    }

    private void ensureSoftDeletesEnabled() {
        if (!this.softDeleteEnabled) {
            assert (false) : "index " + this.shardId.getIndex() + " does not have soft-deletes enabled";
            throw new IllegalStateException("index " + this.shardId.getIndex() + " does not have soft-deletes enabled");
        }
    }

    @Override
    public Translog.Snapshot newChangesSnapshot(String source, MapperService mapperService, long fromSeqNo, long toSeqNo, boolean requiredFullRange) throws IOException {
        LuceneChangesSnapshot luceneChangesSnapshot;
        this.ensureSoftDeletesEnabled();
        this.ensureOpen();
        this.refreshIfNeeded(source, toSeqNo);
        Engine.Searcher searcher = this.acquireSearcher(source, Engine.SearcherScope.INTERNAL);
        try {
            LuceneChangesSnapshot snapshot = new LuceneChangesSnapshot(searcher, mapperService, 1024, fromSeqNo, toSeqNo, requiredFullRange);
            searcher = null;
            luceneChangesSnapshot = snapshot;
        }
        catch (Exception e) {
            try {
                try {
                    this.maybeFailEngine("acquire changes snapshot", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{searcher});
                throw throwable;
            }
        }
        IOUtils.close((Closeable[])new Closeable[]{searcher});
        return luceneChangesSnapshot;
    }

    @Override
    public boolean hasCompleteOperationHistory(String reason, Engine.HistorySource historySource, MapperService mapperService, long startingSeqNo) throws IOException {
        if (historySource == Engine.HistorySource.INDEX) {
            this.ensureSoftDeletesEnabled();
            return this.getMinRetainedSeqNo() <= startingSeqNo;
        }
        long currentLocalCheckpoint = this.localCheckpointTracker.getProcessedCheckpoint();
        if (startingSeqNo > currentLocalCheckpoint) {
            return true;
        }
        LocalCheckpointTracker tracker = new LocalCheckpointTracker(startingSeqNo, startingSeqNo - 1L);
        try (Translog.Snapshot snapshot = this.getTranslog().newSnapshotFromMinSeqNo(startingSeqNo);){
            Translog.Operation operation;
            while ((operation = snapshot.next()) != null) {
                if (operation.seqNo() == -2L) continue;
                tracker.markSeqNoAsProcessed(operation.seqNo());
            }
        }
        return tracker.getProcessedCheckpoint() >= currentLocalCheckpoint;
    }

    @Override
    public final long getMinRetainedSeqNo() {
        this.ensureSoftDeletesEnabled();
        return this.softDeletesPolicy.getMinRetainedSeqNo();
    }

    @Override
    public Closeable acquireHistoryRetentionLock(Engine.HistorySource historySource) {
        if (historySource == Engine.HistorySource.INDEX) {
            this.ensureSoftDeletesEnabled();
            return this.softDeletesPolicy.acquireRetentionLock();
        }
        return this.translog.acquireRetentionLock();
    }

    private static Map<String, String> commitDataAsMap(IndexWriter indexWriter) {
        HashMap<String, String> commitData = new HashMap<String, String>(8);
        for (Map.Entry entry : indexWriter.getLiveCommitData()) {
            commitData.put((String)entry.getKey(), (String)entry.getValue());
        }
        return commitData;
    }

    final long lastRefreshedCheckpoint() {
        return this.lastRefreshedCheckpointListener.refreshedCheckpoint.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refreshIfNeeded(String source, long requestingSeqNo) {
        if (this.lastRefreshedCheckpoint() < requestingSeqNo) {
            Object object = this.refreshIfNeededMutex;
            synchronized (object) {
                if (this.lastRefreshedCheckpoint() < requestingSeqNo) {
                    this.refresh(source, Engine.SearcherScope.INTERNAL, true);
                }
            }
        }
    }

    @Override
    public final long getMaxSeenAutoIdTimestamp() {
        return this.maxSeenAutoIdTimestamp.get();
    }

    @Override
    public final void updateMaxUnsafeAutoIdTimestamp(long newTimestamp) {
        this.updateAutoIdTimestamp(newTimestamp, true);
    }

    private void updateAutoIdTimestamp(long newTimestamp, boolean unsafe) {
        assert (newTimestamp >= -1L) : "invalid timestamp [" + newTimestamp + "]";
        this.maxSeenAutoIdTimestamp.updateAndGet(curr -> Math.max(curr, newTimestamp));
        if (unsafe) {
            this.maxUnsafeAutoIdTimestamp.updateAndGet(curr -> Math.max(curr, newTimestamp));
        }
        assert (this.maxUnsafeAutoIdTimestamp.get() <= this.maxSeenAutoIdTimestamp.get());
    }

    @Override
    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.maxSeqNoOfUpdatesOrDeletes.get();
    }

    @Override
    public void advanceMaxSeqNoOfUpdatesOrDeletes(long maxSeqNoOfUpdatesOnPrimary) {
        if (maxSeqNoOfUpdatesOnPrimary == -2L) {
            assert (false) : "max_seq_no_of_updates on primary is unassigned";
            throw new IllegalArgumentException("max_seq_no_of_updates on primary is unassigned");
        }
        this.maxSeqNoOfUpdatesOrDeletes.updateAndGet(curr -> Math.max(curr, maxSeqNoOfUpdatesOnPrimary));
    }

    private boolean assertMaxSeqNoOfUpdatesIsAdvanced(Term id, long seqNo, boolean allowDeleted, boolean relaxIfGapInSeqNo) {
        VersionValue versionValue;
        long maxSeqNoOfUpdates = this.getMaxSeqNoOfUpdatesOrDeletes();
        if (allowDeleted && (versionValue = this.versionMap.getVersionForAssert(id.bytes())) != null && versionValue.isDelete()) {
            return true;
        }
        if (relaxIfGapInSeqNo && this.localCheckpointTracker.getProcessedCheckpoint() < maxSeqNoOfUpdates) {
            return true;
        }
        assert (seqNo <= maxSeqNoOfUpdates) : "id=" + id + " seq_no=" + seqNo + " msu=" + maxSeqNoOfUpdates;
        return true;
    }

    private static void trimUnsafeCommits(EngineConfig engineConfig) throws IOException {
        Store store = engineConfig.getStore();
        String translogUUID = (String)store.readLastCommittedSegmentsInfo().getUserData().get("translog_uuid");
        Path translogPath = engineConfig.getTranslogConfig().getTranslogPath();
        long globalCheckpoint = Translog.readGlobalCheckpoint(translogPath, translogUUID);
        long minRetainedTranslogGen = Translog.readMinTranslogGeneration(translogPath, translogUUID);
        store.trimUnsafeCommits(globalCheckpoint, minRetainedTranslogGen, engineConfig.getIndexSettings().getIndexVersionCreated());
    }

    private void restoreVersionMapAndCheckpointTracker(DirectoryReader directoryReader) throws IOException {
        IndexSearcher searcher = new IndexSearcher((IndexReader)directoryReader);
        searcher.setQueryCache(null);
        Query query = LongPoint.newRangeQuery((String)"_seq_no", (long)(this.getPersistedLocalCheckpoint() + 1L), (long)Long.MAX_VALUE);
        Weight weight = searcher.createWeight(query, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        for (LeafReaderContext leaf : directoryReader.leaves()) {
            int docId;
            Scorer scorer = weight.scorer(leaf);
            if (scorer == null) continue;
            CombinedDocValues dv = new CombinedDocValues(leaf.reader());
            IdOnlyFieldVisitor idFieldVisitor = new IdOnlyFieldVisitor();
            DocIdSetIterator iterator = scorer.iterator();
            while ((docId = iterator.nextDoc()) != Integer.MAX_VALUE) {
                long primaryTerm = dv.docPrimaryTerm(docId);
                if (primaryTerm == -1L) continue;
                long seqNo = dv.docSeqNo(docId);
                this.localCheckpointTracker.markSeqNoAsProcessed(seqNo);
                this.localCheckpointTracker.markSeqNoAsPersisted(seqNo);
                idFieldVisitor.reset();
                leaf.reader().document(docId, (StoredFieldVisitor)idFieldVisitor);
                if (idFieldVisitor.getId() == null) {
                    assert (dv.isTombstone(docId));
                    continue;
                }
                BytesRef uid = new Term("_id", Uid.encodeId(idFieldVisitor.getId())).bytes();
                Releasable ignored = this.versionMap.acquireLock(uid);
                try {
                    VersionValue curr = this.versionMap.getUnderLock(uid);
                    if (curr != null && InternalEngine.compareOpToVersionMapOnSeqNo(idFieldVisitor.getId(), seqNo, primaryTerm, curr) != OpVsLuceneDocStatus.OP_NEWER) continue;
                    if (dv.isTombstone(docId)) {
                        long startTime = 0L;
                        this.versionMap.putDeleteUnderLock(uid, new DeleteVersionValue(dv.docVersion(docId), seqNo, primaryTerm, 0L));
                        continue;
                    }
                    this.versionMap.putIndexUnderLock(uid, new IndexVersionValue(null, dv.docVersion(docId), seqNo, primaryTerm));
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
        }
        this.refresh("restore_version_map_and_checkpoint_tracker", Engine.SearcherScope.INTERNAL, true);
    }

    private static /* synthetic */ void lambda$index$1() {
    }

    private final class LastRefreshedCheckpointListener
    implements ReferenceManager.RefreshListener {
        final AtomicLong refreshedCheckpoint;
        private long pendingCheckpoint;

        LastRefreshedCheckpointListener(long initialLocalCheckpoint) {
            this.refreshedCheckpoint = new AtomicLong(initialLocalCheckpoint);
        }

        public void beforeRefresh() {
            this.pendingCheckpoint = InternalEngine.this.localCheckpointTracker.getProcessedCheckpoint();
        }

        public void afterRefresh(boolean didRefresh) {
            if (didRefresh) {
                this.updateRefreshedCheckpoint(this.pendingCheckpoint);
            }
        }

        void updateRefreshedCheckpoint(long checkpoint) {
            this.refreshedCheckpoint.updateAndGet(curr -> Math.max(curr, checkpoint));
            assert (this.refreshedCheckpoint.get() >= checkpoint) : this.refreshedCheckpoint.get() + " < " + checkpoint;
        }
    }

    private final class AssertingIndexWriter
    extends IndexWriter {
        AssertingIndexWriter(Directory d, IndexWriterConfig conf) throws IOException {
            super(d, conf);
        }

        public long updateDocument(Term term, Iterable<? extends IndexableField> doc) throws IOException {
            assert (!InternalEngine.this.softDeleteEnabled) : "Call #updateDocument but soft-deletes is enabled";
            return super.updateDocument(term, doc);
        }

        public long updateDocuments(Term delTerm, Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
            assert (!InternalEngine.this.softDeleteEnabled) : "Call #updateDocuments but soft-deletes is enabled";
            return super.updateDocuments(delTerm, docs);
        }

        public long deleteDocuments(Term ... terms) throws IOException {
            assert (!InternalEngine.this.softDeleteEnabled) : "Call #deleteDocuments but soft-deletes is enabled";
            return super.deleteDocuments(terms);
        }

        public long softUpdateDocument(Term term, Iterable<? extends IndexableField> doc, Field ... softDeletes) throws IOException {
            assert (InternalEngine.this.softDeleteEnabled) : "Call #softUpdateDocument but soft-deletes is disabled";
            return super.softUpdateDocument(term, doc, softDeletes);
        }

        public long softUpdateDocuments(Term term, Iterable<? extends Iterable<? extends IndexableField>> docs, Field ... softDeletes) throws IOException {
            assert (InternalEngine.this.softDeleteEnabled) : "Call #softUpdateDocuments but soft-deletes is disabled";
            return super.softUpdateDocuments(term, docs, softDeletes);
        }

        public long tryDeleteDocument(IndexReader readerIn, int docID) {
            assert (false) : "#tryDeleteDocument is not supported. See Lucene#DirectoryReaderWithAllLiveDocs";
            throw new UnsupportedOperationException();
        }
    }

    private final class EngineMergeScheduler
    extends ElasticsearchConcurrentMergeScheduler {
        private final AtomicInteger numMergesInFlight;
        private final AtomicBoolean isThrottling;

        EngineMergeScheduler(ShardId shardId, IndexSettings indexSettings) {
            super(shardId, indexSettings);
            this.numMergesInFlight = new AtomicInteger(0);
            this.isThrottling = new AtomicBoolean();
        }

        @Override
        public synchronized void beforeMerge(OnGoingMerge merge) {
            int maxNumMerges = InternalEngine.this.mergeScheduler.getMaxMergeCount();
            if (this.numMergesInFlight.incrementAndGet() > maxNumMerges && !this.isThrottling.getAndSet(true)) {
                this.logger.info("now throttling indexing: numMergesInFlight={}, maxNumMerges={}", (Object)this.numMergesInFlight, (Object)maxNumMerges);
                InternalEngine.this.activateThrottling();
            }
        }

        @Override
        public synchronized void afterMerge(OnGoingMerge merge) {
            int maxNumMerges = InternalEngine.this.mergeScheduler.getMaxMergeCount();
            if (this.numMergesInFlight.decrementAndGet() < maxNumMerges && this.isThrottling.getAndSet(false)) {
                this.logger.info("stop throttling indexing: numMergesInFlight={}, maxNumMerges={}", (Object)this.numMergesInFlight, (Object)maxNumMerges);
                InternalEngine.this.deactivateThrottling();
            }
            if (!InternalEngine.this.indexWriter.hasPendingMerges() && System.nanoTime() - InternalEngine.this.lastWriteNanos >= InternalEngine.this.engineConfig.getFlushMergesAfter().nanos()) {
                InternalEngine.this.engineConfig.getThreadPool().executor("flush").execute(new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        if (!InternalEngine.this.isClosed.get()) {
                            EngineMergeScheduler.this.logger.warn("failed to flush after merge has finished");
                        }
                    }

                    @Override
                    protected void doRun() {
                        if (!InternalEngine.this.tryRenewSyncCommit()) {
                            InternalEngine.this.flush();
                        }
                    }
                });
            } else if (merge.getTotalBytesSize() >= InternalEngine.this.engineConfig.getIndexSettings().getFlushAfterMergeThresholdSize().getBytes()) {
                InternalEngine.this.shouldPeriodicallyFlushAfterBigMerge.set(true);
            }
        }

        protected void handleMergeException(final Directory dir, final Throwable exc) {
            InternalEngine.this.engineConfig.getThreadPool().generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    EngineMergeScheduler.this.logger.debug("merge failure action rejected", (Throwable)e);
                }

                @Override
                protected void doRun() throws Exception {
                    InternalEngine.this.failEngine("merge failed", (Exception)new MergePolicy.MergeException(exc, dir));
                }
            });
        }
    }

    static final class RefreshWarmerListener
    implements BiConsumer<ElasticsearchDirectoryReader, ElasticsearchDirectoryReader> {
        private final Engine.Warmer warmer;
        private final Logger logger;
        private final AtomicBoolean isEngineClosed;

        RefreshWarmerListener(Logger logger, AtomicBoolean isEngineClosed, EngineConfig engineConfig) {
            this.warmer = engineConfig.getWarmer();
            this.logger = logger;
            this.isEngineClosed = isEngineClosed;
        }

        @Override
        public void accept(ElasticsearchDirectoryReader reader, ElasticsearchDirectoryReader previousReader) {
            block3: {
                if (this.warmer != null) {
                    try {
                        this.warmer.warm(reader);
                    }
                    catch (Exception e) {
                        if (this.isEngineClosed.get()) break block3;
                        this.logger.warn("failed to prepare/warm", (Throwable)e);
                    }
                }
            }
        }
    }

    protected static final class DeletionStrategy {
        final boolean deleteFromLucene;
        final boolean addStaleOpToLucene;
        final boolean currentlyDeleted;
        final long versionOfDeletion;
        final Optional<Engine.DeleteResult> earlyResultOnPreflightError;

        private DeletionStrategy(boolean deleteFromLucene, boolean addStaleOpToLucene, boolean currentlyDeleted, long versionOfDeletion, Engine.DeleteResult earlyResultOnPreflightError) {
            assert (!(deleteFromLucene && earlyResultOnPreflightError != null)) : "can only delete from lucene or have a preflight result but not both.deleteFromLucene: " + deleteFromLucene + "  earlyResultOnPreFlightError:" + earlyResultOnPreflightError;
            this.deleteFromLucene = deleteFromLucene;
            this.addStaleOpToLucene = addStaleOpToLucene;
            this.currentlyDeleted = currentlyDeleted;
            this.versionOfDeletion = versionOfDeletion;
            this.earlyResultOnPreflightError = earlyResultOnPreflightError == null ? Optional.empty() : Optional.of(earlyResultOnPreflightError);
        }

        public static DeletionStrategy skipDueToVersionConflict(VersionConflictEngineException e, long currentVersion, boolean currentlyDeleted) {
            Engine.DeleteResult deleteResult = new Engine.DeleteResult(e, currentVersion, 0L, -2L, !currentlyDeleted);
            return new DeletionStrategy(false, false, currentlyDeleted, -1L, deleteResult);
        }

        static DeletionStrategy processNormally(boolean currentlyDeleted, long versionOfDeletion) {
            return new DeletionStrategy(true, false, currentlyDeleted, versionOfDeletion, null);
        }

        public static DeletionStrategy processButSkipLucene(boolean currentlyDeleted, long versionOfDeletion) {
            return new DeletionStrategy(false, false, currentlyDeleted, versionOfDeletion, null);
        }

        static DeletionStrategy processAsStaleOp(boolean addStaleOpToLucene, long versionOfDeletion) {
            return new DeletionStrategy(false, addStaleOpToLucene, false, versionOfDeletion, null);
        }
    }

    protected static final class IndexingStrategy {
        final boolean currentNotFoundOrDeleted;
        final boolean useLuceneUpdateDocument;
        final long versionForIndexing;
        final boolean indexIntoLucene;
        final boolean addStaleOpToLucene;
        final Optional<Engine.IndexResult> earlyResultOnPreFlightError;

        private IndexingStrategy(boolean currentNotFoundOrDeleted, boolean useLuceneUpdateDocument, boolean indexIntoLucene, boolean addStaleOpToLucene, long versionForIndexing, Engine.IndexResult earlyResultOnPreFlightError) {
            assert (!useLuceneUpdateDocument || indexIntoLucene) : "use lucene update is set to true, but we're not indexing into lucene";
            assert (!(indexIntoLucene && earlyResultOnPreFlightError != null)) : "can only index into lucene or have a preflight result but not both.indexIntoLucene: " + indexIntoLucene + "  earlyResultOnPreFlightError:" + earlyResultOnPreFlightError;
            this.currentNotFoundOrDeleted = currentNotFoundOrDeleted;
            this.useLuceneUpdateDocument = useLuceneUpdateDocument;
            this.versionForIndexing = versionForIndexing;
            this.indexIntoLucene = indexIntoLucene;
            this.addStaleOpToLucene = addStaleOpToLucene;
            this.earlyResultOnPreFlightError = earlyResultOnPreFlightError == null ? Optional.empty() : Optional.of(earlyResultOnPreFlightError);
        }

        static IndexingStrategy optimizedAppendOnly(long versionForIndexing) {
            return new IndexingStrategy(true, false, true, false, versionForIndexing, null);
        }

        public static IndexingStrategy skipDueToVersionConflict(VersionConflictEngineException e, boolean currentNotFoundOrDeleted, long currentVersion) {
            Engine.IndexResult result = new Engine.IndexResult(e, currentVersion);
            return new IndexingStrategy(currentNotFoundOrDeleted, false, false, false, -1L, result);
        }

        static IndexingStrategy processNormally(boolean currentNotFoundOrDeleted, long versionForIndexing) {
            return new IndexingStrategy(currentNotFoundOrDeleted, !currentNotFoundOrDeleted, true, false, versionForIndexing, null);
        }

        public static IndexingStrategy processButSkipLucene(boolean currentNotFoundOrDeleted, long versionForIndexing) {
            return new IndexingStrategy(currentNotFoundOrDeleted, false, false, false, versionForIndexing, null);
        }

        static IndexingStrategy processAsStaleOp(boolean addStaleOpToLucene, long versionForIndexing) {
            return new IndexingStrategy(false, false, false, addStaleOpToLucene, versionForIndexing, null);
        }
    }

    static enum OpVsLuceneDocStatus {
        OP_NEWER,
        OP_STALE_OR_EQUAL,
        LUCENE_DOC_NOT_FOUND;

    }

    @SuppressForbidden(reason="reference counting is required here")
    private static final class ExternalReaderManager
    extends ReferenceManager<ElasticsearchDirectoryReader> {
        private final BiConsumer<ElasticsearchDirectoryReader, ElasticsearchDirectoryReader> refreshListener;
        private final ElasticsearchReaderManager internalReaderManager;
        private boolean isWarmedUp;

        ExternalReaderManager(ElasticsearchReaderManager internalReaderManager, BiConsumer<ElasticsearchDirectoryReader, ElasticsearchDirectoryReader> refreshListener) throws IOException {
            this.refreshListener = refreshListener;
            this.internalReaderManager = internalReaderManager;
            this.current = internalReaderManager.acquire();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ElasticsearchDirectoryReader refreshIfNeeded(ElasticsearchDirectoryReader referenceToRefresh) throws IOException {
            this.internalReaderManager.maybeRefreshBlocking();
            ElasticsearchDirectoryReader newReader = (ElasticsearchDirectoryReader)((Object)this.internalReaderManager.acquire());
            if (!this.isWarmedUp || newReader != referenceToRefresh) {
                boolean success = false;
                try {
                    this.refreshListener.accept(newReader, this.isWarmedUp ? referenceToRefresh : null);
                    this.isWarmedUp = true;
                    success = true;
                }
                finally {
                    if (!success) {
                        this.internalReaderManager.release((Object)newReader);
                    }
                }
            }
            if (referenceToRefresh == newReader) {
                this.internalReaderManager.release((Object)newReader);
                return null;
            }
            return newReader;
        }

        protected boolean tryIncRef(ElasticsearchDirectoryReader reference) {
            return reference.tryIncRef();
        }

        protected int getRefCount(ElasticsearchDirectoryReader reference) {
            return reference.getRefCount();
        }

        protected void decRef(ElasticsearchDirectoryReader reference) throws IOException {
            reference.decRef();
        }
    }
}

