/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145Key;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145PrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145PublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECGOST3410PrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECGOST3410PublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410Key;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410PrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410PublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPublicKey;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410DomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsymmetricKeyPair<P extends AsymmetricPublicKey, S extends AsymmetricPrivateKey> {
    private final P publicKey;
    private final S privateKey;

    public AsymmetricKeyPair(P p, S s) {
        AccessController.doPrivileged(new PrivilegedAction((AsymmetricPublicKey)p, (AsymmetricPrivateKey)s){
            final /* synthetic */ AsymmetricPublicKey val$publicKey;
            final /* synthetic */ AsymmetricPrivateKey val$privateKey;
            {
                this.val$publicKey = asymmetricPublicKey;
                this.val$privateKey = asymmetricPrivateKey;
            }

            public Object run() {
                AsymmetricKeyPair.this.checkKeyPairForConsistency(this.val$publicKey, this.val$privateKey);
                return null;
            }
        });
        this.publicKey = p;
        this.privateKey = s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkKeyPairForConsistency(P p, S s) {
        if (p instanceof AsymmetricECKey && s instanceof AsymmetricECKey) {
            AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)s;
            AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)p;
            if (!asymmetricECPrivateKey.getDomainParameters().equals(asymmetricECPublicKey.getDomainParameters())) {
                throw new IllegalArgumentException("EC keys do not have the same domain parameters");
            }
            if (asymmetricECPrivateKey.getDomainParameters().getG().multiply(asymmetricECPrivateKey.getS()).normalize().equals(asymmetricECPublicKey.getW())) return;
            throw new IllegalArgumentException("EC public key not consistent with EC private key");
        }
        if (p instanceof AsymmetricDHKey && s instanceof AsymmetricDHKey) {
            AsymmetricDHPrivateKey asymmetricDHPrivateKey = (AsymmetricDHPrivateKey)s;
            AsymmetricDHPublicKey asymmetricDHPublicKey = (AsymmetricDHPublicKey)p;
            DHDomainParameters dHDomainParameters = asymmetricDHPrivateKey.getDomainParameters();
            if (!dHDomainParameters.equals(asymmetricDHPublicKey.getDomainParameters())) {
                throw new IllegalArgumentException("DH keys do not have the same domain parameters");
            }
            if (dHDomainParameters.getG().modPow(asymmetricDHPrivateKey.getX(), dHDomainParameters.getP()).equals(asymmetricDHPublicKey.getY())) return;
            throw new IllegalArgumentException("DH public key not consistent with DH private key");
        }
        if (p instanceof AsymmetricDSAKey && s instanceof AsymmetricDSAKey) {
            AsymmetricDSAPrivateKey asymmetricDSAPrivateKey = (AsymmetricDSAPrivateKey)s;
            AsymmetricDSAPublicKey asymmetricDSAPublicKey = (AsymmetricDSAPublicKey)p;
            DSADomainParameters dSADomainParameters = asymmetricDSAPrivateKey.getDomainParameters();
            if (!dSADomainParameters.equals(asymmetricDSAPublicKey.getDomainParameters())) {
                throw new IllegalArgumentException("DSA keys do not have the same domain parameters");
            }
            if (dSADomainParameters.getG().modPow(asymmetricDSAPrivateKey.getX(), dSADomainParameters.getP()).equals(asymmetricDSAPublicKey.getY())) return;
            throw new IllegalArgumentException("DSA public key not consistent with DSA private key");
        }
        if (p instanceof AsymmetricRSAKey && s instanceof AsymmetricRSAKey) {
            AsymmetricRSAPrivateKey asymmetricRSAPrivateKey = (AsymmetricRSAPrivateKey)s;
            AsymmetricRSAPublicKey asymmetricRSAPublicKey = (AsymmetricRSAPublicKey)p;
            if (!asymmetricRSAPrivateKey.getModulus().equals(asymmetricRSAPublicKey.getModulus())) {
                throw new IllegalArgumentException("RSA keys do not have the same modulus");
            }
            BigInteger bigInteger = BigInteger.valueOf(2L);
            if (bigInteger.modPow(asymmetricRSAPrivateKey.getPrivateExponent(), asymmetricRSAPrivateKey.getModulus()).modPow(asymmetricRSAPublicKey.getPublicExponent(), asymmetricRSAPrivateKey.getModulus()).equals(bigInteger)) return;
            throw new IllegalArgumentException("RSA public key not consistent with RSA private key");
        }
        if (p instanceof AsymmetricGOST3410Key && s instanceof AsymmetricGOST3410Key) {
            if (!((AsymmetricGOST3410Key)p).getParameters().equals(((AsymmetricGOST3410Key)s).getParameters())) {
                throw new IllegalArgumentException("GOST3410 parameters mismatch");
            }
            if (p instanceof AsymmetricGOST3410PublicKey && s instanceof AsymmetricGOST3410PrivateKey) {
                AsymmetricGOST3410PrivateKey asymmetricGOST3410PrivateKey = (AsymmetricGOST3410PrivateKey)s;
                AsymmetricGOST3410PublicKey asymmetricGOST3410PublicKey = (AsymmetricGOST3410PublicKey)p;
                GOST3410Parameters gOST3410Parameters = asymmetricGOST3410PrivateKey.getParameters();
                GOST3410DomainParameters gOST3410DomainParameters = (GOST3410DomainParameters)gOST3410Parameters.getDomainParameters();
                if (gOST3410DomainParameters.getA().modPow(asymmetricGOST3410PrivateKey.getX(), gOST3410DomainParameters.getP()).equals(asymmetricGOST3410PublicKey.getY())) return;
                throw new IllegalArgumentException("GOST3410 public key not consistent with GOST3410 private key");
            }
            if (!(p instanceof AsymmetricECGOST3410PublicKey) || !(s instanceof AsymmetricECGOST3410PrivateKey)) throw new IllegalArgumentException("GOST3410 key pair inconsistent");
            AsymmetricECGOST3410PrivateKey asymmetricECGOST3410PrivateKey = (AsymmetricECGOST3410PrivateKey)s;
            AsymmetricECGOST3410PublicKey asymmetricECGOST3410PublicKey = (AsymmetricECGOST3410PublicKey)p;
            GOST3410Parameters gOST3410Parameters = asymmetricECGOST3410PrivateKey.getParameters();
            ECDomainParameters eCDomainParameters = (ECDomainParameters)gOST3410Parameters.getDomainParameters();
            if (eCDomainParameters.getG().multiply(asymmetricECGOST3410PrivateKey.getS()).normalize().equals(asymmetricECGOST3410PublicKey.getW())) return;
            throw new IllegalArgumentException("ECGOST3410 public key not consistent with ECGOST3410 private key");
        }
        if (!(p instanceof AsymmetricDSTU4145Key) || !(s instanceof AsymmetricDSTU4145Key)) throw new IllegalArgumentException("Key pair inconsistent");
        AsymmetricDSTU4145PrivateKey asymmetricDSTU4145PrivateKey = (AsymmetricDSTU4145PrivateKey)s;
        AsymmetricDSTU4145PublicKey asymmetricDSTU4145PublicKey = (AsymmetricDSTU4145PublicKey)p;
        if (!asymmetricDSTU4145PrivateKey.getParameters().equals(asymmetricDSTU4145PublicKey.getParameters())) {
            throw new IllegalArgumentException("DSTU4145 keys do not have the same domain parameters");
        }
        if (asymmetricDSTU4145PrivateKey.getParameters().getDomainParameters().getG().multiply(asymmetricDSTU4145PrivateKey.getS()).negate().normalize().equals(asymmetricDSTU4145PublicKey.getW())) return;
        throw new IllegalArgumentException("DSTU4145 public key not consistent with DSTU4145 private key");
    }

    public P getPublicKey() {
        return this.publicKey;
    }

    public S getPrivateKey() {
        return this.privateKey;
    }
}

