/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.FailProcessorException;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public final class FailProcessor
extends AbstractProcessor {
    public static final String TYPE = "fail";
    private final TemplateScript.Factory message;

    FailProcessor(String tag, TemplateScript.Factory message) {
        super(tag);
        this.message = message;
    }

    public TemplateScript.Factory getMessage() {
        return this.message;
    }

    public IngestDocument execute(IngestDocument document) {
        throw new FailProcessorException(document.renderTemplate(this.message));
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public FailProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String message = ConfigurationUtils.readStringProperty((String)FailProcessor.TYPE, (String)processorTag, config, (String)"message");
            TemplateScript.Factory compiledTemplate = ConfigurationUtils.compileTemplate((String)FailProcessor.TYPE, (String)processorTag, (String)"message", (String)message, (ScriptService)this.scriptService);
            return new FailProcessor(processorTag, compiledTemplate);
        }
    }
}

