/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.api.DeploymentManager;
import java.lang.reflect.Field;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.embedded.undertow.UndertowCompressionConfigurer;
import org.springframework.boot.web.server.Compression;
import org.springframework.boot.web.server.PortInUseException;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.xnio.channels.BoundChannel;

public class UndertowServletWebServer
implements WebServer {
    private static final Log logger = LogFactory.getLog(UndertowServletWebServer.class);
    private final Object monitor = new Object();
    private final Undertow.Builder builder;
    private final DeploymentManager manager;
    private final String contextPath;
    private final boolean useForwardHeaders;
    private final boolean autoStart;
    private final Compression compression;
    private final String serverHeader;
    private Undertow undertow;
    private volatile boolean started = false;

    public UndertowServletWebServer(Undertow.Builder builder, DeploymentManager manager, String contextPath, boolean autoStart, Compression compression) {
        this(builder, manager, contextPath, false, autoStart, compression);
    }

    public UndertowServletWebServer(Undertow.Builder builder, DeploymentManager manager, String contextPath, boolean useForwardHeaders, boolean autoStart, Compression compression) {
        this(builder, manager, contextPath, useForwardHeaders, autoStart, compression, null);
    }

    public UndertowServletWebServer(Undertow.Builder builder, DeploymentManager manager, String contextPath, boolean useForwardHeaders, boolean autoStart, Compression compression, String serverHeader) {
        this.builder = builder;
        this.manager = manager;
        this.contextPath = contextPath;
        this.useForwardHeaders = useForwardHeaders;
        this.autoStart = autoStart;
        this.compression = compression;
        this.serverHeader = serverHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws WebServerException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.started) {
                return;
            }
            try {
                if (!this.autoStart) {
                    return;
                }
                if (this.undertow == null) {
                    this.undertow = this.createUndertowServer();
                }
                this.undertow.start();
                this.started = true;
                logger.info((Object)("Undertow started on port(s) " + this.getPortsDescription() + " with context path '" + this.contextPath + "'"));
            }
            catch (Exception ex) {
                try {
                    if (this.findBindException(ex) != null) {
                        List<Port> failedPorts = this.getConfiguredPorts();
                        List<Port> actualPorts = this.getActualPorts();
                        failedPorts.removeAll(actualPorts);
                        if (failedPorts.size() == 1) {
                            throw new PortInUseException(failedPorts.iterator().next().getNumber());
                        }
                    }
                    throw new WebServerException("Unable to start embedded Undertow", ex);
                }
                catch (Throwable throwable) {
                    this.stopSilently();
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentManager getDeploymentManager() {
        Object object = this.monitor;
        synchronized (object) {
            return this.manager;
        }
    }

    private void stopSilently() {
        try {
            if (this.undertow != null) {
                this.undertow.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BindException findBindException(Exception ex) {
        for (Throwable candidate = ex; candidate != null; candidate = candidate.getCause()) {
            if (!(candidate instanceof BindException)) continue;
            return (BindException)candidate;
        }
        return null;
    }

    private Undertow createUndertowServer() throws ServletException {
        HttpHandler httpHandler = this.manager.start();
        httpHandler = this.getContextHandler(httpHandler);
        if (this.useForwardHeaders) {
            httpHandler = Handlers.proxyPeerAddress((HttpHandler)httpHandler);
        }
        if (StringUtils.hasText((String)this.serverHeader)) {
            httpHandler = Handlers.header((HttpHandler)httpHandler, (String)"Server", (String)this.serverHeader);
        }
        this.builder.setHandler(httpHandler);
        return this.builder.build();
    }

    private HttpHandler getContextHandler(HttpHandler httpHandler) {
        HttpHandler contextHandler = UndertowCompressionConfigurer.configureCompression(this.compression, httpHandler);
        if (StringUtils.isEmpty((Object)this.contextPath)) {
            return contextHandler;
        }
        return Handlers.path().addPrefixPath(this.contextPath, contextHandler);
    }

    private String getPortsDescription() {
        List<Port> ports = this.getActualPorts();
        if (!ports.isEmpty()) {
            return StringUtils.collectionToDelimitedString(ports, (String)" ");
        }
        return "unknown";
    }

    private List<Port> getActualPorts() {
        ArrayList<Port> ports = new ArrayList<Port>();
        try {
            if (!this.autoStart) {
                ports.add(new Port(-1, "unknown"));
            } else {
                for (BoundChannel channel : this.extractChannels()) {
                    ports.add(this.getPortFromChannel(channel));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ports;
    }

    private List<BoundChannel> extractChannels() {
        Field channelsField = ReflectionUtils.findField(Undertow.class, (String)"channels");
        ReflectionUtils.makeAccessible((Field)channelsField);
        return (List)ReflectionUtils.getField((Field)channelsField, (Object)this.undertow);
    }

    private Port getPortFromChannel(BoundChannel channel) {
        SocketAddress socketAddress = channel.getLocalAddress();
        if (socketAddress instanceof InetSocketAddress) {
            String protocol = ReflectionUtils.findField(channel.getClass(), (String)"ssl") != null ? "https" : "http";
            return new Port(((InetSocketAddress)socketAddress).getPort(), protocol);
        }
        return null;
    }

    private List<Port> getConfiguredPorts() {
        ArrayList<Port> ports = new ArrayList<Port>();
        for (Object listener : this.extractListeners()) {
            try {
                Port port = this.getPortFromListener(listener);
                if (port.getNumber() == 0) continue;
                ports.add(port);
            }
            catch (Exception exception) {}
        }
        return ports;
    }

    private List<Object> extractListeners() {
        Field listenersField = ReflectionUtils.findField(Undertow.class, (String)"listeners");
        ReflectionUtils.makeAccessible((Field)listenersField);
        return (List)ReflectionUtils.getField((Field)listenersField, (Object)this.undertow);
    }

    private Port getPortFromListener(Object listener) {
        Field typeField = ReflectionUtils.findField(listener.getClass(), (String)"type");
        ReflectionUtils.makeAccessible((Field)typeField);
        String protocol = ReflectionUtils.getField((Field)typeField, (Object)listener).toString();
        Field portField = ReflectionUtils.findField(listener.getClass(), (String)"port");
        ReflectionUtils.makeAccessible((Field)portField);
        int port = (Integer)ReflectionUtils.getField((Field)portField, (Object)listener);
        return new Port(port, protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws WebServerException {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            try {
                this.manager.stop();
                this.manager.undeploy();
                this.undertow.stop();
            }
            catch (Exception ex) {
                throw new WebServerException("Unable to stop undertow", ex);
            }
        }
    }

    @Override
    public int getPort() {
        List<Port> ports = this.getActualPorts();
        if (ports.isEmpty()) {
            return 0;
        }
        return ports.get(0).getNumber();
    }

    private static final class Port {
        private final int number;
        private final String protocol;

        private Port(int number, String protocol) {
            this.number = number;
            this.protocol = protocol;
        }

        public int getNumber() {
            return this.number;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Port other = (Port)obj;
            return this.number == other.number;
        }

        public int hashCode() {
            return this.number;
        }

        public String toString() {
            return this.number + " (" + this.protocol + ")";
        }
    }
}

