/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.reflect;

import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.Toggleable;
import org.slf4j.LoggerFactory;

public interface ClassLoadingReporter
extends AutoCloseable,
Toggleable {
    public void onPresent(Class<?> var1);

    public void onBeanPresent(Class<?> var1);

    public void onMissing(String var1);

    @Override
    public void close();

    public static boolean isReportingEnabled() {
        return ClassUtils.CLASS_LOADING_REPORTER_ENABLED;
    }

    public static void reportPresent(Class<?> type) {
        if (ClassUtils.CLASS_LOADING_REPORTER_ENABLED) {
            for (ClassLoadingReporter reporter : ClassUtils.CLASS_LOADING_REPORTERS) {
                reporter.onPresent(type);
            }
        }
    }

    public static void reportBeanPresent(Class<?> type) {
        if (ClassUtils.CLASS_LOADING_REPORTER_ENABLED) {
            for (ClassLoadingReporter reporter : ClassUtils.CLASS_LOADING_REPORTERS) {
                reporter.onBeanPresent(type);
            }
        }
    }

    public static void reportMissing(String type) {
        if (ClassUtils.CLASS_LOADING_REPORTER_ENABLED) {
            for (ClassLoadingReporter reporter : ClassUtils.CLASS_LOADING_REPORTERS) {
                reporter.onMissing(type);
            }
        }
    }

    public static void finish() {
        if (ClassUtils.CLASS_LOADING_REPORTER_ENABLED) {
            for (ClassLoadingReporter classLoadingReporter : ClassUtils.CLASS_LOADING_REPORTERS) {
                try {
                    classLoadingReporter.close();
                }
                catch (Throwable e) {
                    LoggerFactory.getLogger(ClassLoadingReporter.class).warn("Error reporting classloading with loader [" + classLoadingReporter + "]: " + e.getMessage(), e);
                }
            }
        }
    }
}

