/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env.yaml;

import io.micronaut.context.env.AbstractPropertySourceLoader;
import io.micronaut.core.util.CollectionUtils;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;

public class YamlPropertySourceLoader
extends AbstractPropertySourceLoader {
    public boolean isEnabled() {
        return YamlPropertySourceLoader.isSnakeYamlPresent();
    }

    @Override
    public Set<String> getExtensions() {
        return CollectionUtils.setOf((Object[])new String[]{"yml", "yaml"});
    }

    @Override
    protected void processInput(String name, InputStream input, Map<String, Object> finalMap) {
        if (System.getProperty("java.runtime.name") == null) {
            System.setProperty("java.runtime.name", "Unknown");
        }
        Yaml yaml = new Yaml();
        Iterable objects = yaml.loadAll(input);
        for (Object object : objects) {
            if (!(object instanceof Map)) continue;
            Map map = (Map)object;
            String prefix = "";
            this.processMap(finalMap, map, prefix);
        }
    }

    private static boolean isSnakeYamlPresent() {
        try {
            Class<Yaml> yamlClass = Yaml.class;
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

