/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pair<A, B> {
    public final A first;
    public final B second;
    private static final Pair EMPTY = Pair.create(null, null);

    @NotNull
    public static <A, B> Pair<A, B> create(A first2, B second) {
        Pair<A, B> pair = new Pair<A, B>(first2, second);
        if (pair == null) {
            Pair.$$$reportNull$$$0(0);
        }
        return pair;
    }

    @NotNull
    public static <A, B> NonNull<A, B> createNonNull(@NotNull A first2, @NotNull B second) {
        if (first2 == null) {
            Pair.$$$reportNull$$$0(1);
        }
        if (second == null) {
            Pair.$$$reportNull$$$0(2);
        }
        NonNull<A, B> nonNull = new NonNull<A, B>(first2, second);
        if (nonNull == null) {
            Pair.$$$reportNull$$$0(3);
        }
        return nonNull;
    }

    @NotNull
    public static <A, B> Pair<A, B> pair(A first2, B second) {
        Pair<A, B> pair = new Pair<A, B>(first2, second);
        if (pair == null) {
            Pair.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @NotNull
    public static <A, B> Function<A, Pair<A, B>> createFunction(final B value2) {
        Function function2 = new Function<A, Pair<A, B>>(){

            @Override
            public Pair<A, B> fun(A a) {
                return Pair.create(a, value2);
            }
        };
        if (function2 == null) {
            Pair.$$$reportNull$$$0(5);
        }
        return function2;
    }

    public static <T> T getFirst(@Nullable Pair<T, ?> pair) {
        return pair != null ? (T)pair.first : null;
    }

    public static <T> T getSecond(@Nullable Pair<?, T> pair) {
        return pair != null ? (T)pair.second : null;
    }

    public static <A, B> Pair<A, B> empty() {
        return EMPTY;
    }

    public Pair(A first2, B second) {
        this.first = first2;
        this.second = second;
    }

    public final A getFirst() {
        return this.first;
    }

    public final B getSecond() {
        return this.second;
    }

    public final boolean equals(Object o) {
        return o instanceof Pair && Comparing.equal(this.first, ((Pair)o).first) && Comparing.equal(this.second, ((Pair)o).second);
    }

    public int hashCode() {
        int result2 = this.first != null ? this.first.hashCode() : 0;
        result2 = 31 * result2 + (this.second != null ? this.second.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "<" + this.first + "," + this.second + ">";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/Pair";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/Pair";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNonNull";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pair";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNonNull";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NonNull<A, B>
    extends Pair<A, B> {
        public NonNull(@NotNull A first2, @NotNull B second) {
            if (first2 == null) {
                NonNull.$$$reportNull$$$0(0);
            }
            if (second == null) {
                NonNull.$$$reportNull$$$0(1);
            }
            super(first2, second);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "first";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "second";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/util/Pair$NonNull";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

