/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelfElementInfo
extends SmartPointerElementInfo {
    private static final FileDocumentManager ourFileDocManager = FileDocumentManager.getInstance();
    private volatile Identikit myIdentikit;
    private final VirtualFile myFile;
    private final boolean myForInjected;
    private int myStartOffset;
    private int myEndOffset;

    SelfElementInfo(@Nullable ProperTextRange range, @NotNull Identikit identikit, @NotNull PsiFile containingFile, boolean forInjected) {
        if (identikit == null) {
            SelfElementInfo.$$$reportNull$$$0(0);
        }
        if (containingFile == null) {
            SelfElementInfo.$$$reportNull$$$0(1);
        }
        this.myForInjected = forInjected;
        this.myIdentikit = identikit;
        this.myFile = containingFile.getViewProvider().getVirtualFile();
        this.setRange(range);
    }

    void switchToAnchor(@NotNull PsiElement element) {
        if (element == null) {
            SelfElementInfo.$$$reportNull$$$0(2);
        }
        this.switchTo(element, this.findAnchor(element));
    }

    private Pair<Identikit.ByAnchor, PsiElement> findAnchor(@NotNull PsiElement element) {
        if (element == null) {
            SelfElementInfo.$$$reportNull$$$0(3);
        }
        return Identikit.withAnchor(element, this.myIdentikit.getFileLanguage());
    }

    private void switchTo(@NotNull PsiElement element, @Nullable Pair<Identikit.ByAnchor, PsiElement> pair) {
        if (element == null) {
            SelfElementInfo.$$$reportNull$$$0(4);
        }
        if (pair != null) {
            assert (((Identikit.ByAnchor)pair.first).hashCode() == this.myIdentikit.hashCode());
            this.myIdentikit = (Identikit)pair.first;
            this.setRange(((PsiElement)pair.second).getTextRange());
        } else {
            this.setRange(element.getTextRange());
        }
    }

    boolean updateRangeToPsi(@NotNull Segment pointerRange, PsiElement cachedElement) {
        Pair<Identikit.ByAnchor, PsiElement> pair;
        TextRange range;
        if (pointerRange == null) {
            SelfElementInfo.$$$reportNull$$$0(5);
        }
        if ((range = ((pair = this.findAnchor(cachedElement)) != null ? (PsiElement)pair.second : cachedElement).getTextRange()) != null && range.intersects(pointerRange)) {
            this.switchTo(cachedElement, pair);
            return true;
        }
        return false;
    }

    void setRange(@Nullable Segment range) {
        if (range == null) {
            this.myStartOffset = -1;
            this.myEndOffset = -1;
        } else {
            this.myStartOffset = range.getStartOffset();
            this.myEndOffset = range.getEndOffset();
        }
    }

    boolean hasRange() {
        return this.myStartOffset >= 0;
    }

    int getPsiStartOffset() {
        return this.myStartOffset;
    }

    int getPsiEndOffset() {
        return this.myEndOffset;
    }

    boolean isGreedy() {
        return this.myForInjected || this.myIdentikit.isForPsiFile();
    }

    @Override
    Document getDocumentToSynchronize() {
        return ourFileDocManager.getCachedDocument(this.getVirtualFile());
    }

    @Override
    PsiElement restoreElement(@NotNull SmartPointerManagerImpl manager) {
        TextRange segment;
        if (manager == null) {
            SelfElementInfo.$$$reportNull$$$0(6);
        }
        if ((segment = this.getPsiRange(manager)) == null) {
            return null;
        }
        PsiFile file2 = this.restoreFile(manager);
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        return this.myIdentikit.findPsiElement(file2, segment.getStartOffset(), segment.getEndOffset());
    }

    @Override
    @Nullable
    TextRange getPsiRange(@NotNull SmartPointerManagerImpl manager) {
        if (manager == null) {
            SelfElementInfo.$$$reportNull$$$0(7);
        }
        return this.calcPsiRange();
    }

    boolean isForInjected() {
        return this.myForInjected;
    }

    @Nullable
    private TextRange calcPsiRange() {
        return this.hasRange() ? new UnfairTextRange(this.myStartOffset, this.myEndOffset) : null;
    }

    @Override
    PsiFile restoreFile(@NotNull SmartPointerManagerImpl manager) {
        if (manager == null) {
            SelfElementInfo.$$$reportNull$$$0(8);
        }
        return SelfElementInfo.restoreFileFromVirtual(this.getVirtualFile(), manager.getProject(), this.myIdentikit.getFileLanguage());
    }

    @Override
    void cleanup() {
        this.setRange(null);
    }

    @Nullable
    public static PsiFile restoreFileFromVirtual(@NotNull VirtualFile virtualFile2, @NotNull Project project, @NotNull Language language) {
        if (virtualFile2 == null) {
            SelfElementInfo.$$$reportNull$$$0(9);
        }
        if (project == null) {
            SelfElementInfo.$$$reportNull$$$0(10);
        }
        if (language == null) {
            SelfElementInfo.$$$reportNull$$$0(11);
        }
        return ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return null;
            }
            VirtualFile child = SelfElementInfo.restoreVFile(virtualFile2);
            if (child == null || !child.isValid()) {
                return null;
            }
            PsiFile file2 = PsiManager.getInstance(project).findFile(child);
            if (file2 != null) {
                return file2.getViewProvider().getPsi(language == Language.ANY ? file2.getViewProvider().getBaseLanguage() : language);
            }
            return null;
        });
    }

    @Nullable
    public static PsiDirectory restoreDirectoryFromVirtual(@NotNull VirtualFile virtualFile2, @NotNull Project project) {
        if (virtualFile2 == null) {
            SelfElementInfo.$$$reportNull$$$0(12);
        }
        if (project == null) {
            SelfElementInfo.$$$reportNull$$$0(13);
        }
        return ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return null;
            }
            VirtualFile child = SelfElementInfo.restoreVFile(virtualFile2);
            if (child == null || !child.isValid()) {
                return null;
            }
            PsiDirectory file2 = PsiManager.getInstance(project).findDirectory(child);
            if (file2 == null || !file2.isValid()) {
                return null;
            }
            return file2;
        });
    }

    @Nullable
    private static VirtualFile restoreVFile(@NotNull VirtualFile virtualFile2) {
        VirtualFile child;
        if (virtualFile2 == null) {
            SelfElementInfo.$$$reportNull$$$0(14);
        }
        if (virtualFile2.isValid()) {
            child = virtualFile2;
        } else {
            VirtualFile vParent = virtualFile2.getParent();
            if (vParent == null || !vParent.isValid()) {
                return null;
            }
            String name = virtualFile2.getName();
            child = vParent.findChild(name);
        }
        return child;
    }

    @Override
    int elementHashCode() {
        return this.getVirtualFile().hashCode() + this.myIdentikit.hashCode() * 31;
    }

    @Override
    boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other, @NotNull SmartPointerManagerImpl manager) {
        if (other == null) {
            SelfElementInfo.$$$reportNull$$$0(15);
        }
        if (manager == null) {
            SelfElementInfo.$$$reportNull$$$0(16);
        }
        if (other instanceof SelfElementInfo) {
            SelfElementInfo otherInfo = (SelfElementInfo)other;
            if (!this.getVirtualFile().equals(other.getVirtualFile()) || this.myIdentikit != otherInfo.myIdentikit) {
                return false;
            }
            return ReadAction.compute(() -> {
                TextRange range1 = this.getPsiRange(manager);
                TextRange range2 = otherInfo.getPsiRange(manager);
                return range1 != null && range2 != null && range1.getStartOffset() == range2.getStartOffset() && range1.getEndOffset() == range2.getEndOffset();
            });
        }
        return false;
    }

    @Override
    @NotNull
    final VirtualFile getVirtualFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            SelfElementInfo.$$$reportNull$$$0(17);
        }
        return virtualFile2;
    }

    @Override
    @Nullable
    Segment getRange(@NotNull SmartPointerManagerImpl manager) {
        SmartPointerTracker tracker;
        PsiDocumentManagerBase documentManager;
        List<DocumentEvent> events;
        Document document;
        if (manager == null) {
            SelfElementInfo.$$$reportNull$$$0(18);
        }
        if (this.hasRange() && (document = this.getDocumentToSynchronize()) != null && !(events = (documentManager = manager.getPsiDocumentManager()).getEventsSinceCommit(document)).isEmpty() && (tracker = manager.getTracker(this.getVirtualFile())) != null) {
            return tracker.getUpdatedRange(this, (FrozenDocument)documentManager.getLastCommittedDocument(document), events);
        }
        return this.calcPsiRange();
    }

    public String toString() {
        return "psi:range=" + this.calcPsiRange() + ",type=" + this.myIdentikit;
    }

    public static Segment calcActualRangeAfterDocumentEvents(@NotNull PsiFile containingFile, @NotNull Document document, @NotNull Segment segment, boolean isSegmentGreedy) {
        SmartPointerManagerImpl pointerManager;
        SmartPointerTracker tracker;
        Project project;
        PsiDocumentManagerBase documentManager;
        List<DocumentEvent> events;
        if (containingFile == null) {
            SelfElementInfo.$$$reportNull$$$0(19);
        }
        if (document == null) {
            SelfElementInfo.$$$reportNull$$$0(20);
        }
        if (segment == null) {
            SelfElementInfo.$$$reportNull$$$0(21);
        }
        if (!(events = (documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project = containingFile.getProject())).getEventsSinceCommit(document)).isEmpty() && (tracker = (pointerManager = (SmartPointerManagerImpl)SmartPointerManager.getInstance(project)).getTracker(containingFile.getViewProvider().getVirtualFile())) != null) {
            return tracker.getUpdatedRange(containingFile, segment, isSegmentGreedy, (FrozenDocument)documentManager.getLastCommittedDocument(document), events);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identikit";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointerRange";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/SelfElementInfo";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/SelfElementInfo";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "switchToAnchor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAnchor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "switchTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateRangeToPsi";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "restoreElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPsiRange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "restoreFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "restoreFileFromVirtual";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "restoreDirectoryFromVirtual";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "restoreVFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "pointsToTheSameElementAs";
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRange";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "calcActualRangeAfterDocumentEvents";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

