/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSharedImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.JavaSharedImplUtil");
    private static final TokenSet BRACKETS = TokenSet.create(JavaTokenType.LBRACKET, JavaTokenType.RBRACKET);

    private JavaSharedImplUtil() {
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor2) {
        if (typeElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(0);
        }
        if (anchor2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(1);
        }
        return JavaSharedImplUtil.getType(typeElement, anchor2, null);
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor2, @Nullable PsiAnnotation stopAt) {
        if (typeElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(2);
        }
        if (anchor2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(3);
        }
        PsiType type2 = typeElement.getType();
        List<PsiAnnotation[]> allAnnotations = JavaSharedImplUtil.collectAnnotations(anchor2, stopAt);
        if (allAnnotations == null) {
            return null;
        }
        for (PsiAnnotation[] annotations2 : allAnnotations) {
            type2 = type2.createArrayType().annotate(TypeAnnotationProvider.Static.create(annotations2));
        }
        return type2;
    }

    @Nullable
    private static List<PsiAnnotation[]> collectAnnotations(@NotNull PsiElement anchor2, @Nullable PsiAnnotation stopAt) {
        if (anchor2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(4);
        }
        List<PsiAnnotation[]> annotations2 = ContainerUtil.newSmartList();
        List current = null;
        boolean found2 = stopAt == null;
        boolean stop = false;
        for (PsiElement child = anchor2.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                if (current == null) {
                    current = ContainerUtil.newSmartList();
                }
                current.add((PsiAnnotation)child);
                if (child != stopAt) continue;
                stop = true;
                found2 = true;
                continue;
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET)) {
                annotations2.add(current == null ? PsiAnnotation.EMPTY_ARRAY : ContainerUtil.toArray(current, PsiAnnotation.ARRAY_FACTORY));
                current = null;
                if (!stop) continue;
                return annotations2;
            }
            if (!PsiUtil.isJavaToken(child, JavaTokenType.RBRACKET)) break;
        }
        return !found2 || stop ? null : annotations2;
    }

    @NotNull
    public static PsiType applyAnnotations(@NotNull PsiType type2, @Nullable PsiModifierList modifierList2) {
        PsiAnnotation[] annotations2;
        if (type2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(5);
        }
        if (modifierList2 != null && (annotations2 = modifierList2.getAnnotations()).length > 0) {
            TypeAnnotationProvider original = modifierList2.getParent() instanceof PsiMethod ? type2.getAnnotationProvider() : TypeAnnotationProvider.EMPTY;
            FilteringTypeAnnotationProvider provider = new FilteringTypeAnnotationProvider(annotations2, original);
            if (type2 instanceof PsiArrayType) {
                Stack<PsiArrayType> types2 = new Stack<PsiArrayType>();
                do {
                    types2.push((PsiArrayType)type2);
                } while ((type2 = ((PsiArrayType)type2).getComponentType()) instanceof PsiArrayType);
                type2 = type2.annotate(provider);
                while (!types2.isEmpty()) {
                    PsiArrayType t = (PsiArrayType)types2.pop();
                    type2 = t instanceof PsiEllipsisType ? new PsiEllipsisType(type2, t.getAnnotations()) : new PsiArrayType(type2, t.getAnnotations());
                }
                PsiType psiType2 = type2;
                if (psiType2 == null) {
                    JavaSharedImplUtil.$$$reportNull$$$0(6);
                }
                return psiType2;
            }
            if (type2 instanceof PsiDisjunctionType) {
                ArrayList<PsiType> components = new ArrayList<PsiType>(((PsiDisjunctionType)type2).getDisjunctions());
                components.set(0, ((PsiType)components.get(0)).annotate(provider));
                PsiDisjunctionType psiDisjunctionType = ((PsiDisjunctionType)type2).newDisjunctionType(components);
                if (psiDisjunctionType == null) {
                    JavaSharedImplUtil.$$$reportNull$$$0(7);
                }
                return psiDisjunctionType;
            }
            PsiType psiType3 = type2.annotate(provider);
            if (psiType3 == null) {
                JavaSharedImplUtil.$$$reportNull$$$0(8);
            }
            return psiType3;
        }
        PsiType psiType4 = type2;
        if (psiType4 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(9);
        }
        return psiType4;
    }

    public static void normalizeBrackets(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(10);
        }
        CompositeElement variableElement = (CompositeElement)variable2.getNode();
        PsiTypeElement typeElement = variable2.getTypeElement();
        PsiIdentifier nameElement = variable2.getNameIdentifier();
        LOG.assertTrue(typeElement != null && nameElement != null);
        ASTNode type2 = typeElement.getNode();
        ASTNode name = nameElement.getNode();
        ASTNode firstBracket = null;
        ASTNode lastBracket = null;
        int arrayCount = 0;
        ASTNode element = name;
        while (element != null && (element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) != null && element.getElementType() == JavaTokenType.LBRACKET) {
            if (firstBracket == null) {
                firstBracket = element;
            }
            lastBracket = element;
            ++arrayCount;
            if ((element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) == null || element.getElementType() != JavaTokenType.RBRACKET) break;
            lastBracket = element;
        }
        if (firstBracket != null) {
            element = firstBracket;
            while (true) {
                ASTNode next = element.getTreeNext();
                CodeEditUtil.removeChild(variableElement, element);
                if (element == lastBracket) break;
                element = next;
            }
            CompositeElement newType = (CompositeElement)type2.clone();
            for (int i = 0; i < arrayCount; ++i) {
                CompositeElement newType1 = ASTFactory.composite(JavaElementType.TYPE);
                newType1.rawAddChildren(newType);
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.LBRACKET, "["));
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.RBRACKET, "]"));
                newType = newType1;
                newType.acceptTree(new GeneratedMarkerVisitor());
            }
            newType.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(type2));
            CodeEditUtil.replaceChild(variableElement, type2, newType);
        }
    }

    public static void setInitializer(@NotNull PsiVariable variable2, PsiExpression initializer2) throws IncorrectOperationException {
        PsiExpression oldInitializer;
        if (variable2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(11);
        }
        if ((oldInitializer = variable2.getInitializer()) != null) {
            oldInitializer.delete();
        }
        if (initializer2 == null) {
            return;
        }
        CompositeElement variableElement = (CompositeElement)variable2.getNode();
        ASTNode eq = variableElement.findChildByRole(20);
        if (eq == null) {
            CharTable charTable = SharedImplUtil.findCharTableByTree(variableElement);
            eq = Factory.createSingleLeafElement(JavaTokenType.EQ, "=", 0, 1, charTable, variable2.getManager());
            PsiIdentifier identifier = variable2.getNameIdentifier();
            assert (identifier != null) : variable2;
            ASTNode node = PsiImplUtil.skipWhitespaceCommentsAndTokens(identifier.getNode().getTreeNext(), BRACKETS);
            variableElement.addInternal((TreeElement)eq, eq, node, Boolean.TRUE);
            eq = variableElement.findChildByRole(20);
            assert (eq != null) : variable2;
        }
        variable2.addAfter(initializer2, eq.getPsi());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/JavaSharedImplUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/JavaSharedImplUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "applyAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectAnnotations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyAnnotations";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "normalizeBrackets";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setInitializer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilteringTypeAnnotationProvider
    implements TypeAnnotationProvider {
        private final PsiAnnotation[] myCandidates;
        private final TypeAnnotationProvider myOriginalProvider;
        private volatile PsiAnnotation[] myCache;

        private FilteringTypeAnnotationProvider(@NotNull PsiAnnotation[] candidates2, @NotNull TypeAnnotationProvider originalProvider) {
            if (candidates2 == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(0);
            }
            if (originalProvider == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(1);
            }
            this.myCandidates = candidates2;
            this.myOriginalProvider = originalProvider;
        }

        @Override
        @NotNull
        public PsiAnnotation[] getAnnotations() {
            PsiAnnotation[] result2 = this.myCache;
            if (result2 == null) {
                List<PsiAnnotation> filtered = JBIterable.of(this.myCandidates).filter(annotation2 -> AnnotationTargetUtil.isTypeAnnotation(annotation2)).append((PsiAnnotation)this.myOriginalProvider.getAnnotations()).toList();
                result2 = filtered.isEmpty() ? PsiAnnotation.EMPTY_ARRAY : filtered.toArray(PsiAnnotation.EMPTY_ARRAY);
                this.myCache = result2;
            }
            if (result2 == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(2);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/tree/JavaSharedImplUtil$FilteringTypeAnnotationProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/JavaSharedImplUtil$FilteringTypeAnnotationProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

