/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import com.google.common.collect.ImmutableSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedValueDescriptor;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreter;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxedValuesCollection;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0015H\u0014J \u0010\u0017\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0015H\u0014J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0015H\u0014J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0014J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0015H\u0014J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0015H\u0014J \u0010\u001e\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0014J\u001a\u0010!\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\"\u001a\u00020\u000eH\u0002J\u0016\u0010#\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fJ*\u0010$\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fH\u0016J\u001a\u0010&\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter;", "insnList", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/org/objectweb/asm/tree/InsnList;Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "candidatesBoxedValues", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection;", "getCandidatesBoxedValues", "()Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection;", "binaryOperation", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "value1", "value2", "copyOperation", "value", "markValueAsDirty", "", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue;", "onAreEqual", "onCompareTo", "onMergeFail", "onMergeSuccess", "v", "w", "onMethodCallWithBoxedValue", "onNewBoxedValue", "onUnboxing", "resultType", "Lorg/jetbrains/org/objectweb/asm/Type;", "processOperationWithBoxedValue", "insnNode", "processPopInstruction", "ternaryOperation", "value3", "unaryOperation", "Companion", "backend"})
public final class RedundantBoxingInterpreter
extends BoxingInterpreter {
    @NotNull
    private final RedundantBoxedValuesCollection candidatesBoxedValues;
    private static final ImmutableSet<Integer> PERMITTED_OPERATIONS_OPCODES;
    private static final ImmutableSet<Integer> PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER;
    public static final Companion Companion;

    @NotNull
    public final RedundantBoxedValuesCollection getCandidatesBoxedValues() {
        return this.candidatesBoxedValues;
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value2) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        if ((insn.getOpcode() == 192 || insn.getOpcode() == 193) && value2 instanceof BoxedBasicValue) {
            TypeInsnNode typeInsn = (TypeInsnNode)insn;
            BoxedBasicValue boxedBasicValue = (BoxedBasicValue)value2;
            String string2 = typeInsn.desc;
            Intrinsics.checkExpressionValueIsNotNull(string2, "typeInsn.desc");
            if (!RedundantBoxingInterpreter.Companion.isSafeCast(boxedBasicValue, string2)) {
                this.markValueAsDirty((BoxedBasicValue)value2);
            }
        }
        this.processOperationWithBoxedValue(value2, insn);
        return super.unaryOperation(insn, value2);
    }

    @Override
    @Nullable
    public BasicValue binaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value1, @NotNull BasicValue value2) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value1, "value1");
        Intrinsics.checkParameterIsNotNull(value2, "value2");
        this.processOperationWithBoxedValue(value1, insn);
        this.processOperationWithBoxedValue(value2, insn);
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    @Nullable
    public BasicValue ternaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value1, @NotNull BasicValue value2, @NotNull BasicValue value3) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value1, "value1");
        Intrinsics.checkParameterIsNotNull(value2, "value2");
        Intrinsics.checkParameterIsNotNull(value3, "value3");
        this.processOperationWithBoxedValue(value3, insn);
        return super.ternaryOperation(insn, value1, value2, value3);
    }

    @Override
    @NotNull
    public BasicValue copyOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value2) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        if (value2 instanceof BoxedBasicValue && insn.getOpcode() == 58) {
            ((BoxedBasicValue)value2).getDescriptor().addVariableIndex(((VarInsnNode)insn).var);
        }
        this.processOperationWithBoxedValue(value2, insn);
        BasicValue basicValue = super.copyOperation(insn, value2);
        Intrinsics.checkExpressionValueIsNotNull(basicValue, "super.copyOperation(insn, value)");
        return basicValue;
    }

    public final void processPopInstruction(@NotNull AbstractInsnNode insnNode, @NotNull BasicValue value2) {
        Intrinsics.checkParameterIsNotNull(insnNode, "insnNode");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        this.processOperationWithBoxedValue(value2, insnNode);
    }

    @Override
    protected void onNewBoxedValue(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        this.candidatesBoxedValues.add(value2.getDescriptor());
    }

    @Override
    protected void onUnboxing(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value2, @NotNull Type resultType) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        Intrinsics.checkParameterIsNotNull(resultType, "resultType");
        BoxedValueDescriptor boxedValueDescriptor = value2.getDescriptor();
        boolean bl = false;
        boolean bl2 = false;
        BoxedValueDescriptor $this$run = boxedValueDescriptor;
        boolean bl3 = false;
        if (Intrinsics.areEqual($this$run.getUnboxedType(), resultType)) {
            RedundantBoxingInterpreter.Companion.addAssociatedInsn(value2, insn);
        } else {
            $this$run.addUnboxingWithCastTo(insn, resultType);
        }
    }

    @Override
    protected void onAreEqual(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value1, @NotNull BoxedBasicValue value2) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value1, "value1");
        Intrinsics.checkParameterIsNotNull(value2, "value2");
        BoxedValueDescriptor descriptor1 = value1.getDescriptor();
        BoxedValueDescriptor descriptor2 = value2.getDescriptor();
        this.candidatesBoxedValues.merge(descriptor1, descriptor2);
        descriptor1.addInsn(insn);
    }

    @Override
    protected void onCompareTo(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value1, @NotNull BoxedBasicValue value2) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value1, "value1");
        Intrinsics.checkParameterIsNotNull(value2, "value2");
        BoxedValueDescriptor descriptor1 = value1.getDescriptor();
        BoxedValueDescriptor descriptor2 = value2.getDescriptor();
        this.candidatesBoxedValues.merge(descriptor1, descriptor2);
        descriptor1.addInsn(insn);
    }

    @Override
    protected void onMethodCallWithBoxedValue(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        this.markValueAsDirty(value2);
    }

    @Override
    protected void onMergeFail(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        this.markValueAsDirty(value2);
    }

    @Override
    protected void onMergeSuccess(@NotNull BoxedBasicValue v, @NotNull BoxedBasicValue w) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        Intrinsics.checkParameterIsNotNull(w, "w");
        this.candidatesBoxedValues.merge(v.getDescriptor(), w.getDescriptor());
    }

    private final void processOperationWithBoxedValue(BasicValue value2, AbstractInsnNode insnNode) {
        if (value2 instanceof BoxedBasicValue) {
            this.checkUsedValue(value2);
            if (!PERMITTED_OPERATIONS_OPCODES.contains(insnNode.getOpcode())) {
                this.markValueAsDirty((BoxedBasicValue)value2);
            } else {
                RedundantBoxingInterpreter.Companion.addAssociatedInsn((BoxedBasicValue)value2, insnNode);
            }
        }
    }

    private final void markValueAsDirty(BoxedBasicValue value2) {
        this.candidatesBoxedValues.remove(value2.getDescriptor());
    }

    public RedundantBoxingInterpreter(@NotNull InsnList insnList, @NotNull GenerationState generationState) {
        Intrinsics.checkParameterIsNotNull(insnList, "insnList");
        Intrinsics.checkParameterIsNotNull(generationState, "generationState");
        super(insnList, generationState);
        this.candidatesBoxedValues = new RedundantBoxedValuesCollection();
    }

    static {
        Companion = new Companion(null);
        PERMITTED_OPERATIONS_OPCODES = ImmutableSet.of(Integer.valueOf(58), Integer.valueOf(25), Integer.valueOf(87), Integer.valueOf(89), Integer.valueOf(192), Integer.valueOf(193), new Integer[0]);
        PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER = ImmutableSet.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), new Integer[0]);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter$Companion;", "", "()V", "PERMITTED_OPERATIONS_OPCODES", "Lcom/google/common/collect/ImmutableSet;", "", "kotlin.jvm.PlatformType", "PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER", "addAssociatedInsn", "", "value", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "isSafeCast", "", "targetInternalName", "", "backend"})
    public static final class Companion {
        private final boolean isSafeCast(BoxedBasicValue value2, String targetInternalName) {
            boolean bl;
            String string2 = targetInternalName;
            if (Intrinsics.areEqual(string2, Type.getInternalName(Object.class))) {
                bl = true;
            } else if (Intrinsics.areEqual(string2, Type.getInternalName(Number.class))) {
                bl = PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER.contains(value2.getDescriptor().getUnboxedType().getSort());
            } else if (Intrinsics.areEqual(string2, "java/lang/Comparable")) {
                bl = true;
            } else {
                Type type2 = value2.getType();
                Intrinsics.checkExpressionValueIsNotNull(type2, "value.type");
                bl = Intrinsics.areEqual(type2.getInternalName(), targetInternalName);
            }
            return bl;
        }

        private final void addAssociatedInsn(BoxedBasicValue value2, AbstractInsnNode insn) {
            BoxedValueDescriptor boxedValueDescriptor = value2.getDescriptor();
            boolean bl = false;
            boolean bl2 = false;
            BoxedValueDescriptor $this$run = boxedValueDescriptor;
            boolean bl3 = false;
            if ($this$run.isSafeToRemove()) {
                $this$run.addInsn(insn);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

