/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.calls.ConstraintSystemCompleter;
import org.jetbrains.kotlin.fir.resolve.calls.InferenceComponents;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeVariableDirectionCalculator;
import org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinder;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtomMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J@\u0010\u0018\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013J\u001e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J.\u0010\u001d\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0010H\u0002J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ConstraintSystemCompleter;", "", "components", "Lorg/jetbrains/kotlin/fir/resolve/calls/InferenceComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/InferenceComponents;)V", "getComponents", "()Lorg/jetbrains/kotlin/fir/resolve/calls/InferenceComponents;", "variableFixationFinder", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder;", "getVariableFixationFinder", "()Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder;", "analyzePostponeArgumentIfPossible", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter$Context;", "topLevelAtoms", "", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "analyze", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtomMarker;", "", "canWeAnalyzeIt", "argument", "complete", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter$ConstraintSystemCompletionMode;", "candidateReturnType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "fixVariable", "variableWithConstraints", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "direction", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;", "topLevelType", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "postponedResolveKtPrimitives", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtom;", "getOrderedNotAnalyzedPostponedArguments", "resolve"})
public final class ConstraintSystemCompleter {
    @NotNull
    private final VariableFixationFinder variableFixationFinder;
    @NotNull
    private final InferenceComponents components;

    @NotNull
    public final VariableFixationFinder getVariableFixationFinder() {
        return this.variableFixationFinder;
    }

    public final void complete(@NotNull KotlinConstraintSystemCompleter.Context c, @NotNull KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode completionMode, @NotNull List<? extends FirStatement> topLevelAtoms, @NotNull ConeKotlinType candidateReturnType, @NotNull Function1<? super PostponedResolvedAtomMarker, Unit> analyze2) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull((Object)completionMode, "completionMode");
        Intrinsics.checkParameterIsNotNull(topLevelAtoms, "topLevelAtoms");
        Intrinsics.checkParameterIsNotNull(candidateReturnType, "candidateReturnType");
        Intrinsics.checkParameterIsNotNull(analyze2, "analyze");
        while (true) {
            VariableFixationFinder.VariableForFixation variableForFixation;
            List<PostponedResolvedAtomMarker> postponedKtPrimitives;
            if (this.analyzePostponeArgumentIfPossible(c, topLevelAtoms, analyze2)) {
                continue;
            }
            List allTypeVariables = CollectionsKt.toList((Iterable)c.getNotFixedTypeVariables().keySet());
            if (this.variableFixationFinder.findFirstVariableForFixation(c, allTypeVariables, postponedKtPrimitives = this.getOrderedNotAnalyzedPostponedArguments(topLevelAtoms), completionMode, candidateReturnType) == null) {
                break;
            }
            if (!variableForFixation.getHasProperConstraint() && completionMode != KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL) break;
            VariableWithConstraints variableWithConstraints = MapsKt.getValue(c.getNotFixedTypeVariables(), variableForFixation.getVariable());
            this.fixVariable(c, candidateReturnType, variableWithConstraints, CollectionsKt.emptyList());
        }
        if (completionMode == KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL) {
            Iterable $this$forEach$iv = this.getOrderedNotAnalyzedPostponedArguments(topLevelAtoms);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                analyze2.invoke((PostponedResolvedAtomMarker)element$iv);
            }
        }
    }

    private final void fixVariable(KotlinConstraintSystemCompleter.Context c, KotlinTypeMarker topLevelType, VariableWithConstraints variableWithConstraints, List<? extends PostponedResolvedAtom> postponedResolveKtPrimitives) {
        TypeVariableDirectionCalculator.ResolveDirection direction = new TypeVariableDirectionCalculator(c, postponedResolveKtPrimitives, topLevelType).getDirection(variableWithConstraints);
        this.fixVariable(c, variableWithConstraints, direction);
    }

    public final void fixVariable(@NotNull KotlinConstraintSystemCompleter.Context c, @NotNull VariableWithConstraints variableWithConstraints, @NotNull TypeVariableDirectionCalculator.ResolveDirection direction) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(variableWithConstraints, "variableWithConstraints");
        Intrinsics.checkParameterIsNotNull((Object)direction, "direction");
        KotlinTypeMarker resultType = this.components.getResultTypeResolver().findResultType(c, variableWithConstraints, direction);
        c.fixVariable(variableWithConstraints.getTypeVariable(), resultType);
    }

    private final boolean analyzePostponeArgumentIfPossible(KotlinConstraintSystemCompleter.Context c, List<? extends FirStatement> topLevelAtoms, Function1<? super PostponedResolvedAtomMarker, Unit> analyze2) {
        for (PostponedResolvedAtomMarker argument : this.getOrderedNotAnalyzedPostponedArguments(topLevelAtoms)) {
            if (!this.canWeAnalyzeIt(c, argument)) continue;
            analyze2.invoke(argument);
            return true;
        }
        return false;
    }

    private final List<PostponedResolvedAtomMarker> getOrderedNotAnalyzedPostponedArguments(List<? extends FirStatement> topLevelAtoms) {
        getOrderedNotAnalyzedPostponedArguments.1 $fun$process$1 = getOrderedNotAnalyzedPostponedArguments.1.INSTANCE;
        boolean bl = false;
        ArrayList notAnalyzedArguments = new ArrayList();
        for (FirStatement firStatement : topLevelAtoms) {
            $fun$process$1.invoke(firStatement, notAnalyzedArguments);
        }
        return notAnalyzedArguments;
    }

    private final boolean canWeAnalyzeIt(KotlinConstraintSystemCompleter.Context c, PostponedResolvedAtomMarker argument) {
        boolean bl;
        block4: {
            if (argument.getAnalyzed()) {
                return false;
            }
            Iterable $this$all$iv = argument.getInputTypes();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KotlinTypeMarker it = (KotlinTypeMarker)element$iv;
                    boolean bl2 = false;
                    if (c.containsOnlyFixedOrPostponedVariables(it)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final InferenceComponents getComponents() {
        return this.components;
    }

    public ConstraintSystemCompleter(@NotNull InferenceComponents components) {
        Intrinsics.checkParameterIsNotNull(components, "components");
        this.components = components;
        this.variableFixationFinder = new VariableFixationFinder(this.components.getTrivialConstraintTypeInferenceOracle());
    }
}

