/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.LoggingContext;
import org.jetbrains.kotlin.backend.common.serialization.DescriptorTable;
import org.jetbrains.kotlin.backend.common.serialization.metadata.DynamicTypeDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataSerializer;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.js.IrTranslationResultValue;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.ir.backend.js.IrModuleInfo;
import org.jetbrains.kotlin.ir.backend.js.JsGeneratorExtensions;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.KotlinFileSerializedData;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrLinker;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrModuleSerializer;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsMangler;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.metadata.JsKlibMetadataVersion;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.metadata.KlibMetadataIncrementalSerializer;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.util.ExpectDeclarationRemover;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.konan.KonanVersion;
import org.jetbrains.kotlin.konan.KonanVersionImpl;
import org.jetbrains.kotlin.konan.MetaVersion;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.properties.PropertiesKt;
import org.jetbrains.kotlin.konan.util.KlibMetadataFactories;
import org.jetbrains.kotlin.library.KonanLibraryVersioning;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibrarySearchPathResolver;
import org.jetbrains.kotlin.library.SerializedIrFile;
import org.jetbrains.kotlin.library.SerializedIrModule;
import org.jetbrains.kotlin.library.SerializedMetadata;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.library.impl.KotlinLibraryImplKt;
import org.jetbrains.kotlin.library.impl.KotlinLibraryWriterImplKt;
import org.jetbrains.kotlin.library.resolver.KotlinLibraryResolveResult;
import org.jetbrains.kotlin.library.resolver.impl.KotlinLibraryResolverImpl;
import org.jetbrains.kotlin.library.resolver.impl.KotlinLibraryResolverImplKt;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi2ir.Psi2IrConfiguration;
import org.jetbrains.kotlin.psi2ir.Psi2IrTranslator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.util.Logger;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u00b2\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0002\u0005\u0015\u001a\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018\u001aJ\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\b\u001a\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002\u001a\u001c\u0010,\u001a\u00020\"2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110\u001e2\u0006\u0010.\u001a\u00020/\u001a:\u00100\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\u001e\u001a\u000e\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\u0011\u001a\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002\u001a`\u00108\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\r2\u0006\u00109\u001a\u00020)2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u00103\u001a\u00020\u00112\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u001e2\u0006\u0010%\u001a\u00020\b\u001a0\u0010?\u001a\b\u0012\u0004\u0012\u00020\t0@2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020C0BH\u0002\u001a&\u0010D\u001a\u00020<*\u0002052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010FH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\"\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006G"}, d2={"JsFactories", "Lorg/jetbrains/kotlin/konan/util/KlibMetadataFactories;", "getJsFactories", "()Lorg/jetbrains/kotlin/konan/util/KlibMetadataFactories;", "emptyLoggingContext", "org/jetbrains/kotlin/ir/backend/js/KlibKt$emptyLoggingContext$1", "Lorg/jetbrains/kotlin/ir/backend/js/KlibKt$emptyLoggingContext$1;", "isBuiltIns", "", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;)Z", "metadataVersion", "Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/metadata/JsKlibMetadataVersion;", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getMetadataVersion", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/metadata/JsKlibMetadataVersion;", "moduleName", "", "getModuleName", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;)Ljava/lang/String;", "createBuiltIns", "org/jetbrains/kotlin/ir/backend/js/KlibKt$createBuiltIns$1", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/storage/StorageManager;)Lorg/jetbrains/kotlin/ir/backend/js/KlibKt$createBuiltIns$1;", "generateKLib", "", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "configuration", "allDependencies", "Lorg/jetbrains/kotlin/library/resolver/KotlinLibraryResolveResult;", "friendDependencies", "outputKlibPath", "nopack", "getDescriptorForElement", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "element", "Lcom/intellij/psi/PsiElement;", "jsResolveLibraries", "libraries", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "loadIr", "Lorg/jetbrains/kotlin/ir/backend/js/IrModuleInfo;", "loadKlib", "klibPath", "runAnalysisAndPreparePsi2Ir", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "depsDescriptors", "Lorg/jetbrains/kotlin/ir/backend/js/ModulesStructure;", "serializeModuleIntoKlib", "bindingContext", "dependencies", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "cleanFiles", "Lorg/jetbrains/kotlin/ir/backend/js/KotlinFileSerializedData;", "sortDependencies", "", "mapping", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "generateModuleFragment", "deserializer", "Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/ir/JsIrLinker;", "ir.serialization.js"})
public final class KlibKt {
    private static final emptyLoggingContext.1 emptyLoggingContext = new LoggingContext(){
        private boolean inVerbosePhase;

        public boolean getInVerbosePhase() {
            return this.inVerbosePhase;
        }

        public void setInVerbosePhase(boolean bl) {
            this.inVerbosePhase = bl;
        }

        public void log(@NotNull Function0<String> message2) {
            Intrinsics.checkParameterIsNotNull(message2, "message");
        }
    };
    @NotNull
    private static final KlibMetadataFactories JsFactories = new KlibMetadataFactories(JsFactories.1.INSTANCE, DynamicTypeDeserializer.INSTANCE);

    @NotNull
    public static final String getModuleName(@NotNull KotlinLibrary $this$moduleName) {
        Intrinsics.checkParameterIsNotNull($this$moduleName, "$this$moduleName");
        String string2 = $this$moduleName.getManifestProperties().getProperty("unique_name");
        Intrinsics.checkExpressionValueIsNotNull(string2, "manifestProperties.getPr\u2026LIB_PROPERTY_UNIQUE_NAME)");
        return string2;
    }

    public static final boolean isBuiltIns(@NotNull KotlinLibrary $this$isBuiltIns) {
        Intrinsics.checkParameterIsNotNull($this$isBuiltIns, "$this$isBuiltIns");
        return PropertiesKt.propertyList$default($this$isBuiltIns.getManifestProperties(), "depends", null, true, 2, null).isEmpty();
    }

    @NotNull
    public static final KotlinLibrary loadKlib(@NotNull String klibPath) {
        Intrinsics.checkParameterIsNotNull(klibPath, "klibPath");
        return KotlinLibraryImplKt.createKotlinLibrary$default(new File(new File(klibPath).getAbsolutePath()), false, 2, null);
    }

    private static final JsKlibMetadataVersion getMetadataVersion(@NotNull CompilerConfiguration $this$metadataVersion) {
        JsKlibMetadataVersion jsKlibMetadataVersion;
        BinaryVersion binaryVersion = $this$metadataVersion.get(CommonConfigurationKeys.METADATA_VERSION);
        if (!(binaryVersion instanceof JsKlibMetadataVersion)) {
            binaryVersion = null;
        }
        if ((jsKlibMetadataVersion = (JsKlibMetadataVersion)binaryVersion) == null) {
            jsKlibMetadataVersion = JsKlibMetadataVersion.INSTANCE;
        }
        return jsKlibMetadataVersion;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinLibraryResolveResult jsResolveLibraries(@NotNull List<String> libraries, @NotNull Logger logger) {
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull(libraries, "libraries");
        Intrinsics.checkParameterIsNotNull(logger, "logger");
        Iterable $this$map$iv = libraries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = new UnresolvedLibrary((String)it, null);
            collection.add(object);
        }
        List unresolvedLibraries = (List)destination$iv$iv;
        Iterable $this$map$iv2 = libraries;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            object = new java.io.File((String)it).getAbsolutePath();
            collection.add(object);
        }
        List libraryAbsolutePaths = (List)destination$iv$iv2;
        KotlinLibraryResolverImpl libraryResolver = KotlinLibraryResolverImplKt.libraryResolver(new KotlinLibrarySearchPathResolver(CollectionsKt.emptyList(), libraryAbsolutePaths, null, null, false, logger));
        KotlinLibraryResolveResult resolvedLibraries = libraryResolver.resolveWithDependencies(unresolvedLibraries, true, true, true);
        return resolvedLibraries;
    }

    /*
     * WARNING - void declaration
     */
    public static final void generateKLib(@NotNull Project project, @NotNull List<? extends KtFile> files2, @NotNull CompilerConfiguration configuration, @NotNull KotlinLibraryResolveResult allDependencies, @NotNull List<? extends KotlinLibrary> friendDependencies, @NotNull String outputKlibPath, boolean nopack) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        Intrinsics.checkParameterIsNotNull(files2, "files");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(allDependencies, "allDependencies");
        Intrinsics.checkParameterIsNotNull(friendDependencies, "friendDependencies");
        Intrinsics.checkParameterIsNotNull(outputKlibPath, "outputKlibPath");
        IncrementalDataProvider incrementalDataProvider = configuration.get(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER);
        List icData = null;
        if (incrementalDataProvider != null) {
            Map it2;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = files2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                KtFile ktFile = (KtFile)item$iv$iv2;
                Collection collection = destination$iv$iv22;
                boolean bl = false;
                Pair<java.io.File, void> pair = TuplesKt.to(VfsUtilCore.virtualToIoFile(((PsiFileImpl)((Object)it2)).getVirtualFile()), it2);
                collection.add(pair);
            }
            Map nonCompiledSources = MapsKt.toMap((List)destination$iv$iv22);
            Map<java.io.File, IrTranslationResultValue> compiledIrFiles = incrementalDataProvider.getSerializedIrFiles();
            Map<java.io.File, TranslationResultValue> compiledMetaFiles = incrementalDataProvider.getCompiledPackageParts();
            boolean $this$mapTo$iv$iv2 = compiledIrFiles.size() == compiledMetaFiles.size();
            boolean destination$iv$iv22 = false;
            boolean bl = false;
            if (_Assertions.ENABLED && !$this$mapTo$iv$iv2) {
                boolean bl2 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            destination$iv$iv22 = false;
            List storage2 = new ArrayList();
            for (java.io.File f : compiledIrFiles.keySet()) {
                TranslationResultValue metaFile;
                IrTranslationResultValue irData;
                Map map2 = nonCompiledSources;
                boolean item$iv$iv2 = false;
                it2 = map2;
                boolean bl3 = false;
                if (it2.containsKey(f)) continue;
                if (compiledIrFiles.get(f) == null) {
                    String item$iv$iv2 = "No Ir Data found for file " + f;
                    boolean it2 = false;
                    throw (Throwable)new IllegalStateException(item$iv$iv2.toString());
                }
                if (compiledMetaFiles.get(f) == null) {
                    it2 = "No Meta Data found for file " + f;
                    bl3 = false;
                    throw (Throwable)new IllegalStateException(it2.toString());
                }
                bl3 = false;
                boolean bl4 = false;
                IrTranslationResultValue $this$with = irData;
                boolean bl5 = false;
                byte[] byArray = $this$with.getFqn();
                byte[] byArray2 = $this$with.getFileData();
                boolean bl6 = false;
                String string3 = new String(byArray, Charsets.UTF_8);
                String string4 = f.getPath();
                Intrinsics.checkExpressionValueIsNotNull(string4, "f.path");
                byte[] byArray3 = $this$with.getDeclarations();
                byte[] byArray4 = $this$with.getBodies();
                byte[] byArray5 = $this$with.getStrings();
                byte[] byArray6 = $this$with.getTypes();
                byte[] byArray7 = $this$with.getSymbols();
                String string5 = StringsKt.replace$default(string4, '\\', '/', false, 4, null);
                String string6 = string3;
                byte[] byArray8 = byArray2;
                SerializedIrFile irFile = new SerializedIrFile(byArray8, string6, string5, byArray7, byArray6, byArray5, byArray4, byArray3);
                storage2.add(new KotlinFileSerializedData(metaFile.getMetadata(), irFile));
            }
            icData = storage2;
        } else {
            icData = CollectionsKt.emptyList();
        }
        ModulesStructure depsDescriptors = new ModulesStructure(project, files2, configuration, allDependencies, friendDependencies);
        GeneratorContext psi2IrContext = KlibKt.runAnalysisAndPreparePsi2Ir(depsDescriptors);
        IrModuleFragment moduleFragment = KlibKt.generateModuleFragment$default(psi2IrContext, files2, null, 2, null);
        String string7 = configuration.get(CommonConfigurationKeys.MODULE_NAME);
        if (string7 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(string7, "configuration[CommonConf\u2026rationKeys.MODULE_NAME]!!");
        String moduleName = string7;
        IrElementVisitorVoidKt.acceptVoid(moduleFragment, new ExpectDeclarationRemover(psi2IrContext.getSymbolTable(), false));
        KlibKt.serializeModuleIntoKlib(moduleName, configuration, psi2IrContext.getBindingContext(), files2, outputKlibPath, KotlinLibraryResolveResult.DefaultImpls.getFullList$default(allDependencies, null, 1, null), moduleFragment, icData, nopack);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<KotlinLibrary> sortDependencies(List<? extends KotlinLibrary> dependencies2, Map<KotlinLibrary, ? extends ModuleDescriptor> mapping2) {
        void $this$mapTo$iv$iv;
        Map<KotlinLibrary, ? extends ModuleDescriptor> $this$map$iv = mapping2;
        boolean $i$f$map = false;
        Map<KotlinLibrary, ? extends ModuleDescriptor> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var8_7 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var8_7.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Pair pair = TuplesKt.to(it.getValue(), it.getKey());
            collection.add(pair);
        }
        Map m2l = MapsKt.toMap((List)destination$iv$iv);
        List list2 = DFS.topologicalOrder((Iterable)dependencies2, new DFS.Neighbors<N>(mapping2, m2l){
            final /* synthetic */ Map $mapping;
            final /* synthetic */ Map $m2l;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Iterable<KotlinLibrary> getNeighbors(KotlinLibrary m) {
                void $this$mapTo$iv$iv;
                ModuleDescriptor it;
                Iterable $this$filterTo$iv$iv;
                ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.$mapping.get(m);
                if (moduleDescriptor == null) {
                    String string2 = "No descriptor found for library " + m.getLibraryName();
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                ModuleDescriptor descriptor2 = moduleDescriptor;
                Iterable $this$filter$iv = descriptor2.getAllDependencyModules();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ModuleDescriptor)element$iv$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual(it, descriptor2) ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ModuleDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    KotlinLibrary kotlinLibrary = (KotlinLibrary)this.$m2l.get(it);
                    collection.add(kotlinLibrary);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$mapping = map2;
                this.$m2l = map3;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(list2, "DFS.topologicalOrder(dep\u2026r }.map { m2l[it] }\n    }");
        return CollectionsKt.reversed(list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrModuleInfo loadIr(@NotNull Project project, @NotNull List<? extends KtFile> files2, @NotNull CompilerConfiguration configuration, @NotNull KotlinLibraryResolveResult allDependencies, @NotNull List<? extends KotlinLibrary> friendDependencies) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(project, "project");
        Intrinsics.checkParameterIsNotNull(files2, "files");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(allDependencies, "allDependencies");
        Intrinsics.checkParameterIsNotNull(friendDependencies, "friendDependencies");
        ModulesStructure depsDescriptors = new ModulesStructure(project, files2, configuration, allDependencies, friendDependencies);
        GeneratorContext psi2IrContext = KlibKt.runAnalysisAndPreparePsi2Ir(depsDescriptors);
        IrBuiltIns irBuiltIns = psi2IrContext.getIrBuiltIns();
        SymbolTable symbolTable = psi2IrContext.getSymbolTable();
        ModuleDescriptor moduleDescriptor = psi2IrContext.getModuleDescriptor();
        JsIrLinker deserializer = new JsIrLinker(moduleDescriptor, JsMangler.INSTANCE, emptyLoggingContext, irBuiltIns, symbolTable);
        Iterable $this$map$iv = KlibKt.sortDependencies(KotlinLibraryResolveResult.DefaultImpls.getFullList$default(allDependencies, null, 1, null), depsDescriptors.getDescriptors());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrModuleFragment irModuleFragment;
            void it;
            KotlinLibrary kotlinLibrary = (KotlinLibrary)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (deserializer.deserializeIrModuleHeader(depsDescriptors.getModuleDescriptor((KotlinLibrary)it)) == null) {
                Intrinsics.throwNpe();
            }
            collection.add(irModuleFragment);
        }
        List deserializedModuleFragments = (List)destination$iv$iv;
        IrModuleFragment moduleFragment = KlibKt.generateModuleFragment(psi2IrContext, files2, deserializer);
        return new IrModuleInfo(moduleFragment, deserializedModuleFragments, irBuiltIns, symbolTable, deserializer);
    }

    private static final GeneratorContext runAnalysisAndPreparePsi2Ir(ModulesStructure depsDescriptors) {
        JsAnalysisResult analysisResult2 = depsDescriptors.runAnalysis();
        return new GeneratorContext(new Psi2IrConfiguration(false, 1, null), analysisResult2.getModuleDescriptor(), analysisResult2.getBindingContext(), CommonConfigurationKeysKt.getLanguageVersionSettings(depsDescriptors.getCompilerConfiguration()), new SymbolTable(), new JsGeneratorExtensions());
    }

    private static final IrModuleFragment generateModuleFragment(@NotNull GeneratorContext $this$generateModuleFragment, List<? extends KtFile> files2, JsIrLinker deserializer) {
        return Psi2IrTranslator.generateModuleFragment$default(new Psi2IrTranslator($this$generateModuleFragment.getLanguageVersionSettings(), $this$generateModuleFragment.getConfiguration(), null, 4, null), $this$generateModuleFragment, files2, deserializer, null, 8, null);
    }

    static /* synthetic */ IrModuleFragment generateModuleFragment$default(GeneratorContext generatorContext, List list2, JsIrLinker jsIrLinker, int n, Object object) {
        if ((n & 2) != 0) {
            jsIrLinker = null;
        }
        return KlibKt.generateModuleFragment(generatorContext, list2, jsIrLinker);
    }

    private static final createBuiltIns.1 createBuiltIns(StorageManager storageManager) {
        return new KotlinBuiltIns(storageManager, storageManager){
            final /* synthetic */ StorageManager $storageManager;
            {
                this.$storageManager = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }

    @NotNull
    public static final KlibMetadataFactories getJsFactories() {
        return JsFactories;
    }

    private static final DeclarationDescriptor getDescriptorForElement(BindingContext context2, PsiElement element) {
        DeclarationDescriptor declarationDescriptor = BindingContextUtils.getNotNull(context2, BindingContext.DECLARATION_TO_DESCRIPTOR, element);
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "BindingContextUtils.getN\u2026N_TO_DESCRIPTOR, element)");
        return declarationDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    public static final void serializeModuleIntoKlib(@NotNull String moduleName, @NotNull CompilerConfiguration configuration, @NotNull BindingContext bindingContext, @NotNull List<? extends KtFile> files2, @NotNull String klibPath, @NotNull List<? extends KotlinLibrary> dependencies2, @NotNull IrModuleFragment moduleFragment, @NotNull List<KotlinFileSerializedData> cleanFiles, boolean nopack) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        Unit unit;
        IncrementalResultsConsumer $this$run;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv32;
        IncrementalResultsConsumer $this$map$iv2;
        List memberScope2;
        Object object3;
        Object object4;
        Object ktFile;
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(files2, "files");
        Intrinsics.checkParameterIsNotNull(klibPath, "klibPath");
        Intrinsics.checkParameterIsNotNull(dependencies2, "dependencies");
        Intrinsics.checkParameterIsNotNull(moduleFragment, "moduleFragment");
        Intrinsics.checkParameterIsNotNull(cleanFiles, "cleanFiles");
        boolean bl = files2.size() == moduleFragment.getFiles().size();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        DescriptorTable descriptorTable = new DescriptorTable();
        SerializedIrModule serializedIr = new JsIrModuleSerializer(emptyLoggingContext, moduleFragment.getIrBuiltins(), descriptorTable).serializedIrModule(moduleFragment);
        ModuleDescriptor moduleDescriptor = moduleFragment.getDescriptor();
        JsKlibMetadataVersion metadataVersion = KlibKt.getMetadataVersion(configuration);
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(configuration);
        KlibMetadataIncrementalSerializer metadataSerializer = new KlibMetadataIncrementalSerializer(languageVersionSettings, metadataVersion, descriptorTable);
        Function2<FqName, Collection<? extends DeclarationDescriptor>, byte[]> $fun$serializeScope$1 = new Function2<FqName, Collection<? extends DeclarationDescriptor>, byte[]>(metadataSerializer, bindingContext, moduleDescriptor){
            final /* synthetic */ KlibMetadataIncrementalSerializer $metadataSerializer;
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ ModuleDescriptor $moduleDescriptor;

            @NotNull
            public final byte[] invoke(@NotNull FqName fqName2, @NotNull Collection<? extends DeclarationDescriptor> memberScope2) {
                Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
                Intrinsics.checkParameterIsNotNull(memberScope2, "memberScope");
                byte[] byArray = this.$metadataSerializer.serializePackageFragment(this.$bindingContext, this.$moduleDescriptor, memberScope2, fqName2).toByteArray();
                Intrinsics.checkExpressionValueIsNotNull(byArray, "metadataSerializer.seria\u2026e\n        ).toByteArray()");
                return byArray;
            }
            {
                this.$metadataSerializer = klibMetadataIncrementalSerializer;
                this.$bindingContext = bindingContext;
                this.$moduleDescriptor = moduleDescriptor;
                super(2);
            }
        };
        IncrementalResultsConsumer incrementalResultsConsumer = configuration.get(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER);
        byte[] empty = new byte[]{};
        Function2<java.io.File, KotlinFileSerializedData, Unit> $fun$processCompiledFileData$2 = new Function2<java.io.File, KotlinFileSerializedData, Unit>(incrementalResultsConsumer, empty){
            final /* synthetic */ IncrementalResultsConsumer $incrementalResultsConsumer;
            final /* synthetic */ byte[] $empty;

            public final void invoke(@NotNull java.io.File ioFile, @NotNull KotlinFileSerializedData compiledFile) {
                block1: {
                    Intrinsics.checkParameterIsNotNull(ioFile, "ioFile");
                    Intrinsics.checkParameterIsNotNull(compiledFile, "compiledFile");
                    IncrementalResultsConsumer incrementalResultsConsumer = this.$incrementalResultsConsumer;
                    if (incrementalResultsConsumer == null) break block1;
                    IncrementalResultsConsumer incrementalResultsConsumer2 = incrementalResultsConsumer;
                    boolean bl = false;
                    boolean bl2 = false;
                    IncrementalResultsConsumer $this$run = incrementalResultsConsumer2;
                    boolean bl3 = false;
                    $this$run.processPackagePart(ioFile, compiledFile.getMetadata(), this.$empty, this.$empty);
                    SerializedIrFile serializedIrFile = compiledFile.getIrData();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    SerializedIrFile $this$with = serializedIrFile;
                    boolean bl6 = false;
                    String string2 = $this$with.getFqName();
                    byte[] byArray = $this$with.getBodies();
                    byte[] byArray2 = $this$with.getDeclarations();
                    byte[] byArray3 = $this$with.getStrings();
                    byte[] byArray4 = $this$with.getTypes();
                    byte[] byArray5 = $this$with.getSymbols();
                    byte[] byArray6 = $this$with.getFileData();
                    java.io.File file2 = ioFile;
                    IncrementalResultsConsumer incrementalResultsConsumer3 = $this$run;
                    Charset charset = Charsets.UTF_8;
                    boolean bl7 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray7 = string3.getBytes(charset);
                    Intrinsics.checkExpressionValueIsNotNull(byArray7, "(this as java.lang.String).getBytes(charset)");
                    byte[] byArray8 = byArray7;
                    incrementalResultsConsumer3.processIrFile(file2, byArray6, byArray5, byArray4, byArray3, byArray2, byArray, byArray8);
                }
            }
            {
                this.$incrementalResultsConsumer = incrementalResultsConsumer;
                this.$empty = byArray;
                super(2);
            }
        };
        boolean bl5 = false;
        List additionalFiles = new ArrayList();
        for (Pair pair : CollectionsKt.zip((Iterable)files2, (Iterable)serializedIr.getFiles())) {
            Collection $this$mapTo$iv$iv4;
            ktFile = (KtFile)pair.component1();
            SerializedIrFile binaryFile = (SerializedIrFile)pair.component2();
            boolean bl6 = Intrinsics.areEqual(((KtFile)ktFile).getVirtualFilePath(), binaryFile.getPath());
            boolean bl7 = false;
            if (_Assertions.ENABLED && !bl6) {
                boolean $i$a$-assert-KlibKt$serializeModuleIntoKlib$42 = false;
                String $i$a$-assert-KlibKt$serializeModuleIntoKlib$42 = StringsKt.trimMargin$default("The Kt and Ir files are put in different order\n                Kt: " + ((KtFile)ktFile).getVirtualFilePath() + "\n                Ir: " + binaryFile.getPath() + "\n            ", null, 1, null);
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-KlibKt$serializeModuleIntoKlib$42));
            }
            Iterable $this$map$iv3 = ((KtFile)ktFile).getDeclarations();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv3;
            Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv4.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                KtDeclaration ktDeclaration = (KtDeclaration)item$iv$iv;
                object4 = destination$iv$iv22;
                boolean bl8 = false;
                object3 = KlibKt.getDescriptorForElement(bindingContext, (PsiElement)it);
                object4.add(object3);
            }
            memberScope2 = (List)destination$iv$iv22;
            byte[] packageFragment = $fun$serializeScope$1.invoke(((KtFile)ktFile).getPackageFqName(), (Collection<DeclarationDescriptor>)((Collection<? extends DeclarationDescriptor>)memberScope2));
            KotlinFileSerializedData compiledKotlinFile = new KotlinFileSerializedData(packageFragment, binaryFile);
            $this$mapTo$iv$iv4 = additionalFiles;
            boolean destination$iv$iv22 = false;
            $this$mapTo$iv$iv4.add(compiledKotlinFile);
            java.io.File file2 = VfsUtilCore.virtualToIoFile(((PsiFileImpl)ktFile).getVirtualFile());
            Intrinsics.checkExpressionValueIsNotNull(file2, "VfsUtilCore.virtualToIoFile(ktFile.virtualFile)");
            $fun$processCompiledFileData$2.invoke(file2, compiledKotlinFile);
        }
        List compiledKotlinFiles = CollectionsKt.plus((Collection)cleanFiles, (Iterable)additionalFiles);
        ktFile = compiledKotlinFiles;
        object3 = moduleDescriptor;
        object4 = metadataSerializer;
        boolean $i$f$map22 = false;
        memberScope2 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv32) {
            void it;
            KotlinFileSerializedData $i$f$mapTo2 = (KotlinFileSerializedData)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl9 = false;
            object = it.getIrData().getFqName();
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        byte[] header = KlibMetadataSerializer.serializeHeader$default((KlibMetadataSerializer)object4, (ModuleDescriptor)object3, CollectionsKt.distinct((Iterable)object2), null, 4, null).toByteArray();
        IncrementalResultsConsumer incrementalResultsConsumer2 = incrementalResultsConsumer;
        if (incrementalResultsConsumer2 != null) {
            $this$map$iv2 = incrementalResultsConsumer2;
            $i$f$map22 = false;
            boolean $this$mapTo$iv$iv32 = false;
            $this$run = $this$map$iv2;
            boolean bl10 = false;
            Intrinsics.checkExpressionValueIsNotNull(header, "header");
            $this$run.processHeader(header);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        Iterable $i$f$map22 = compiledKotlinFiles;
        object4 = metadataSerializer;
        boolean $i$f$groupBy = false;
        $this$run = $this$groupBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object5;
            KotlinFileSerializedData it = (KotlinFileSerializedData)element$iv$iv;
            boolean bl11 = false;
            key$iv$iv = it.getIrData().getFqName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl12 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object5 = answer$iv$iv$iv;
            } else {
                object5 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object5;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = object3 = destination$iv$iv2;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo3 = false;
        Iterator item$iv$iv = $this$mapTo$iv$iv2;
        boolean bl13 = false;
        for (Map.Entry item$iv$iv2 : item$iv$iv.entrySet()) {
            void $this$mapTo$iv$iv5;
            void $this$map$iv4;
            Iterable $this$sortedBy$iv;
            void $dstr$fqn$data;
            key$iv$iv = item$iv$iv2;
            object3 = destination$iv$iv2;
            boolean bl14 = false;
            Iterable $i$f$getOrPut = $dstr$fqn$data;
            boolean value$iv$iv$iv = false;
            String fqn = (String)$i$f$getOrPut.getKey();
            $i$f$getOrPut = $dstr$fqn$data;
            value$iv$iv$iv = false;
            List data = (List)$i$f$getOrPut.getValue();
            $i$f$getOrPut = data;
            String string3 = fqn;
            boolean $i$f$sortedBy = false;
            void var39_93 = $this$sortedBy$iv;
            boolean bl15 = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    KotlinFileSerializedData it = (KotlinFileSerializedData)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getIrData().getPath());
                    it = (KotlinFileSerializedData)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string2 = it.getIrData().getPath();
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)string2));
                }
            };
            Collection<byte[]> collection = CollectionsKt.sortedWith(var39_93, comparator);
            $this$sortedBy$iv = collection;
            boolean $i$f$map3 = false;
            var39_93 = $this$map$iv4;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv4, 10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv5) {
                void it;
                KotlinFileSerializedData kotlinFileSerializedData = (KotlinFileSerializedData)item$iv$iv3;
                collection = destination$iv$iv3;
                boolean bl16 = false;
                byte[] byArray = it.getMetadata();
                collection.add(byArray);
            }
            collection = (List)destination$iv$iv3;
            object2 = TuplesKt.to(string3, collection);
            object3.add(object2);
        }
        object3 = (List)destination$iv$iv2;
        Map map2 = MapsKt.toMap((Iterable)object3);
        Intrinsics.checkExpressionValueIsNotNull(header, "header");
        SerializedMetadata serializedMetadata = ((KlibMetadataIncrementalSerializer)object4).serializedMetadata(map2, header);
        Iterable $this$map$iv5 = compiledKotlinFiles;
        boolean $i$f$map4 = false;
        destination$iv$iv2 = $this$map$iv5;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv5, 10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv4 : $this$mapTo$iv$iv) {
            void it;
            KotlinFileSerializedData item$iv$iv2 = (KotlinFileSerializedData)item$iv$iv4;
            object2 = destination$iv$iv4;
            boolean bl17 = false;
            object = it.getIrData();
            object2.add((SerializedIrFile)object);
        }
        object2 = (List)destination$iv$iv4;
        Collection<SerializedIrFile> collection = object2;
        SerializedIrModule fullSerializedIr = new SerializedIrModule(collection);
        KotlinAbiVersion abiVersion = KotlinAbiVersion.Companion.getCURRENT();
        KonanVersionImpl compilerVersion = new KonanVersionImpl(MetaVersion.DEV, 1, 3, 0, -1);
        Object libraryVersion = null;
        Object object6 = compilerVersion;
        Object object7 = libraryVersion;
        KotlinAbiVersion kotlinAbiVersion = abiVersion;
        KonanLibraryVersioning versions2 = new KonanLibraryVersioning((String)object7, (KonanVersion)object6, kotlinAbiVersion);
        object6 = versions2;
        object7 = klibPath;
        boolean bl18 = nopack;
        String string4 = moduleName;
        Properties properties2 = null;
        byte[] byArray = null;
        SerializedMetadata serializedMetadata2 = serializedMetadata;
        SerializedIrModule serializedIrModule = fullSerializedIr;
        KotlinLibraryWriterImplKt.buildKoltinLibrary(dependencies2, serializedMetadata2, serializedIrModule, (KonanLibraryVersioning)object6, (String)object7, string4, bl18, properties2, byArray);
    }

    public static final /* synthetic */ createBuiltIns.1 access$createBuiltIns(StorageManager storageManager) {
        return KlibKt.createBuiltIns(storageManager);
    }
}

