'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _bluebird = require('bluebird');

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _indexeddbCryptoStore = require('./store/indexeddb-crypto-store');

var _indexeddbCryptoStore2 = _interopRequireDefault(_indexeddbCryptoStore);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @alias module:crypto/RoomList
 */
var RoomList = function () {
    function RoomList(cryptoStore) {
        (0, _classCallCheck3.default)(this, RoomList);

        this._cryptoStore = cryptoStore;

        // Object of roomId -> room e2e info object (body of the m.room.encryption event)
        this._roomEncryption = {};
    }

    (0, _createClass3.default)(RoomList, [{
        key: 'init',
        value: function () {
            var _ref = (0, _bluebird.coroutine)( /*#__PURE__*/_regenerator2.default.mark(function _callee() {
                var _this = this;

                return _regenerator2.default.wrap(function _callee$(_context) {
                    while (1) {
                        switch (_context.prev = _context.next) {
                            case 0:
                                _context.next = 2;
                                return (0, _bluebird.resolve)(this._cryptoStore.doTxn('readwrite', [_indexeddbCryptoStore2.default.STORE_ROOMS], function (txn) {
                                    _this._cryptoStore.getEndToEndRooms(txn, function (result) {
                                        _this._roomEncryption = result;
                                    });
                                }));

                            case 2:
                            case 'end':
                                return _context.stop();
                        }
                    }
                }, _callee, this);
            }));

            function init() {
                return _ref.apply(this, arguments);
            }

            return init;
        }()
    }, {
        key: 'getRoomEncryption',
        value: function getRoomEncryption(roomId) {
            return this._roomEncryption[roomId] || null;
        }
    }, {
        key: 'isRoomEncrypted',
        value: function isRoomEncrypted(roomId) {
            return Boolean(this.getRoomEncryption(roomId));
        }
    }, {
        key: 'setRoomEncryption',
        value: function () {
            var _ref2 = (0, _bluebird.coroutine)( /*#__PURE__*/_regenerator2.default.mark(function _callee2(roomId, roomInfo) {
                var _this2 = this;

                return _regenerator2.default.wrap(function _callee2$(_context2) {
                    while (1) {
                        switch (_context2.prev = _context2.next) {
                            case 0:
                                // important that this happens before calling into the store
                                // as it prevents the Crypto::setRoomEncryption from calling
                                // this twice for consecutive m.room.encryption events
                                this._roomEncryption[roomId] = roomInfo;
                                _context2.next = 3;
                                return (0, _bluebird.resolve)(this._cryptoStore.doTxn('readwrite', [_indexeddbCryptoStore2.default.STORE_ROOMS], function (txn) {
                                    _this2._cryptoStore.storeEndToEndRoom(roomId, roomInfo, txn);
                                }));

                            case 3:
                            case 'end':
                                return _context2.stop();
                        }
                    }
                }, _callee2, this);
            }));

            function setRoomEncryption(_x, _x2) {
                return _ref2.apply(this, arguments);
            }

            return setRoomEncryption;
        }()
    }]);
    return RoomList;
}(); /*
     Copyright 2018, 2019 New Vector Ltd
     
     Licensed under the Apache License, Version 2.0 (the "License");
     you may not use this file except in compliance with the License.
     You may obtain a copy of the License at
     
         http://www.apache.org/licenses/LICENSE-2.0
     
     Unless required by applicable law or agreed to in writing, software
     distributed under the License is distributed on an "AS IS" BASIS,
     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
     See the License for the specific language governing permissions and
     limitations under the License.
     */

/**
 * @module crypto/RoomList
 *
 * Manages the list of encrypted rooms
 */

exports.default = RoomList;
//# sourceMappingURL=RoomList.js.map