/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import sbt.State;
import sbt.State$;
import sbt.internal.librarymanagement.cross.CrossVersionUtil$;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.AttributeKey$;
import sbt.io.FileFilter;
import sbt.io.FileFilter$;
import sbt.io.GlobFilter$;
import sbt.io.Path$;
import sbt.io.RichFile$;
import sbt.io.syntax$;
import sbt.util.OptJsonWriter;
import sbt.util.OptJsonWriter$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import xsbti.compile.ScalaInstance;

public final class BuildPaths$ {
    public static BuildPaths$ MODULE$;
    private final AttributeKey<File> globalBaseDirectory;
    private final AttributeKey<File> globalPluginsDirectory;
    private final AttributeKey<File> globalSettingsDirectory;
    private final AttributeKey<File> stagingDirectory;
    private final AttributeKey<File> dependencyBaseDirectory;
    private final AttributeKey<File> globalZincDirectory;

    static {
        new BuildPaths$();
    }

    public AttributeKey<File> globalBaseDirectory() {
        return this.globalBaseDirectory;
    }

    public AttributeKey<File> globalPluginsDirectory() {
        return this.globalPluginsDirectory;
    }

    public AttributeKey<File> globalSettingsDirectory() {
        return this.globalSettingsDirectory;
    }

    public AttributeKey<File> stagingDirectory() {
        return this.stagingDirectory;
    }

    public AttributeKey<File> dependencyBaseDirectory() {
        return this.dependencyBaseDirectory;
    }

    public AttributeKey<File> globalZincDirectory() {
        return this.globalZincDirectory;
    }

    public File getGlobalBase(State state) {
        File file = this.defaultVersionedGlobalBase(this.binarySbtVersion(state));
        return this.getFileSetting(this.globalBaseDirectory(), "sbt.global.base", (Function0<File>)(Function0 & Serializable & scala.Serializable)() -> file, state);
    }

    public File getStagingDirectory(State state, File globalBase) {
        return this.fileSetting(this.stagingDirectory(), "sbt.global.staging", this.defaultStaging(globalBase), state);
    }

    public File getGlobalPluginsDirectory(State state, File globalBase) {
        return this.fileSetting(this.globalPluginsDirectory(), "sbt.global.plugins", this.defaultGlobalPlugins(globalBase), state);
    }

    public File getGlobalSettingsDirectory(State state, File globalBase) {
        return this.fileSetting(this.globalSettingsDirectory(), "sbt.global.settings", globalBase, state);
    }

    public File getDependencyDirectory(State state, File globalBase) {
        return this.fileSetting(this.dependencyBaseDirectory(), "sbt.dependency.base", this.defaultDependencyBase(globalBase), state);
    }

    public File getZincDirectory(State state, File globalBase) {
        return this.fileSetting(this.globalZincDirectory(), "sbt.global.zinc", this.defaultGlobalZinc(globalBase), state);
    }

    private File fileSetting(AttributeKey<File> stateKey, String property, File file, State state) {
        return this.getFileSetting(stateKey, property, (Function0<File>)(Function0 & Serializable & scala.Serializable)() -> file, state);
    }

    public File getFileSetting(AttributeKey<File> stateKey, String property, Function0<File> function0, State state) {
        return (File)State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(state), stateKey).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getFileProperty(property)).getOrElse(function0);
    }

    public Option<File> getFileProperty(String name) {
        return Option$.MODULE$.apply((Object)System.getProperty(name)).flatMap((Function1 & Serializable & scala.Serializable)path -> {
            None$ none$;
            if (path.isEmpty()) {
                none$ = None$.MODULE$;
            } else if (BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(path)).head()) == '~') {
                String tildePath = MODULE$.expandTildePrefix((String)path);
                none$ = new Some((Object)new File(tildePath));
            } else {
                none$ = new Some((Object)new File((String)path));
            }
            return none$;
        });
    }

    /*
     * Unable to fully structure code
     */
    public String expandTildePrefix(String path) {
        var4_2 = false;
        var5_3 = null;
        var6_4 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("\\/"))).headOption();
        if (!(var6_4 instanceof Some)) ** GOTO lbl-1000
        var4_2 = true;
        var5_3 = (Some)var6_4;
        var7_5 = (String)var5_3.value();
        if ("~".equals(var7_5)) {
            var2_6 = (String)package$.MODULE$.env().getOrElse((Object)"HOME", (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$expandTildePrefix$1(), ()Ljava/lang/String;)());
        } else lbl-1000:
        // 2 sources

        {
            var2_6 = var4_2 != false && "~+".equals(var8_7 = (String)var5_3.value()) != false ? (String)package$.MODULE$.env().getOrElse((Object)"PWD", (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$expandTildePrefix$2(), ()Ljava/lang/String;)()) : (var4_2 != false && "~-".equals(var9_8 = (String)var5_3.value()) != false ? (String)package$.MODULE$.env().getOrElse((Object)"OLDPWD", (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$expandTildePrefix$3(), ()Ljava/lang/String;)()) : "");
        }
        tildePath = var2_6;
        var10_10 = path.indexOf("/");
        switch (var10_10) {
            case -1: {
                v0 = tildePath;
                break;
            }
            default: {
                v0 = new StringBuilder(0).append(tildePath).append(path.substring(path.indexOf("/"))).toString();
                break;
            }
        }
        return v0;
    }

    public File defaultVersionedGlobalBase(String sbtVersion) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(this.defaultGlobalBase()), sbtVersion);
    }

    public File defaultGlobalBase() {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(Path$.MODULE$.userHome()), ".sbt");
    }

    private String binarySbtVersion(State state) {
        return CrossVersionUtil$.MODULE$.binarySbtVersion(state.configuration().provider().id().version());
    }

    private File defaultStaging(File globalBase) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(globalBase), "staging");
    }

    private File defaultGlobalPlugins(File globalBase) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(globalBase), "plugins");
    }

    private File defaultDependencyBase(File globalBase) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(globalBase), "dependency");
    }

    private File defaultGlobalZinc(File globalBase) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(globalBase), "zinc");
    }

    public Seq<File> configurationSources(File base) {
        return syntax$.MODULE$.singleFileFinder(base).$times((FileFilter)GlobFilter$.MODULE$.apply("*.sbt").$minus(FileFilter$.MODULE$.globFilter(".sbt"))).get();
    }

    public File pluginDirectory(File definitionBase) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(definitionBase), "plugins");
    }

    public File evalOutputDirectory(File base) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(this.outputDirectory(base)), "config-classes");
    }

    public File outputDirectory(File base) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(base), "target");
    }

    public File projectStandard(File base) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(base), "project");
    }

    public final String PluginsDirectoryName() {
        return "plugins";
    }

    public final String DefaultTargetName() {
        return "target";
    }

    public final String ConfigDirectoryName() {
        return ".sbt";
    }

    public final String GlobalBaseProperty() {
        return "sbt.global.base";
    }

    public final String StagingProperty() {
        return "sbt.global.staging";
    }

    public final String GlobalPluginsProperty() {
        return "sbt.global.plugins";
    }

    public final String GlobalSettingsProperty() {
        return "sbt.global.settings";
    }

    public final String DependencyBaseProperty() {
        return "sbt.dependency.base";
    }

    public final String GlobalZincProperty() {
        return "sbt.global.zinc";
    }

    public File crossPath(File base, ScalaInstance instance) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(base), new StringBuilder(6).append("scala_").append(instance.version()).toString());
    }

    public static final /* synthetic */ String $anonfun$expandTildePrefix$1() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$expandTildePrefix$2() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$expandTildePrefix$3() {
        return "";
    }

    private BuildPaths$() {
        MODULE$ = this;
        this.globalBaseDirectory = AttributeKey$.MODULE$.apply("global-base-directory", "The base directory for global sbt configuration and staging.", 10000, ManifestFactory$.MODULE$.classType(File.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.globalPluginsDirectory = AttributeKey$.MODULE$.apply("global-plugins-directory", "The base directory for global sbt plugins.", 10000, ManifestFactory$.MODULE$.classType(File.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.globalSettingsDirectory = AttributeKey$.MODULE$.apply("global-settings-directory", "The base directory for global sbt settings.", 10000, ManifestFactory$.MODULE$.classType(File.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.stagingDirectory = AttributeKey$.MODULE$.apply("staging-directory", "The directory for staging remote projects.", 10000, ManifestFactory$.MODULE$.classType(File.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.dependencyBaseDirectory = AttributeKey$.MODULE$.apply("dependency-base-directory", "The base directory for caching dependency resolution.", 10000, ManifestFactory$.MODULE$.classType(File.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.globalZincDirectory = AttributeKey$.MODULE$.apply("global-zinc-directory", "The base directory for Zinc internals.", 10000, ManifestFactory$.MODULE$.classType(File.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
    }
}

