/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.conflict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.plugins.conflict.AbstractConflictManager;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.util.Message;

public class LatestConflictManager
extends AbstractConflictManager {
    private LatestStrategy strategy;
    private String strategyName;

    public LatestConflictManager() {
    }

    public LatestConflictManager(LatestStrategy latestStrategy) {
        this.strategy = latestStrategy;
    }

    public LatestConflictManager(String string, LatestStrategy latestStrategy) {
        this.setName(string);
        this.strategy = latestStrategy;
    }

    @Override
    public Collection resolveConflicts(IvyNode ivyNode, Collection object) {
        Object object2;
        Object object3;
        if (object.size() < 2) {
            return object;
        }
        Object object4 = object.iterator();
        while (object4.hasNext()) {
            object3 = (IvyNode)object4.next();
            object2 = ((IvyNode)object3).getDependencyDescriptor(ivyNode);
            if (object2 == null || !object2.isForce() || !ivyNode.getResolvedId().equals(object2.getParentRevisionId())) continue;
            return Collections.singleton(object3);
        }
        object4 = object.iterator();
        while (object4.hasNext()) {
            object3 = (IvyNode)object4.next();
            object2 = ((IvyNode)object3).getResolvedId();
            if (!this.getSettings().getVersionMatcher().isDynamic((ModuleRevisionId)object2)) continue;
            return null;
        }
        object4 = new ArrayList();
        object3 = object.iterator();
        while (object3.hasNext()) {
            object2 = (IvyNode)object3.next();
            if (((IvyNode)object2).isCompletelyEvicted()) continue;
            ((ArrayList)object4).add(object2);
        }
        if (((ArrayList)object4).size() > 0) {
            object = object4;
        }
        try {
            object3 = (IvyNodeArtifactInfo)this.getStrategy().findLatest(this.toArtifactInfo((Collection)object), null);
            if (object3 != null) {
                return Collections.singleton(((IvyNodeArtifactInfo)object3).getNode());
            }
            return object;
        }
        catch (NoConflictResolvedYetException noConflictResolvedYetException) {
            return null;
        }
    }

    protected ArtifactInfo[] toArtifactInfo(Collection collection) {
        ArrayList<IvyNodeArtifactInfo> arrayList = new ArrayList<IvyNodeArtifactInfo>(collection.size());
        for (IvyNode ivyNode : collection) {
            arrayList.add(new IvyNodeArtifactInfo(ivyNode));
        }
        return arrayList.toArray(new ArtifactInfo[arrayList.size()]);
    }

    public LatestStrategy getStrategy() {
        if (this.strategy == null) {
            if (this.strategyName != null) {
                this.strategy = this.getSettings().getLatestStrategy(this.strategyName);
                if (this.strategy == null) {
                    Message.error("unknown latest strategy: " + this.strategyName);
                    this.strategy = this.getSettings().getDefaultLatestStrategy();
                }
            } else {
                this.strategy = this.getSettings().getDefaultLatestStrategy();
            }
        }
        return this.strategy;
    }

    public void setLatest(String string) {
        this.strategyName = string;
    }

    public void setStrategy(LatestStrategy latestStrategy) {
        this.strategy = latestStrategy;
    }

    @Override
    public String toString() {
        return this.strategy != null ? String.valueOf(this.strategy) : this.strategyName;
    }

    protected static final class IvyNodeArtifactInfo
    implements ArtifactInfo {
        private final IvyNode node;

        private IvyNodeArtifactInfo(IvyNode ivyNode) {
            this.node = ivyNode;
        }

        @Override
        public long getLastModified() {
            long l = this.node.getLastModified();
            if (l == 0L) {
                throw new NoConflictResolvedYetException();
            }
            return l;
        }

        @Override
        public String getRevision() {
            return this.node.getResolvedId().getRevision();
        }

        public IvyNode getNode() {
            return this.node;
        }
    }

    public static class NoConflictResolvedYetException
    extends RuntimeException {
    }
}

